<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: style_mapping_css.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/01/28 15:22:20 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help"
                exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help">

    <!--+++++ CSS PROPERTIES  +++++-->
    <xsl:template name="write-style-properties">
        <xsl:param name="globalData" />
        <xsl:param name="style:properties" />

        <xsl:for-each select="$style:properties/@*">
        <!-- debugEnabledMESSAGE:
            <xsl:message> Name:<xsl:value-of select="name()" /> Value:<xsl:value-of select="." /></xsl:message>      -->
            <!-- <!ATTLIST style:properties style:horizontal-pos (from-left|left|center|right|from-inside|inside|outside)#IMPLIED>-->
            <!-- 2DO: is inside/from-inside also better showable ? -->
            <!-- !!!! 2DO: Still there have to be placed a <br clear='all' /> to disable the flow!!!!-->
            <!--           The OOo attribute 'style:number-wrapped-paragraphs' is currently ignored -->
            <xsl:choose>
                <xsl:when test='name()="style:wrap"'>
                    <xsl:choose>
                        <xsl:when test='.="left"'>
                            <xsl:text>float:right; </xsl:text>
                        </xsl:when>
                        <xsl:when test='.="right"'>
                            <xsl:text>float:left; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:clear"'>
                    <xsl:text>clear:both; </xsl:text>
                </xsl:when>

                <xsl:when test='name() = "style:horizontal-pos"'>
                    <xsl:choose>
                        <xsl:when test='.="left"'>
                            <xsl:text>text-align:left; </xsl:text>
                        </xsl:when>
                        <xsl:when test='. = "right"'>
                            <xsl:text>text-align:right; </xsl:text>
                        </xsl:when>
                        <xsl:when test='.="center"'>
                            <xsl:text>text-align:center; </xsl:text>
                        </xsl:when>
                        <!-- 2DO: currently rest values are ignored!!
                            If the property value is from-left or from-inside,
                            the svg:x attribute associated with the frame element specifies
                            the horizontal position of the frame.
                            Otherwise the svg:x attribute is ignored for text documents.
                        -->
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name() = "style:vertical-pos"'>
                    <xsl:choose>
                        <xsl:when test='.="from-top"'>
                            <xsl:text>vertical-align:top; </xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>vertical-align:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name() = "table:align"'>
                    <xsl:choose>
                        <xsl:when test='.="left"'><!--
                        PROBLEMS WITH MEETING MINUTES EXAMPLE
                            <xsl:text>float:right; </xsl:text> -->
                        </xsl:when>
                        <xsl:when test='.="right"'><!--
                        PROBLEMS WITH MEETING MINUTES EXAMPLE
                            <xsl:text>float:left; </xsl:text> -->
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>float:none; </xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <!-- PADDING for all variations: fo:padding, fo:padding-top, fo:padding-bottom, fo:padding-left, fo:padding-right -->
                <xsl:when test='contains(name(),"fo:padding")'>
                    <xsl:text>padding:</xsl:text>
                    <xsl:choose>
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <!--
                fo:border
                fo:border-top
                fo:border-bottom
                fo:border-left
                fo:border-right

                    At present, all four borders must be set simultaneously by using either
                    the fo:border property or by attaching all four of the other border
                    properties to an item set element. In the latter case, if one or more
                    of the properties is missing their values are assumed to be none. The
                    only border styles supported are none or hidden, solid, and double. Any
                    other border style specified is displayed as solid. Transparent borders
                    are not supported and the border widths thin, medium, and thick are
                    mapped to lengths. In addition, only some distinct border widths are
                    supported. Unsupported widths are rounded up to the next supported
                    width.
                    If there are no padding properties specified within the same
                    item set element, a default padding is used for sides that have a
                    border. A value of 0cm is used for sides without a border.
                    (cp. wd-so-xml-text.sdw)
                -->
                <xsl:when test='name()="fo:border"'>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:text>border-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,'ch ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'cm')">
                            <xsl:text>border-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'pt')">
                            <xsl:text>border-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:border-top"'>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:text>border-top-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,'ch ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-top-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-top-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'cm')">
                            <xsl:text>border-top-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-top-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-top-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'pt')">
                            <xsl:text>border-top-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-top-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-top-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:border-bottom"'>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:text>border-bottom-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,'ch ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'cm')">
                            <xsl:text>border-bottom-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'pt')">
                            <xsl:text>border-bottom-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-bottom-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:border-left"'>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:text>border-left-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,'ch ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-left-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-left-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'cm')">
                            <xsl:text>border-left-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-left-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-left-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'pt')">
                            <xsl:text>border-left-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-left-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-left-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:border-right"'>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:text>border-right-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,'ch ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-right-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-right-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'ch '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'cm')">
                            <xsl:text>border-right-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-right-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-right-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'cm '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'pt')">
                            <xsl:text>border-right-width:</xsl:text>
                            <xsl:call-template name="round-up-border-width">
                                <xsl:with-param name="value" select="substring-before(.,' ')" />
                            </xsl:call-template>
                            <xsl:text>; </xsl:text>
                            <xsl:text>border-right-style:</xsl:text><xsl:value-of select="substring-before(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                            <xsl:text>border-right-color:</xsl:text><xsl:value-of select="substring-after(substring-after(.,'pt '), ' ')" /><xsl:text>; </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="style:column-width"'>
                    <xsl:text>width:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:row-height"'>
                    <xsl:text>height:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:width"'>
                    <xsl:text>width:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <!-- frame property -->
                <xsl:when test='name()="fo:width"'>
                    <xsl:text>width:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:font-style"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:font-name"'>
                    <xsl:text>font-family:</xsl:text>
                    <xsl:variable name="content" select="." />
                    <xsl:value-of select="$globalData/office:font-decls/style:font-decl[@style:name=$content]/@fo:font-family" />
                    <xsl:text>; </xsl:text>
                    <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Italic')">
                        <xsl:text>font-style:italic; </xsl:text>
                    </xsl:if>
                    <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Bold')">
                        <xsl:text>font-weight:bold; </xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test='name()="fo:font-weight"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:font-size"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:font-family"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:color"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:margin-left"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:margin-right"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:margin-top"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:margin-bottom"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:line-height"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                    <xsl:choose>
                        <!-- changing the distance measure: inch to in -->
                        <xsl:when test="contains(., 'inch')">
                            <xsl:value-of select="substring-before(.,'ch')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="." />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:text-align"'>
                    <!-- IMPORTANT is necessary as table cell value alignment is decided by runtime over the valuetype
                         Otherwise a table cell style-class will ALWAYS be overwritten by the run-time value -->
                     <xsl:choose>
                        <xsl:when test="contains(., 'start')">
                            <xsl:text>text-align:left ! important; </xsl:text>
                        </xsl:when>
                        <xsl:when test="contains(., 'end')">
                            <xsl:text>text-align:right ! important; </xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>text-align:</xsl:text><xsl:value-of select='.' /><xsl:text> ! important; </xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test='name()="fo:text-indent"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:text-background-color"'>
                    <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="fo:background-color"'>
                    <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:background-image"'>
                    <xsl:text>background-image:url(</xsl:text><xsl:value-of select="@xlink:href" /><xsl:text>); </xsl:text>
                    <xsl:choose>
                        <xsl:when test="@style:repeat = 'repeat'">
                            <xsl:text>background-repeat:repeat; </xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>background-repeat:no-repeat; </xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <!-- text-shadow is a CSS2 feature and yet not common used in user-agents -->
                <xsl:when test='name()="fo:text-shadow"'>
                    <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:when test='name()="style:text-crossing-out"'>
                    <xsl:if test='not(.="none")'>
                        <xsl:text>text-decoration:line-through; </xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test='name()="style:text-underline"'>
                    <xsl:if test='not(.="none")'>
                        <xsl:text>text-decoration:underline; </xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test='name()="style:text-position"'>
                    <xsl:if test='contains(., "sub")'>
                        <xsl:text>vertical-align:sub; </xsl:text>
                    </xsl:if>
                    <xsl:if test='contains(., "sup")'>
                        <xsl:text>vertical-align:sup; </xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test='name()="fo:vertical-align"'>
                    <xsl:choose>
                    <xsl:when test='contains(., "bottom")'>
                        <xsl:text>vertical-align:bottom; </xsl:text>
                    </xsl:when>
                    <xsl:when test='contains(., "middle")'>
                        <xsl:text>vertical-align:middle; </xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>vertical-align:top; </xsl:text>
                    </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>

                <!-- debugEnabledMESSAGE:
                <xsl:otherwise>
                        <xsl:message>No transformation implemented for attribute-typ <xsl:value-of select="name()" /></xsl:message>
                </xsl:otherwise>-->
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>


    <!-- Changing border width measure to cm and
         enlarging border-width to the Mozilla browser(1.6) visible minimum (0.014 cm) -->
    <xsl:template name="round-up-border-width">
        <xsl:param name="value" />

        <xsl:variable name="border-width-in-cm">
            <xsl:call-template name="convert2cm">
                <xsl:with-param name="value" select="$value" />
            </xsl:call-template>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="number($border-width-in-cm) &lt; 0.014">
                <xsl:text>0.014cm</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$border-width-in-cm" /><xsl:text>cm</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
