/*************************************************************************
 *
 *  $RCSfile: asyncnotification.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2005/01/17 13:59:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef FORMS_SOURCE_INC_ASYNCNOTIFICATION_HXX
#define FORMS_SOURCE_INC_ASYNCNOTIFICATION_HXX

/** === begin UNO includes === **/
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XADAPTER_HPP_
#include <com/sun/star/uno/XAdapter.hpp>
#endif
/** === end UNO includes === **/

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _OSL_CONDITN_HXX_
#include <osl/conditn.hxx>
#endif

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#include <deque>

//........................................................................
namespace frm
{
//........................................................................

    //====================================================================
    //= EventDescription
	//====================================================================
    class EventDescription : ::rtl::IReference
    {
    private:
        oslInterlockedCount m_refCount;

    public:
        EventDescription();

	    virtual oslInterlockedCount SAL_CALL acquire();
	    virtual oslInterlockedCount SAL_CALL release();

    protected:
        virtual ~EventDescription();
    };

    //====================================================================
    //= typedefs
	//====================================================================
    typedef ::rtl::Reference< EventDescription >    EventReference;
    typedef ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
                                                    XComponentRef;

    //====================================================================
    //= IEventProcessor
    //====================================================================
    class IEventProcessor
    {
    public:
        /** process a single event
        */
        virtual void processEvent( const EventReference& _rEvent ) = 0;

        /** retrieve the component associated with the event processor
        */
        virtual XComponentRef getComponent() = 0;

        // lifetime control
        virtual void SAL_CALL acquire() = 0;
	    virtual void SAL_CALL release() = 0;
    };

    //====================================================================
    //= AsyncEventNotifier
    //====================================================================
    typedef ::vos::OThread                                                      AsyncEventNotifier_TBASE;
    typedef ::cppu::WeakImplHelper1< ::com::sun::star::lang::XEventListener >   AsyncEventNotifier_BASE;
    class AsyncEventNotifier
                :public AsyncEventNotifier_TBASE
                ,public AsyncEventNotifier_BASE
    {
    private:
        typedef ::std::deque< EventReference >      Events;

    private:
        ::osl::Mutex                    m_aMutex;
        ::osl::Condition                m_aCond;

        Events                          m_aEvents;

        IEventProcessor*                m_pEventProcessor;
        XComponentRef                   m_xComponent;

    protected:
        // OThread
        virtual void SAL_CALL run();
        virtual void SAL_CALL kill();
        virtual void SAL_CALL onTerminated();

    public:
        AsyncEventNotifier( IEventProcessor* _pProcessor );

        /** adds an event to the queue
        */
        void addEvent( const EventReference& _rEvent );

        // XEventListener
        virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& _rSource ) throw (::com::sun::star::uno::RuntimeException);

        /* resolve ambiguity : both OWeakObject and OObject have these memory operators */
        void* SAL_CALL operator new( size_t size ) throw() { return OThread::operator new( size ); }
        void SAL_CALL operator delete( void * p ) throw() { OThread::operator delete( p ); }

    protected:
        virtual ~AsyncEventNotifier();

    private:
        void    implStarted( );
        void    implTerminated( );
    };

//........................................................................
} // namespace frm
//........................................................................

#endif // FORMS_SOURCE_INC_ASYNCNOTIFICATION_HXX
