/*************************************************************************
 *
 *  $RCSfile: model.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/16 10:54:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _MODEL_HXX
#define _MODEL_HXX


// include for parent class(es)
#include <cppuhelper/implbase4.hxx>
#include <propertysetbase.hxx>
#include <com/sun/star/xforms/XModel.hpp>
#include <com/sun/star/xforms/XFormsUIHelper1.hpp>
#include <com/sun/star/util/XUpdatable.hpp>
#include <com/sun/star/lang/XUnoTunnel.hpp>


// includes for member variables
#include <com/sun/star/uno/Reference.hxx>
#include <map>


// forward declaractions
namespace com { namespace sun { namespace star
{
    namespace xml { namespace dom { class XDocument; } }
    namespace xml { namespace dom { class XNode; } }
    namespace uno { template<typename T> class Sequence; }
    namespace lang { class IndexOutOfBoundsException; }
    namespace lang { class IllegalArgumentException; }
    namespace beans { class XPropertySet; }
    namespace container { class XSet; }
    namespace container { class XNameContainer; }
    namespace frame { class XModel; }
} } }
namespace rtl { class OUString; }
namespace xforms
{
    class Binding;
    class MIP;
    class BindingCollection;
    class SubmissionCollection;
    class InstanceCollection;
    class EvaluationContext;
}


namespace xforms
{

/** An XForms Model. Contains:
 *  # (set of) instance data (XML DOM tree)
 *  # (set of) bindings
 *  # (set of) submissions
 *  # (NOT YET IMPLEMENTED) actions (set of)
 *
 * See http://www.w3.org/TR/xforms/ for more information.
 */
typedef cppu::ImplInheritanceHelper4<PropertySetBase,com::sun::star::xforms::XModel,com::sun::star::xforms::XFormsUIHelper1,com::sun::star::util::XUpdatable,com::sun::star::lang::XUnoTunnel> Model_t;
class Model : public Model_t
{
    // a number of local typedefs, to make the remaining header readable
    typedef com::sun::star::uno::Reference<com::sun::star::xml::dom::XDocument> XDocument_t;
    typedef com::sun::star::uno::Reference<com::sun::star::xml::dom::XNode> XNode_t;
    typedef com::sun::star::lang::IndexOutOfBoundsException IndexOutOfBoundsException_t;
    typedef com::sun::star::lang::IllegalArgumentException IllegalArgumentException_t;
    typedef com::sun::star::uno::Reference<com::sun::star::beans::XPropertySet> XPropertySet_t;
    typedef com::sun::star::uno::Reference<com::sun::star::xforms::XDataTypeRepository> XDataTypeRepository_t;
    typedef com::sun::star::uno::Reference<com::sun::star::container::XNameContainer> XNameContainer_t;
    typedef com::sun::star::uno::Reference<com::sun::star::xforms::XSubmission> XSubmission_t;
    typedef com::sun::star::uno::Reference<com::sun::star::frame::XModel> Frame_XModel_t;
    typedef com::sun::star::uno::Reference<com::sun::star::xforms::XModel> XModel_t;
    typedef com::sun::star::uno::Reference<com::sun::star::task::XInteractionHandler> XInteraction_t;

    typedef com::sun::star::uno::Reference<com::sun::star::container::XSet> XSet_t;
    typedef com::sun::star::beans::PropertyVetoException PropertyVetoException_t;
    typedef com::sun::star::beans::UnknownPropertyException UnknownPropertyException_t;
    typedef com::sun::star::util::VetoException VetoException_t;
    typedef com::sun::star::lang::WrappedTargetException WrappedTargetException_t;
    typedef com::sun::star::uno::RuntimeException RuntimeException_t;
    typedef com::sun::star::uno::Any Any_t;
    typedef com::sun::star::uno::Sequence<sal_Int8> IntSequence_t;
    typedef std::multimap<XNode_t,std::pair<void*,MIP> > MIPs_t;


private:

    rtl::OUString msID;                     /// the model ID
    BindingCollection* mpBindings;          /// the bindings
    SubmissionCollection* mpSubmissions;    /// the submissions
    InstanceCollection* mpInstances;        /// the instance(s)

    XDataTypeRepository_t mxDataTypes;      /// the XSD data-types used
    XDocument_t mxForeignSchema;            /// the XSD-schema part we cannot
                                            /// map onto data types
    rtl::OUString msSchemaRef;              /// xforms:model/@schema attribute

    XNameContainer_t mxNamespaces;          /// namespaces for entire model


    // references to mpBindings/mpSubmissions, for UNO reference counting
    XSet_t mxBindings;
    XSet_t mxSubmissions;
    XSet_t mxInstances;

    MIPs_t maMIPs;                          /// map nodes to their MIPs

    bool mbInitialized;                     /// has model been initialized ?

    static comphelper::PropertySetInfo* _getPropertySetInfo();

    void ensureAtLeastOneInstance();


public:

    /// create a new model with an empty, default instance
    Model();
    virtual ~Model() throw();

    // get Model implementation from API object
    static Model* getModel( const com::sun::star::uno::Reference<com::sun::star::xforms::XModel>& );

    xforms::EvaluationContext getEvaluationContext();


    static IntSequence_t getUnoTunnelID();


    // get/set that part of the schema, that we can't interpret as data types
    XDocument_t getForeignSchema() const;
    void setForeignSchema( const XDocument_t& );

    // get/set the xforms:model/@schema attribute
    rtl::OUString getSchemaRef() const;
    void setSchemaRef( const rtl::OUString& );


#if OSL_DEBUG_LEVEL > 1
    void dbg_assertInvariant() const;
#endif


    //
    // MIP (model item property) management
    //

    // register MIPs which apply to a given node; only to be called by bindings
    // (The pTag parameter serves only to be able to remove the MIPs
    // that were added using the same tag. No functions will be
    // performed on it; hence the void* type.)
    void addMIP( void* pTag, const XNode_t&, const MIP& );
    void removeMIPs( void* pTag );

    /// query which MIPs appy to the given node
    MIP queryMIP( const XNode_t& xNode ) const;

    /// re-bind all bindings
    void rebind();

    /// call defer notifications on all bindings
    void deferNotifications( bool );

    /// set a data value in the instance
    /// (also defers notifications)
    bool setSimpleContent( const XNode_t&, const rtl::OUString& );

    /// load instance data
    void loadInstance( sal_Int32 nInstance );
    void loadInstances();

    /// has model been initialized?
    bool isInitialized() const;



    //
    // XModel
    //    implement the xforms::XModel implementation
    //


    virtual rtl::OUString SAL_CALL getID()
        throw( RuntimeException_t );

    virtual void SAL_CALL setID( const rtl::OUString& sID )
        throw( RuntimeException_t );

    virtual void SAL_CALL initialize()
        throw( RuntimeException_t );

    virtual void SAL_CALL rebuild()
        throw( RuntimeException_t );

    virtual void SAL_CALL recalculate()
        throw( RuntimeException_t );

    virtual void SAL_CALL revalidate()
        throw( RuntimeException_t );

    virtual void SAL_CALL refresh()
        throw( RuntimeException_t );

    virtual void SAL_CALL submit( const rtl::OUString& sID )
        throw( VetoException_t, WrappedTargetException_t, RuntimeException_t );

    virtual void SAL_CALL submitWithInteraction( const ::rtl::OUString& id, const XInteraction_t& _rxHandler )
        throw( VetoException_t, WrappedTargetException_t, RuntimeException_t );

    virtual XDataTypeRepository_t SAL_CALL getDataTypeRepository(  )
        throw( RuntimeException_t );


    // XModel: instance management

    virtual XSet_t SAL_CALL getInstances()
        throw( RuntimeException_t );

    virtual XDocument_t SAL_CALL getInstanceDocument( const rtl::OUString& )
        throw( RuntimeException_t );

    virtual XDocument_t SAL_CALL getDefaultInstance()
        throw( RuntimeException_t );



    // XModel: binding management

    virtual XPropertySet_t SAL_CALL createBinding()
        throw( RuntimeException_t );

    virtual XPropertySet_t SAL_CALL cloneBinding( const XPropertySet_t& )
        throw( RuntimeException_t );

    virtual XPropertySet_t SAL_CALL getBinding( const rtl::OUString& )
        throw( RuntimeException_t );

    virtual XSet_t SAL_CALL getBindings()
        throw( RuntimeException_t );


    // XModel: submission management

    virtual XSubmission_t SAL_CALL createSubmission()
        throw( RuntimeException_t );

    virtual XSubmission_t SAL_CALL cloneSubmission( const XPropertySet_t& )
        throw( RuntimeException_t );

    virtual XSubmission_t SAL_CALL getSubmission( const rtl::OUString& )
        throw( RuntimeException_t );

    virtual XSet_t SAL_CALL getSubmissions()
        throw( RuntimeException_t );



    //
    // XFormsUIHelper1 & friends:
    //   (implementation in model_ui.cxx)
    //

    /// determine a reasonable control service for a given node
    /// (based on data type MIP assigned to the node)
    virtual rtl::OUString SAL_CALL getDefaultServiceNameForNode( const XNode_t& xNode ) throw (RuntimeException_t);

    /// call getDefaultBindingExpressionForNode with default evaluation context
    virtual rtl::OUString SAL_CALL getDefaultBindingExpressionForNode( const XNode_t& xNode ) throw (RuntimeException_t);

    /// determine a reasonable default binding expression for a given node
    /// and a given evaluation context
    /// @returns expression, or empty string if no expression could be derived
    rtl::OUString getDefaultBindingExpressionForNode(
        const XNode_t&,
        const EvaluationContext& );

    virtual rtl::OUString SAL_CALL getNodeDisplayName( const XNode_t&,
                                                       sal_Bool bDetail )
        throw( RuntimeException_t );

    virtual rtl::OUString SAL_CALL getNodeName( const XNode_t& )
        throw( RuntimeException_t );

    virtual rtl::OUString SAL_CALL getBindingName( const XPropertySet_t&,
                                                   sal_Bool bDetail )
        throw( RuntimeException_t );

    virtual rtl::OUString SAL_CALL getSubmissionName( const XPropertySet_t&,
                                                      sal_Bool bDetail )
        throw( RuntimeException_t );

    virtual XDocument_t SAL_CALL newInstance( const rtl::OUString& sName,
                                              const rtl::OUString& sURL,
                                              sal_Bool bURLOnce )
        throw( RuntimeException_t );

    virtual void SAL_CALL renameInstance( const rtl::OUString& sFrom,
                                          const rtl::OUString& sTo )
        throw( RuntimeException_t );

    virtual void SAL_CALL removeInstance( const rtl::OUString& sName )
        throw( RuntimeException_t );


    virtual XModel_t SAL_CALL newModel( const Frame_XModel_t& xComponent,
                                        const rtl::OUString& sName )
        throw( RuntimeException_t );
    virtual void SAL_CALL renameModel( const Frame_XModel_t& xComponent,
                                       const rtl::OUString& sFrom,
                                       const rtl::OUString& sTo )
        throw( RuntimeException_t );

    virtual void SAL_CALL removeModel( const Frame_XModel_t& xComponent,
                                       const rtl::OUString& sName )
        throw( RuntimeException_t );


    virtual XNode_t SAL_CALL createElement( const XNode_t& xParent,
                                            const rtl::OUString& sName )
        throw( RuntimeException_t );

    virtual XNode_t SAL_CALL createAttribute( const XNode_t& xParent,
                                              const rtl::OUString& sName )
        throw( RuntimeException_t );

    virtual XNode_t SAL_CALL renameNode( const XNode_t& xNode,
                                         const rtl::OUString& sName )
        throw( RuntimeException_t );

    virtual XPropertySet_t SAL_CALL getBindingForNode( const XNode_t&,
                                                       sal_Bool bCreate )
        throw( RuntimeException_t );

    virtual void SAL_CALL removeBindingForNode( const XNode_t& )
        throw( RuntimeException_t );

    virtual rtl::OUString SAL_CALL getResultForExpression(
        const XPropertySet_t& xBinding,
        sal_Bool bIsBindingExpression,
        const rtl::OUString& sExpression )
        throw( RuntimeException_t );

    virtual sal_Bool SAL_CALL isValidXMLName( const rtl::OUString& sName )
        throw( RuntimeException_t );

    virtual sal_Bool SAL_CALL isValidPrefixName( const rtl::OUString& sName )
        throw( RuntimeException_t );

    virtual void SAL_CALL setNodeValue(
        const XNode_t& xNode,
        const rtl::OUString& sValue )
        throw( RuntimeException_t );


    //
    // XPropertySet & friends:
    //   implement abstract methods from PropertySetHelper
    //

protected:

	virtual void _setPropertyValues(
        const comphelper::PropertyMapEntry** ppEntries,
        const Any_t* pValues )
        throw( UnknownPropertyException_t,
               PropertyVetoException_t,
               IllegalArgumentException_t,
               WrappedTargetException_t );

	virtual void _getPropertyValues(
        const comphelper::PropertyMapEntry** ppEntries,
        Any_t* pValue )
        throw( UnknownPropertyException_t,
               WrappedTargetException_t );


    //
    // XUpdatable
    //

public:
    virtual void SAL_CALL update()
        throw( RuntimeException_t );

    //
    // XUnoTunnel
    //

public:
    virtual sal_Int64 SAL_CALL getSomething( const IntSequence_t& )
        throw( RuntimeException_t );

    //
    // XTypeProvider::getImplementationId
    //

public:
    virtual IntSequence_t SAL_CALL getImplementationId()
        throw( RuntimeException_t );

};

// finally, allow 'shifting' of Model objects into/out of Any
void operator <<= ( com::sun::star::uno::Any&, const xforms::Model* );
bool operator >>= ( xforms::Model*, const com::sun::star::uno::Any&  );

} // namespace
#endif
