/*************************************************************************
 *
 *  $RCSfile: detectorfactory.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 16:04:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________
// includes of own project

#ifndef __FRAMEWORK_SERVICES_DETECTORFACTORY_HXX_
#include <services/detectorfactory.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_CONVERTER_HXX_
#include <classes/converter.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_______________________________________________
// includes of interfaces

//_______________________________________________
// includes of other projects

//_______________________________________________
// namespace

namespace framework{

//_______________________________________________
// non exported const

//_______________________________________________
// non exported definitions

//_______________________________________________
// declarations

/* css::uno::XInterface, XTypeProvider, XServiceInfo
   05.03.2003 14:01
 */

DEFINE_XINTERFACE_8(DetectorFactory                                  ,
                    OWeakObject                                      ,
                    DIRECT_INTERFACE(css::lang::XTypeProvider       ),
                    DIRECT_INTERFACE(css::lang::XServiceInfo        ),
                    DIRECT_INTERFACE(css::lang::XMultiServiceFactory),
                    DIRECT_INTERFACE(css::container::XNameContainer ),
                    DIRECT_INTERFACE(css::container::XNameReplace   ),
                    DIRECT_INTERFACE(css::container::XNameAccess    ),
                    DIRECT_INTERFACE(css::container::XElementAccess ),
                    DIRECT_INTERFACE(css::util::XFlushable          ))

DEFINE_XTYPEPROVIDER_8(DetectorFactory                ,
                       css::lang::XTypeProvider       ,
                       css::lang::XServiceInfo        ,
                       css::lang::XMultiServiceFactory,
                       css::container::XNameContainer ,
                       css::container::XNameReplace   ,
                       css::container::XNameAccess    ,
                       css::container::XElementAccess ,
                       css::util::XFlushable          )

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE(DetectorFactory                   ,
                                       ::cppu::OWeakObject               ,
                                       SERVICENAME_DETECTORFACTORY       ,
                                       IMPLEMENTATIONNAME_DETECTORFACTORY)

DEFINE_INIT_SERVICE(DetectorFactory, {} )

/*-------------------------------------------------------------------------------------------------
    05.03.2003 13:58
-------------------------------------------------------------------------------------------------*/
DetectorFactory::DetectorFactory( const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR )
        // Init baseclasses first
        : ThreadHelpBase      (                                )
        , ::cppu::OWeakObject (                                )
		// Init member
        , m_xSMGR             ( xSMGR                          )
        , m_aCache            (                                )
        , m_aListenerContainer( m_aLock.getShareableOslMutex() )
{
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:04
-------------------------------------------------------------------------------------------------*/
DetectorFactory::~DetectorFactory()
{
    // Our singleton cache will be released automaticly be decreasing it's ref count ...
    // But our listener must be informed.
    m_aListenerContainer.clear();
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:05
-------------------------------------------------------------------------------------------------*/
css::uno::Reference< css::uno::XInterface > SAL_CALL DetectorFactory::createInstance( const ::rtl::OUString& sName )
    throw(css::uno::Exception       ,
          css::uno::RuntimeException)
{
    // shared implementation ... bug called without optional arguments!
    return createInstanceWithArguments(sName, css::uno::Sequence< css::uno::Any >());
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:08
-------------------------------------------------------------------------------------------------*/
css::uno::Reference< css::uno::XInterface > SAL_CALL DetectorFactory::createInstanceWithArguments( const ::rtl::OUString&                     sName      ,
                                                                                                   const css::uno::Sequence< css::uno::Any >& lArguments )
    throw(css::uno::Exception       ,
          css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);

        // check, if this item exists inside this container
        css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
        if (!m_aCache.existsDetector(sName))
            throw css::uno::Exception(DECLARE_ASCII("detector is unknown"), xThis);
        // create the detect service.
        css::uno::Reference< css::uno::XInterface > xDetector = m_xSMGR->createInstance(sName);
        // get it's properties.
        // They are neccessary for initialization of the new created detect service.
        css::uno::Sequence< css::beans::PropertyValue > lCFGData = m_aCache.getDetectorProperties(sName);

    aReadLock.unlock();
    // } SAFE

    // initialize it with it's own configuration data
    css::uno::Reference< css::lang::XInitialization > xInit(xDetector, css::uno::UNO_QUERY);
    if (xInit.is())
    {
        sal_Int32                           nCount   = lArguments.getLength();
        css::uno::Sequence< css::uno::Any > lInitData(nCount+1);

        lInitData[0] <<= lCFGData;
        for (sal_Int32 s=0, d=1; s<nCount; ++s, ++d)
            lInitData[d] = lArguments[s];

        xInit->initialize(lInitData);
    }

    return xDetector;
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:19
-------------------------------------------------------------------------------------------------*/
css::uno::Sequence< ::rtl::OUString > SAL_CALL DetectorFactory::getAvailableServiceNames()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
        return m_aCache.getAllDetectorNames();
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:19
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::insertByName( const ::rtl::OUString& sName        ,
                                             const css::uno::Any&   aPropertySet )
    throw(css::lang::IllegalArgumentException  ,
          css::container::ElementExistException,
          css::lang::WrappedTargetException    ,
          css::uno::RuntimeException           )
{
    // check arguments.
    css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
    if (sName.getLength() < 1)
        throw css::lang::IllegalArgumentException(DECLARE_ASCII("empty name value not very usefull"), xThis, 0 );

    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    if (!(aPropertySet >>= lProperties))
        throw css::lang::IllegalArgumentException(DECLARE_ASCII("missing property set"), xThis, 1 );

    // Attention: Some exceptions are thrown by following cache method automaticly.
    // The last parameter == sal_True force it.
    try
    {
        // SAFE {
        WriteGuard aWriteLock(m_aLock);
            sal_Bool bEnableExceptions = sal_True;
            m_aCache.addDetector(sName, lProperties, bEnableExceptions);
        aWriteLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        throw css::lang::WrappedTargetException(DECLARE_ASCII("wrapped by inserting detect service"), xThis, css::uno::makeAny(exInvalid));
    }
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:27
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::removeByName( const ::rtl::OUString& sName )
    throw(css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    // Attention: Some exceptions are thrown by following cache method automaticly.
    // The last parameter == sal_True force it.
    try
    {
        // SAFE {
        WriteGuard aWriteLock(m_aLock);
            sal_Bool bEnableExceptions = sal_True;
            m_aCache.removeDetector(sName, bEnableExceptions);
        aWriteLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
        throw css::lang::WrappedTargetException(DECLARE_ASCII("wrapped by removing detect service"), xThis, css::uno::makeAny(exInvalid));
    }
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:35
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::replaceByName( const ::rtl::OUString& sName        ,
                                              const css::uno::Any&   aPropertySet )
    throw(css::lang::IllegalArgumentException   ,
          css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    // check parameter
    css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
    if (sName.getLength() < 1)
        throw css::lang::IllegalArgumentException(DECLARE_ASCII("empty name value not very usefull"), xThis, 0 );

    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    if (!(aPropertySet >>= lProperties))
        throw css::lang::IllegalArgumentException(DECLARE_ASCII("missing property set"), xThis, 1 );

    // Attention: Some exceptions are thrown by following cache method automaticly.
    // The last parameter == sal_True force it.
    try
    {
        // SAFE {
        WriteGuard aWriteLock(m_aLock);
            sal_Bool bEnableExceptions = sal_True;
            m_aCache.replaceDetector(sName, lProperties, bEnableExceptions);
        aWriteLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        throw css::lang::WrappedTargetException(DECLARE_ASCII("wrapped by replacing detect service"), xThis, css::uno::makeAny(exInvalid));
    }
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:39
-------------------------------------------------------------------------------------------------*/
css::uno::Any SAL_CALL DetectorFactory::getByName( const ::rtl::OUString& sName )
    throw(css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);

        // check for existing item
        css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
        if (!m_aCache.existsDetector(sName))
            throw css::container::NoSuchElementException(DECLARE_ASCII("item does not exist inside this container"), xThis);
        // get it's properties
        css::uno::Any aPropertySet;
        aPropertySet <<= m_aCache.getDetectorProperties(sName);

    aReadLock.unlock();
    // } SAFE

    return aPropertySet;
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:39
-------------------------------------------------------------------------------------------------*/
css::uno::Sequence< ::rtl::OUString > SAL_CALL DetectorFactory::getElementNames()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
        return m_aCache.getAllDetectorNames();
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:41
-------------------------------------------------------------------------------------------------*/
sal_Bool SAL_CALL DetectorFactory::hasByName( const ::rtl::OUString& sName )
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
        return m_aCache.existsDetector(sName);
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:42
-------------------------------------------------------------------------------------------------*/
css::uno::Type SAL_CALL DetectorFactory::getElementType()
    throw(css::uno::RuntimeException)
{
    return( ::getCppuType( (const css::uno::Sequence< css::beans::PropertyValue >*)NULL ) );
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:42
-------------------------------------------------------------------------------------------------*/
sal_Bool SAL_CALL DetectorFactory::hasElements()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
        return m_aCache.hasDetectors();
}

/*-------------------------------------------------------------------------------------------------
    05.03.2003 14:50
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::flush()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    WriteGuard aWriteLock(m_aLock);

        // it checks all made changes for detect services
        // If it found some invalid states or items, it try to repair it.
        // If this was not successfully - we should throw an exception.
        // Because this cache will not be useable further more!
        // Supress updating of the configuration layer.
        // Otherwhise may wrong data are written to it and next start of office can fail.
        css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
        if (!m_aCache.validateAndRepairDetectors())
            throw css::uno::RuntimeException(DECLARE_ASCII("cache seams to be invalid and could not be repaired"), xThis);

        m_aCache.flush(DataContainer::E_DETECTSERVICE);

    aWriteLock.unlock();
    // } SAFE

    // inform listener
    // dont lock our mutex here ...
    // we share it with this helper instance!
    ::cppu::OInterfaceContainerHelper* pContainer = m_aListenerContainer.getContainer(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL));
    if (!pContainer)
        return;

    css::lang::EventObject aEvent;
    aEvent.Source = xThis;
    ::cppu::OInterfaceIteratorHelper pIterator(*pContainer);
    while (pIterator.hasMoreElements())
    {
        try
        {
            ((css::util::XFlushListener*)pIterator.next())->flushed(aEvent);
        }
        catch(const css::uno::RuntimeException&)
        {
            // fiter invalid listener (already disposed ..)
            // or may our bridge was damaged ...
            // Then we will get an exception for every remote call.
            pIterator.remove();
        }
    }
}

/*-------------------------------------------------------------------------------------------------
    07.03.2003 08:09
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::addFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
    throw(css::uno::RuntimeException)
{
    css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
    if (!xListener.is())
        throw css::uno::RuntimeException(DECLARE_ASCII("listener reference invalid"), xThis);

    // dont lock our mutex here ...
    // we share it with this helper instance!
    m_aListenerContainer.addInterface(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL), xListener);
}

/*-------------------------------------------------------------------------------------------------
    07.03.2003 08:09
-------------------------------------------------------------------------------------------------*/
void SAL_CALL DetectorFactory::removeFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
    throw(css::uno::RuntimeException)
{
    css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
    if (!xListener.is())
        throw css::uno::RuntimeException(DECLARE_ASCII("listener reference invalid"), xThis);

    // dont lock our mutex here ...
    // we share it with this helper instance!
    m_aListenerContainer.removeInterface(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL), xListener);
}

} // namespace framework
