/*************************************************************************
 *
 *  $RCSfile: eventsconfiguration.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/05/03 13:23:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_XML_EVENTSCONFIGURATION_HXX_
#include <xml/eventsconfiguration.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_EVENTSDOCUMENTHANDLER_HXX_
#include <xml/eventsdocumenthandler.hxx>
#endif

#ifndef __FRAMEWORK_XML_SAXNAMESPACEFILTER_HXX_
#include <xml/saxnamespacefilter.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::io;


namespace framework
{

static Reference< XParser > GetSaxParser(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	//Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	//return Reference< XParser >( xServiceManager->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )), UNO_QUERY);
	return Reference< XParser >( xServiceFactory->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )), UNO_QUERY);
}

static Reference< XDocumentHandler > GetSaxWriter(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	//Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	//return Reference< XDocumentHandler >( xServiceManager->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;
	return Reference< XDocumentHandler >( xServiceFactory->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;
}

// #110897#
sal_Bool EventsConfiguration::LoadEventsConfig( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rInStream, EventsConfig& aItems )
{
	Reference< XParser > xParser( GetSaxParser( xServiceFactory ) );
	Reference< XInputStream > xInputStream( 
								(::cppu::OWeakObject *)new utl::OInputStreamWrapper( rInStream ), 
								UNO_QUERY );

	// connect stream to input stream to the parser
	InputSource aInputSource;

	aInputSource.aInputStream = xInputStream;

	// create namespace filter and set events document handler inside to support xml namespaces
	Reference< XDocumentHandler > xDocHandler( new OReadEventsDocumentHandler( aItems ));
	Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

	// connect parser and filter
	xParser->setDocumentHandler( xFilter );

	try
	{
		xParser->parseStream( aInputSource );
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch( SAXException& )
	{
		return sal_False;
	}
	catch( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

// #110897#
sal_Bool EventsConfiguration::StoreEventsConfig( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rOutStream, const EventsConfig& aItems )
{
	Reference< XDocumentHandler > xWriter( GetSaxWriter( xServiceFactory ) );

	Reference< XOutputStream > xOutputStream( 
								(::cppu::OWeakObject *)new utl::OOutputStreamWrapper( rOutStream ), 
								UNO_QUERY );

	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
	xDataSource->setOutputStream( xOutputStream );

	try
	{
		OWriteEventsDocumentHandler aWriteEventsDocumentHandler( aItems, xWriter );
		aWriteEventsDocumentHandler.WriteEventsDocument();
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch ( SAXException& )
	{
		return sal_False;
	}
	catch ( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

}
