
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ForwardDclPanel;
import org.netbeans.modules.openoffice.wizard.keys.ForwardDclKey;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;


public class ForwardDcl extends LeafNode
{

    public ForwardDcl(ForwardDclKey forwarddclkey)
    {
        super(forwarddclkey);
        setName(forwarddclkey.getName());
        if(forwarddclkey.isInterface())
            setIconBase("org/netbeans/modules/openoffice/wizard/ui/interface");
        else
            setIconBase("org/netbeans/modules/openoffice/wizard/ui/value");
    }

    public String generateSelf(int i)
    {
        String s = "";
        for(int j = 0; j < i; j++)
            s = s + "    ";

        if(((ForwardDclKey)key).isInterface())
            s = s + "interface ";
        else
            s = s + "valuetype ";
        s = s + getName() + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        ForwardDclPanel forwarddclpanel = new ForwardDclPanel();
        forwarddclpanel.setName(getName());
        forwarddclpanel.setInterface(((ForwardDclKey)key).isInterface());
        return forwarddclpanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof ForwardDclPanel)
        {
            ForwardDclPanel forwarddclpanel = (ForwardDclPanel)BasePanel;
            String s = forwarddclpanel.getName();
            boolean flag = forwarddclpanel.isInterface();
            if(!s.equals(getName()))
            {
                setName(s);
                key.setName(s);
            }
            if(flag != ((ForwardDclKey)key).isInterface())
            {
                ((ForwardDclKey)key).setInterface(flag);
                if(flag)
                    setIconBase("org/netbeans/modules/openoffice/wizard/ui/interface");
                else
                    setIconBase("org/netbeans/modules/openoffice/wizard/ui/value");
            }
        }
    }

    
    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    private static final String INTERFACE_ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/interface";
    private static final String VALUETYPE_ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/value";
}
