/*************************************************************************
 *
 *  $RCSfile: chartdlg.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2004/06/04 11:30:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SC_CHARTDLG_HXX
#define SC_CHARTDLG_HXX

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef SC_ANYREFDG_HXX
#include "anyrefdg.hxx"
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

class ScViewData;
class ScDocument;
class ScRangeUtil;
class ScChartArray;
class SfxItemSet;
class SchMemChart;


//============================================================================

class ScChartDlg : public ScAnyRefDlg
{
public:
					ScChartDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
								ScViewData* pData );
					~ScChartDlg();

	virtual void	SetReference( const ScRange& rRef, ScDocument* pDoc );
	virtual void	AddRefEntry();
	virtual BOOL	IsRefInputMode() const;
	virtual void	SetActive();
	virtual BOOL	Close();
    virtual void    Activate();

private:
    FixedLine       aFL_1;
	FixedText		aFT_RANGE;
	ScRefEdit		aET_RANGE;
	ScRefButton		aRB_RANGE;

	CheckBox		aCB_COLHEADER;
	CheckBox		aCB_ROWHEADER;

	FixedText		aFT_TOTABLE;
	ListBox			aLB_TOTABLE;

    FixedText       aFT_TEXT;
    FixedLine       aFL_HLINE;

	HelpButton		aBTN_HELP;
	CancelButton	aBTN_CANCEL;
	PushButton		aBTN_PREV;
	PushButton		aBTN_NEXT;
	PushButton		aBTN_FINISH;

	// Referenzeingabe mit der Maus:
	ScRangeListRef	aRangeListRef;
	ScViewData*		pViewData;
	ScDocument*		pDoc;
	ScRangeUtil*	pRangeUtil;
	Selection		theCurSel;

	ScChartArray*	pScChartArray;
	SchMemChart*	pMemChart;
	SfxItemSet*		pInItemSet;
	SfxItemSet*		pOutItemSet;

	ModalDialog*	pScChartTestDlg;
	BOOL			bChildOpen;

	SCTAB			nCurTab;
	BOOL			bIsEditChart;
	String			aEditChartName;

#ifdef _CHARTDLG_CXX
	DECL_LINK( ImpBtnClickHdl, Button* );

	void	ImpFillTableList();
	void	ImpSwitchToChart();
	void	ImpSwitchFromChart();
	void	ImpCreateChartObject();
	void	ImpSetRangeList( const ScRange& rNew );
	void	ImpSetReferenceList( const ScRangeListRef&, ScDocument* pDoc );
#endif
};



#endif //SC_CHARTDLG_HXX
