/*************************************************************************
 *
 *  $RCSfile: invmerge.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/02/03 12:55:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include <vcl/window.hxx>
#include <tools/debug.hxx>

#include "invmerge.hxx"

//------------------------------------------------------------------

ScInvertMerger::ScInvertMerger( Window* pWindow ) :
	pWin( pWindow )
{
	//	both rectangles empty
}

ScInvertMerger::~ScInvertMerger()
{
	Flush();
}

void ScInvertMerger::Flush()
{
	FlushLine();
	FlushTotal();

	DBG_ASSERT( aLineRect.IsEmpty() && aTotalRect.IsEmpty(), "Flush: not empty" );
}

void ScInvertMerger::FlushTotal()
{
	if( aTotalRect.IsEmpty() )
		return;							// nothing to do

	pWin->Invert( aTotalRect, INVERT_HIGHLIGHT );
	aTotalRect.SetEmpty();
}

void ScInvertMerger::FlushLine()
{
	if( aLineRect.IsEmpty() )
		return;							// nothing to do

	if ( aTotalRect.IsEmpty() )
	{
		aTotalRect = aLineRect;			// start new total rect
	}
	else
	{
		if ( aLineRect.Left()  == aTotalRect.Left()  &&
			 aLineRect.Right() == aTotalRect.Right() &&
			 aLineRect.Top()   == aTotalRect.Bottom() + 1 )
		{
			// extend total rect
			aTotalRect.Bottom() = aLineRect.Bottom();
		}
		else
		{
			FlushTotal();					// draw old total rect
			aTotalRect = aLineRect;			// and start new one
		}
	}

	aLineRect.SetEmpty();
}

void ScInvertMerger::AddRect( const Rectangle& rRect )
{
	if ( aLineRect.IsEmpty() )
	{
		aLineRect = rRect;			// start new line rect
	}
	else
	{
		Rectangle aJustified = rRect;
		if ( rRect.Left() > rRect.Right() )		// switch for RTL layout
		{
			aJustified.Left() = rRect.Right();
			aJustified.Right() = rRect.Left();
		}

		BOOL bDone = FALSE;
		if ( aJustified.Top()    == aLineRect.Top()    &&
			 aJustified.Bottom() == aLineRect.Bottom() )
		{
			// try to extend line rect
			if ( aJustified.Left() == aLineRect.Right() + 1 )
			{
				aLineRect.Right() = aJustified.Right();
				bDone = TRUE;
			}
			else if ( aJustified.Right() + 1 == aLineRect.Left() )	// for RTL layout
			{
				aLineRect.Left() = aJustified.Left();
				bDone = TRUE;
			}
		}
		if (!bDone)
		{
			FlushLine();				// use old line rect for total rect
			aLineRect = aJustified;		// and start new one
		}
	}
}




