/*************************************************************************
 *
 *  $RCSfile: axisid.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 09:05:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "axisid.hxx"
#include "glob.hxx"



/*************************************************************************
|*
|* Objekt-Id ermitteln;
|* Liefert -1, wenn das Objekt keine Id hat
|*
\************************************************************************/

SchAxisId* GetAxisId (const SdrObject& rObj)
{
	for (long i = 0;
			  i < rObj.GetUserDataCount();
			  i ++)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);

		if (pData && (pData->GetId() == SCH_AXIS_ID)) return (SchAxisId*) pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Objekt mit Id suchen;
|* liefert NULL, wenn kein Objekt gefunden wurde.
|*
\************************************************************************/

SdrObject *GetObjWithAxisId (long             nAxisId,
							 const SdrObjList &rObjList,
							 long             *pIndex,
							 SdrIterMode      eMode)
{
	long           nIndex = 0;
	SdrObjListIter aIterator (rObjList, eMode);

	while (aIterator.IsMore ())
	{
		SdrObject *pObj    = aIterator.Next ();
		SchAxisId *pAxisId = GetAxisId (*pObj);

		if (pAxisId && (pAxisId->AxisId () == nAxisId))
		{
			if (pIndex) *pIndex = nIndex;
			return pObj;
		}

		nIndex++;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId () :
	SdrObjUserData (SchInventor, SCH_AXIS_ID, 0),
	nAxisId (0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId (long nId) :
	SdrObjUserData (SchInventor, SCH_AXIS_ID, 0),
	nAxisId (nId)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId (const SchAxisId &rAxisId) :
	SdrObjUserData (rAxisId),
	nAxisId (rAxisId.nAxisId)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchAxisId::Clone(SdrObject *pObj) const
{
	return new SchAxisId (*this);
}

/*************************************************************************
|*
|* Daten in Stream schreiben
|*
\************************************************************************/

//BFS01void SchAxisId::WriteData(SvStream& rOut)
//BFS01{
//BFS01	SdrObjUserData::WriteData(rOut);
//BFS01
//BFS01	rOut << nAxisId;
//BFS01}


/*************************************************************************
|*
|* Daten aus Stream lesen
|*
\************************************************************************/

//BFS01void SchAxisId::ReadData(SvStream& rIn)
//BFS01{
//BFS01	SdrObjUserData::ReadData(rIn);
//BFS01
//BFS01	rIn >> nAxisId;
//BFS01}



