/*************************************************************************
 *
 *  $RCSfile: chdescr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2002/05/27 09:17:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "chdescr.hxx"
#include "chaxis.hxx"

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#include "float.h"
#include "globfunc.hxx"
#include "schgroup.hxx"
#include "chtscene.hxx"

ChartDataDescription::ChartDataDescription(long nCols, long nRows, SdrObjList *pList,
										   ChartModel* pModel, BOOL bEnable) :
		mnRows(nRows),
		mnCols(nCols),
		mpList(pList),
		mpModel(pModel),
		mbEnable(bEnable),
		mpDescrLists(NULL),
		mpDescrArray(NULL),
		mpDescrGroups(NULL)
{
}

void ChartDataDescription::Build( BOOL bRowDescr )
{
	Dirty2D( bRowDescr );
	if(mpList && mpDescrGroups)
	{
		for( long nRow=0; nRow<mnRows; nRow++ )
		{
			if(mpDescrGroups[nRow])
				mpList->NbcInsertObject( mpDescrGroups[nRow] );
		}
	}
}

void ChartDataDescription::Build3D( ChartScene *pScene, Matrix4D* pMatrix )
{
	if(pScene && mpDescrGroups)
	{
		for( long nRow=0; nRow<mnRows; nRow++ )
		{
			for( long nCol=0; nCol<mnCols; nCol++ )
			{
				long nIndex = nCol + nRow * mnCols;
				if( mpDescrArray[nIndex].fValue != DBL_MIN )
				{
					mpDescrArray[nIndex].pLabelObj->SetMarkProtect(TRUE);
					E3dLabelObj* pLabel=new E3dLabelObj(mpDescrArray[nIndex].aTextPos3D,
														mpDescrArray[nIndex].pLabelObj);

					CHART_TRACE3( "Descr::Build3D TextPos = (%ld, %ld, %ld)",
								  mpDescrArray[ nIndex ].aTextPos3D.X(),
								  mpDescrArray[ nIndex ].aTextPos3D.Y(),
								  mpDescrArray[ nIndex ].aTextPos3D.Z() );
					
					pLabel->SetMarkProtect(TRUE);
					pScene->Insert3DObj(pLabel);
					if(pMatrix)
						pLabel->NbcSetTransform(*pMatrix);
				}
			}
		}
	}
}

ChartDataDescription::~ChartDataDescription()
{
	if(mpDescrLists)
		delete[] mpDescrLists;
	if(mpDescrGroups)
		delete[] mpDescrGroups;
	if(mpDescrArray)
		delete[] mpDescrArray;
}

void ChartDataDescription::Create(long nRow)
{
	if(!mpDescrArray)
	{
		mpDescrArray = new DataDescription[ mnRows * mnCols ];
		long nElements = mnRows * mnCols;
		while(nElements)
		{
			nElements--;
			mpDescrArray[nElements].bSymbol = FALSE;
			mpDescrArray[nElements].pLabelObj   = NULL;
			mpDescrArray[nElements].fValue  = DBL_MIN;
			mpDescrArray[nElements].aTextPos2D = Point(0,0);
		}
	}
	if(!mpDescrLists)
	{
		mpDescrLists =new SdrObjList*[mnRows];
		mpDescrGroups=new SchObjGroup*[mnRows];
		for(long n=0;n<mnRows;n++)
		{
			mpDescrLists[n] =NULL;
			mpDescrGroups[n]=NULL;
		}
	}
	
	if(!mpDescrLists[nRow])
	{
		mpDescrGroups[nRow] = (SchObjGroup*)CreateSimpleGroup( CHOBJID_DIAGRAM_DESCRGROUP, TRUE, TRUE );
		mpDescrGroups[nRow]->InsertUserData( new SchDataRow(nRow) );
		mpDescrLists[nRow] = mpDescrGroups[nRow]->GetSubList();
	}
}

DataDescription* ChartDataDescription::Insert( long nCol, long nRow, const SfxItemSet& rAttr, Point aPos,
											   BOOL bPercent, ChartAdjust eAdjust, ChartAxis* pAxis )
{
	SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)rAttr.Get(SCHATTR_DATADESCR_DESCR)).GetValue();

	if(mbEnable && eDescr != CHDESCR_NONE)
	{
		Create(nRow); //evtl. Array und Liste erstellen
		long nIndex = nCol + nRow * mnCols;

		mpDescrArray[nIndex].eDescr  = eDescr;
		mpDescrArray[nIndex].bSymbol = ((const SfxBoolItem&)rAttr.Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
		mpDescrArray[nIndex].fValue  = mpModel->GetData(nCol,nRow,bPercent);
		mpDescrArray[nIndex].eAdjust = eAdjust;
		mpDescrArray[nIndex].aTextPos2D = aPos;
		mpModel->CreateDataDescr(mpDescrArray[nIndex],nCol,nRow,pAxis,bPercent);
		return &mpDescrArray[nIndex];
	}
	return NULL;
}

void ChartDataDescription::Dirty2D( BOOL bRowDescr )
{

	if(mpDescrLists)
	{
		for( long nRow = 0; nRow < mnRows; nRow ++ )
		{
			if( mpDescrLists[nRow] )
			{
				for( long nCol = 0; nCol < mnCols; nCol++ )
				{
						long nIndex = nCol + nRow * mnCols;
						if (mpDescrArray[nIndex].fValue != DBL_MIN)
							if (mpDescrArray[nIndex].pLabelObj)
								mpDescrLists[nRow]->NbcInsertObject(mpDescrArray[nIndex].pLabelObj);
				}
			}
		}
	}
}

