/*************************************************************************
 *
 *  $RCSfile: attrib.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2004/08/20 08:44:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop
#include <svx/svxids.hrc> //add CHINA001 
#define ITEMID_FONTLIST 	SID_ATTR_CHAR_FONTLIST
#define ITEMID_ESCAPEMENT	SID_ATTR_CHAR_ESCAPEMENT
#define ITEMID_CASEMAP		SID_ATTR_CHAR_CASEMAP
#define ITEMID_NUMBERINFO	SID_ATTR_NUMBERFORMAT_INFO
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE //CHINA001 
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST //CHINA001 
#define ITEMID_HATCH_LIST		SID_HATCH_LIST //CHINA001 
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST //CHINA001 
#define ITEMID_DASH_LIST			SID_DASH_LIST	//CHINA001 
#define ITEMID_LINEEND_LIST		SID_LINEEND_LIST	//CHINA001 
#include "svx/xoutx.hxx"
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#include <svtools/intitem.hxx> //add CHINA001 
#include <svx/drawitem.hxx> //add CHINA001 
#include <svx/ofaitem.hxx> //add CHINA001 
#include <svx/svxgrahicitem.hxx> //CHINA001 
//CHINA001 #include <svx/numfmt.hxx>
#include <svx/dialogs.hrc>
//CHINA001 #include <svx/chardlg.hxx>
#include <svx/flagsdef.hxx> //CHINA001 
#ifndef _SVX_FLSTITEM_HXX //CHINA001 
#include <svx/flstitem.hxx> //CHINA001 
#endif //CHINA001 
#include <svx/tabline.hxx>

#include "schresid.hxx"
#include "attrib.hrc"
#include "schdll.hxx"
#include "chtmodel.hxx"
#include "schattr.hxx"
#include "attrib.hxx"

#include "tplabel.hxx"
#include "tplabel.hrc"
#include "tpscaley.hxx"
#include "tpscaley.hrc"

#include <svx/numinf.hxx>

/************************************************************************/

const USHORT nNoArrowDlg			= 1100;
const USHORT nNoArrowNoShadowDlg	= 1101;

/*************************************************************************
|*
|* Liefert die Ressourcen-Id fuer den angegebenen Attributs-Typ
|*
\************************************************************************/

USHORT SchAttribTabDlg::GetResId(AttrType eType)
{
	switch (eType)
	{
		case ATTR_TITLE:			return TAB_TITLE;
		case ATTR_LEGEND:			return TAB_LEGEND;
		case ATTR_DATA_ROW:			return TAB_DATA_ROW;
		case ATTR_DATA_LINE:		return TAB_DATA_LINE;
		case ATTR_DATA_POINT:		return TAB_DATA_POINT;
		case ATTR_AXIS:				return TAB_AXIS;
		case ATTR_X_AXIS_2D:
		case ATTR_X_AXIS_3D:		return TAB_X_AXIS;
		case ATTR_Y_AXIS_2D:
		case ATTR_Y_AXIS_3D:		return TAB_Y_AXIS;
		case ATTR_Z_AXIS:			return TAB_Z_AXIS;
		case ATTR_GRID:				return TAB_GRID;
		case ATTR_LINE:             return TAB_LINE;
		case ATTR_DIAGRAM_AREA:		return TAB_DIAGRAM_AREA;
		case ATTR_DIAGRAM_WALL:		return TAB_DIAGRAM_WALL;
		case ATTR_DIAGRAM_FLOOR:	return TAB_DIAGRAM_FLOOR;
		case ATTR_DIAGRAM_STOCK_LOSS: return TAB_DIAGRAM_STOCK_LOSS;
		case ATTR_DIAGRAM_STOCK_PLUS: return TAB_DIAGRAM_STOCK_PLUS;

		default:					return 0;
	}
}

/*************************************************************************
|*
|* Konstruktor des Tab-Dialogs: Fuegt die Seiten zum Dialog hinzu
|*
\************************************************************************/

SchAttribTabDlg::SchAttribTabDlg(Window* pParent, AttrType eType,
								 const SfxItemSet* pAttr,
								 const SfxObjectShell* pDocShell,
								 const ChartModel* pModel,
								 int   nID,
								 int   nType,
								 const SfxItemSet* pSymbolAttr,
								 Graphic aGraphic) :
	SfxTabDialog(pParent, SchResId(GetResId(eType)), pAttr),
	pColorTab(pModel->GetColorTable()),
	maSymbolGraphic(aGraphic),
	pDashList(pModel->GetDashList()),
	pLineEndList(pModel->GetLineEndList()),
	pGradientList(pModel->GetGradientList()),
	pHatchingList(pModel->GetHatchList()),
	pBitmapList(pModel->GetBitmapList()),
	nPageType(0),
	nDlgType(2),
	nPos(0),
	mpSymbolAttr(pSymbolAttr),
	nColorTableState(CT_NONE),
	nBitmapListState(CT_NONE),
	nGradientListState(CT_NONE),
	nHatchingListState(CT_NONE),
	eAttrType(eType),
	rDocShell(*pDocShell)
{
	pMyModel = (ChartModel*) pModel;
	FreeResource();

	switch (eAttrType)
	{
		case ATTR_TITLE:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_AREA);//CHINA001 AddTabPage(RID_SVXPAGE_AREA, SvxAreaTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_TRANSPARENCE);//CHINA001 AddTabPage(RID_SVXPAGE_TRANSPARENCE, SvxTransparenceTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_ALIGNMENT, SchAlignmentTabPage::Create, NULL);
			/*if (//(nID == CHOBJID_DIAGRAM_TITLE_X_AXIS) || (nID == CHOBJID_DIAGRAM_TITLE_Z_AXIS) ||
				(nID == CHOBJID_TITLE_MAIN) || (nID == CHOBJID_TITLE_SUB))
				RemoveTabPage (TP_ALIGNMENT);*/
			nDlgType = nNoArrowDlg;
			break;

		case ATTR_LEGEND:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_AREA);//CHINA001 AddTabPage(RID_SVXPAGE_AREA, SvxAreaTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_TRANSPARENCE);//CHINA001 AddTabPage(RID_SVXPAGE_TRANSPARENCE, SvxTransparenceTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_LEGEND_POS, SchLegendPosTabPage::Create, NULL);
			nDlgType = nNoArrowDlg;
			break;

		case ATTR_DATA_ROW:
		case ATTR_DATA_POINT:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_AREA);//CHINA001 AddTabPage(RID_SVXPAGE_AREA, SvxAreaTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_TRANSPARENCE);//CHINA001 AddTabPage(RID_SVXPAGE_TRANSPARENCE, SvxTransparenceTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_DATA_DESCR, SchDataDescrTabPage::Create, NULL);
			AddTabPage(TP_STAT, SchStatisticTabPage::Create, NULL);
			//	Layout tab only for 3D bar and column charts.
			if (pMyModel->Is3DChart() && (pMyModel->IsBar() || pMyModel->IsCol(0)))
				AddTabPage(TP_LAYOUT,SchLayoutTabPage::Create, NULL);
			else
				RemoveTabPage(TP_LAYOUT);
			AddTabPage(TP_OPTIONS,SchOptionTabPage::Create, NULL);
			if ((((const SfxInt32Item &)pAttr->Get (SCHATTR_DUMMY1)).GetValue () == CHOBJID_DIAGRAM_DATA) ||
				!pMyModel->IsStatisticChart())
				RemoveTabPage (TP_STAT);
			if(eAttrType==ATTR_DATA_POINT)
			{
				RemoveTabPage(TP_OPTIONS);
			}

			if(!pMyModel->CanAxis(CHART_AXIS_SECONDARY_Y))
				RemoveTabPage(TP_OPTIONS);

			if(pMyModel->ChartStyle() == CHSTYLE_3D_PIE)
			{
//				RemoveTabPage (RID_SVXPAGE_LINE);
				RemoveTabPage(TP_LAYOUT);
			}

			nDlgType = nNoArrowNoShadowDlg;
			break;

		case ATTR_DATA_LINE:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_DATA_DESCR, SchDataDescrTabPage::Create, NULL);
			//if (pMyModel->IsStatisticChart())
			AddTabPage(TP_STAT, SchStatisticTabPage::Create, NULL);
			AddTabPage(TP_OPTIONS,SchOptionTabPage::Create, NULL);
			if (!pMyModel->IsStatisticChart())
				RemoveTabPage (TP_STAT);
			if(!pMyModel->CanAxis(CHART_AXIS_SECONDARY_Y))
				RemoveTabPage(TP_OPTIONS);
			nDlgType = nNoArrowDlg;
			break;


		case ATTR_AXIS:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_AXIS_LABEL, SchAxisLabelTabPage::Create, NULL);
			nDlgType = nNoArrowDlg;
			break;

		case ATTR_X_AXIS_2D:
		case ATTR_X_AXIS_3D:
		{
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_AXIS_LABEL, SchAxisLabelTabPage::Create, NULL);
			AddTabPage(TP_SCALE_Y, SchScaleYAxisTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_NUMBERFORMAT); //CHINA001 AddTabPage(RID_SVXPAGE_NUMBERFORMAT, SvxNumberFormatTabPage::Create, NULL);

			if (! pModel->IsXYChart ())
			{
				RemoveTabPage (TP_SCALE_Y);
				RemoveTabPage (RID_SVXPAGE_NUMBERFORMAT);
			}
			nDlgType = nNoArrowDlg;
			((SfxItemSet * const) pAttr)->ClearItem (SCHATTR_AXISTYPE);
			((SfxItemSet *) pAttr)->Put (SfxInt32Item (SCHATTR_AXISTYPE, CHART_AXIS_X));

			nAxisType = 1;
			break;
		}

		case ATTR_Y_AXIS_2D:
		case ATTR_Y_AXIS_3D:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_SCALE_Y, SchScaleYAxisTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_NUMBERFORMAT); //CHINA001 AddTabPage(RID_SVXPAGE_NUMBERFORMAT, SvxNumberFormatTabPage::Create, NULL);
			AddTabPage(TP_AXIS_LABEL, SchAxisLabelTabPage::Create, NULL);
			nDlgType = nNoArrowDlg;
			((SfxItemSet * const) pAttr)->ClearItem (SCHATTR_AXISTYPE);
			((SfxItemSet *) pAttr)->Put (SfxInt32Item (SCHATTR_AXISTYPE, CHART_AXIS_Y));

			nAxisType = 2;
			break;

		case ATTR_Z_AXIS:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_NAME ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, NULL);
			AddTabPage(RID_SVXPAGE_CHAR_EFFECTS ); //CHINA001 AddTabPage(RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, NULL);
			AddTabPage(TP_AXIS_LABEL, SchAxisLabelTabPage::Create, NULL);
			nDlgType = nNoArrowDlg;
			((SfxItemSet * const) pAttr)->ClearItem (SCHATTR_AXISTYPE);
			((SfxItemSet *) pAttr)->Put (SfxInt32Item (SCHATTR_AXISTYPE, CHART_AXIS_Z));

			nAxisType = 3;
			break;

		case ATTR_GRID:
		case ATTR_LINE:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			nDlgType = nNoArrowDlg;
			break;

		case ATTR_DIAGRAM_STOCK_LOSS:
		case ATTR_DIAGRAM_STOCK_PLUS:
		case ATTR_DIAGRAM_AREA:
		case ATTR_DIAGRAM_FLOOR:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_AREA);//CHINA001 AddTabPage(RID_SVXPAGE_AREA, SvxAreaTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_TRANSPARENCE);//CHINA001 AddTabPage(RID_SVXPAGE_TRANSPARENCE, SvxTransparenceTabPage::Create, NULL);
			nDlgType = nNoArrowNoShadowDlg;
			break;

		case ATTR_DIAGRAM_WALL:
			AddTabPage(RID_SVXPAGE_LINE);//CHINA001 AddTabPage(RID_SVXPAGE_LINE, SvxLineTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_AREA);//CHINA001 AddTabPage(RID_SVXPAGE_AREA, SvxAreaTabPage::Create, NULL);
			AddTabPage(RID_SVXPAGE_TRANSPARENCE);//CHINA001 AddTabPage(RID_SVXPAGE_TRANSPARENCE, SvxTransparenceTabPage::Create, NULL);
			nDlgType = nNoArrowNoShadowDlg;
			break;

	}
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchAttribTabDlg::~SchAttribTabDlg()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchAttribTabDlg::PageCreated(USHORT nId, SfxTabPage &rPage)
{
	SfxAllItemSet aSet(*(GetInputSetImpl()->GetPool()));
	switch (nId)
	{
		case TP_LAYOUT:
		break;
		case RID_SVXPAGE_LINE:
//CHINA001			((SvxLineTabPage&)rPage).SetColorTable(pColorTab);
//CHINA001			((SvxLineTabPage&)rPage).SetDashList(pDashList);
//CHINA001			((SvxLineTabPage&)rPage).SetLineEndList(pLineEndList);
//CHINA001			((SvxLineTabPage&)rPage).SetPageType(&nPageType);
//CHINA001			((SvxLineTabPage&)rPage).SetDlgType(&nDlgType);
//CHINA001			((SvxLineTabPage&)rPage).Construct();
//CHINA001			((SvxLineTabPage&)rPage).ActivatePage(*GetInputSetImpl());
//CHINA001			if(mpSymbolAttr)//unfein, aber wenn man schon die Attribute setzt, wird es wohl ne Linie
//CHINA001			{               //mit Symbolen sein.
//CHINA001			((SvxLineTabPage&)rPage).ShowSymbolControls(TRUE);
//CHINA001			((SvxLineTabPage&)rPage).SetSymbolList(pMyModel->GetSdrObjList());
//CHINA001			((SvxLineTabPage&)rPage).SetSymbolAttr(mpSymbolAttr);
//CHINA001			((SvxLineTabPage&)rPage).SetAutoSymbolGraphic(&maSymbolGraphic);
//CHINA001			}
			aSet.Put (SvxColorTableItem(pColorTab,SID_COLOR_TABLE));
			aSet.Put (SvxDashListItem(pDashList,SID_DASH_LIST));
			aSet.Put (SvxLineEndListItem(pLineEndList,SID_LINEEND_LIST));
			aSet.Put (SfxUInt16Item(SID_PAGE_TYPE,nPageType));
			aSet.Put (SfxUInt16Item(SID_DLG_TYPE,nDlgType));
			if(mpSymbolAttr)//unfein, aber wenn man schon die Attribute setzt, wird es wohl ne Linie
			{               //mit Symbolen sein.
				aSet.Put(OfaPtrItem(SID_OBJECT_LIST,pMyModel->GetSdrObjList()));
				aSet.Put(SfxTabDialogItem(SID_ATTR_SET,*mpSymbolAttr));
				aSet.Put(SvxGraphicItem(SID_GRAPHIC,maSymbolGraphic));
			}
			rPage.PageCreated(aSet);
			break;

		case RID_SVXPAGE_AREA:
			
			//CHINA001 ((SvxAreaTabPage&)rPage).SetColorTable(pColorTab);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetGradientList(pGradientList);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetHatchingList(pHatchingList);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetBitmapList(pBitmapList);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetPageType(&nPageType);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetDlgType(&nDlgType);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetGrdChgd(&nGradientListState);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetHtchChgd(&nHatchingListState);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetBmpChgd(&nBitmapListState);
			//CHINA001 ((SvxAreaTabPage&)rPage).SetColorChgd(&nColorTableState);
			//CHINA001 ((SvxAreaTabPage&)rPage).Construct();
			//CHINA001 ((SvxAreaTabPage&)rPage).ActivatePage(*GetInputSetImpl());
			
			aSet.Put (SvxColorTableItem(pColorTab,SID_COLOR_TABLE));
			aSet.Put (SvxGradientListItem(pGradientList,SID_GRADIENT_LIST));
			aSet.Put (SvxHatchListItem(pHatchingList,SID_HATCH_LIST));
			aSet.Put (SvxBitmapListItem(pBitmapList,SID_BITMAP_LIST));
			aSet.Put (SfxUInt16Item(SID_PAGE_TYPE,nPageType));
			aSet.Put (SfxUInt16Item(SID_DLG_TYPE,nDlgType));
			rPage.PageCreated(aSet);
			rPage.ActivatePage(*GetInputSetImpl());

			break;

		case RID_SVXPAGE_TRANSPARENCE:
			//CHINA001 ( (SvxTransparenceTabPage&) rPage ).SetPageType( &nPageType );
//CHINA001 			( (SvxTransparenceTabPage&) rPage ).SetDlgType( &nDlgType );
//CHINA001 			( (SvxTransparenceTabPage&) rPage ).Construct();
			aSet.Put (SfxUInt16Item(SID_PAGE_TYPE,nPageType));
			aSet.Put (SfxUInt16Item(SID_DLG_TYPE,nDlgType));
			rPage.PageCreated(aSet);
			break;

		case RID_SVXPAGE_CHAR_NAME:
			//CHINA001 ((SvxCharNamePage&)rPage).
				//CHINA001 SetFontList(*(const SvxFontListItem*)
							 //CHINA001 rDocShell.GetItem(SID_ATTR_CHAR_FONTLIST));
			//SvxFontListItem aFontListItem( *(const SvxFontListItem*)rDocShell.GetItem(SID_ATTR_CHAR_FONTLIST) );
			//aSet.Put (SvxFontListItem( aFontListItem.GetFontList(), SID_ATTR_CHAR_FONTLIST));
			aSet.Put (SvxFontListItem(*(const SvxFontListItem*)rDocShell.GetItem(SID_ATTR_CHAR_FONTLIST)));
			rPage.PageCreated(aSet);
			break;

		case RID_SVXPAGE_CHAR_EFFECTS:
			//CHINA001 ((SvxCharEffectsPage&) rPage).DisableControls( DISABLE_CASEMAP );			
			aSet.Put (SfxUInt16Item(SID_DISABLE_CTL,DISABLE_CASEMAP)); //CHINA001
			rPage.PageCreated(aSet);
			break;

		case TP_AXIS_LABEL:
		{
			OrderMode eMode;
			switch( eAttrType )
			{
				case ATTR_X_AXIS_2D:
					eMode = CHORDMODE_X_AXIS;
					break;

				case ATTR_Y_AXIS_2D:
					eMode = CHORDMODE_Y_AXIS;
					break;

				default:
					eMode = CHORDMODE_NONE;
					break;
			}
			((SchAxisLabelTabPage&)rPage).SetOrderMode( eMode );
			((SchAxisLabelTabPage&)rPage).AllowTextOverlap( TRUE );
			break;
		}

		case TP_ALIGNMENT:
		{
			OrderMode eMode;
			switch (eAttrType)
			{
				case ATTR_X_AXIS_2D:
					eMode = CHORDMODE_X_AXIS;
					break;

				case ATTR_Y_AXIS_2D:
					eMode = CHORDMODE_Y_AXIS;
					break;

				default:
					eMode = CHORDMODE_NONE;
					break;
			}
			((SchAlignmentTabPage&)rPage).SetOrderMode(eMode);
			((SchAlignmentTabPage&)rPage).SetTextCanOverlap(/*pMyModel->IsReal3D()*/TRUE);
			break;
		}

		case TP_SCALE_Y:
            {
                SchScaleYAxisTabPage & rAxisTabPage = static_cast< SchScaleYAxisTabPage & >( rPage );

                // #i16487# use precision of current numberformat (of current
                // number formatter not always the chart-internal one).  This
                // undoes the change of #101318#
				rAxisTabPage.SetNumFormatter( pMyModel->GetNumFormatter());
                rAxisTabPage.SetModel( pMyModel );
            }
            break;

		case RID_SVXPAGE_NUMBERFORMAT:
			//CHINA001 ((SvxNumberFormatTabPage&)rPage).SetNumberFormatList(pMyModel->GetNumFormatter());
			aSet.Put (SvxNumberInfoItem( pMyModel->GetNumFormatter(), (const USHORT)SID_ATTR_NUMBERFORMAT_INFO));
			rPage.PageCreated(aSet);
			break;
	}
}


