/*************************************************************************
 *
 *  $RCSfile: ShowWindow.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 20:14:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SD_SHOW_WINDOW_HXX
#define SD_SHOW_WINDOW_HXX

#include <limits.h>
#include <vcl/timer.hxx>
#include <vcl/graph.hxx>

#ifndef SD_WINDOW_HXX
#include "Window.hxx"
#endif

// ----------------
// - SdShowWindow -
// ----------------


namespace sd {

class PreviewWindow;
class ViewShell;

// -----------
// - Defines -
// -----------

#define SLIDE_NO_TIMEOUT LONG_MAX

// ---------
// - Enums -
// ---------

enum ShowWindowMode
{
    SHOWWINDOWMODE_NORMAL = 0,
    SHOWWINDOWMODE_PAUSE = 1,
    SHOWWINDOWMODE_END = 2,
    SHOWWINDOWMODE_BLANK = 3,
	SHOWWINDOWMODE_PREVIEW = 4
};

//class ShowWindowImpl;

class ShowWindow
    : public ::sd::Window
{
//	friend class ShowWindowImpl;
public:
	ShowWindow ( ::Window* pParent );
    virtual ~ShowWindow (void);

   	BOOL			SetEndMode();
	BOOL			SetPauseMode( sal_Int32 nPageIndexToRestart, sal_Int32 nTimeoutSec = SLIDE_NO_TIMEOUT, Graphic* pLogo = NULL );
	BOOL			SetBlankMode( sal_Int32 nPageIndexToRestart, const Color& rBlankColor );

	void			SetPreviewMode();
	void			SetPresentationArea( const Rectangle& rPresArea );

	ShowWindowMode  GetShowWindowMode() const { return meShowWindowMode; }

	void			RestartShow( sal_Int32 nPageIndexToRestart );

    virtual void	Move();
    virtual void	Resize();
    virtual void	GetFocus();
    virtual void	LoseFocus();
//	virtual void	GrabFocus();

	virtual void	KeyInput(const KeyEvent& rKEvt);
	virtual void	MouseMove(const MouseEvent& rMEvt);
	virtual void	MouseButtonUp(const MouseEvent& rMEvt);
	virtual void	MouseButtonDown(const MouseEvent& rMEvt);
	virtual void	Paint(const Rectangle& rRect);
	virtual long	Notify(NotifyEvent& rNEvt);

private:
	void			DrawPauseScene( BOOL bTimeoutOnly );
	void			DrawEndScene();
	void			DrawBlankScene();

	void			TerminateShow();
	void			RestartShow();

private:
	Timer			maPauseTimer;
	Wallpaper		maShowBackground;
	Graphic			maLogo;
	ULONG			mnPauseTimeout;
	sal_Int32		mnRestartPageIndex;
    ShowWindowMode  meShowWindowMode;
	BOOL			mbShowNavigatorAfterSpecialMode;
	Rectangle		maPresArea;

					DECL_LINK( PauseTimeoutHdl, Timer* pTimer );
};

} // end of namespace sd

#endif
