/*************************************************************************
 *
 *  $RCSfile: AccessibleTitledControl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/13 14:29:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SD_TOOLPANEL_ACCESSIBLE_TITLED_CONTROL_HXX
#define SD_TOOLPANEL_ACCESSIBLE_TITLED_CONTROL_HXX

#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEACTION_HPP_
#include <com/sun/star/accessibility/XAccessibleAction.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEVENTBROADCASTER_HPP_
#include <com/sun/star/accessibility/XAccessibleEventBroadcaster.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE3_HXX_
#include <cppuhelper/implbase3.hxx>
#endif
#include <comphelper/accessiblecomponenthelper.hxx>
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

namespace utl {
class AccessibleStateSetHelper;
}

namespace sd { namespace toolpanel {

class TitledControl;

typedef ::cppu::ImplHelper3	<
    ::com::sun::star::accessibility::XAccessible,
    ::com::sun::star::accessibility::XAccessibleAction,
    ::com::sun::star::lang::XServiceInfo
    > AccessibleTitledControlInterfaceBase;


/** This class makes the TitledControl class accessible.
*/
class AccessibleTitledControl
    : public AccessibleTitledControlInterfaceBase,
      public ::comphelper::OAccessibleComponentHelper
{
public:
    AccessibleTitledControl (TitledControl& rControl);
    ~AccessibleTitledControl (void);

    void Init (void);

    DECLARE_XINTERFACE();
	DECLARE_XTYPEPROVIDER();


    // XAccessible

    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessibleContext> SAL_CALL 
        getAccessibleContext (void) 
        throw (::com::sun::star::uno::RuntimeException);


    // XAccessibleAction

    virtual sal_Int32 SAL_CALL getAccessibleActionCount (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL doAccessibleAction (sal_Int32 nIndex)
        throw (::com::sun::star::lang::IndexOutOfBoundsException, 
            ::com::sun::star::uno::RuntimeException);

    virtual ::rtl::OUString SAL_CALL 
        getAccessibleActionDescription (sal_Int32 nIndex) 
        throw (::com::sun::star::lang::IndexOutOfBoundsException, 
            ::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessibleKeyBinding> SAL_CALL 
        getAccessibleActionKeyBinding (sal_Int32 nIndex) 
        throw (::com::sun::star::lang::IndexOutOfBoundsException, 
            ::com::sun::star::uno::RuntimeException);


    // XAccessibleContext

    virtual sal_Int32 SAL_CALL getAccessibleChildCount (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference< 
        ::com::sun::star::accessibility::XAccessible> SAL_CALL 
        getAccessibleChild (sal_Int32 i) 
        throw (::com::sun::star::lang::IndexOutOfBoundsException, 
            ::com::sun::star::uno::RuntimeException);
    
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible> SAL_CALL 
        getAccessibleParent (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Int16 SAL_CALL getAccessibleRole (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::rtl::OUString SAL_CALL getAccessibleDescription (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::rtl::OUString SAL_CALL getAccessibleName (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference< 
        ::com::sun::star::accessibility::XAccessibleRelationSet> SAL_CALL 
        getAccessibleRelationSet (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference< 
        ::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL 
        getAccessibleStateSet (void) 
        throw (::com::sun::star::uno::RuntimeException);


    // XAccessibleComponent

    virtual ::com::sun::star::uno::Reference< 
        ::com::sun::star::accessibility::XAccessible> SAL_CALL 
        getAccessibleAtPoint (const ::com::sun::star::awt::Point& aPoint) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL grabFocus (void) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL getForeground (void) 
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual sal_Int32 SAL_CALL getBackground (void) 
        throw (::com::sun::star::uno::RuntimeException);


	// XServiceInfo

	virtual ::rtl::OUString SAL_CALL
    	getImplementationName (void)
        throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL
    	supportsService (const ::rtl::OUString& sServiceName)
        throw (::com::sun::star::uno::RuntimeException);

	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString> SAL_CALL
    	getSupportedServiceNames (void)
        throw (::com::sun::star::uno::RuntimeException);


protected:
    virtual ::com::sun::star::awt::Rectangle SAL_CALL implGetBounds (void) 
        throw (::com::sun::star::uno::RuntimeException);

private:
    /** This is a pointer instead of a reference so that we can set it
        to NULL when the control dies but its accessible object lives
        on.
    */
    TitledControl* mpControl;

    ::com::sun::star::uno::Reference< 
        ::com::sun::star::accessibility::XAccessibleStateSet> mxStateSet;

    /** Return a pointer to the object that internally represents the
        state set and at which states can be set and reset.
    */
    ::utl::AccessibleStateSetHelper* GetStateSetHelper (void) const;

    /** Update the state set to reflect the states of the associated
        control.  This method sends events to tell all listeners about
        states that change their value.
    */
    void UpdateStates (void);

    /** Check whether or not the object has been disposed (or is in
        the state of beeing disposed).  If that is the case then
        DisposedException is thrown to inform the (indirect) caller of
        the foul deed.
    */
    void ThrowIfDisposed (void)
        throw (::com::sun::star::lang::DisposedException);

    DECL_LINK(WindowEventListener, VclSimpleEvent*);
};

} } // end of namespace ::sd::toolpanel

#endif
