/*************************************************************************
 *
 *  $RCSfile: frstinit.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2004/09/08 15:34:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
#include <com/sun/star/frame/XFrameActionListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HPP_
#include <com/sun/star/frame/FrameActionEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMEACTION_HPP_
#include <com/sun/star/frame/FrameAction.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include <com/sun/star/frame/XConfigManager.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HPP_
#include <com/sun/star/registry/MergeConflictException.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HPP_
#include <com/sun/star/loader/XImplementationLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HPP_
#include <com/sun/star/loader/CannotActivateFactoryException.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <unotools/processfactory.hxx>
#endif

#include <vos/diagnose.hxx>
#include <tools/datetime.hxx>
#include <tools/string.hxx>
//ASDBG #include <usr/services.hxx>
#include "sfxuno.hxx"

#define FIRST_TIME_INIT_ROOT_KEY                    "/STAR_DESKTOP/RUN_AT_STARTUP"
#define FIRST_TIME_INIT_URL_KEY                     "/URL"
#define FIRST_TIME_INIT_MODE_KEY                    "/MODE"
#define FIRST_TIME_INIT_STATE_KEY                   "/STATE"
#define FIRST_TIME_INIT_DATE_KEY                    "/DATE"
#define FIRST_TIME_INIT_DATEDONE_KEY                "/DATEDONE"
#define FIRST_TIME_INIT_MODE_ONCE                   "run once"
#define FIRST_TIME_INIT_MODE_ONCE_EVERY_LANGUAGE    "run once every language"
#define FIRST_TIME_INIT_MODE_SUCCESS                "until success"
#define FIRST_TIME_INIT_STATE_NOT_STARTED           "not started"
#define FIRST_TIME_INIT_STATE_FAILURE               "failure"
#define FIRST_TIME_INIT_STATE_SUCCESS               "success"

enum FirstTimeInitMode
{
    RUN_ONCE,
    RUN_ONCE_EVERY_LANGUAGE,
    UNTIL_SUCCESS
};

enum FirstTimeInitState
{
    NOT_STARTED,
    FAILURE,
    SUCCESS
};

/*****************************************************************************
    Helper function for query/setting key values

    These functions accept (unicode-)string and ascii value while reading
    the registry. They write back (unicode-)strings.

*****************************************************************************/

#if 0
static void traceException(const ::com::sun::star::uno::Exception& e)
{
//ASDBG String name = OUStringToString(e.getName(), RTL_TEXTENCODING_UTF8);
    ::rtl::OString message = U2S(e.Message);

//ASDBG VOS_TRACE("%s raised while doFirstTimeInit(): '%s'\n", (cStr)name, (cStr)message);
    VOS_TRACE("%s raised while doFirstTimeInit(): '%s'\n", "exception has no name!", (sal_Char*)message.getStr());
}
#endif

static ::rtl::OUString getUrlFromEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xEntry)
{
    ::rtl::OUString url;

    {
        if (xEntry.is())
        {
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xUrlKey = xEntry->openKey(::rtl::OUString::createFromAscii(FIRST_TIME_INIT_URL_KEY));

            if (xUrlKey.is())
            {
                if (xUrlKey->getValueType() == ::com::sun::star::registry::RegistryValueType_ASCII)
                    url = xUrlKey->getAsciiValue();
                else if (xUrlKey->getValueType() == ::com::sun::star::registry::RegistryValueType_STRING)
                    url = xUrlKey->getStringValue();
            }
        }
    }

    return url;
}

static FirstTimeInitMode getModeFromEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xEntry)
{
    FirstTimeInitMode mode = RUN_ONCE;

    {
        if (xEntry.is())
        {
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xModeKey = xEntry->openKey(::rtl::OUString::createFromAscii(FIRST_TIME_INIT_MODE_KEY));

            if (xModeKey.is())
            {
                ::rtl::OUString modeString;

                if (xModeKey->getValueType() == ::com::sun::star::registry::RegistryValueType_ASCII)
                    modeString = xModeKey->getAsciiValue();
                else if (xModeKey->getValueType() == ::com::sun::star::registry::RegistryValueType_STRING)
                    modeString = xModeKey->getStringValue();

                if (modeString.compareToAscii(FIRST_TIME_INIT_MODE_ONCE) == 0)
                    mode = RUN_ONCE;
                else if (modeString.compareToAscii(FIRST_TIME_INIT_MODE_ONCE_EVERY_LANGUAGE)==0)
                    mode = RUN_ONCE_EVERY_LANGUAGE;
                else if (modeString.compareToAscii(FIRST_TIME_INIT_MODE_SUCCESS)==0)
                    mode = UNTIL_SUCCESS;
            }
        }
    }

    return mode;
}

#if 0
static void setModeToEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xEntry, FirstTimeInitMode mode)
{
    {
        if (xEntry.is())
        {
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xModeKey = xEntry->createKey(::rtl::OUString::createFromAscii(FIRST_TIME_INIT_MODE_ONCE));

            if (xModeKey.is())
            {
                ::rtl::OUString modeString;

                switch (mode)
                {
                    case RUN_ONCE:
                        modeString = ::rtl::OUString::createFromAscii(FIRST_TIME_INIT_MODE_ONCE);
                        break;
                    case RUN_ONCE_EVERY_LANGUAGE:
                        modeString = ::rtl::OUString::createFromAscii(FIRST_TIME_INIT_MODE_ONCE_EVERY_LANGUAGE);
                        break;
                    case UNTIL_SUCCESS:
                        modeString = ::rtl::OUString::createFromAscii(FIRST_TIME_INIT_MODE_SUCCESS);
                        break;
                    default:
                        break;
                }

                xModeKey->setStringValue(modeString);
            }
        }
    }
}
#endif

/*****************************************************************************
    Registry entries:

    DATE = timestamp
    DATEDONE
        <LanguageID 0> = timestamp
        <LanguageID 1> = timestamp
        ...
        <LanguageID n> = timestamp
*****************************************************************************/
static FirstTimeInitState getLanguageStateFromEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xDateKey, const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xDateDoneKey)
{
    // We need some keys to work. If one this not exist, we cant get right information.
    // In this way we return a default state - NOT_STARTED - try later again!
    if  (
            ( ! xDateKey.is     () )    ||
            ( ! xDateDoneKey.is () )
        )
    {
        return NOT_STARTED ;
    }

    // Else
    // Try to get TimeStamp of setup from registry
    // Keyname [/DATE]

    String sDate;
    if  ( xDateKey->getValueType () == ::com::sun::star::registry::RegistryValueType_ASCII )
    {
        sDate = String(xDateKey->getAsciiValue());
    }
    else
    if  ( xDateKey->getValueType () == ::com::sun::star::registry::RegistryValueType_STRING )
    {
        sDate = String(xDateKey->getStringValue());
    }

    // Get language ID from SpecialConfigManager, to search for right timestamp-key in registry!
    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >    xFactory                ( ::utl::getProcessServiceFactory () )                                                  ;
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XConfigManager >         xSpecialConfigManager   ( xFactory->createInstance ( DEFINE_CONST_UNICODE("com.sun.star.config.SpecialConfigManager") ), ::com::sun::star::uno::UNO_QUERY   ) ;

    // If Manager not found ... return with default state.
    if ( ! xSpecialConfigManager.is () )
    {
        return NOT_STARTED ;
    }

    // Else get language ID as string from Manager.
    // This value is used at follow statements as keyname of subkey [/DATEDONE] to find right timestamp!
    ::rtl::OUString sLanguageID = xSpecialConfigManager->substituteVariables ( DEFINE_CONST_UNICODE("$(langid)") ) ;

    // Try to get TimeStamp of last init from registry
    // Name of this key is "/DATEDONE/<LanguageID>"
    // There is one subkey as timestamp for every language, who is successed.
    // If a subkey not exist, makro FIRST_INIT was not started before for this language!

    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xLanguageKey = xDateDoneKey->openKey ( sLanguageID ) ;

    if ( ! xLanguageKey.is () )
    {
        return NOT_STARTED ;
    }

    String sDateDone;
    if  ( xLanguageKey->getValueType () == ::com::sun::star::registry::RegistryValueType_ASCII )
    {
        sDateDone = String(xLanguageKey->getAsciiValue());
    }
    else
    if  ( xLanguageKey->getValueType () == ::com::sun::star::registry::RegistryValueType_STRING )
    {
        sDateDone = String(xLanguageKey->getStringValue());
    }

    // If format of keyvalues invalid ... return default state!
    if  (
            ( sDate.GetTokenCount       ( ';' ) != 6 )  ||
            ( sDateDone.GetTokenCount   ( ';' ) != 6 )
        )
    {
        return NOT_STARTED ;
    }

    // Else;
    // Extract date- and time-values from keyvalue (string).
    DateTime    aOldStamp   (   Date ( sDate.GetToken       ( 2, ';' ).ToInt32(), sDate.GetToken        ( 1, ';' ).ToInt32(), sDate.GetToken        ( 0, ';' ).ToInt32() ) ,
                                Time ( sDate.GetToken       ( 3, ';' ).ToInt32(), sDate.GetToken        ( 4, ';' ).ToInt32(), sDate.GetToken        ( 5, ';' ).ToInt32() ) ) ;
    DateTime    aNewStamp   (   Date ( sDateDone.GetToken   ( 2, ';' ).ToInt32(), sDateDone.GetToken    ( 1, ';' ).ToInt32(), sDateDone.GetToken    ( 0, ';' ).ToInt32() ) ,
                                Time ( sDateDone.GetToken   ( 3, ';' ).ToInt32(), sDateDone.GetToken    ( 4, ';' ).ToInt32(), sDateDone.GetToken    ( 5, ';' ).ToInt32() ) ) ;

    // CompareTo timestamps to get state of initialization.
    // If old stamp greater then new stamp, then new stamp is from an older installation of this program!
    if ( aOldStamp > aNewStamp )
    {
        return NOT_STARTED ;
    }

    // These language was initialized with success before.
    return SUCCESS ;
}

/*****************************************************************************/
static void setLanguageStateToEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xDateDoneKey)
{
    if ( xDateDoneKey.is () )
    {
        // Get language ID from SpecialConfigManager, to write right timestamp-key in registry!
        ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >    xFactory                ( ::utl::getProcessServiceFactory ()                                            ) ;
        ::com::sun::star::uno::Reference< ::com::sun::star::frame::XConfigManager >         xSpecialConfigManager   ( xFactory->createInstance ( DEFINE_CONST_UNICODE("com.sun.star.config.SpecialConfigManager") ), ::com::sun::star::uno::UNO_QUERY   ) ;

        if ( xSpecialConfigManager.is () )
        {
            // Get language ID as string from Manager.
            ::rtl::OUString sLanguageID = xSpecialConfigManager->substituteVariables ( DEFINE_CONST_UNICODE("$(langid)") ) ;

            // And create a new subkey for this language.
            // "createKey()" open an existing key automaticly!
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xLanguageKey = xDateDoneKey->createKey ( sLanguageID ) ;

            if ( xLanguageKey.is () )
            {
                // Build a new stamp for this key.
                // (A default DateTime-object has automaticly the actual date and time!)
                DateTime    aStamp  ;
                String      sValue  ;

                sValue  = String::CreateFromInt32( aStamp.GetYear   ()  );
                sValue += ';'                   ;
                sValue += String::CreateFromInt32( aStamp.GetMonth  ()  );
                sValue += ';'                   ;
                sValue += String::CreateFromInt32( aStamp.GetDay    ()  );
                sValue += ';'                   ;
                sValue += String::CreateFromInt32( aStamp.GetHour   ()  );
                sValue += ';'                   ;
                sValue += String::CreateFromInt32( aStamp.GetMin    ()  );
                sValue += ';'                   ;
                sValue += String::CreateFromInt32( aStamp.GetSec    ()  );

                xLanguageKey->setAsciiValue ( sValue ) ;
            }
        }
    }
}

static FirstTimeInitState getStateFromEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xEntry, FirstTimeInitMode mode)
{
    FirstTimeInitState state = NOT_STARTED;

    {
        if ( xEntry.is() )
        {
            // Try to open TimeStamp for setup in applicat.rdb
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xDateKey = xEntry->openKey( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_DATE_KEY) );
            if ( !xDateKey.is() )
            {
                // bug in packing tool: DATE entry is not a subkey
                ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >  xMgr( ::utl::getProcessServiceFactory()  );
                ::com::sun::star::uno::Reference< ::com::sun::star::registry::XSimpleRegistry >  xRegistry( xMgr->createInstance( DEFINE_CONST_UNICODE("com.sun.star.registry.DefaultRegistry") ), ::com::sun::star::uno::UNO_QUERY );
                if ( xRegistry.is() )
                    xDateKey = xRegistry->getRootKey()->openKey( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_DATE_KEY) );
            }

            if ( xDateKey.is() )
            {
                if ( mode == RUN_ONCE )
                {
                    // Try to get TimeStamp from user.rdb
                    ::rtl::OUString stateString;
                    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xStateKey = xEntry->openKey( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_DATEDONE_KEY) );
                    if ( xStateKey.is() )
                    {
                        if ( xStateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_ASCII )
                            stateString = xStateKey->getAsciiValue();
                        else if ( xStateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_STRING )
                            stateString = xStateKey->getStringValue();
                    }

                    ::rtl::OUString dateString;
                    if ( xDateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_ASCII )
                        dateString = xDateKey->getAsciiValue();
                    else if ( xDateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_STRING )
                        dateString = xDateKey->getStringValue();

                    // compare TimeStamps
                    String date( dateString );
                    String dateDone( stateString );

                    if ( dateDone.GetTokenCount() == 6 && date.GetTokenCount() == 6 )
                    {
                        DateTime aSetupTime(
                            Date( date.GetToken( 2 ).ToInt32(), date.GetToken( 1 ).ToInt32(), date.GetToken( 0 ).ToInt32() ),
                            Time( date.GetToken( 3 ).ToInt32(), date.GetToken( 4 ).ToInt32(), date.GetToken( 5 ).ToInt32() ) );
                        DateTime aFinishedTime(
                            Date( dateDone.GetToken( 2 ).ToInt32(), dateDone.GetToken( 1 ).ToInt32(), dateDone.GetToken( 0 ).ToInt32() ),
                            Time( dateDone.GetToken( 3 ).ToInt32(), dateDone.GetToken( 4 ).ToInt32(), dateDone.GetToken( 5 ).ToInt32() ) );
                        if ( aSetupTime < aFinishedTime )
                            // already done
                            state = SUCCESS;
                    }
                }
                else
                if ( mode == RUN_ONCE_EVERY_LANGUAGE )
                {
                    // Do the same like before, but for every supported language!
                    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xStateKey = xEntry->openKey( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_DATEDONE_KEY) );
                    if ( xStateKey.is() )
                    {
                        state = getLanguageStateFromEntry ( xDateKey, xStateKey ) ;
                    }
                }
            }
            else
            {
                // Old interface: no time stamps, only state strings
                ::rtl::OUString stateString;
                ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xStateKey = xEntry->openKey( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_STATE_KEY) );
                if ( xStateKey.is() )
                {
                    if ( xStateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_ASCII )
                        stateString = xStateKey->getAsciiValue();
                    else if ( xStateKey->getValueType() == ::com::sun::star::registry::RegistryValueType_STRING )
                        stateString = xStateKey->getStringValue();
                }

                if (stateString.compareToAscii(FIRST_TIME_INIT_STATE_NOT_STARTED)==0)
                    state = NOT_STARTED;
                else if (stateString.compareToAscii(FIRST_TIME_INIT_STATE_FAILURE)==0)
                    state = FAILURE;
                else if (stateString.compareToAscii(FIRST_TIME_INIT_STATE_SUCCESS)==0)
                    state = SUCCESS;
            }
        }
    }

    return state;
}

static void setStateToEntry(const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > & xEntry, FirstTimeInitState state, FirstTimeInitMode mode)
{
    {
        if ( xEntry.is() )
        {
            switch ( state )
            {
                case NOT_STARTED:
                {
                    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xStateKey = xEntry->createKey(DEFINE_CONST_UNICODE(FIRST_TIME_INIT_STATE_KEY));
                    if ( xStateKey.is() )
                        xStateKey->setStringValue( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_STATE_NOT_STARTED) );
                    break;
                }

                case FAILURE:
                {
                    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xStateKey = xEntry->createKey(DEFINE_CONST_UNICODE(FIRST_TIME_INIT_STATE_KEY));
                    if ( xStateKey.is() )
                        xStateKey->setStringValue( DEFINE_CONST_UNICODE(FIRST_TIME_INIT_STATE_FAILURE) );
                    break;
                }

                case SUCCESS:
                {
                    ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xDateKey = xEntry->createKey(DEFINE_CONST_UNICODE(FIRST_TIME_INIT_DATEDONE_KEY));
                    if ( xDateKey.is() )
                    {
                        if ( mode == RUN_ONCE )
                        {
                            DateTime aTime;
                            String aStr;
                            char cTok( ';' );
                            aStr = String::CreateFromInt32( aTime.GetYear() );
                            aStr += cTok;
                            aStr += String::CreateFromInt32( aTime.GetMonth() );
                            aStr += cTok;
                            aStr += String::CreateFromInt32( aTime.GetDay() );
                            aStr += cTok;
                            aStr += String::CreateFromInt32( aTime.GetHour() );
                            aStr += cTok;
                            aStr += String::CreateFromInt32( aTime.GetMin() );
                            aStr += cTok;
                            aStr += String::CreateFromInt32( aTime.GetSec() );
                            xDateKey->setAsciiValue( aStr );
                        }
                        else
                        if ( mode == RUN_ONCE_EVERY_LANGUAGE )
                        {
                            // Do the same like before, but for every supported language!
                            setLanguageStateToEntry(xDateKey);
                        }
                    }
                    break;
                }

                default:
                    break;
            }
        }
    }
}

/*****************************************************************************
    search registry for ::com::sun::star::util::URL to load at startup time.

    Registry entries:

    STAR_DESKTOP
        RUN_AT_STARTUP
            <unique name>
                ::com::sun::star::util::URL = <desktop url>
                MODE = "run once" | "run once every language" | "until success"
                STATE = "not started" | "failure" | "success"


    MODE is optional, default is "run once"
    STATE is optional, default is "not started"
*****************************************************************************/

void doFirstTimeInit()
{
    {
        ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >  xMgr( ::utl::getProcessServiceFactory() );
        ::com::sun::star::uno::Reference< ::com::sun::star::registry::XSimpleRegistry >  xRegistry( xMgr->createInstance( DEFINE_CONST_UNICODE("com.sun.star.registry.DefaultRegistry") ), ::com::sun::star::uno::UNO_QUERY );
        if ( xRegistry.is() )
        {
            ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >  xLoader;

            // get our root key
            ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey >  xKey = xRegistry->getRootKey()->openKey(DEFINE_CONST_UNICODE(FIRST_TIME_INIT_ROOT_KEY));
            if (xKey.is())
            {
                // get all subkeys
                ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > > subkeys = xKey->openKeys();
                sal_uInt32 n = subkeys.getLength();
                const ::com::sun::star::uno::Reference< ::com::sun::star::registry::XRegistryKey > * pSubkeys = subkeys.getConstArray();

                for (sal_uInt32 i = 0; i < n; i++)
                {
                    ::rtl::OUString url = getUrlFromEntry(pSubkeys[i]);

                    // url is not optional
                    if (0 != url.getLength())
                    {
                        FirstTimeInitMode mode = getModeFromEntry(pSubkeys[i]);
                        FirstTimeInitState state = getStateFromEntry(pSubkeys[i],mode);

                        // only execute url, if not succeded yet
                        if (SUCCESS != state)
                        {
                            if (!xLoader.is() )
                            {
                                xLoader = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader > ( xMgr->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Desktop") ), ::com::sun::star::uno::UNO_QUERY );
                                if ( !xLoader.is() )
                                    break;
                            }

                            ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue> aArgs(1);
                            ::com::sun::star::beans::PropertyValue* pArg = aArgs.getArray();
                            pArg[0].Name = DEFINE_CONST_UNICODE("Referer");
                            ::rtl::OUString sTemp( DEFINE_CONST_UNICODE("private:user") ) ;
                            pArg[0].Value <<= sTemp ;

                            ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >  xComponent = xLoader->loadComponentFromURL(url, DEFINE_CONST_UNICODE("_blank"), 0, aArgs );

                            // mode == RUN_ONCE:
                            // this function decides, if the url was successfully started
                            // mode == RUN_ONCE_EVERY_LANGUAGE:
                            // this function decides, if the url was successfully started for current language
                            // mode == UNTIL_SUCCESS:
                            // the executed component has decide this flag and set it in registry
                            if (RUN_ONCE == mode)
                            {
//                              if (xComponent.is())
                                    setStateToEntry(pSubkeys[i], SUCCESS, RUN_ONCE);
//                              else
//                                  setStateToEntry(pSubkeys[i], FAILURE);
                            }
                            else if (RUN_ONCE_EVERY_LANGUAGE == mode)
                            {
//                              if (xComponent.is())
                                    setStateToEntry(pSubkeys[i], SUCCESS, RUN_ONCE_EVERY_LANGUAGE);
//                              else
//                                  setStateToEntry(pSubkeys[i], FAILURE, RUN_ONCE_EVERY_LANGUAGE);
                            }
                            else if (UNTIL_SUCCESS == mode)
                            {
                            }
                        }
                    }
                }
            }
        }
    }
}


