/*************************************************************************
 *
 *  $RCSfile: propset.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: svesik $ $Date: 2004/04/21 13:06:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// StarOne-Header
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUES_HPP_
#include <com/sun/star/beans/PropertyValues.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HPP_
#include <com/sun/star/beans/XFastPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HPP_
#include <com/sun/star/beans/XVetoableChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATE_HPP_
#include <com/sun/star/beans/XPropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyStateChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include <com/sun/star/beans/XPropertyAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyStateChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_LISTENEREXISTEXCEPTION_HPP_
#include <com/sun/star/lang/ListenerExistException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_ELEMENTEXISTEXCEPTION_HPP_
#include <com/sun/star/container/ElementExistException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_INVALIDLISTENEREXCEPTION_HPP_
#include <com/sun/star/lang/InvalidListenerException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif

// externe Header
#ifndef _SVTOOLS_SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

// interne Header

// eigene Header
#ifndef _SFX_PROPSET_HXX
#include "propset.hxx"
#endif

#ifndef GCC
#pragma hdrstop
#endif

//========================================================================

#ifdef WNT
#define CDECL _cdecl
#endif
#ifdef OS2
#define CDECL _Optlink
#endif
#if defined(UNX)  || defined(MAC)
#define CDECL
#endif

extern "C" int CDECL SfxCompare_SfxPropertyDescriptors_Impl( const void *arg1, const void *arg2 )
{
   return ((SfxPropertyDescriptor*)arg1)->aName.
			compareTo( ((SfxPropertyDescriptor*)arg2)->aName );
}

extern "C" int CDECL SfxCompare_UString_SfxPropertyDescriptor_Impl( const void *arg1, const void *arg2 )
{
   return ((::rtl::OUString*)arg1)->compareTo( ((SfxPropertyDescriptor*)arg2)->aName ) ;
}

//========================================================================

SFX_IMPL_XINTERFACE_1( SfxPropertySetInfo, OWeakObject, ::com::sun::star::beans::XPropertySetInfo )
SFX_IMPL_XTYPEPROVIDER_1( SfxPropertySetInfo, ::com::sun::star::beans::XPropertySetInfo )

typedef ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >* XEventListenerPtr;
SV_DECL_PTRARR_DEL(SfxEventListenerArr_Impl, XEventListenerPtr, 4, 4);
//SV_IMPL_PTRARR(SfxEventListenerArr_Impl, XEventListenerPtr);

//========================================================================
/* ASDBG
//-------------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  SfxPropertySetInfo_NewInstance()
{
	return (UsrObject *) new SfxPropertySetInfo( 0, 0 );
}

//-------------------------------------------------------------------------

Reflection* ::getCppuType((const SfxPropertySetInfo*)0)
{
	static StandardClassReflection aRefl(
		0,
		createStandardClass(
			"SfxPropertySetInfo", UsrObject::getUsrObjectIdlClass(),
			1,
			::getCppuType((const ::com::sun::star::beans::XPropertySetInfo*)0) ) );
	return &aRefl;
}
//-------------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  SfxPropertySetInfo::getIdlClass()
{
	static ::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  xClass = ::getCppuType((const SfxPropertySetInfo*)0)->getIdlClass();
	return xClass;
}

//-------------------------------------------------------------------------

void* SfxPropertySetInfo::getImplementation(Reflection* pRef)
{
	if( pRef == ::getCppuType((const SfxPropertySetInfo*)0) )
		return this;
	else
		return UsrObject::getImplementation(pRef);

}
*/

//-------------------------------------------------------------------------

SfxPropertySetInfo::SfxPropertySetInfo(
		const SfxPropertyDescriptor* pDescriptors, sal_uInt16 nCount )
:	_pPropDescriptors( pDescriptors ),
	_nPropCount( nCount )
{
}

//-------------------------------------------------------------------------

sal_Int32 SfxPropertySetInfo::GetHandle( const ::rtl::OUString &rPropName ) const
{
	SfxPropertyDescriptor * pR;
	pR = (SfxPropertyDescriptor *)
			bsearch( &rPropName, _pPropDescriptors, _nPropCount,
					  sizeof( SfxPropertyDescriptor ),
					  SfxCompare_UString_SfxPropertyDescriptor_Impl );
	return pR ? pR->nHandle : -1;
}

//-------------------------------------------------------------------------

::com::sun::star::uno::Sequence< ::com::sun::star::beans::Property > SAL_CALL SfxPropertySetInfo::getProperties(void)  throw ( ::com::sun::star::uno::RuntimeException )
{
	if ( _aProps.getLength() != _nPropCount )
	{
		((SfxPropertySetInfo*)this)->_aProps.realloc( _nPropCount );
		::com::sun::star::beans::Property * pProps = ((SfxPropertySetInfo*)this)->_aProps.getArray();
		for ( sal_Int32 i = 0; i < _nPropCount; i++ )
		{
			pProps[i].Name = _pPropDescriptors[i].aName;
			pProps[i].Handle = _pPropDescriptors[i].nHandle;
			pProps[i].Type = _pPropDescriptors[i].aType;
			pProps[i].Attributes = _pPropDescriptors[i].nAttributes;
		}
	}
	return _aProps;
}

//-------------------------------------------------------------------------

::com::sun::star::beans::Property SAL_CALL  SfxPropertySetInfo::getPropertyByName(const ::rtl::OUString& aPropertyName)  throw ( ::com::sun::star::uno::RuntimeException )
{
	SfxPropertyDescriptor * pR;
	pR = (SfxPropertyDescriptor*)
			bsearch( &aPropertyName, _pPropDescriptors, _nPropCount,
					  sizeof( SfxPropertyDescriptor ),
					  SfxCompare_UString_SfxPropertyDescriptor_Impl );
	if( !pR )
		throw ::com::sun::star::beans::UnknownPropertyException();

	::com::sun::star::beans::Property aProp;
	aProp.Name = pR->aName;
	aProp.Handle = pR->nHandle;
	aProp.Type = pR->aType;

	aProp.Attributes = pR->nAttributes;
	return aProp;
}

sal_Bool SAL_CALL  SfxPropertySetInfo::hasPropertyByName(const ::rtl::OUString& aPropertyName)  throw ( ::com::sun::star::uno::RuntimeException )
{
	SfxPropertyDescriptor * pR;
	pR = (SfxPropertyDescriptor*)
			bsearch( &aPropertyName, _pPropDescriptors, _nPropCount,
					  sizeof( SfxPropertyDescriptor ),
					  SfxCompare_UString_SfxPropertyDescriptor_Impl );
	return ( pR != NULL );
}

//-------------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo >  SAL_CALL  SfxPropertySet::getPropertySetInfo(void)  throw ( ::com::sun::star::uno::RuntimeException )
{
	return (::com::sun::star::beans::XPropertySetInfo*)_pInfo;
}

//-------------------------------------------------------------------------

void SAL_CALL  SfxPropertySet::setPropertyValue(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue) throw ( ::com::sun::star::uno::RuntimeException )
{
	setFastPropertyValue( _pInfo->GetHandle(aPropertyName), aValue );
}

//-------------------------------------------------------------------------

::com::sun::star::uno::Any SAL_CALL  SfxPropertySet::getPropertyValue(const ::rtl::OUString& aPropertyName)  throw ( ::com::sun::star::uno::RuntimeException )
{
	return getFastPropertyValue( _pInfo->GetHandle(aPropertyName) );
}

//-------------------------------------------------------------------------

void  SAL_CALL SfxPropertySet::addPropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener > & aListener) throw( ::com::sun::star::uno::RuntimeException )
{
}

//-------------------------------------------------------------------------

void  SAL_CALL SfxPropertySet::removePropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener > & aListener) throw( ::com::sun::star::uno::RuntimeException )
{
}

//-------------------------------------------------------------------------

void  SAL_CALL SfxPropertySet::addVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener > & aListener) throw( ::com::sun::star::uno::RuntimeException )
{
}

//-------------------------------------------------------------------------

void  SAL_CALL SfxPropertySet::removeVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener > & aListener) throw( ::com::sun::star::uno::RuntimeException )
{
}


