/*************************************************************************
 *
 *  $RCSfile: ipenv.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kz $ $Date: 2004/10/04 21:03:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <so3/iface.hxx>
#ifndef _IPMENU_HXX //autogen
#include <so3/ipmenu.hxx>
#endif
#ifndef _IPWIN_HXX //autogen
#include <so3/ipwin.hxx>
#endif
#include <svtools/menuoptions.hxx>
#include <comphelper/processfactory.hxx>

#pragma hdrstop

#include "virtmenu.hxx"
#include "dispatch.hxx"
#include "ipfrm.hxx"
#include "viewsh.hxx"
#include "accmgr.hxx"
#include "mnumgr.hxx"
#include "cfgmgr.hxx"
#include "interno.hxx"
#include "docfac.hxx"
#include "ipenv.hxx"
#include <vcl/syswin.hxx>

#ifndef _TOOLKIT_AWT_VCLXMENU_HXX_
#include <toolkit/awt/vclxmenu.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_FRAME_XMODULEMANAGER_HPP_
#include <drafts/com/sun/star/frame/XModuleManager.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_UI_XUIELEMENTFACTORY_HPP_
#include <drafts/com/sun/star/ui/XUIElementFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#include <com/sun/star/uno/Reference.hxx>
#include <com/sun/star/frame/XFrame.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <drafts/com/sun/star/frame/XLayoutManager.hpp>

using namespace com::sun::star;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;
using namespace com::sun::star::frame;
using namespace com::sun::star::container;
using namespace drafts::com::sun::star::frame;
using namespace drafts::com::sun::star::ui;

//=========================================================================

#define SVIPWINDOW(p) ((SvInPlaceWindow&)p->GetWindow())

//--------------------------------------------------------------------

static void impl_MapCommandsToLabels( Menu* pMenu, const Reference< XNameAccess > xCommandToLabel )
{
    // Try to map commands to labels
    for ( USHORT nPos = 0; nPos < pMenu->GetItemCount(); nPos++ )
    {
        USHORT nItemId = pMenu->GetItemId( nPos );
        if ( pMenu->GetItemType( nPos ) != MENUITEM_SEPARATOR )
        {
            PopupMenu* pPopupMenu = pMenu->GetPopupMenu( nItemId );
            if ( pPopupMenu )
                impl_MapCommandsToLabels( (Menu*)pPopupMenu, xCommandToLabel );

            String aCommand = pMenu->GetItemCommand( nItemId );
            if ( aCommand.Len() > 0 )
            {
                try
                {
                    rtl::OUString aStr;
                    Sequence< PropertyValue > aPropSeq;
                    Any a( xCommandToLabel->getByName( rtl::OUString( aCommand )));
                    if ( a >>= aPropSeq )
                    {
                        for ( sal_Int32 i = 0; i < aPropSeq.getLength(); i++ )
                        {
                            if ( aPropSeq[i].Name.equalsAscii( "Label" ))
                            {
                                aPropSeq[i].Value >>= aStr;
                                break;
                            }
                        }

                        pMenu->SetItemText( nItemId, aStr );
                    }
                }
                catch ( com::sun::star::uno::Exception& )
                {
                }
            }
        }
    }
}

//--------------------------------------------------------------------

SfxInPlaceEnv_Impl::~SfxInPlaceEnv_Impl()
{
	DeleteWindows();
	delete pMenuBar;
}

//--------------------------------------------------------------------

MenuBar* SfxInPlaceEnv_Impl::QueryMenu( USHORT * nCount0, USHORT * nCount1,
										USHORT * nCount2 )
{
//	SfxObjectFactory &rObjFactory = pFrame->GetObjectShell()->GetFactory();

	if( !pMenuBar )
	{
        MenuBar* pAppBar = NULL;
        Reference< XFrame > xFrame = pFrame->GetFrame()->GetFrameInterface();
        if ( xFrame.is() )
        {
            Reference< XMultiServiceFactory > xServiceManager( ::comphelper::getProcessServiceFactory() );
            Reference< XModuleManager > xModuleManager( xServiceManager->createInstance(
                                                            rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                                                "drafts.com.sun.star.frame.ModuleManager" ))), UNO_QUERY );

            rtl::OUString aModuleIdentifier = xModuleManager->identify( Reference< XInterface >( xFrame, UNO_QUERY ));
            Reference< XUIElementFactory > m_xFactory( xServiceManager->createInstance( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                                            "drafts.com.sun.star.ui.UIElementFactoryManager" ))), UNO_QUERY );
            Reference< XUIElement > xMenuBar;
            Sequence< PropertyValue > aPropSeq( 3 );
            aPropSeq[0].Name = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Frame" ));
            aPropSeq[0].Value <<= xFrame;
            aPropSeq[1].Name = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Persistent" ));
            aPropSeq[1].Value <<= sal_False;
            aPropSeq[2].Name = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "MenuOnly" ));
            aPropSeq[2].Value <<= sal_True;

            try
            {
                Reference< com::sun::star::awt::XMenuBar > xAwtMenuBar;
                xMenuBar = m_xFactory->createUIElement( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "private:resource/menubar/menubar" )), aPropSeq );
                Reference< XPropertySet > xPropSet( xMenuBar, UNO_QUERY );
                if ( xPropSet.is() )
                {
                    Any a = xPropSet->getPropertyValue( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "XMenuBar" )));
                    if ( a >>= xAwtMenuBar )
                    {
                        VCLXMenu* pAwtMenuBar = VCLXMenu::GetImplementation( xAwtMenuBar );
                        if ( pAwtMenuBar )
                        {
                            Reference< XNameAccess > xUICommands;
                            Reference< XNameAccess > xNameAccess( ::comphelper::getProcessServiceFactory()->createInstance(
                                                        rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "drafts.com.sun.star.frame.UICommandDescription" ))),
                                                        UNO_QUERY );
                            if ( xNameAccess.is() )
                            {
                                Any a = xNameAccess->getByName( aModuleIdentifier );
                                a >>= xUICommands;
                            }

                            MenuBar* pMenuBar = (MenuBar *)pAwtMenuBar->GetMenu();
                            pAppBar = new MenuBar( *pMenuBar );
                            if ( xUICommands.is() )
                                impl_MapCommandsToLabels( pAppBar, xUICommands );
                        }
                    }
                }
            }
            catch ( NoSuchElementException& )
            {
            }
            catch ( IllegalArgumentException& )
            {
            }
            catch ( com::sun::star::beans::UnknownPropertyException )
            {
            }
            catch ( com::sun::star::lang::WrappedTargetException )
            {
            }
        }

        // Safety. Create empty menu bar!
        if ( !pAppBar )
            pAppBar = new MenuBar();

//        const ResId* pId = rObjFactory.GetMenuBarId();
/*
        SfxMenuBarManager* pMenuMgr = pFrame->GetViewShell()->GetMenuBar_Impl();
		pFrame->GetDispatcher()->UpdateObjectMenus_Impl(pMenuMgr);

		SfxVirtualMenu *pAppMenu = pMenuMgr->GetMenu();
*/
//        pAppBar = new MenuBar( *pId );

//		MenuBar *pAppBar = (MenuBar*) pAppMenu->GetSVMenu();

		// Bereich 1: hinter dem Datei-Menue und vor dem 2.Containermenue;
		// da wir dieses nicht haben: vor dem Fenstermenue
		USHORT nPos = pAppBar->GetItemPos( SID_MDIWINDOWLIST );
        if ( nPos == MENU_ITEM_NOTFOUND )
        {
            // We have to search for the unique .uno command now!
            for ( USHORT n = 0; n < pAppBar->GetItemCount(); n++ )
            {
                USHORT nId = pAppBar->GetItemId( n );
                String aCommand = pAppBar->GetItemCommand( nId );
                if ( aCommand.EqualsAscii( ".uno:WindowList" ))
                {
                    nPos = n;
                    break;
                }
            }
        }

		// Die Menue-Konfiguration mu\s sicherstellen, da\s vor dem Dateimenue
		// nichts steht und da\s Datei - und Fenstermenue nicht wegkonfiguriert
		// werden k"onnen !
		DBG_ASSERT( nPos != MENU_ITEM_NOTFOUND, "Wer hat das MDI-Menue geklaut ?!");

		USHORT nStart1 = 1, nCount1 = nPos - 1;

		// Bereich 2: hinter dem 2.Containermenue
		USHORT nStart2 = 0, nCount2 = 0;

		// Bereich 3: hinter dem Fenster-Menue; das ist in der Regel nur das
		// Hilfe-Menue
		USHORT 	nStart3 = nPos + 1,
				nCount3 = pAppBar->GetItemCount() - nStart3;
		pMenuBar = new SvInPlaceMenuBar( pAppBar,
										 nStart1, nCount1,
										 nStart2, nCount2,
										 nStart3, nCount3 );
#if SUPD<613//MUSTINI
		if ( !SFX_INIMANAGER()->IsDontHideDisabledEntries() )
#else
		if( SvtMenuOptions().IsEntryHidingEnabled() == sal_False )
#endif
			pMenuBar->SetMenuFlags( pMenuBar->GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES );

		// Die einschl"agigen Menu-Handler m"ussen gesetzt werden, damit ein
		// TRUE returniert werdenn kann, um SV daran zu hindern, an das AppMenue
		// zu gehen und dort seinen Aufruf loszuwerden, was InPlace garantiert
		// nicht richtig sein kann!
		Link aLink = LINK( this, SfxInPlaceEnv_Impl, DummyMenuHdl );
		pMenuBar->SetHighlightHdl( aLink );
		pMenuBar->SetActivateHdl( aLink );
		pMenuBar->SetDeactivateHdl( aLink );
	}

	return pMenuBar->GetBlocks( nCount0, nCount1, nCount2 );
}

//-------------------------------------------------------------------------

SfxInPlaceEnv_Impl::SfxInPlaceEnv_Impl
(
	SfxInPlaceObject*	pObj,
	SfxInPlaceFrame*	pIPFrame
)
:	SvInPlaceEnvironment( pObj->GetIPClient()->GetEnv(), pObj ),
	pFrame( pIPFrame ),
    pMenuBar( 0 )
{
	SfxObjectShell *pObjShell = pFrame->GetObjectShell();

    pIPFrame->GetFrame()->SetWorkWindow_Impl(  new SfxIPWorkWin_Impl( GetContainerEnv()->GetTopWin(),
                            pFrame->GetBindings(), this ) );
	MakeWindows();

	// StatusUpdates gehen erst los, wenn UITools angezeigt werden
	pFrame->GetBindings().ENTERREGISTRATIONS();
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::TopWinResize()
{
	if ( IsShowUITools())
	{
		// TopWinResize kann auch kommen, wenn die Tools nicht angezeigt
		// werden, weil das Dokumentfenster nicht aktiv ist.
        SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
		pWorkWin->ArrangeChilds_Impl();
		pWorkWin->ShowChilds_Impl();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::RectsChangedPixel( const Rectangle & rObjRect,
											const Rectangle & rClipRect )
{
	DBG_ASSERT( pFrame, "no pFrame in RectsChangedPixel" );

	SvInPlaceEnvironment::RectsChangedPixel( rObjRect, rClipRect );

	// View skalieren
	SfxInPlaceObject* pObj = (SfxInPlaceObject*) GetIPObj();
	if ( !pObj->IsViewScalingDisabled() )
		MakeScale( GetIPObj()->GetVisArea().GetSize(),
				   GetIPObj()->GetMapUnit(), rObjRect.GetSize() );

	// View resizen
	Size aHatch( GetBorderWin()->GetHatchBorderPixel() );
	Point aPos( aHatch.Width(), aHatch.Height() );
	pFrame->DoAdjustPosSizePixel( pFrame->GetViewShell(),
					aPos, rObjRect.GetSize() ); //! +/-1 Problem
}

//-------------------------------------------------------------------------

BOOL SfxInPlaceEnv_Impl::DispatchAccel(const KeyCode &rKeyCode)
{
	if (!pFrame->GetViewShell()->GetWindow()->HasFocus())
		return FALSE;

	return pFrame->GetViewShell()->KeyInput( KeyEvent(0, rKeyCode) );
}

//-------------------------------------------------------------------------

void SfxInPlaceEnv_Impl::TopWinActivate( BOOL bActivate )
{
/*
	if( bActivate )
	{
		ActivateConfig();
	}
 */
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::UIActivate( BOOL bActivate )
{
    SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
	if ( bActivate )
	{
		pFrame->GetViewShell()->GetWindow()->GrabFocus();
		pWorkWin->ArrangeChilds_Impl();
		pWorkWin->ShowChilds_Impl();
	}
	else
	{
		pWorkWin->ResetObjectBars_Impl();
		pWorkWin->UpdateObjectBars_Impl();
		pWorkWin->Close_Impl();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::DocWinActivate( BOOL bActivate )
{
	if( bActivate )
	{
//        ActivateConfig();

		// Da bei internem Inplace die Objekte und der Container einen Teil
		// des Environments gemeinsam haben, m"ussen "Anderungen upgedatet
		// werden, wenn von einem zum anderen gewechselt wird (z.B. der Status
		// der Objektleiste u.a.).
		if ( GetContainerEnv()->GetIPClient()->Owner() )
			pFrame->GetBindings().InvalidateAll( FALSE );
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::ShowUITools( BOOL bShow )
{
    SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
    uno::Reference < beans::XPropertySet > xFrame( pFrame->GetFrame()->GetFrameInterface(), uno::UNO_QUERY );
    uno::Reference< ::drafts::com::sun::star::frame::XLayoutManager > xMyMan;
    uno::Any aAny = xFrame->getPropertyValue( ::rtl::OUString::createFromAscii("LayoutManager") );
    aAny >>= xMyMan;

	if ( bShow )
	{
		// Wenn nach letztem ShowUITools(FALSE) TopWin-Groesse veraendert
		// wurde, muss neu arrangiert werden
        xMyMan->unlock();
        xMyMan->setVisible( sal_True );

        pWorkWin->Lock_Impl(FALSE);
        pWorkWin->SetObjectBarVisibility_Impl( SFX_VISIBILITY_STANDARD );
        pFrame->GetBindings().LEAVEREGISTRATIONS();
        pFrame->GetDispatcher()->Update_Impl( TRUE );
        //pWorkWin->ArrangeChilds_Impl();
        //pWorkWin->ShowChilds_Impl();
		pFrame->GetBindings().HidePopups(FALSE);
	}
	else
	{
        //pWorkWin->HideChilds_Impl();
		pFrame->GetBindings().HidePopups(TRUE);
		pFrame->GetBindings().ENTERREGISTRATIONS();
        pWorkWin->Lock_Impl(TRUE);
        pWorkWin->SetObjectBarVisibility_Impl( SFX_VISIBILITY_UNVISIBLE );
        pFrame->GetDispatcher()->Update_Impl( TRUE );
        xMyMan->setVisible( sal_False );
        xMyMan->lock();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::QueryObjAreaPixel( Rectangle& rRect ) const
{
	pFrame->GetViewShell()->QueryObjAreaPixel(rRect);
}


//--------------------------------------------------------------------
/*
void SfxInPlaceEnv_Impl::ActivateConfig()
{
	SfxConfigManager *pMgr = pFrame->GetObjectShell()->GetConfigManager();
	if ( pMgr )
		SFX_APP()->SetConfigManager_Impl( pMgr );
	else
		SFX_APP()->SetConfigManager_Impl( pCfgMgr);
}
*/
//--------------------------------------------------------------------

IMPL_LINK( SfxInPlaceEnv_Impl, DummyMenuHdl, Menu *, pMenu )
{
	return TRUE;
}

BOOL SfxInPlaceEnv_Impl::IsInternalInPlace() const
{
	return TRUE;
}

