/*************************************************************************
 *
 *  $RCSfile: gdimtftools.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:53:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>
#include <gdimtftools.hxx>

#ifndef _COM_SUN_STAR_DOCUMENT_XEXPORTER_HPP_
#include <com/sun/star/document/XExporter.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XFILTER_HPP_
#include <com/sun/star/document/XFilter.hpp>
#endif

#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_GDIMTF_HXX 
#include <vcl/gdimtf.hxx>
#endif
#ifndef _SV_METAACT_HXX 
#include <vcl/metaact.hxx>
#endif
#ifndef _SV_ANIMATE_HXX
#include <vcl/animate.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif


using namespace ::com::sun::star;


// free support functions
// ======================

namespace presentation
{
    namespace internal 
    {
        namespace
        {
            bool getMetaFile( const uno::Reference< lang::XComponent >& 	xSource, 
                              const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                              GDIMetaFile& 									rMtf,
                              bool											bVerboseComments,
                              bool 											bBackgroundOnly )
            {
                SvMemoryStream aStream( 1024, 1024 );
                uno::Reference< io::XOutputStream > xOut( new utl::OOutputStreamWrapper( aStream ) );
            
                // -> stuff that into UnoGraphicExporter.
                uno::Reference< lang::XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
                if( !xFactory.is() )
                    return false;

                // creating the graphic exporter
                uno::Reference< document::XExporter > xExporter( xFactory->createInstance( 
                                                                     rtl::OUString::createFromAscii("com.sun.star.drawing.GraphicExportFilter")), 
                                                                 uno::UNO_QUERY);
                uno::Reference< document::XFilter > xFilter( xExporter, uno::UNO_QUERY );

                if( !xExporter.is() || !xFilter.is() )
                    return false;

                uno::Sequence< beans::PropertyValue > aProps(3);
                aProps[0].Name = rtl::OUString::createFromAscii("FilterName");
                aProps[0].Value <<= rtl::OUString::createFromAscii("SVM");

                aProps[1].Name = rtl::OUString::createFromAscii("OutputStream");
                aProps[1].Value <<= xOut;

                uno::Sequence< beans::PropertyValue > aFilterData(4);
                aFilterData[0].Name = rtl::OUString::createFromAscii("VerboseComments");
                aFilterData[0].Value <<= bVerboseComments;

                aFilterData[1].Name = rtl::OUString::createFromAscii("ExportOnlyBackground");
                aFilterData[1].Value <<= bBackgroundOnly;

                aFilterData[2].Name = rtl::OUString::createFromAscii("Version");
                const sal_Int32 nVersion = SOFFICE_FILEFORMAT_50; 
                aFilterData[2].Value <<= nVersion; 

                aFilterData[3].Name = rtl::OUString::createFromAscii("CurrentPage");
                aFilterData[3].Value <<= uno::Reference< uno::XInterface >( xContainingPage,
                                                                            uno::UNO_QUERY_THROW );

                aProps[2].Name = rtl::OUString::createFromAscii("FilterData");
                aProps[2].Value <<= aFilterData;

                xExporter->setSourceDocument( xSource );
                xFilter->filter( aProps );

                xOut = NULL; // release wrapper
                aStream.Seek( STREAM_SEEK_TO_BEGIN ); // rewind

                aStream >> rMtf;
            
                return aStream.GetError() == 0;
            }
        }

        bool getMetaFile( const uno::Reference< drawing::XShape >& 		xShape, 
                          const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                          GDIMetaFile& 									o_rMtf,
                          bool											bVerboseComments )
        {
            return getMetaFile( uno::Reference< lang::XComponent >( 
                                    xShape,
                                    uno::UNO_QUERY ),
                                xContainingPage,
                                o_rMtf,
                                bVerboseComments,
                                false );
        }

        bool getBackgroundMetaFile( const uno::Reference< drawing::XDrawPage >& xPage, 
                                    const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                                    GDIMetaFile& 							    o_rMtf,
                                    bool									    bVerboseComments )
        {
            return getMetaFile( uno::Reference< lang::XComponent >( 
                                    xPage,
                                    uno::UNO_QUERY ),
                                xContainingPage,
                                o_rMtf,
                                bVerboseComments,
                                true );
        }

        void removeTextActions( GDIMetaFile& rMtf )
        {
            // search metafile for text output
            MetaAction* pCurrAct;

            int nActionIndex(0);
            pCurrAct = rMtf.FirstAction(); 
            while( pCurrAct )
            {
                switch( pCurrAct->GetType() )
                {
                    case META_TEXTCOLOR_ACTION:
                    case META_TEXTFILLCOLOR_ACTION:
                    case META_TEXTLINECOLOR_ACTION:
                    case META_TEXTALIGN_ACTION:
                    case META_FONT_ACTION:
                    case META_LAYOUTMODE_ACTION:
                    case META_TEXT_ACTION:
                    case META_TEXTARRAY_ACTION:
                    case META_TEXTRECT_ACTION:
                    case META_STRETCHTEXT_ACTION:
                    case META_TEXTLINE_ACTION:
                    {
                        // remove every text-related actions
                        pCurrAct = rMtf.NextAction();

                        rMtf.RemoveAction( nActionIndex );
                        break;
                    }

                    default:
                        pCurrAct = rMtf.NextAction();
                        ++nActionIndex;
                        break;
                }
            }
        }

        bool getAnimationFromGraphic( VectorOfMtfAnimationFrames& o_rFrames,
                                      const Graphic&			  rGraphic )
        {
            o_rFrames.clear();

            if( !rGraphic.IsAnimated() )
                return false;

            // some loop invariants
            Animation 	aAnimation( rGraphic.GetAnimation() );            
            const Point aEmptyPoint;
            const Size  aAnimSize( aAnimation.GetDisplaySizePixel() );              

            // setup alpha VDev, into which all bitmaps are painted
            // (want to normalize animations to n bitmaps of same
            // size. An Animation, though, can contain bitmaps of
            // varying sizes and different update modes)
            VirtualDevice aVDev( *::Application::GetDefaultDevice(), 0, 0 );
            aVDev.SetOutputSizePixel( aAnimSize );
            aVDev.EnableMapMode( FALSE );

            // setup alpha VDev, from which potential background
            // restores are performed
            VirtualDevice aRestoreVDev( *::Application::GetDefaultDevice(), 0, 0 );
            aRestoreVDev.SetOutputSizePixel( aAnimSize );
            aRestoreVDev.EnableMapMode( FALSE );

            Disposal eLastDisposal( DISPOSE_BACK );

            for( USHORT i=0, nCount=aAnimation.Count(); i<nCount; ++i )
            {
                // potentially restore vdev background from
                // aRestoreVDev
                if( eLastDisposal != DISPOSE_BACK &&
                    eLastDisposal != DISPOSE_NOT )
                {
                    aRestoreVDev.DrawOutDev( aEmptyPoint, 
                                             aAnimSize, 
                                             aEmptyPoint, 
                                             aAnimSize, 
                                             aVDev );
                }

                const AnimationBitmap& rAnimBmp( aAnimation.Get(i) );

                aVDev.DrawBitmapEx( rAnimBmp.aPosPix, 
                                    rAnimBmp.aSizePix, 
                                    rAnimBmp.aBmpEx );

                // extract current aVDev content into a new animation
                // frame
                GDIMetaFileSharedPtr pMtf( new GDIMetaFile() );
                pMtf->AddAction( 
                    new MetaBmpExAction( aEmptyPoint,
                                         aVDev.GetBitmapEx(
                                             aEmptyPoint,
                                             aAnimSize ) ) );

                // setup mtf dimensions and pref map mode (for
                // simplicity, keep it all in pixel. the metafile
                // renderer scales it down to (1, 1) box anyway)
                pMtf->SetPrefMapMode( MapMode() );
                pMtf->SetPrefSize( aAnimSize );

                o_rFrames.push_back( MtfAnimationFrame( pMtf,
                                                        rAnimBmp.nWait / 1000.0 ) );

                // restore background, if requested
                if( DISPOSE_NOT != rAnimBmp.eDisposal )
                {
                    if( DISPOSE_BACK == rAnimBmp.eDisposal )
                    {
                        // restore original background -> clear VDev
                        aVDev.Erase();
                    }
                    else
                    {
                        // restore previously saved frame
                        aVDev.DrawOutDev( aEmptyPoint, 
                                          aAnimSize, 
                                          aEmptyPoint, 
                                          aAnimSize, 
                                          aRestoreVDev );
                    }
                }
                
                eLastDisposal = rAnimBmp.eDisposal;
            }

            return !o_rFrames.empty();
        }
    }
}

