/*************************************************************************
 *
 *  $RCSfile: intrinsicanimationactivity.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:54:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>
#include <intrinsicanimationactivity.hxx>


namespace presentation
{
    namespace internal
    {

        IntrinsicAnimationActivity::IntrinsicAnimationActivity( const SlideShowContext& 		rContext,
                                                                const DrawShapeSharedPtr&		rDrawShape,
                                                                const WakeupEventSharedPtr&		rWakeupEvent,
                                                                const ::std::vector<double>&	rTimeouts ) :
            maContext( rContext ),
            mpDrawShape( rDrawShape ),
            mpWakeupEvent( rWakeupEvent ),
            maTimeouts( rTimeouts ),
            mnCurrIndex(0)
        { 
            ENSURE_AND_THROW( rContext.mpLayerManager.get(),
                              "IntrinsicAnimationActivity::IntrinsicAnimationActivity(): Invalid layer manager" );
            ENSURE_AND_THROW( rDrawShape.get(),
                              "IntrinsicAnimationActivity::IntrinsicAnimationActivity(): Invalid draw shape" );
            ENSURE_AND_THROW( rWakeupEvent.get(),
                              "IntrinsicAnimationActivity::IntrinsicAnimationActivity(): Invalid wakeup event" );
            ENSURE_AND_THROW( !rTimeouts.empty(),
                              "IntrinsicAnimationActivity::IntrinsicAnimationActivity(): Empty timeout vector" );
        }

        void IntrinsicAnimationActivity::dispose()
        {
            if( mpWakeupEvent.get() )
                mpWakeupEvent->dispose();

            maContext.dispose();
            mpDrawShape.reset();
            mpWakeupEvent.reset();
            maTimeouts.clear();
            mnCurrIndex = 0;
        }

        bool IntrinsicAnimationActivity::perform()
        {
            if( !isActive() )
                return false;

            ENSURE_AND_RETURN( mpDrawShape.get(),
                               "IntrinsicAnimationActivity::perform(): still active, but NULL draw shape");
            ENSURE_AND_RETURN( mpWakeupEvent.get(),
                               "IntrinsicAnimationActivity::perform(): still active, but NULL wakeup event");

            mpWakeupEvent->start();
            mpWakeupEvent->setNextTimeout( maTimeouts[mnCurrIndex] );
            maContext.mrEventQueue.addEvent( mpWakeupEvent );

            mnCurrIndex = (mnCurrIndex + 1) % maTimeouts.size();
            
            mpDrawShape->setIntrinsicAnimationFrame( mnCurrIndex );
            maContext.mpLayerManager->notifyShapeUpdate( mpDrawShape );

            return false; // don't reinsert, WakeupEvent will perform
                          // that after the given timeout
        }

        bool IntrinsicAnimationActivity::isActive() const
        {
            if( !mpDrawShape.get() )
                return false;

            return true;
        }

        bool IntrinsicAnimationActivity::needsScreenUpdate() const
        {
            return isActive();
        }

        void IntrinsicAnimationActivity::end()
        {
            dispose();
        }

    }
}
