/*************************************************************************
 *
 *  $RCSfile: mediashape.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:54:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>
#include <mediashape.hxx>

#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _BGFX_NUMERIC_FTOOLS_HXX
#include <basegfx/numeric/ftools.hxx>
#endif

#ifndef BOOST_BIND_HPP_INCLUDED
#include <boost/bind.hpp>
#endif
#ifndef BOOST_MEM_FN_HPP_INCLUDED
#include <boost/mem_fn.hpp>
#endif

#include <canvas/canvastools.hxx>

#include <cmath> // for trigonometry and fabs
#include <algorithm>
#include <functional>
#include <limits>

#include <slideshowexceptions.hxx>
#include <tools.hxx>

using namespace ::drafts::com::sun::star;
using namespace ::com::sun::star;


namespace presentation
{
    namespace internal
    {
        namespace
        {
            ::basegfx::B2DRectangle getShapeBounds( const uno::Reference< drawing::XShape >& xShape )
            {
                uno::Reference< beans::XPropertySet > xPropSet( xShape, 
                                                                uno::UNO_QUERY_THROW );
                // read bound rect
                awt::Rectangle aTmpRect;
                ENSURE_AND_THROW( (xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("BoundRect") ) ) >>= aTmpRect),
                                  "getShapeBounds(): Could not get \"BoundRect\" property from shape" );

                return ::basegfx::B2DRectangle( aTmpRect.X, 
                                                aTmpRect.Y,
                                                aTmpRect.X+aTmpRect.Width, 
                                                aTmpRect.Y+aTmpRect.Height );
            }
        }
		
		// ---------------------------------------------------------------------

        MediaShape::MediaShape( const uno::Reference< drawing::XShape >& 	xShape,
                                const uno::Reference< drawing::XDrawPage >&	xContainingPage,
                              	double										nPrio ) :
            mxShape( xShape ),
            mnPriority( nPrio ), // TODO(F1): When ZOrder someday becomes usable: make this ( getShapePrio( xShape ) ),
            maBounds( getShapeBounds( xShape ) ),
			mnIsAnimatedCount( 0 )
        {
            ENSURE_AND_THROW( mxShape.is(), "MediaShape::MediaShape(): Invalid XShape" );
        }

		// ---------------------------------------------------------------------

        uno::Reference< drawing::XShape > MediaShape::getXShape() const
        {
            return mxShape;
        }

		// ---------------------------------------------------------------------
		
        void MediaShape::addViewLayer( const ViewLayerSharedPtr& rNewLayer,
                                       bool						 bRedrawLayer )
        {
            ViewMediaShapeVector::iterator aEnd( maViewMediaShapes.end() );

            // already added?
            if( ::std::find_if( maViewMediaShapes.begin(), 
                                		aEnd, 
                                		::boost::bind<bool>( 
                                    		::std::equal_to< ViewLayerSharedPtr >(),
                                    		::boost::bind( &ViewMediaShape::getViewLayer,
                                            		       _1 ),
                                    		::boost::cref( rNewLayer ) ) ) == aEnd )
            {
				maViewMediaShapes.push_back( 
					ViewMediaShapeSharedPtr( new ViewMediaShape( *this, rNewLayer, getXShape() ) ) );
	
				// render the Shape on the newly added ViewLayer
				if( bRedrawLayer )
					maViewMediaShapes.back()->update( MediaShape::getPosSize() );
			}
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::removeViewLayer( const ViewLayerSharedPtr& rLayer )
        {
            const ViewMediaShapeVector::iterator aEnd( maViewMediaShapes.end() );

            OSL_ENSURE( ::std::count_if(maViewMediaShapes.begin(), 
                                        aEnd, 
                                        ::boost::bind<bool>( 
                                            ::std::equal_to< ViewLayerSharedPtr >(),
                                            ::boost::bind( &ViewMediaShape::getViewLayer, _1 ),
                                            ::boost::cref( rLayer ) ) ) < 2,
                        "MediaShape::removeViewLayer(): Duplicate ViewLayer entries!" );

            ViewMediaShapeVector::iterator aIter;

            if( (aIter=::std::remove_if( maViewMediaShapes.begin(), 
                                         aEnd, 
                                         ::boost::bind<bool>( 
                                             ::std::equal_to< ViewLayerSharedPtr >(),
                                             ::boost::bind( &ViewMediaShape::getViewLayer,
                                                            _1 ),
                                             ::boost::cref( rLayer ) ) )) == aEnd )
            {
                // view layer seemingly was not added, failed
                return false;
            }

            // actually erase from container
            maViewMediaShapes.erase( aIter, aEnd );

            return true;
        }

		// ---------------------------------------------------------------------
		        
		void MediaShape::enterAnimationMode()
        {
            if( mnIsAnimatedCount++ == 0 )
            {
                // notify all ViewShapes, by calling their enterAnimationMode method.
                // We're now entering animation mode
                ::std::for_each( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::mem_fn( &ViewMediaShape::enterAnimationMode ) );
            }
        }

		// ---------------------------------------------------------------------
		
        void MediaShape::leaveAnimationMode()
        {
            if( --mnIsAnimatedCount == 0 )
            {
                // notify all ViewShapes, by calling their leaveAnimationMode method.
                // we're now leaving animation mode
                ::std::for_each( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::mem_fn( &ViewMediaShape::leaveAnimationMode ) );
            }
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::update() const
        {
			return render();
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::render() const
        {
            const ::basegfx::B2DRectangle aCurrBounds( MediaShape::getPosSize() );

            if( aCurrBounds.getRange().equalZero() )
            {
                // zero-sized shapes are effectively invisible,
                // thus, we save us the rendering...
                return true;
            }

            // redraw all view shapes, by calling their update() method
            if( ::std::count_if( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::bind<bool>( 
                                     ::boost::mem_fn( &ViewMediaShape::update ), 
                                     _1,
                                     ::boost::cref( aCurrBounds ) ) ) 
                != static_cast<ViewMediaShapeVector::difference_type>(maViewMediaShapes.size()) )
            {
                // at least one of the ViewShape::update() calls did return 
                // false - update failed on at least one ViewLayer
                return false;
            }

            return true;
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::isUpdateNecessary() const
		{
			return true;
        }

		// ---------------------------------------------------------------------
		
        ::basegfx::B2DRectangle MediaShape::getPosSize() const
        {
        	return maBounds;
        }

		// ---------------------------------------------------------------------
		
        ::basegfx::B2DRectangle MediaShape::getUpdateArea() const
        {
            // add some safety margin to shape bounds, to account for
            // anti-aliasing (which touches pixel outside actual
            // bounding box).
            return ::basegfx::B2DRectangle( maBounds.getMinX() - ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE,
                                            maBounds.getMinY() - ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE,
                                            maBounds.getMaxX() + ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE,
                                            maBounds.getMaxY() + ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE );
        }

		// ---------------------------------------------------------------------
				
        bool MediaShape::isVisible() const
		{
			return true;
		}

		// ---------------------------------------------------------------------
		
        double MediaShape::getPriority() const
        {
            return mnPriority;
        }

		// ---------------------------------------------------------------------
						
        bool MediaShape::isBackgroundDetached() const
        {
			return( ( maViewMediaShapes.size() > 0 ) ? 
					( *maViewMediaShapes.begin() )->isBackgroundDetached() :
					false );
        }

		// ---------------------------------------------------------------------
        
        bool MediaShape::hasIntrinsicAnimation() const
        {
            return true;
        }
        
		// ---------------------------------------------------------------------
        
        bool MediaShape::startIntrinsicAnimation( const SlideShowContext& rContext,
                                                  const ShapeSharedPtr&	  rShape )
        {
            if( hasIntrinsicAnimation() )
            {
            
                ::std::for_each( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::mem_fn( &ViewMediaShape::enterAnimationMode ) );

                return true;
            }
            
            return false;
        }
        
		// ---------------------------------------------------------------------
        
        bool MediaShape::endIntrinsicAnimation()
        {
            if( hasIntrinsicAnimation() )
            {
                ::std::for_each( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::mem_fn( &ViewMediaShape::leaveAnimationMode ) );

                return true;
            }
            
            return false;
        }
    }
}
