/*************************************************************************
 *
 *  $RCSfile: parametricpolypolygon.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:06:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX
#define _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX

#ifndef _BGFX_POLYGON_B2DPOLYPOLYGON_HXX
#include <basegfx/polygon/b2dpolypolygon.hxx>
#endif

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif


/* Definition of ParametricPolyPolygon interface */

namespace presentation
{
    namespace internal
    {
        /** Interface defining a parametric poly-polygon.

        	This interface defines a poly-polygon, whose actual shape
        	is parameterized by a floating point value. This is
        	e.g. used to generically access the various clip polygon
        	generators for transition effects.

            Since for every parametric poly-polygon, there is a set of
            variations, which can easily be generated by simple
            transformations or change in parameter range sweep
            direction, objects implementing this interface only
            generate <em>one</em> prototypical instance of the
            parametric poly-polygon. Generally speaking, the main
            effect direction should be horizontal, it should make
            increasingly more area visible (transition 'in'), and when
            there is a designated direction given, that should be
            left-to-right.
         */
        class ParametricPolyPolygon
        {
        public:
            virtual ~ParametricPolyPolygon() {}

            /** Retrieve the poly-polygon for value t.

                @param t
                Current parameter value to retrieve the corresponding
                poly-polygon for. Permissible values for t must be in
                the range [0,1].

                @return a poly-polygon corresponding to the given
                parameter value. The poly-polygon is interpreted as
                living in the unit rectangle (i.e. [0,1]x[0,1]), but
                is not necessarily constrained to completely lie in
                this area (this very much depends on the actual effect
                to be generated). Although, from a performance
                perspective, it currently <em>is</em> advantageous to
                try to keep the poly-polygon within these bounds (at
                least if there are no hard reasons not to do so),
                because then reversion or out transformations are
                potentially faster to compute (see the
                TransitionInfo::meReverseMethod member in
                transitionfactory.cxx). Furthermore, if one of the
                polygon modifications involve subtraction (also see
                TransitionInfo::meReverseMethod), all generated
                polygons should be oriented clock-wise
                (i.e. traversing the polygon vertices with increasing
                vertex index should generate a clock-wise movement).
             */
            virtual ::basegfx::B2DPolyPolygon operator()( double t ) = 0;
        };

        typedef ::boost::shared_ptr< ParametricPolyPolygon > ParametricPolyPolygonSharedPtr;

    }
}

#endif /* _SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX */
