:
eval 'exec perl -S $0 ${1+"$@"}'
    if 0;
#*************************************************************************
#
#   $RCSfile: stats.pl,v $
#
#   $Revision: 1.1 $
#
#   last change: $Author: kz $ $Date: 2004/08/05 10:37:04 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

#
# stats - create statistic for installed office 
#

#### script id #####

( $script_name = $0 ) =~ s/^.*\b(\w+)\.pl$/$1/; 

$id_str = ' $Revision: 1.1 $ ';
$id_str =~ /Revision:\s+(\S+)\s+\$/
  ? ($script_rev = $1) : ($script_rev = "-");

print "$script_name -- version: $script_rev\n";

if ($ENV{OS} ne 'LINUX') {
	&print_error('Tool is available only for linux!!');
};

use Cwd;

#########################
#                       #
#   Globale Variablen   #
#                       #
#########################
$office_exe = '';

$preload_library = $ENV{SRC_ROOT} . '/smoketest_native/' . $ENV{GVERDIR} . '/lib/libgenstats.so';

$so_version_file = 'bootstraprc';
if ((!defined $ENV{CWS_WORK_STAMP}) && (defined $ENV{UPDATER})) {
    $statistic_file = '/develop4/update/merge/EIS/SyscallImport/lib_output';
    $syscall_file = '/develop4/update/merge/EIS/SyscallImport/Syscall.txt';
} else {
    $statistic_file = $ENV{HOME} . '/lib_output';
    $syscall_file = $ENV{HOME} . '/Syscall.txt';
};
$product_key = '';
$stand = '';
$minor = '';
$build_id = '';
$index = 0;
$backup_script = '';
$platform = $ENV{INPATH};
$gcc_version;
@chart_jars = ('jcommon-0.7.1.jar', 'jfreechart-0.9.4.jar');

#### main ####
&get_options;
&get_office_stats;
exit(0);
#### end of main procedure ####

#########################
#                       #
#      Procedures       #
#                       #
#########################

#
# this procedure removes all entries from $syscall_file with
# the same $build_id & $ENV{OS}
#
sub clear_stats_file {
    return if (!(-r $syscall_file));
    &print_error("Cannot open $syscall_file") if (!open (SYSCALLFILE, $syscall_file));
    my @file_strings = <SYSCALLFILE>;
    my (@new_file_strings, $need_rewrite);
    close SYSCALLFILE;
    foreach (@file_strings) {
        /^\w+\t\w\t(\d+)\t(\w+)/;
        if (($1 eq $build_id) && ($2 eq $ENV{OS})) {
            $need_rewrite++;
            next;
        };
        push (@new_file_strings, $_);
    };
    if ($need_rewrite) {
        unlink $syscall_file;
        open (SYSCALLFILE, ">>$syscall_file");
        foreach (@new_file_strings) {
            print SYSCALLFILE $_;
        };
        close SYSCALLFILE;
    };
};

sub get_office_stats {
    my $action = '';
    &clear_stats_file;
    
    open (SYSCALLFILE, ">>$syscall_file");
    &patch_office_script;
    my $office_exe_path = $office_exe;
    my $commando = "\"$office_exe\"";
    foreach (@ARGV) {
        chomp;
        $commando .= ' ' . $_;
    };
    $? = '';
    system($commando);
    unlink $office_exe_path;
    system("mv \"$backup_script\" \"$office_exe_path\"");
    &print_error("Error occurred while executing $commando", $?) if ($?);
    open (OFFICE_STAT, $statistic_file);
    while (<OFFICE_STAT>) {
        chomp;
        $action = ''        and next if (/^========================================$/);
        $action = 'read'    and next if (/^Bytes read statistic:$/);
        $action = 'write'   and next if (/^Bytes written statistic:$/);
        $action = 'malloc'  and next if (/^Bytes malloced statistic:$/);
        if (/^Calls to free\(3\):\s+(\d+)/) {
            $action = 'free'   and $_ = "0\t0\t$1\t";
        };
        if (/^Calls to poll\(2\):\s+(\d+)/) {
            $action = 'poll'   and $_ = "0\t0\t$1\t";
        };
        if (/^Calls to select\(2\):\s+(\d+)/) {
            $action = 'select'   and $_ = "0\t0\t$1\t";
        };
        next if (!$action);
        print SYSCALLFILE "$stand\t$minor\t$build_id\t$ENV{OS}\t$platform\t$gcc_version\t$action\t$_\r\n"; 
    };
    close SYSCALLFILE;
    close OFFICE_STAT;
    $ENV{LD_PRELOAD} = '';
    if (defined $ENV{CWS_WORK_STAMP}) {
        &show_graphic;
    } else {
        unlink $statistic_file;
    };
};

#
# function shows graphic for the statistics generated
#
sub show_graphic {
    my $classpath = $ENV{CLASSPATH};
    my $java_files_path = cwd() . '/' . $ENV{INPATH} . '/class/';
    chdir $java_files_path;
    cwd;
    my $graphics_class = $java_files_path . 'Graphics';
    foreach (@chart_jars) {
        $classpath .= ':' . $java_files_path . $_;
    };
    system ("java -classpath $classpath Graphics > /dev/null 2>&1 &");
};

#
# this function retrieves build info
#
sub get_gcc_version {
    my $gcc = `which gcc`;
    chomp $gcc;
    open(GCCINFO, "$gcc -v 2>&1 |");
    while (<GCCINFO>) {
        chomp;
        if (/^gcc\sversion\s/) {
            close GCCINFO;
            return $';
        };
    };
    close GCCINFO;
    &print_error("No information could be retrieved for current gcc: $gcc");
};

#
# this function retrieves build info
#
sub get_build_info {
    $gcc_version = 'gcc ' . &get_gcc_version;
    my $office_exe_dir = shift;
    if (!$office_exe_dir) {
        $office_exe =~ /[\w| \.]+$/;
        $office_exe_dir = $`;
    };
    if (open(OFFICE_VER, $office_exe_dir . 'program/' . $so_version_file) ||
        open(OFFICE_VER, $office_exe_dir . $so_version_file)) {
        while (<OFFICE_VER>) {
            chomp;
            $product_key = $1 and next if (/^ProductKey=(\S*Office\S*)\s+/);
            if (/^buildid=(\d+)(\w+)\(Build:(\d+)\)/) {
                $stand = $1;
                $minor = $2;
                if (defined $ENV{CWS_WORK_STAMP}) {
                    my @now = split(/\s/, localtime(time()));
                    $now[4] =~ /(\d\d)$/o;
                    $build_id = "($now[3]\@$now[2]\/$now[1]\/$1)";
                } else {
                    $build_id = $3;
                }
            };
        };
        close (OFFICE_VER);
        return if ($product_key && $minor && $build_id);
    };
    &print_error('No office version info found');
};

sub get_options {
    my @argv_bak = ();
    while ($arg = shift @ARGV) {
        # We working only with one parameter - path, that's why '...and last' 
        $arg =~ /^-p=/ and $office_exe = $' and last;
        $arg =~ /^--path=/ and $office_exe = $' and last;
        push(@argv_bak, $arg);
    };
    unshift(@ARGV, $arg) while ($arg = pop @argv_bak);
    if ($office_exe) {
        $office_exe =~ s/\"//go;
    } else {
        print STDERR 'No parameters passed, trying to figure them out  ';
        $office_exe = &guess_office_exe;
    };
    print STDERR "\b \nTrying $office_exe\n";
    &get_build_info;
};

#
# This procedure tries to choose the right installation from more than one
#
sub choose_installation {
    my $dirs_array_ref = shift;
    $ENV{UPD};
    foreach (@$dirs_array_ref) {
        &get_build_info($_. '/');
        return $_ if ($stand == $ENV{UPD});
    };
    print STDERR "Cannot choose between following alternatives:\n";
    foreach (@$dirs_array_ref) {
        print STDERR "\t$_/soffice";
    };
    &print_error('Cannot choose the right office executable');
};

#
# This procedure is trying to figure out office executable
#
sub guess_office_exe {
    my $home_dir = $ENV{HOME};
    my (@reg_installs, @live_installs);
    
    open SVERSIONRC, $home_dir . '/.sversionrc';
    while (<SVERSIONRC>) {
        chomp;
        if (/^StarOffice\s+[\d\.]+=file:\/\/([\w|\.|\/|\-]+)\n*/) {
            push(@reg_installs, $1);
        };
    };
    close SVERSIONRC;
    foreach (@reg_installs) {
        push(@live_installs, $_) if (-d);
    };
    &print_error('No office installation detected!!') if ($#live_installs == -1);
    if ($#live_installs) { # more than 1 installation detected
        print STDERR("WARNING: more then one installation detected\n");
        return &choose_installation(\@live_installs) . '/program/soffice';
    };
#    &get_build_info($live_installs[0] . '/');
    return $live_installs[0] . '/program/soffice';
};

sub print_error {
    my ($message, $error_code) = @_;
    print STDERR "\nERROR: $message\n";
    exit ($error_code) if ($error_code);
	exit(1);
};

#
# this procedure patches the office script for collecting statistics
#
sub patch_office_script {
    $backup_script = $office_exe . '.bak';
    unlink $backup_script;
    system("mv \"$office_exe\" \"$backup_script\"");
    open OFFICE_EXE, $backup_script;
    my @strings = <OFFICE_EXE>;
    close OFFICE_EXE;
    open OFFICE_EXE, ">>$office_exe";
    foreach (@strings) {
        if (/^\s*exec/) {
            print OFFICE_EXE "LD_PRELOAD=$preload_library\n";
            print OFFICE_EXE "export LD_PRELOAD\n\n";
        };
        print OFFICE_EXE $_;
    };
    close OFFICE_EXE;
    system("chmod +x \"$office_exe\"");
};
