/*************************************************************************
 *
 *  $RCSfile: ddetest.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/06 19:38:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sv.hxx>
#include <svdde.hxx>
#include <socore.hxx>
#include <solink.hxx>
#include <soui.hxx>

#include "ddetest.hrc"


// ------------ Verbindung vom BaseLink zum Content ----------------

class MyLink : public SvBaseLink
{
public:
	Window* pWin;

	String* pText;
	Graphic* pGrf;

	MyLink( Window* pW, String* pStr, USHORT eType )
		: SvBaseLink( eType, FORMAT_STRING ),
		pWin( pW ),
		pText( pStr ),
		pGrf( 0 )
	{}

	MyLink( Window* pW, Graphic* pG, USHORT nFmt )
		: SvBaseLink( LINKUPDATE_ONCALL, nFmt ),
		pWin( pW ),
		pText( 0 ),
		pGrf( pG )
	{}

	virtual void DataChanged( SvData& );
};


// -------------- Klassen um DDE-Server zu spielen --------------

class MyTstDdeService : public DdeService
{
	Window* pWin;
public:
	MyTstDdeService( Window* pW, const String& rNm )
		: DdeService( rNm ), pWin( pW )
	{}
	virtual int MakeTopic( const String& );
};


class MyTstDdeTopic : public DdeTopic
{
	Window* pWin;
	DdeData aData;
public:
	MyTstDdeTopic( Window* pW )
		: DdeTopic( String( "Dokument1" ) ),
		pWin( pW )
	{}

	virtual DdeData* Get( ULONG );
	virtual BOOL Put( const DdeData* );
	virtual BOOL Execute( const String* );
	virtual void Connect( long n );
	virtual void Disconnect( long n );

	virtual int MakeItem( const String& rItem );
};

class MyEdit : public Edit, public SvPseudoObject
{
	virtual void Modify();
public:
	MyEdit( Window* pParent )
		: Edit( pParent )
	{ AddNextRef(); }

	virtual BOOL GetData( SvData* );
	virtual BOOL ChangeData( SvData& );
};


// ------------------- der Rest fuer eine Applikation -------------------

class MyApp : public Application
{
public:
	DdeService* pDdeService;
	virtual void 	Main( int, char*[] );

};

// class AppWin ----------------------------------------------------------

class AppWin: public WorkWindow
{
	SvLinkManager aCMgr;

	String sText1, sText2, sText3;
	Graphic aGrf1;

public:
	DdeTopic* pTopic;
	DdeItem* pItem;
	MyEdit aEdit;

					AppWin();
					~AppWin();

	void			Paint( const Rectangle& rRect );

	long MenuSelect( Menu* );
};


// ----------------------------------------------------------

void _export MyLink::DataChanged( SvData& rData )
{
// erstmal nur das Window-Invaldieren, hier kann man aber auch schon die
// richtige Position vom Object erneuern

	switch( rData.GetFormat() )
	{
	case FORMAT_STRING:
		if( pText )
			rData.GetData( *pText );
		break;

	case FORMAT_GDIMETAFILE:
		if( pGrf )
		{
			GDIMetaFile *pPtr;
			if( rData.GetData( &pPtr, TRANSFER_REFERENCE ) )
				*pGrf = *pPtr;
		}
		break;

	case FORMAT_BITMAP:
		if( pGrf )
		{
			Bitmap *pBmp;
			if( rData.GetData( &pBmp, TRANSFER_REFERENCE ) )
				*pGrf = *pBmp;
		}
		break;
	}
	pWin->Invalidate();
}


// -------------------------------------------------

DdeData* _export MyTstDdeTopic::Get( ULONG nFmt )
{
	const String& rGetItem = GetCurItem();
	return 0;
}

BOOL _export MyTstDdeTopic::Put( const DdeData* )
{
	const String& rGetItem = GetCurItem();
	return FALSE;
}

BOOL _export MyTstDdeTopic::Execute( const String* )
{
	const String& rGetItem = GetCurItem();
	return FALSE;
}

void _export MyTstDdeTopic::Connect( long n )
{
	const String& rGetItem = GetCurItem();
	n = n;
}

void _export MyTstDdeTopic::Disconnect( long n )
{
	const String& rGetItem = GetCurItem();
	n = n;
}

int _export MyTstDdeTopic::MakeItem( const String& rItem )
{
	if( STRING_NOTFOUND != rItem.ICompare( "EDIT1" ) )
	{
		String sNm( ((MyApp*)pApp)->pDdeService->GetName() );
		sNm += ' ';
		sNm += GetName();
		sNm += ' ';
		sNm += rItem;

		new SvBaseLink( sNm, OBJECT_DDE_EXTERN, &((AppWin*)pWin)->aEdit );
		return TRUE;
	}
	return FALSE;
}

int _export MyTstDdeService::MakeTopic( const String& rTopic )
{
	if( STRING_NOTFOUND != rTopic.ICompare( "DOKUMENT1" ) )
	{
		AddTopic( *( ((AppWin*)pWin)->pTopic = new MyTstDdeTopic( pWin )));
		return TRUE;
	}
	return FALSE;
}

// -------------------------------------------------

void _export MyEdit::Modify()
{
	if( GetSelectorCount() )
		DataChanged( SvData( FORMAT_STRING ) );
}

BOOL _export MyEdit::GetData( SvData* pData )
{
	switch( pData->GetFormat() )
	{
	case FORMAT_STRING:
		{
			SvData aTmp( FORMAT_STRING );
			aTmp.SetData( GetText() );
			*pData = aTmp;
			return TRUE;
		}
	}
	return FALSE;
}

BOOL _export MyEdit::ChangeData( SvData& rData )
{
	switch( rData.GetFormat() )
	{
	case FORMAT_STRING:
		{
			const char* pStr;
			rData.GetData( (void**)&pStr, TRANSFER_REFERENCE );
			SetText( pStr );
			return TRUE;
		}
	}
	return FALSE;
}

// AppWin::AppWin() ------------------------------------------------------

AppWin::AppWin()
	: WorkWindow( 0, WinBits( WB_APP | WB_STDWORK ) ),
	pTopic( 0 ),
	pItem( 0 ),
	aEdit( this )
{
	SetPosSizePixel( Point( 20, 20 ), Size( 300, 300 ) );

	aEdit.SetPosSizePixel( Point( 10, 80 ), Size( 300, 30 ) );
	aEdit.SetText( "Edit1: ein zu linkendes Object"  );
	aEdit.Show();

//	aCMgr.SetErrorHdl( LINK( this, AppWin, DDEError ));

	MyLink* pTmp;

	pTmp = new MyLink( this, &sText1, LINKUPDATE_ONCALL );
	aCMgr.InsertDDELink( *pTmp, "Excel", "[Mappe1]Tabelle1", "Z1S1:Z2S1" );

	pTmp = new MyLink( this, &sText2, LINKUPDATE_ALWAYS );
	aCMgr.InsertDDELink( *pTmp, "Excel", "[Mappe1]Tabelle1", "Z1S2:Z2S2" );

	pTmp = new MyLink( this, &sText3, LINKUPDATE_ALWAYS );
	aCMgr.InsertDDELink( *pTmp, "TIMES", "TIME", "NOW" );

	/*
	pTmp = new MyLink( this, &aGrf1, FORMAT_BITMAP );
	aCMgr.InsertFileLink( *pTmp, OBJECT_CLIENT_GRF,
								"s:\\w31\\arches.bmp", 0 );
	*/

	SvBaseLinks& rLinks = (SvBaseLinks&)aCMgr.GetLinks();
	for( USHORT n = rLinks.Count(); n;  )
		(*rLinks[ --n ])->Update();
}

AppWin::~AppWin()
{
	delete pTopic;
	delete pItem;
}

void _export AppWin::Paint( const Rectangle& rRect )
{
	DrawRect( rRect );

	Font aTmp( GetFont() );
	aTmp.ChangeColor( Color( COL_LIGHTBLUE ) );
	Font aOldFont( ChangeFont( aTmp ));
	DrawText( Point( 10, 10 ), sText1 );

	aTmp.ChangeColor( Color( COL_LIGHTRED) );
	ChangeFont( aTmp );
	DrawText( Point( 10, 30 ), sText2 );

	aTmp.ChangeColor( Color( COL_LIGHTGREEN ) );
	ChangeFont( aTmp );
	DrawText( Point( 10, 50 ), sText3 );

	aGrf1.Draw( this, Point( 10, 100 ), Size( 50, 50 ) );

	SetFont( aOldFont );
}

long _export AppWin::MenuSelect( Menu* pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
	case MI_FILEQUIT:
		Close();
		break;

	case MI_LINKDLG:
		{
			SvBaseLinksDialog( this, &aCMgr ).Execute();
			break;
		}
	}
	return TRUE;
}

// BrowserApp::Main() ----------------------------------------------------

void MyApp::Main( int, char*[] )
{
	ChangeAppName( "ddetest" );
	InitAppRes( ResId( APPLICATION_ID ) );
	EnableSVLook();

	SvFactory::Init();

	AppWin aMainWin;
	aMainWin.SetText( "DDE-Testprogramm" );

	MenuBar aMenuBar( ResId( MENUBAR_APP ) );
/*
	PopupMenu aFileMenu( ResId( MENU_FILE ) );
	PopupMenu aDialogMenu( ResId( MENU_DIALOG ) );

	aMenuBar.ChangePopupMenu( MENU_FILE, &aFileMenu );
	aMenuBar.ChangePopupMenu( MENU_DIALOG, &aDialogMenu );

	aFileMenu.PushSelectHdl( LINK( &aMainWin, AppWin, MenuSelect ) );
	aDialogMenu.PushSelectHdl( LINK( &aMainWin, AppWin, MenuSelect ) );
*/
	aMenuBar.PushSelectHdl( LINK( &aMainWin, AppWin, MenuSelect ) );
	ChangeAppMenu( &aMenuBar );

	aMainWin.Show();

	pDdeService = new MyTstDdeService( &aMainWin, String( "DDETest" ) );

	if( pDdeService->GetError() )
	{
		ErrorBox( NULL, WinBits( WB_OK ),
				  String( "Service TIMES not activated !" ) ).Execute();
	}

	Execute();

	SvFactory::DeInit();
	delete pDdeService;
}


MyApp aMyApp;

