#*************************************************************************
#
#   $RCSfile: files.pm,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: rt $ $Date: 2005/01/31 10:50:31 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************


package par2script::files;

use par2script::exiter;

############################################
# File Operations
############################################

sub check_file
{
	my ($arg) = @_;

	if(!( -f $arg ))
	{
		par2script::exiter::exit_program("ERROR: Cannot find file $arg", "check_file");
	}
}

sub read_file
{
	my ($localfile) = @_;

	open( IN, "<$localfile" ) || par2script::exiter::exit_program("ERROR: Cannot open file: $localfile", "read_file");
	my @localfile = <IN>;
	close( IN );

	return \@localfile;
}

###########################################
# Saving files, arrays and hashes
###########################################

sub save_file
{
	my ($savefile, $savecontent) = @_;
	open( OUT, ">$savefile" );
	print OUT @{$savecontent};
	close( OUT);
	if (! -f $savefile) { pre2par::exiter::exit_program("ERROR: Cannot write file: $savefile", "save_file"); }
}

sub save_hash
{
	my ($savefile, $hashref) = @_;

	my @printcontent = ();
	
	my ($itemkey, $itemvalue, $line);
		
	foreach $itemkey ( keys %{$hashref} )
	{
		$line = "";
		$itemvalue = $hashref->{$itemkey};
		$line = $itemkey . "=" . $itemvalue . "\n";
		push(@printcontent, $line);
	}

	open( OUT, ">$savefile" );
	print OUT @printcontent;
	close( OUT);
}

sub save_array_of_hashes
{
	my ($savefile, $arrayref) = @_;

	my @printcontent = ();
	
	my ($itemkey, $itemvalue, $line, $hashref);
		
	for ( my $i = 0; $i <= $#{$arrayref}; $i++ )
	{		
		$line = "";
		$hashref = ${$arrayref}[$i];
				
		foreach $itemkey ( keys %{$hashref} )
		{
			$itemvalue = $hashref->{$itemkey};

			$line = $line . $itemkey . "=" . $itemvalue . "\t";
		}

		$line = $line . "\n";
		
		push(@printcontent, $line);
	}

	open( OUT, ">$savefile" );
	print OUT @printcontent;
	close( OUT);
}

1;
