/*************************************************************************
 *
 *  $RCSfile: svtdata.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hjs $ $Date: 2004/06/25 16:31:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_SVTDATA_HXX
#define _SVTOOLS_SVTDATA_HXX

#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif
#ifndef _TOOLS_RESID_HXX
#include <tools/resid.hxx>
#endif
#ifndef _TOOLS_SIMPLERESMGR_HXX_
#include <tools/simplerm.hxx>
#endif

class ResMgr;
class SfxItemDesruptorList_Impl;
class SfxItemPool;
class Twain;

//============================================================================
class ImpSvtData
{
public:
	Twain * pTwain;
	const SfxItemPool * pStoringPool;
	SfxItemDesruptorList_Impl * pItemDesruptList;

	ResMgr *		pResMgr;

	void*			m_pThreadsafeRMs;
		// one SimpleResMgr for each language for which a resource was requested
		// (When using the 'non-simple' resmgr, the first request for any language wins, any
		// further request for any other language supply the resmgr of the first call.
		// For the simple resmgr we have a mgr for each language ever requested).

private:
	ImpSvtData():
		pTwain(0), pStoringPool(0), pItemDesruptList(0), pResMgr(0), m_pThreadsafeRMs(NULL)
	{}

	~ImpSvtData();

public:
	ResMgr * GetResMgr(const ::com::sun::star::lang::Locale aLocale);
	ResMgr * GetResMgr(); // VCL dependant, only available in SVT, not in SVL!

	SimpleResMgr * GetSimpleRM(const ::com::sun::star::lang::Locale& rLocale);

	static ImpSvtData & GetSvtData();
};

//============================================================================
class SvtResId: public ResId
{
public:
	SvtResId(USHORT nId, const ::com::sun::star::lang::Locale aLocale):
		ResId(nId, ImpSvtData::GetSvtData().GetResMgr(aLocale)) {}

	SvtResId(USHORT nId): ResId(nId, ImpSvtData::GetSvtData().GetResMgr()) {}
	 // VCL dependant, only available in SVT, not in SVL!
};

//============================================================================
class SvtSimpleResId
{
	String	m_sValue;

public:
	SvtSimpleResId(USHORT nId, const ::com::sun::star::lang::Locale aLocale) : m_sValue(ImpSvtData::GetSvtData().GetSimpleRM(aLocale)->ReadString(nId)) { };

	operator String () const { return m_sValue; }
};

#endif //  _SVTOOLS_SVTDATA_HXX

