/*************************************************************************
 *
 *  $RCSfile: registrationdlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2004/06/17 13:20:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SVTOOLS_REGISTRATIONDLG_HXX
#define SVTOOLS_REGISTRATIONDLG_HXX

#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _SV_DIALOG_HXX 
#include <vcl/dialog.hxx>
#endif

//........................................................................
namespace svt
{
//........................................................................

	//====================================================================
	//= RegistrationDialog
	//====================================================================
	class RegistrationDialog : public ModalDialog
	{
	public:
		enum UserResponse
		{
			urRegisterNow,
			urRegisterLater,
			urRegisterNever,
			urAlreadyRegistered
		};

	private:
		UserResponse	m_eResponse;

		FixedImage		m_aLogo;
		FixedText		m_aIntro;

		RadioButton 	m_aNow;
		RadioButton 	m_aLater;
		RadioButton 	m_aNever;
		RadioButton 	m_aAlreadyDone;

		FixedLine		m_aSeparator;

		OKButton		m_aOK;
		HelpButton 		m_aHelp;

	public:
		RegistrationDialog( Window* _pWindow, bool _bEvalVersion );

		virtual short	Execute();
        virtual long    PreNotify( NotifyEvent& rNEvt );

		inline	UserResponse	getResponse() const	{ return m_eResponse; }
	};



//........................................................................
}// namespace svt
//........................................................................

#endif // SVTOOLS_REGISTRATIONDLG_HXX

/*************************************************************************
 * history:
 *	$Log: registrationdlg.hxx,v $
 *	Revision 1.4  2004/06/17 13:20:56  rt
 *	INTEGRATION: CWS ooo64bit01 (1.3.266); FILE MERGED
 *	2004/03/31 16:48:45 fa 1.3.266.2: Back out of changes since 2004-03-24, focus on smaller, more integratable changes
 *	2004/03/29 00:29:58 fa 1.3.266.1: More 64-bit changes.  'rsc' still broken, but not as much as before.
 *	
 *	Revision 1.3.266.2  2004/03/31 16:48:45  fa
 *	Back out of changes since 2004-03-24, focus on smaller, more integratable changes
 *	
 *	Revision 1.3  2003/06/10 14:36:36  vg
 *	INTEGRATION: CWS vcl11 (1.2.74); FILE MERGED
 *	2003/06/03 07:03:20 fs 1.2.74.1: #110024# slightly changed registration dialog in eval version
 *	
 *	Revision 1.2.74.1  2003/06/03 07:03:20  fs
 *	#110024# slightly changed registration dialog in eval version
 *	
 *	Revision 1.2  2003/03/27 14:38:49  hr
 *	MWS_SRX644: migrate branch mws_srx644 -> HEAD
 *	
 *	Revision 1.1.22.1  2003/02/20 20:37:26  hr
 *	INTEGRATION: CWS os5 (1.1.98); FILE MERGED
 *	2003/02/04 11:35:34 os 1.1.98.1: #107142# overload PreNotify to detect KEY_ESCAPE and cancel the dialog
 *	
 *	Revision 1.1.98.1  2003/02/04 11:35:34  os
 *	#107142# overload PreNotify to detect KEY_ESCAPE and cancel the dialog
 *	
 *	Revision 1.1  2001/12/20 13:13:35  fs
 *	initial checkin - product registration dialog
 *	
 *
 *	Revision 1.0 19.12.01 17:00:05  fs
 ************************************************************************/

