/*************************************************************************
 *
 *  $RCSfile: communi.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: rt $ $Date: 2004/06/16 10:29:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#if OSL_DEBUG_LEVEL > 1
#define DEBUGPRINTF(x) { printf(x); fflush( stdout ); }
#else
#define DEBUGPRINTF(x)
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _VOS_SOCKET_HXX_ //autogen
#include <vos/socket.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#include "communi.hxx"


/*	Um den Destruktor protected zu machen wurde unten das delete entfernt.
	Die Methode wird ohnehin hucht benutzt.
//				delete *((AE*)pData+n);
*/

#undef  SV_IMPL_PTRARR_SORT
#define SV_IMPL_PTRARR_SORT( nm,AE )\
_SV_IMPL_SORTAR_ALG( nm,AE )\
	void nm::DeleteAndDestroy( USHORT nP, USHORT nL ) { \
		if( nL ) {\
			DBG_ASSERT( nP < nA && nP + nL <= nA, "ERR_VAR_DEL" );\
			for( USHORT n=nP; n < nP + nL; n++ ) \
				DBG_ERROR("Das Element der Liste wurde nicht gelscht"); \
			SvPtrarr::Remove( nP, nL ); \
		} \
	} \
_SV_SEEK_PTR( nm, AE )




SV_IMPL_PTRARR_SORT( CommunicationLinkList, CommunicationLink* );


CommunicationLinkViaSocket::CommunicationLinkViaSocket( CommunicationManager *pMan, NAMESPACE_VOS(OStreamSocket) *pSocket )
: SimpleCommunicationLinkViaSocket( pMan, pSocket )
, nConnectionClosedEventId( 0 )
, nDataReceivedEventId( 0 )
{
    // this is necassary to prevent the running thread from sending the close event
    // before the open event has been sent.
   	StartCallback();

	create();
}

CommunicationLinkViaSocket::~CommunicationLinkViaSocket()
{
	StopCommunication();
	while ( nConnectionClosedEventId || nDataReceivedEventId )
		GetpApp()->Reschedule();
	{
		NAMESPACE_VOS(OGuard) aGuard( aMConnectionClosed );
		if ( nConnectionClosedEventId )
		{
			GetpApp()->RemoveUserEvent( nConnectionClosedEventId );
			nConnectionClosedEventId = 0;
			INFO_MSG( CByteString("Event gelscht"),
				CByteString( "ConnectionClosedEvent aus Queue gelscht"),
				CM_MISC, NULL );
		}
	}
	{
		NAMESPACE_VOS(OGuard) aGuard( aMDataReceived );
		if ( nDataReceivedEventId )
		{
			GetpApp()->RemoveUserEvent( nDataReceivedEventId );
			nDataReceivedEventId = 0;
			delete GetServiceData();
			INFO_MSG( CByteString("Event gelscht"),
				CByteString( "DataReceivedEvent aus Queue gelscht"),
				CM_MISC, NULL );
		}
	}
}

BOOL CommunicationLinkViaSocket::ShutdownCommunication()
{
	if ( isRunning() )
	{

		terminate();
		if ( pStreamSocket )
			pStreamSocket->shutdown();

		if ( pStreamSocket )	// Mal wieder nach oben verschoben, da sonst nicht vom Read runtergesprungen wird.
			pStreamSocket->close();

		resume();	// So da das run auch die Schleife verlassen kann

		join();

		delete pStreamSocket;
		pStreamSocket = NULL;

//		ConnectionClosed();		Wird am Ende des Thread gerufen

	}
	else
	{
		join();
	}

	return TRUE;
}

void CommunicationLinkViaSocket::WaitForShutdown()
{
	Timer aTimer;
	aTimer.SetTimeout( 30000 );		// Should be 30 Seconds
	aTimer.Start();
	while ( aTimer.IsActive() )
	{
		if ( IsCommunicationError() )
			return;
		GetpApp()->Reschedule();
	}
	ShutdownCommunication();
}

BOOL CommunicationLinkViaSocket::IsCommunicationError()
{
	return !isRunning() || SimpleCommunicationLinkViaSocket::IsCommunicationError();
}

void CommunicationLinkViaSocket::run()
{
	BOOL bWasError = FALSE;
	while ( schedule() && !bWasError && pStreamSocket )
	{
		if ( bWasError |= !DoReceiveDataStream() )
			continue;

		TimeValue sNochEins = {0, 1000000};
		while ( schedule() && bIsInsideCallback )	// solange der letzte Callback nicht beendet ist
			sleep( sNochEins );
		SetNewPacketAsCurrent();
		StartCallback();
		{
			NAMESPACE_VOS(OGuard) aGuard( aMDataReceived );
			nDataReceivedEventId = GetpApp()->PostUserEvent( LINK( this, CommunicationLinkViaSocket, DataReceived ) );
		}
	}
	TimeValue sNochEins = {0, 1000000};
	while ( schedule() && bIsInsideCallback )	// solange der letzte Callback nicht beendet ist
		sleep( sNochEins );

    StartCallback();
	{
		NAMESPACE_VOS(OGuard) aGuard( aMConnectionClosed );
		nConnectionClosedEventId = GetpApp()->PostUserEvent( LINK( this, CommunicationLinkViaSocket, ConnectionClosed ) );
	}
}

BOOL CommunicationLinkViaSocket::DoTransferDataStream( SvStream *pDataStream, CMProtocol nProtocol )
{
	if ( !isRunning() )
		return FALSE;

	return SimpleCommunicationLinkViaSocket::DoTransferDataStream( pDataStream, nProtocol );
}

/// Dies ist ein virtueller Link!!!
long CommunicationLinkViaSocket::ConnectionClosed( void* EMPTYARG )
{
	{
		NAMESPACE_VOS(OGuard) aGuard( aMConnectionClosed );
		nConnectionClosedEventId = 0;	// Achtung!! alles andere mu oben gemacht werden.
	}
	ShutdownCommunication();
	return CommunicationLink::ConnectionClosed( );
}

/// Dies ist ein virtueller Link!!!
long CommunicationLinkViaSocket::DataReceived( void* EMPTYARG )
{
	{
		NAMESPACE_VOS(OGuard) aGuard( aMDataReceived );
		nDataReceivedEventId = 0;	// Achtung!! alles andere mu oben gemacht werden.
	}
	return CommunicationLink::DataReceived( );
}




MultiCommunicationManager::MultiCommunicationManager( BOOL bUseMultiChannel )
: CommunicationManager( bUseMultiChannel )
{
	ActiveLinks = new CommunicationLinkList;
	InactiveLinks = new CommunicationLinkList;
}

MultiCommunicationManager::~MultiCommunicationManager()
{
	StopCommunication();

	// Alles weghauen, was nicht rechtzeitig auf die Bume gekommen ist
	// Was bei StopCommunication brig geblieben ist, da es sich asynchron austragen wollte
	int i = ActiveLinks->Count();
	while ( i )
	{
		CommunicationLinkRef rTempLink = ActiveLinks->GetObject(i-1);
		ActiveLinks->Remove( i-1 );
		rTempLink->InvalidateManager();
		rTempLink->ReleaseReference();
		i--;
	}
	delete ActiveLinks;

	/// Die Links zwischen ConnectionClosed und Destruktor.
	/// Hier NICHT gerefcounted, da sie sich sonst im Kreis festhaten wrden,
	/// da die Links sich erst in ihrem Destruktor austragen
	i = InactiveLinks->Count();
	while ( i )
	{
		CommunicationLinkRef rTempLink = InactiveLinks->GetObject(i-1);
		InactiveLinks->Remove( i-1 );
		rTempLink->InvalidateManager();
		i--;
	}
	delete InactiveLinks;
}

BOOL MultiCommunicationManager::StopCommunication()
{
	// Alle Verbindungen abbrechen
	// ConnectionClosed entfernt die Links aus der Liste. Je nach Implementation syncron
	// oder asyncron. Daher Von oben nach unten Abrumen, so da sich nichts verschiebt.
	int i = ActiveLinks->Count();
	int nFail = 0;
	while ( i )
	{
		if ( !ActiveLinks->GetObject(i-1)->StopCommunication() )
			nFail++;	// Hochzhlen, da Verbindung sich nicht beenden lsst. Sollte aber nie Passieren
		i--;
	}

	return nFail == 0;
}

BOOL MultiCommunicationManager::IsLinkValid( CommunicationLink* pCL )
{
	if ( ActiveLinks->Seek_Entry( pCL ) )
		return TRUE;
	else
		return FALSE;
}

USHORT MultiCommunicationManager::GetCommunicationLinkCount()
{
	return ActiveLinks->Count();
}

CommunicationLinkRef MultiCommunicationManager::GetCommunicationLink( USHORT nNr )
{
	return ActiveLinks->GetObject( nNr );
}

void MultiCommunicationManager::CallConnectionOpened( CommunicationLink* pCL )
{
	CommunicationLinkRef rHold(pCL);	// Hlt den Zeiger bis zum Ende des calls
	ActiveLinks->C40_PTR_INSERT(CommunicationLink, pCL);
	rHold->AddRef();

	CommunicationManager::CallConnectionOpened( pCL );
}

void MultiCommunicationManager::CallConnectionClosed( CommunicationLink* pCL )
{
	CommunicationLinkRef rHold(pCL);	// Hlt denm Zeiger bis zum Ende des calls

	CommunicationManager::CallConnectionClosed( pCL );

	USHORT nPos;
	if ( ActiveLinks->Seek_Entry( pCL, &nPos ) )
	{
		InactiveLinks->C40_PTR_INSERT(CommunicationLink, pCL);	// Ohne Reference
		ActiveLinks->Remove( nPos );
	}
	pCL->ReleaseReference();

	bIsCommunicationRunning = ActiveLinks->Count() > 0;
//	delete pCL;
}

void MultiCommunicationManager::DestroyingLink( CommunicationLink *pCL )
{
	USHORT nPos;
	if ( InactiveLinks->Seek_Entry( pCL, &nPos ) )
		InactiveLinks->Remove( nPos );
	pCL->InvalidateManager();
}



CommunicationManagerClient::CommunicationManagerClient( BOOL bUseMultiChannel )
: MultiCommunicationManager( bUseMultiChannel )
{
	aApplication = ByteString("Something inside ");
	aApplication.Append( ByteString( DirEntry( Application::GetAppFileName() ).GetName(), gsl_getSystemTextEncoding() ) );
}



CommunicationManagerServerViaSocket::CommunicationManagerServerViaSocket( ULONG nPort, USHORT nMaxCon, BOOL bUseMultiChannel )
: CommunicationManagerServer( bUseMultiChannel )
, nPortToListen( nPort )
, nMaxConnections( nMaxCon )
, pAcceptThread( NULL )
{
}

CommunicationManagerServerViaSocket::~CommunicationManagerServerViaSocket()
{
	StopCommunication();
}

BOOL CommunicationManagerServerViaSocket::StartCommunication()
{
	if ( !pAcceptThread )
		pAcceptThread = new CommunicationManagerServerAcceptThread( this, nPortToListen, nMaxConnections );
	return TRUE;
}


BOOL CommunicationManagerServerViaSocket::StopCommunication()
{
	// Erst den Acceptor anhalten
	delete pAcceptThread;
	pAcceptThread = NULL;

	// Dann alle Verbindungen kappen
	return CommunicationManagerServer::StopCommunication();
}


void CommunicationManagerServerViaSocket::AddConnection( CommunicationLink *pNewConnection )
{
	CallConnectionOpened( pNewConnection );
}


CommunicationManagerServerAcceptThread::CommunicationManagerServerAcceptThread( CommunicationManagerServerViaSocket* pServer, ULONG nPort, USHORT nMaxCon )
: pMyServer( pServer )
, pAcceptorSocket( NULL )
, nPortToListen( nPort )
, nMaxConnections( nMaxCon )
, nAddConnectionEventId( 0 )
, xNewConnection( NULL )
{
	create();
}


CommunicationManagerServerAcceptThread::~CommunicationManagerServerAcceptThread()
{
#ifndef aUNX		// Weil das Accept nicht abgebrochen werden kann, so terminiert wenigstens das Prog
	// #62855# pl: gilt auch bei anderen Unixen
	// die richtige Loesung waere natuerlich, etwas auf die pipe zu schreiben,
	// was der thread als Abbruchbedingung erkennt
	// oder wenigstens ein kill anstatt join
	terminate();
	if ( pAcceptorSocket )
		pAcceptorSocket->close();	// Dann das Accept unterbrechen

	join();		// Warten bis fertig

	if ( pAcceptorSocket )
	{
		delete pAcceptorSocket;
		pAcceptorSocket = NULL;
	}
#else
	DEBUGPRINTF ("Destructor CommunicationManagerServerAcceptThread bersprungen!!!! (wegen Solaris BUG)\n");
#endif
	{
		NAMESPACE_VOS(OGuard) aGuard( aMAddConnection );
		if ( nAddConnectionEventId )
		{
			GetpApp()->RemoveUserEvent( nAddConnectionEventId );
			nAddConnectionEventId = 0;
			CommunicationLinkRef xNewConnection = GetNewConnection();
			INFO_MSG( CByteString("Event gelscht"),
				CByteString( "AddConnectionEvent aus Queue gelscht"),
				CM_MISC, xNewConnection );
			xNewConnection->InvalidateManager();
			xNewConnection.Clear();	// sollte das Objekt hier lschen
		}
	}
}

void CommunicationManagerServerAcceptThread::run()
{
	if ( !nPortToListen )
		return;

	pAcceptorSocket = new NAMESPACE_VOS(OAcceptorSocket)();
	NAMESPACE_VOS(OInetSocketAddr) Addr;
	Addr.setPort( nPortToListen );
	pAcceptorSocket->setReuseAddr( 1 );
	if ( !pAcceptorSocket->bind( Addr ) )
	{
		return;
	}
	if ( !pAcceptorSocket->listen( nMaxConnections ) )
	{
		return;
	}


	NAMESPACE_VOS(OStreamSocket) *pStreamSocket = NULL;

	while ( schedule() )
	{
		pStreamSocket = new NAMESPACE_VOS(OStreamSocket);
		switch ( pAcceptorSocket->acceptConnection( *pStreamSocket ) )
		{
		case NAMESPACE_VOS(ISocketTypes::TResult_Ok):
			{
				pStreamSocket->setTcpNoDelay( 1 );

				TimeValue sNochEins = {0, 100};
				while ( schedule() && xNewConnection.Is() )	// Solange die letzte Connection nicht abgeholt wurde warten wir
					sleep( sNochEins );
				xNewConnection = new CommunicationLinkViaSocket( pMyServer, pStreamSocket );
				xNewConnection->StartCallback();
				{
					NAMESPACE_VOS(OGuard) aGuard( aMAddConnection );
					nAddConnectionEventId = GetpApp()->PostUserEvent( LINK( this, CommunicationManagerServerAcceptThread, AddConnection ) );
				}
			}
			break;
		case NAMESPACE_VOS(ISocketTypes::TResult_TimedOut):
			delete pStreamSocket;
			pStreamSocket = NULL;
			break;
		case NAMESPACE_VOS(ISocketTypes::TResult_Error):
			delete pStreamSocket;
			pStreamSocket = NULL;
			break;

		case NAMESPACE_VOS(ISocketTypes::TResult_Interrupted):
		case NAMESPACE_VOS(ISocketTypes::TResult_InProgress):
			break;  // -Wall not handled...
		}
	}
}


IMPL_LINK( CommunicationManagerServerAcceptThread, AddConnection, void*, EMPTYARG )
{
	{
		NAMESPACE_VOS(OGuard) aGuard( aMAddConnection );
		nAddConnectionEventId = 0;
	}
	pMyServer->AddConnection( xNewConnection );
	xNewConnection.Clear();
	return 1;
}


#define GETSET(aVar, KeyName, Dafault)                 \
	aVar = aConf.ReadKey(KeyName,"No Entry");          \
	if ( aVar == "No Entry" )                          \
	{                                                  \
		aVar = Dafault;                                \
		aConf.WriteKey(KeyName, aVar);                 \
	}


CommunicationManagerClientViaSocket::CommunicationManagerClientViaSocket( ByteString aHost, ULONG nPort, BOOL bUseMultiChannel )
: CommunicationManagerClient( bUseMultiChannel )
, aHostToTalk( aHost )
, nPortToTalk( nPort )
{
}

CommunicationManagerClientViaSocket::CommunicationManagerClientViaSocket( BOOL bUseMultiChannel )
: CommunicationManagerClient( bUseMultiChannel )
, aHostToTalk( "" )
, nPortToTalk( 0 )
{
}

CommunicationManagerClientViaSocket::~CommunicationManagerClientViaSocket()
{
}


