/*************************************************************************
 *
 *  $RCSfile: twain.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/02/04 13:59:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "twain.hxx"

#include <comphelper/processfactory.hxx>
#include <cppuhelper/implbase1.hxx>
#include <com/sun/star/uno/Reference.h>
#include <vos/xception.hxx>

#include <tools/debug.hxx>
#include <tools/stream.hxx>
#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_EVENTOBJECT_HPP_
#include <com/sun/star/lang/EventObject.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XBITMAP_HPP_
#include <com/sun/star/awt/XBitmap.hpp>
#endif
#ifndef _COM_SUN_STAR_SCANNER_XSCANNERMANAGER_HPP_
#include <com/sun/star/scanner/XScannerManager.hpp>
#endif

// -----------
// - Defines -
// -----------

#define NMSP_UNO		::com::sun::star::uno
#define NMSP_LANG		::com::sun::star::lang
#define NMSP_SCANNER	::com::sun::star::scanner

// -----------------
// - EventListener -
// -----------------

class TwainEventListener : public ::cppu::WeakImplHelper1< NMSP_LANG::XEventListener >
{
private:

	Twain*					mpParent;

public:

							TwainEventListener( Twain* pParent ) : mpParent( pParent )  {};

	virtual void SAL_CALL 	disposing( const NMSP_LANG::EventObject& rEventObject );
	void					ParentDestroyed() { mpParent = NULL; }
};

// -----------------------------------------------------------------------------

void SAL_CALL TwainEventListener::disposing( const NMSP_LANG::EventObject& rEventObject )
{
	if( mpParent )
		mpParent->Disposing( rEventObject );
}

// --------
// - Misc -
// --------

struct TwainImp
{
	TwainEventListener*										mpListener;
	NMSP_UNO::Reference< NMSP_SCANNER::XScannerManager >	mxManager;
	NMSP_UNO::Reference< NMSP_LANG::XEventListener >		mxListener;
};

// ---------
// - Twain -
// ---------

Twain::Twain( const Link& rUpdateLink ) :
		maUpdateLink( rUpdateLink ),
		mnErrorCode	( TWAIN_ERR_NO_ERROR ),
		mbScanning	( FALSE ),
		mpImp		( new TwainImp )
{
	DBG_ASSERT( maUpdateLink.IsSet(), "Twain::Twain: invalid callback" );
	NMSP_UNO::Reference< NMSP_LANG::XMultiServiceFactory > xMgr( ::comphelper::getProcessServiceFactory() );

	if( xMgr.is() )
	{
		mpImp->mxManager = NMSP_UNO::Reference< NMSP_SCANNER::XScannerManager >(
						   xMgr->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.scanner.ScannerManager" ) ),
						   NMSP_UNO::UNO_QUERY );

		const NMSP_UNO::Reference<NMSP_UNO::XInterface> xIf( static_cast< ::cppu::OWeakObject* >( mpImp->mpListener = new TwainEventListener( this ) ) );
		mpImp->mxListener = NMSP_UNO::Reference< NMSP_LANG::XEventListener >( xIf, NMSP_UNO::UNO_QUERY );
	}
	else
		mpImp->mpListener = NULL;
}

// ------------------------------------------------------------------------

Twain::~Twain()
{
	if( mpImp->mpListener )
		mpImp->mpListener->ParentDestroyed();

	delete mpImp;
}

// -----------------------------------------------------------------------------

void Twain::Disposing( const NMSP_LANG::EventObject& rEventObject )
{
	BOOL bScanDone;

	maBitmap = Bitmap();

	if( mpImp->mxManager.is() )
	{
		NMSP_SCANNER::ScannerContext	aContext( mpImp->mxManager->getAvailableScanners().getConstArray()[ 0 ] );
		const NMSP_SCANNER::ScanError	eError = mpImp->mxManager->getError( aContext );

		if( NMSP_SCANNER::ScanError_ScanErrorNone == eError )
		{
			const NMSP_UNO::Reference< ::com::sun::star::awt::XBitmap > xBitmap( mpImp->mxManager->getBitmap( aContext ) );

	 		if( xBitmap.is() )
			{
				::com::sun::star::awt::Size aSize( xBitmap->getSize() );

				if( aSize.Width && aSize.Height )
				{
					const NMSP_UNO::Sequence< sal_Int8 > aSeq( xBitmap->getDIB() );

					if( aSeq.getLength() )
					{
						SvMemoryStream aMemStm( (char*) aSeq.getConstArray(), aSeq.getLength(), STREAM_READ );
						aMemStm >> maBitmap;
					}
				}
			}
		}
	}

	bScanDone = !!maBitmap;

	if( bScanDone )
		Application::PostUserEvent( maUpdateLink, this );
}

// ------------------------------------------------------------------------

BOOL Twain::SelectSource()
{
	BOOL bRet;

	maBitmap = Bitmap();

	if( mpImp->mxManager.is() )
	{
		try
		{
			NMSP_UNO::Sequence< NMSP_SCANNER::ScannerContext > aContexts( mpImp->mxManager->getAvailableScanners() );

			if( aContexts.getLength() )
			{
				NMSP_SCANNER::ScannerContext aContext( aContexts.getConstArray()[ 0 ] );
				bRet = mpImp->mxManager->configureScanner( aContext );
			}
			else
				bRet = FALSE;
		}
		catch(...)
		{
			bRet = FALSE;
		}
	}
	else
		bRet = FALSE;

	return bRet;
}

// ------------------------------------------------------------------------

BOOL Twain::PerformTransfer()
{
	BOOL bRet;

	maBitmap = Bitmap();

	if( mpImp->mxManager.is() )
	{
		try
		{
			const NMSP_UNO::Sequence< NMSP_SCANNER::ScannerContext > aContexts( mpImp->mxManager->getAvailableScanners() );

			if( aContexts.getLength() )
			{
				NMSP_SCANNER::ScannerContext aContext( aContexts.getConstArray()[ 0 ] );
				mpImp->mxManager->startScan( aContext, mpImp->mxListener );
				bRet = TRUE;
			}
			else
				bRet = FALSE;
		}
		catch(...)
		{
			bRet = FALSE;
		}
	}
	else
		bRet = FALSE;

	return bRet;
}

// ------------------------------------------------------------------------

Bitmap Twain::GetBitmap()
{
	Bitmap aRet( maBitmap );
	maBitmap = Bitmap();
	return aRet;
}
