/*************************************************************************
 *
 *  $RCSfile: svdomedia.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 15:28:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDOMEDIA_HXX
#define _SVDOMEDIA_HXX

#ifndef _SVDORECT_HXX
#include "svdorect.hxx"
#endif
#ifndef _AVMEDIA_MEDIAITEM_HXX
#include <avmedia/mediaitem.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

namespace sdr { namespace contact { class ViewContactOfSdrMediaObj; } }

// ---------------
// - SdrMediaObj -
// ---------------

class SVX_DLLPUBLIC SdrMediaObj : public SdrRectObj
{
	friend class ::sdr::contact::ViewContactOfSdrMediaObj;

public:
	
									TYPEINFO();
						
									SdrMediaObj();
									SdrMediaObj( const Rectangle& rRect );

		virtual 					~SdrMediaObj();

		virtual FASTBOOL 			HasTextEdit() const;
		
		virtual void				TakeObjInfo(SdrObjTransformInfoRec& rInfo) const;
		virtual UINT16				GetObjIdentifier() const;
		virtual sal_Bool 			DoPaintObject(XOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const;

		virtual void 				TakeObjNameSingul(String& rName) const;
		virtual void 				TakeObjNamePlural(String& rName) const;

		virtual void 				operator=(const SdrObject& rObj);
		
public:

		void						setURL( const ::rtl::OUString& rURL );
		const ::rtl::OUString&		getURL() const;

		void						setMediaProperties( const ::avmedia::MediaItem& rState );
		const ::avmedia::MediaItem& getMediaProperties() const;
									
		bool						hasPreferredSize() const;
		Size						getPreferredSize() const;

protected:

		virtual void				mediaPropertiesChanged( const ::avmedia::MediaItem& rNewState );

private:

		virtual ::sdr::contact::ViewContact* CreateObjectSpecificViewContact();
		
		::avmedia::MediaItem		maMediaProperties;
};

#endif //_SVDOMEDIA_HXX
