/*************************************************************************
 *
 *  $RCSfile: viewcontactpainthelper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 10:47:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX
#include <svx/sdr/contact/viewcontactpainthelper.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTREDIRECTOR_HXX
#include <svx/sdr/contact/viewobjectcontactredirector.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif

#ifndef _SDR_PROPERTIES_PROPERTIES_HXX
#include <svx/sdr/properties/properties.hxx>
#endif

#ifndef SVX_XFILLIT0_HXX
#include <xfillit0.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _SVX_XLINEIT0_HXX
#include <xlineit0.hxx>
#endif

#ifndef _XOUTX_HXX
#include <xoutx.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// ViewContact Paint helpers

namespace sdr
{
	namespace contact
	{
		// process the BackgroundObject painting
		sal_Bool PaintBackgroundObject(
			ViewContact& rPainter,
			SdrObject& rBackgroundObject,
			DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, 
			const ViewObjectContact& rAssociatedVOC)
		{
			sal_Bool bRetval(sal_False);

			// get the correct redirector
			ViewObjectContactRedirector* pRedirector = rAssociatedVOC.GetRedirector();

			if(pRedirector)
			{
				// for historical reasons if the pPaintProc is set we need
				// to call the old paint mechanism here to get created the output
				// into the metafile(s).
				rBackgroundObject.DoPaintObject(
					*rDisplayInfo.GetExtendedOutputDevice(), 
					*rDisplayInfo.GetPaintInfoRec());

				rPaintRectangle = rPainter.GetPaintRectangle();
				bRetval = sal_True;
			}
			else
			{
				// use pFillProperties to paint a object in the size of the page
				const SfxItemSet& rFillProperties = rBackgroundObject.GetProperties().GetObjectItemSet();

				Rectangle a2ndPaintRect;
				bRetval = PaintBackgroundObjectWithItemSet(
					rPainter, rDisplayInfo, rPaintRectangle, rFillProperties);
			}

			return bRetval;
		}

		// Paint a PageBackgroundObject with the size of the page and the attributes
		// of the given FillProperties
		sal_Bool PaintBackgroundObjectWithItemSet(
			ViewContact& rPainter,
			DisplayInfo& rDisplayInfo, Rectangle& rPaintRectangle,
			const SfxItemSet& rFillProperties)
		{
			sal_Bool bRetval(sal_False);
			XOutputDevice* pExtOut = rDisplayInfo.GetExtendedOutputDevice();

			if(pExtOut)
			{
				XFillStyle eFillStyle = ((XFillStyleItem&)(rFillProperties.Get(XATTR_FILLSTYLE))).GetValue();

				if(XFILL_NONE != eFillStyle)
				{
					Rectangle aPaintRectangle = rPainter.GetPaintRectangle();
					SfxItemSet aEmptySet(*rFillProperties.GetPool());
					aEmptySet.Put(XLineStyleItem(XLINE_NONE));

					pExtOut->SetLineAttr(aEmptySet);
					pExtOut->SetFillAttr(rFillProperties);
					pExtOut->DrawRect(aPaintRectangle);

					rPaintRectangle = aPaintRectangle;
					bRetval = sal_True;
				}
			}

			return bRetval;
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
