/*************************************************************************
 *
 *  $RCSfile: vocofmasterpagedescriptor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/12/13 08:55:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VOCOFMASTERPAGEDESCRIPTOR_HXX
#include <svx/sdr/contact/vocofmasterpagedescriptor.hxx>
#endif

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		// basic constructor.
		VOCOfMasterPageDescriptor::VOCOfMasterPageDescriptor(ObjectContact& rObjectContact, ViewContactOfMasterPageDescriptor& rViewContact)
		:	VOCBitmapBuffer(rObjectContact, rViewContact),
			rViewContactOfMasterPageDescriptor(rViewContact)
		{
		}

		// The destructor.
		VOCOfMasterPageDescriptor::~VOCOfMasterPageDescriptor()
		{
		}

		// Prepare deletion of this object.
		void VOCOfMasterPageDescriptor::PrepareDelete()
		{
			// allow ViewContactOfMasterPageDescriptor to buffer the last valid painted
			// buffer of this object to re-use it when re-displaying
			if(maBuffer.BufferIsValid())
			{
				rViewContactOfMasterPageDescriptor.OfferBufferedData(
					maBuffer.GetBufferedBitmap(), maBuffer.GetBufferedMapMode());
			}

			// call parent
			VOCBitmapBuffer::PrepareDelete();
		}

		void VOCOfMasterPageDescriptor::PaintObject(DisplayInfo& rDisplayInfo)
		{
			// see if cached data is available
			OutputDevice* pOriginalOutDev = rDisplayInfo.GetOutputDevice();
			if(pOriginalOutDev && !maBuffer.BufferIsValid())
			{
				Bitmap aBitmap(rViewContactOfMasterPageDescriptor.RequestBufferedData(pOriginalOutDev->GetMapMode()));

				if(!aBitmap.IsEmpty())
				{
					maBuffer.SetBufferedData(pOriginalOutDev->GetMapMode(), aBitmap);
				}
			}

			// call parent
			VOCBitmapBuffer::PaintObject(rDisplayInfo);

			// #i37869# Paint evtl. necessary borders and grids. Paint this over the evtl.
			// buffered MasterPage where those outputs are suppresed by purpose.
			rViewContactOfMasterPageDescriptor.PaintBackgroundPageBordersAndGrids(rDisplayInfo);
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
