/*************************************************************************
 *
 *  $RCSfile: svdio.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 10:56:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//BFS01#ifndef _OSL_ENDIAN_H_
//BFS01#include <osl/endian.h>
//BFS01#endif
//BFS01#include <tools/debug.hxx>

#include "svdio.hxx"
//BFS01#include "svdobj.hxx"

////////////////////////////////////////////////////////////////////////////////////////////////////


//BFS01SdrIOHeader::SdrIOHeader(SvStream& rNewStream, UINT16 nNewMode, const char cID[2], 
//BFS01	BOOL bAutoOpen)
//BFS01:	rStream(rNewStream)
//BFS01{
//BFS01	nFilePos = 0;
//BFS01	nMode = nNewMode;
//BFS01	bOpen = FALSE;
//BFS01	bClosed = FALSE;
//BFS01	bLookAhead = FALSE;
//BFS01	SetID(cID);
//BFS01	nVersion = nAktSdrFileVersion;
//BFS01	nBlkSize = 0;
//BFS01	SetMagic();
//BFS01
//BFS01	if(bAutoOpen) 
//BFS01	{
//BFS01		OpenRecord();
//BFS01	}
//BFS01}

//BFS01SdrIOHeader::~SdrIOHeader()
//BFS01{
//BFS01	if(bOpen && !bClosed && !bLookAhead) 
//BFS01		CloseRecord();
//BFS01}

//BFS01void SdrIOHeader::OpenRecord()
//BFS01{
//BFS01	if(rStream.GetError()) 
//BFS01		return;
//BFS01	
//BFS01	DBG_ASSERT(!bClosed,"SdrIOHeader::OpenRecord(): Record ist bereits geschlossen.");
//BFS01	DBG_ASSERT(!bOpen,"SdrIOHeader::OpenRecord(): Record ist bereits geoeffnet.");
//BFS01	
//BFS01	// Fileposition des Records merken
//BFS01	nFilePos = rStream.Tell(); 
//BFS01
//BFS01	if(nMode==STREAM_READ) 
//BFS01	{
//BFS01		// RecordHeader lesen
//BFS01		Read(); 
//BFS01	} 
//BFS01	else if(nMode == STREAM_WRITE) 
//BFS01	{
//BFS01		// Platz fuer RecordHeader schaffen
//BFS01		Write();   
//BFS01	} 
//BFS01	else 
//BFS01		DBG_ERROR("SdrIOHeader::OpenRecord(): Falscher StreamMode angegeben.");
//BFS01	
//BFS01	bOpen = TRUE;
//BFS01	
//BFS01	// Endemarke wird sofort geschlossen.
//BFS01	if(IsEnde() && !bLookAhead) 
//BFS01		CloseRecord(); 
//BFS01
//BFS01	if(bLookAhead) 
//BFS01		rStream.Seek(nFilePos);
//BFS01}

//BFS01void SdrIOHeader::CloseRecord()
//BFS01{
//BFS01	if(rStream.GetError()) 
//BFS01		return;
//BFS01
//BFS01	if(bLookAhead) 
//BFS01	{
//BFS01		rStream.Seek(nFilePos);
//BFS01		DBG_ERROR("SdrIOHeader::CloseRecord(): CloseRecord im Modus LookAhead.");
//BFS01		return;
//BFS01	}
//BFS01	
//BFS01	DBG_ASSERT(!bClosed,"SdrIOHeader::CloseRecord(): Record ist bereits geschlossen.");
//BFS01	DBG_ASSERT(bOpen || bClosed,"SdrIOHeader::CloseRecord(): Record ist noch nicht geoeffnet.");
//BFS01	
//BFS01	UINT32 nAktPos(rStream.Tell());
//BFS01	
//BFS01	if(nMode == STREAM_READ) 
//BFS01	{
//BFS01		UINT32 nReadAnz(nAktPos - nFilePos);
//BFS01
//BFS01#ifdef DBG_UTIL
//BFS01		ImpCheckRecordIntegrity();
//BFS01#endif
//BFS01
//BFS01		if(nReadAnz != nBlkSize) 
//BFS01		{
//BFS01			// FilePos korregieren
//BFS01			rStream.Seek(nFilePos + nBlkSize); 
//BFS01		}
//BFS01	} 
//BFS01	else if(nMode == STREAM_WRITE) 
//BFS01	{
//BFS01		// Groesse dieses Records (inkl. der Header)
//BFS01		nBlkSize = nAktPos - nFilePos;     
//BFS01		// an den Anfang des Records
//BFS01		rStream.Seek(nFilePos);        
//BFS01		// Header rausschreiben.
//BFS01		Write();                       
//BFS01		// und die FilePos restaurieren.
//BFS01		rStream.Seek(nAktPos);         
//BFS01
//BFS01#ifdef DBG_UTIL
//BFS01		ImpCheckRecordIntegrity();
//BFS01#endif
//BFS01	} 
//BFS01	else 
//BFS01		DBG_ERROR("SdrIOHeader::CloseRecord(): Falscher StreamMode angegeben.");
//BFS01	
//BFS01	bOpen = FALSE;
//BFS01	bClosed = TRUE;
//BFS01}

//BFS01void SdrIOHeader::Write()
//BFS01{
//BFS01#ifdef OSL_BIGENDIAN
//BFS01	nVersion=SWAPSHORT(nVersion);
//BFS01	nBlkSize=SWAPLONG (nBlkSize);
//BFS01#endif
//BFS01
//BFS01	rStream.Write(cMagic, 4);
//BFS01
//BFS01	if(!IsEnde()) 
//BFS01	{
//BFS01		rStream.Write((char*)&nVersion, 2);
//BFS01		rStream.Write((char*)&nBlkSize, 4);
//BFS01	}
//BFS01
//BFS01#ifdef OSL_BIGENDIAN
//BFS01	nVersion=SWAPSHORT(nVersion);
//BFS01	nBlkSize=SWAPLONG (nBlkSize);
//BFS01#endif
//BFS01}


//BFS01void SdrIOHeader::Read()
//BFS01{
//BFS01	rStream.Read(cMagic, 4);
//BFS01
//BFS01	if(!IsEnde()) 
//BFS01	{
//BFS01		rStream.Read((char*)&nVersion, 2);
//BFS01		rStream.Read((char*)&nBlkSize, 4);
//BFS01
//BFS01#ifdef OSL_BIGENDIAN
//BFS01		nVersion=SWAPSHORT(nVersion);
//BFS01		nBlkSize=SWAPLONG (nBlkSize);
//BFS01#endif
//BFS01	} 
//BFS01	else 
//BFS01	{
//BFS01		nBlkSize = 4;
//BFS01	}
//BFS01}

//BFS01UINT32 SdrIOHeader::GetBytesLeft() const
//BFS01{
//BFS01	if(nMode == STREAM_READ) 
//BFS01	{
//BFS01		UINT32 nAktPos(rStream.Tell());
//BFS01		UINT32 nReadAnz(nAktPos - nFilePos);
//BFS01		
//BFS01		if(nReadAnz <= nBlkSize) 
//BFS01			return nBlkSize - nReadAnz;
//BFS01		else 
//BFS01			// Fehler, zuviel gelesen!
//BFS01			return 0; 
//BFS01	} 
//BFS01	else 
//BFS01		return 0;
//BFS01}

//BFS01#ifdef DBG_UTIL

//BFS01void SdrIOHeader::ImpGetRecordName(ByteString& rStr, INT32 nSubRecCount, 
//BFS01	INT32 nSubRecReadCount) const
//BFS01{
//BFS01	rStr = "CheckRecordIntegrity (ID=";
//BFS01	rStr += cMagic[0];
//BFS01	rStr += cMagic[1];
//BFS01	rStr += cHdrID[0];
//BFS01	rStr += cHdrID[1];
//BFS01	rStr += ')';
//BFS01	
//BFS01	if(nSubRecCount != -1) 
//BFS01	{
//BFS01		rStr += " (";
//BFS01		
//BFS01		if(nSubRecReadCount != -1) 
//BFS01		{
//BFS01			rStr += ByteString::CreateFromInt32( nSubRecReadCount );
//BFS01			rStr += " von ";
//BFS01			rStr += ByteString::CreateFromInt32( nSubRecCount );
//BFS01			rStr += " Records gelesen)";
//BFS01		} 
//BFS01		else 
//BFS01		{
//BFS01			rStr += ByteString::CreateFromInt32( nSubRecCount );
//BFS01			rStr += " Records)";
//BFS01		}
//BFS01	}
//BFS01}

//BFS01BOOL SdrIOHeader::ImpHasSubRecords() const
//BFS01{
//BFS01	// nicht jeder Record hat SubRecords
//BFS01	return IsID(SdrIOModlID) || 
//BFS01		   IsID(SdrIOPageID) ||
//BFS01		   IsID(SdrIOMaPgID) ||
//BFS01		   IsID(SdrIODObjID);
//BFS01}

// Testet die Integritaet eines Records. Innerhalb eines Records
// muessen alle Daten in Subrecords (SdrDownCompat) untergebracht sein.

//BFS01void SdrIOHeader::ImpCheckRecordIntegrity()
//BFS01{
//BFS01	UINT32 nFilePos0(rStream.Tell());
//BFS01	
//BFS01	if(IsMagic() && ImpHasSubRecords()) 
//BFS01	{ 
//BFS01		// nicht jeder Record hat SubRecords
//BFS01		// Seek an den Recordanfang
//BFS01		rStream.Seek(nFilePos); 
//BFS01		Read();
//BFS01
//BFS01		// Anzahl der vorhandenen SubRecords
//BFS01		UINT32 nHasSubRecCount(0);  
//BFS01		// Anzahl der SubRecords bis nFilePos0
//BFS01		UINT32 nReadSubRecCount(0); 
//BFS01		UINT32 nAktFilePos(rStream.Tell());
//BFS01		BOOL bFilePos0Hit(nAktFilePos == nFilePos0);
//BFS01		
//BFS01		while(!rStream.GetError() && !rStream.IsEof() && nAktFilePos < nFilePos + nBlkSize) 
//BFS01		{
//BFS01			UINT32 nSubRecSiz;
//BFS01
//BFS01			nHasSubRecCount++;
//BFS01			rStream >> nSubRecSiz;
//BFS01			nAktFilePos += nSubRecSiz;
//BFS01			rStream.Seek(nAktFilePos);
//BFS01
//BFS01			if(nAktFilePos <= nFilePos0) 
//BFS01				nReadSubRecCount++;
//BFS01
//BFS01			if(nAktFilePos == nFilePos0) 
//BFS01				// Aha, nFilePos0 ist ok.
//BFS01				bFilePos0Hit = TRUE; 
//BFS01		}
//BFS01	
//BFS01		ByteString aStr;
//BFS01		
//BFS01		if(nAktFilePos != nFilePos+nBlkSize) 
//BFS01			aStr += "- SubRecord-Strukturfehler.\n";
//BFS01
//BFS01		if(nFilePos0 > nAktFilePos) 
//BFS01		{
//BFS01			UINT32 nToMuch(nFilePos0 - nAktFilePos);
//BFS01
//BFS01			aStr += "- ";
//BFS01
//BFS01			if(nToMuch == 1) 
//BFS01				aStr += "1 Byte";
//BFS01			else 
//BFS01			{
//BFS01				aStr += ByteString::CreateFromInt32( nToMuch );
//BFS01				aStr += " Bytes";
//BFS01			}
//BFS01
//BFS01			aStr += " zuviel gelesen.\n";
//BFS01		}
//BFS01
//BFS01		if(!bFilePos0Hit) 
//BFS01			aStr += "- Aktuelle Fileposition liegt nicht am Ende eines SubRecords.\n";
//BFS01
//BFS01		if(aStr.Len()) 
//BFS01		{
//BFS01			ByteString aStr2;
//BFS01
//BFS01			aStr.Insert(":\n", 0);
//BFS01			ImpGetRecordName(aStr2, nHasSubRecCount, nReadSubRecCount);
//BFS01			aStr.Insert(aStr2, 0);
//BFS01			DBG_ERROR(aStr.GetBuffer());
//BFS01		}
//BFS01	} 
//BFS01	else 
//BFS01	{ 
//BFS01		// keine SubRecords vorhanden, also nur FilePos pruefen
//BFS01		if(nFilePos0 > nFilePos + nBlkSize) 
//BFS01		{
//BFS01			ByteString aStr;
//BFS01			UINT32 nToMuch(nFilePos0 - nFilePos+nBlkSize);
//BFS01			
//BFS01			ImpGetRecordName(aStr);
//BFS01			aStr += ":\nAus dem Record wurde";
//BFS01			
//BFS01			if(nToMuch == 1) 
//BFS01				aStr += "1 Byte";
//BFS01			else 
//BFS01			{
//BFS01				aStr += "n ";
//BFS01				aStr += ByteString::CreateFromInt32( nToMuch );
//BFS01				aStr += " Bytes";
//BFS01			}
//BFS01
//BFS01			aStr += " zuviel gelesen. FilePos wird korregiert";
//BFS01
//BFS01			DBG_ERROR(aStr.GetBuffer());
//BFS01		}
//BFS01	}
//BFS01
//BFS01	// Fileposition restaurieren
//BFS01	rStream.Seek(nFilePos0); 
//BFS01}
//BFS01#endif

//BFS01SdrIOHeaderLookAhead::SdrIOHeaderLookAhead(SvStream& rNewStream, BOOL bAutoOpen)
//BFS01:	SdrIOHeader(rNewStream, STREAM_READ, SdrIOEndeID, FALSE)
//BFS01{
//BFS01	bLookAhead = TRUE;
//BFS01	
//BFS01	if(bAutoOpen) 
//BFS01	{
//BFS01		OpenRecord();
//BFS01	}
//BFS01}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

//BFS01SdrObjIOHeader::SdrObjIOHeader(SvStream& rNewStream, UINT16 nNewMode, 
//BFS01	const SdrObject* pNewObj, BOOL bAutoOpen)
//BFS01:	SdrIOHeader(rNewStream, nNewMode, SdrIODObjID, FALSE), 
//BFS01	pObj(pNewObj)
//BFS01{
//BFS01	if(pNewObj) 
//BFS01	{
//BFS01		nInventor = pNewObj->GetObjInventor();
//BFS01		nIdentifier = pNewObj->GetObjIdentifier();
//BFS01	} 
//BFS01	else 
//BFS01	{
//BFS01		nInventor = 0;
//BFS01		nIdentifier = 0;
//BFS01	}
//BFS01
//BFS01	if(bAutoOpen) 
//BFS01	{
//BFS01		OpenRecord();
//BFS01	}
//BFS01}

//BFS01SdrObjIOHeader::~SdrObjIOHeader()
//BFS01{
//BFS01	if(bOpen && !bClosed && !bLookAhead) 
//BFS01		CloseRecord();
//BFS01}

//BFS01void SdrObjIOHeader::Write()
//BFS01{
//BFS01	SdrIOHeader::Write();
//BFS01
//BFS01	if(!IsEnde()) 
//BFS01	{
//BFS01#ifdef OSL_BIGENDIAN
//BFS01		nInventor = SWAPLONG(nInventor);
//BFS01		nIdentifier = SWAPSHORT(nIdentifier);
//BFS01#endif
//BFS01		rStream.Write((char*)&nInventor, 4);
//BFS01		rStream.Write((char*)&nIdentifier, 2);
//BFS01#ifdef OSL_BIGENDIAN
//BFS01		nInventor = SWAPLONG(nInventor);
//BFS01		nIdentifier = SWAPSHORT(nIdentifier);
//BFS01#endif
//BFS01	}
//BFS01}

//BFS01void SdrObjIOHeader::Read()
//BFS01{
//BFS01	SdrIOHeader::Read();
//BFS01
//BFS01	if(!IsEnde()) 
//BFS01	{
//BFS01		rStream.Read((char*)&nInventor, 4);
//BFS01		rStream.Read((char*)&nIdentifier, 2);
//BFS01#ifdef OSL_BIGENDIAN
//BFS01		nInventor = SWAPLONG(nInventor);
//BFS01		nIdentifier = SWAPSHORT(nIdentifier);
//BFS01#endif
//BFS01	}
//BFS01}

//BFS01SdrObjIOHeaderLookAhead::SdrObjIOHeaderLookAhead(SvStream& rNewStream, 
//BFS01	BOOL bAutoOpen)
//BFS01:	SdrObjIOHeader(rNewStream, STREAM_READ, NULL, FALSE)
//BFS01{
//BFS01	bLookAhead = TRUE;
//BFS01
//BFS01	if(bAutoOpen) 
//BFS01	{
//BFS01		OpenRecord();
//BFS01	}
//BFS01}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

//BFS01SdrDownCompat::SdrDownCompat(SvStream& rNewStream, UINT16 nNewMode, BOOL bAutoOpen)
//BFS01:	rStream(rNewStream), 
//BFS01	nSubRecSiz(0), 
//BFS01	nSubRecPos(0), 
//BFS01	nMode(nNewMode),
//BFS01	bOpen(FALSE), 
//BFS01	bClosed(FALSE), 
//BFS01	pRecId(NULL)
//BFS01{
//BFS01	if(bAutoOpen) 
//BFS01		OpenSubRecord();
//BFS01}

//BFS01SdrDownCompat::~SdrDownCompat()
//BFS01{
//BFS01	if(!bClosed)
//BFS01		CloseSubRecord();
//BFS01}

//BFS01void SdrDownCompat::Read()
//BFS01{
//BFS01	// Subrecordgroesse auslesen
//BFS01	rStream >> nSubRecSiz;   
//BFS01}

//BFS01void SdrDownCompat::Write()
//BFS01{
//BFS01	// Platz fuer Groessenangabe schaffen
//BFS01	rStream << nSubRecSiz;   
//BFS01}

//BFS01void SdrDownCompat::OpenSubRecord()
//BFS01{
//BFS01	if(rStream.GetError()) 
//BFS01		return;
//BFS01
//BFS01	DBG_ASSERT(!bClosed,"SdrDownCompat::OpenSubRecord(): Record ist bereits geschlossen.");
//BFS01	DBG_ASSERT(!bOpen,"SdrDownCompat::OpenSubRecord(): Record ist bereits geoeffnet.");
//BFS01	
//BFS01	// Fileposition des Records merken
//BFS01	nSubRecPos = rStream.Tell(); 
//BFS01
//BFS01	if(nMode == STREAM_READ) 
//BFS01	{
//BFS01		// Subrecordgroesse auslesen
//BFS01		Read();         
//BFS01	} 
//BFS01	else if(nMode == STREAM_WRITE) 
//BFS01	{
//BFS01		// Platz fuer Groessenangabe schaffen
//BFS01		Write();            
//BFS01	} 
//BFS01	else 
//BFS01		DBG_ERROR("SdrDownCompat::OpenSubRecord(): Falscher StreamMode angegeben.");
//BFS01
//BFS01	bOpen = TRUE;
//BFS01}

//BFS01void SdrDownCompat::CloseSubRecord()
//BFS01{
//BFS01	if(rStream.GetError()) 
//BFS01		return;
//BFS01
//BFS01	DBG_ASSERT(!bClosed,"SdrDownCompat::CloseSubRecord(): Record ist bereits geschlossen.");
//BFS01	DBG_ASSERT(bOpen || bClosed,"SdrDownCompat::CloseSubRecord(): Record ist noch nicht geoeffnet.");
//BFS01	
//BFS01	UINT32 nAktPos(rStream.Tell());
//BFS01	
//BFS01	if(nMode == STREAM_READ) 
//BFS01	{
//BFS01		UINT32 nReadAnz(nAktPos - nSubRecPos);
//BFS01
//BFS01#ifdef DBG_UTIL
//BFS01		if(nReadAnz > nSubRecSiz) 
//BFS01		{
//BFS01			ByteString aErrMsg("SdrDownCompat::CloseSubRecord(), ");
//BFS01			
//BFS01			aErrMsg += "RedordID";
//BFS01
//BFS01			if(!pRecId) 
//BFS01				aErrMsg += " unbekannt";
//BFS01			else 
//BFS01			{
//BFS01				aErrMsg += '=';
//BFS01				aErrMsg += pRecId;
//BFS01			}
//BFS01
//BFS01			aErrMsg += ":\nAus dem Record wurde";
//BFS01
//BFS01			UINT32 nToMuch(nReadAnz - nSubRecSiz);
//BFS01			
//BFS01			if(nToMuch == 1) 
//BFS01				aErrMsg += " 1 Byte";
//BFS01			else 
//BFS01			{
//BFS01				aErrMsg += "n ";
//BFS01				aErrMsg += ByteString::CreateFromInt32( nToMuch );
//BFS01				aErrMsg += " Bytes";
//BFS01			}
//BFS01
//BFS01			aErrMsg += " zuviel gelesen, FilePos korregiert.";
//BFS01
//BFS01			DBG_ERROR(aErrMsg.GetBuffer());
//BFS01		}
//BFS01#endif
//BFS01
//BFS01		if(nReadAnz != nSubRecSiz) 
//BFS01		{
//BFS01			// den Rest ueberspringen
//BFS01			rStream.Seek(nSubRecPos + nSubRecSiz); 
//BFS01		}
//BFS01	} 
//BFS01	else if(nMode == STREAM_WRITE) 
//BFS01	{
//BFS01		// Groesse dieses SubRecords (inkl. der Groessenangabe selbst)
//BFS01		nSubRecSiz = nAktPos - nSubRecPos; 
//BFS01
//BFS01		// an den Anfang des Records
//BFS01		rStream.Seek(nSubRecPos);      
//BFS01		// rausschreiben.
//BFS01		Write();                    
//BFS01		// und die FilePos restaurieren.
//BFS01		rStream.Seek(nAktPos);         
//BFS01	} 
//BFS01	else 
//BFS01		DBG_ERROR("SdrDownCompat::CloseSubRecord(): Falscher StreamMode angegeben.");
//BFS01	
//BFS01	bOpen = FALSE;
//BFS01	bClosed = TRUE;
//BFS01}

//BFS01UINT32 SdrDownCompat::GetBytesLeft() const
//BFS01{
//BFS01	if(nMode == STREAM_READ) 
//BFS01	{
//BFS01		UINT32 nAktPos(rStream.Tell());
//BFS01		UINT32 nReadAnz(nAktPos - nSubRecPos);
//BFS01		
//BFS01		if(nReadAnz <= nSubRecSiz) 
//BFS01			return nSubRecSiz - nReadAnz;
//BFS01		else 
//BFS01		// Fehler, zuviel gelesen!
//BFS01			return 0; 
//BFS01	} 
//BFS01	else 
//BFS01		return 0;
//BFS01}

////////////////////////////////////////////////////////////////////////////////////////////////////

//BFS01SdrNamedSubRecord::SdrNamedSubRecord(SvStream& rNewStream, UINT16 nNewMode,
//BFS01	UINT32 nNewInventor, UINT16 nNewIdentifier,
//BFS01	BOOL bAutoOpen)
//BFS01:	SdrDownCompat(rNewStream, nNewMode, FALSE),
//BFS01	nInventor(nNewInventor),
//BFS01	nIdentifier(nNewIdentifier)
//BFS01{
//BFS01	DBG_ASSERT(nNewMode==STREAM_READ || (nNewInventor!=0xFFFF && nNewInventor!=0xFFFF),
//BFS01		"SdrNamedSubRecord: bei Write muss Inventor und Identifier angegeben werden");
//BFS01	
//BFS01	if(bAutoOpen) 
//BFS01		OpenSubRecord();
//BFS01}

//BFS01void SdrNamedSubRecord::Read()
//BFS01{
//BFS01	SdrDownCompat::Read();
//BFS01
//BFS01	rStream.Read((char*)&nInventor, 4);
//BFS01	rStream.Read((char*)&nIdentifier, 2);
//BFS01
//BFS01#ifdef OSL_BIGENDIAN
//BFS01	nIdentifier = SWAPSHORT(nIdentifier);
//BFS01	nInventor = SWAPLONG(nInventor);
//BFS01#endif
//BFS01}

//BFS01void SdrNamedSubRecord::Write()
//BFS01{
//BFS01	SdrDownCompat::Write();
//BFS01
//BFS01#ifdef OSL_BIGENDIAN
//BFS01	nIdentifier = SWAPSHORT(nIdentifier);
//BFS01	nInventor = SWAPLONG(nInventor);
//BFS01#endif
//BFS01
//BFS01	rStream.Write((char*)&nInventor, 4);
//BFS01	rStream.Write((char*)&nIdentifier, 2);
//BFS01
//BFS01#ifdef OSL_BIGENDIAN
//BFS01	nIdentifier = SWAPSHORT(nIdentifier);
//BFS01	nInventor = SWAPLONG(nInventor);
//BFS01#endif
//BFS01}

////////////////////////////////////////////////////////////////////////////////////////////////////

//BFS01BOOL SdrIsModel(SvStream& rIn)
//BFS01{
//BFS01	if(!rIn.GetError() && !rIn.IsEof()) 
//BFS01	{
//BFS01		SdrIOHeaderLookAhead aHead(rIn);
//BFS01		
//BFS01		if(!rIn.GetError() && aHead.IsMagic() && aHead.IsID(SdrIOModlID)) 
//BFS01			return TRUE;
//BFS01	}
//BFS01
//BFS01	return FALSE;
//BFS01}

//BFS01BOOL SdrIsView(SvStream& rIn)
//BFS01{
//BFS01	if(!rIn.GetError() && !rIn.IsEof()) 
//BFS01	{
//BFS01		SdrIOHeaderLookAhead aHead(rIn);
//BFS01	
//BFS01		if(!rIn.GetError() && aHead.IsMagic() && aHead.IsID(SdrIOViewID)) 
//BFS01			return TRUE;
//BFS01	}
//BFS01
//BFS01	return FALSE;
//BFS01}

