/*************************************************************************
 *
 *  $RCSfile: _ximp.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 11:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <algorithm>

#include <stdlib.h>
#include <math.h>
#include <vcl/svapp.hxx>
#include <tools/poly.hxx>
#include <vcl/gradient.hxx>
#include <vcl/virdev.hxx>
#include <vcl/gdimtf.hxx>
#include <vcl/metaact.hxx>
#include <vcl/salbtype.hxx>
#include <vcl/wrkwin.hxx>
#include <goodies/grfmgr.hxx>
#include "xpoly.hxx"
#include "xattr.hxx"
#include "xoutbmp.hxx"
#include "xoutx.hxx"
#include "svdoimp.hxx"

// -----------
// - Statics -
// -----------

#ifdef MAC
	const BOOL XIMP_bDrawRasterOps = FALSE;
#else
	const BOOL XIMP_bDrawRasterOps = TRUE;
#endif

// -----------
// - Defines -
// -----------

#define FILL_TILE 200

// ----------------
// - XOuputDevice -
// ----------------

void XOutputDevice::DrawFillPolyPolygon( const PolyPolygon& rPolyPoly, BOOL bRect )
{
	if( ( eFillStyle != XFILL_NONE ) && pTransGradient &&
		( eFillStyle != XFILL_SOLID || pTransGradient->GetStartColor() != pTransGradient->GetEndColor() ) )
	{
		XGradient&		rTransGradient = *pTransGradient;
		Gradient		aVCLGradient;
		GDIMetaFile		aMtf;
		VirtualDevice	aVDev;
		OutputDevice*	pOldOut = pOut;
		const Rectangle	aBound( rPolyPoly.GetBoundRect() );
		MapMode			aMap( pOldOut->GetMapMode() );

		pOut = &aVDev;
		aVDev.EnableOutput( FALSE );
		aVDev.SetMapMode( pOldOut->GetMapMode() );
		aMtf.Record( &aVDev );
		aVDev.SetLineColor( pOldOut->GetLineColor() );
		aVDev.SetFillColor( pOldOut->GetFillColor() );
		aVDev.SetFont( pOldOut->GetFont() );
		aVDev.SetDrawMode( pOldOut->GetDrawMode() );
		aVDev.SetRefPoint( pOldOut->GetRefPoint() );
		ImpDrawFillPolyPolygon( rPolyPoly, bRect, pOldOut->GetOutDevType() == OUTDEV_PRINTER );
		aMtf.Stop();
		aMtf.WindStart();
		aMap.SetOrigin( aBound.TopLeft() );
		aMtf.SetPrefMapMode( aMap );
		aMtf.SetPrefSize( aBound.GetSize() );
		pOut = pOldOut;

		aVCLGradient.SetStyle((GradientStyle)rTransGradient.GetGradientStyle());
		aVCLGradient.SetStartColor(rTransGradient.GetStartColor());
		aVCLGradient.SetEndColor(rTransGradient.GetEndColor());
		aVCLGradient.SetAngle((USHORT)rTransGradient.GetAngle());
		aVCLGradient.SetBorder(rTransGradient.GetBorder());
		aVCLGradient.SetOfsX(rTransGradient.GetXOffset());
		aVCLGradient.SetOfsY(rTransGradient.GetYOffset());
		aVCLGradient.SetStartIntensity(rTransGradient.GetStartIntens());
		aVCLGradient.SetEndIntensity(rTransGradient.GetEndIntens());
		aVCLGradient.SetSteps(rTransGradient.GetSteps());

		pOut->DrawTransparent( aMtf, aBound.TopLeft(), aBound.GetSize(), aVCLGradient );
	}
	else
		ImpDrawFillPolyPolygon( rPolyPoly, bRect, pOut->GetOutDevType() == OUTDEV_PRINTER );
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawFillPolyPolygon( const PolyPolygon& rPolyPoly, BOOL bRect, BOOL bPrinter )
{
	if( eFillStyle != XFILL_NONE )
	{
		const Color aOldLineColor( pOut->GetLineColor() );
		const ULONG	nDrawMode = pOut->GetDrawMode();

		pOut->SetLineColor();

		if( eFillStyle == XFILL_SOLID )
		{
			if( nFillTransparence )
				pOut->DrawTransparent( rPolyPoly, nFillTransparence );
			else
				pOut->DrawPolyPolygon( rPolyPoly );
		}
		else if( eFillStyle == XFILL_HATCH )
		{
			long		nAngle10 = aHatch.GetAngle() % 3600;
			HatchStyle	eStyle;

			if( nAngle10 < 0 )
				nAngle10 += 3600;

			switch( aHatch.GetHatchStyle() )
			{
				case( XHATCH_TRIPLE ): eStyle = HATCH_TRIPLE; break;
				case( XHATCH_DOUBLE ): eStyle = HATCH_DOUBLE; break;

				default:
					eStyle = HATCH_SINGLE;
				break;
			}

			if( bSolidHatch )
				pOut->DrawPolyPolygon( rPolyPoly );

			pOut->DrawHatch( rPolyPoly, Hatch( eStyle, aHatch.GetColor(), aHatch.GetDistance(), (USHORT) nAngle10 ) );
		}
		else if( eFillStyle == XFILL_GRADIENT )
		{
			GDIMetaFile*	pMtf = pOut->GetConnectMetaFile();
			Gradient		aVCLGradient;


			aVCLGradient.SetStyle((GradientStyle)aGradient.GetGradientStyle());
			aVCLGradient.SetStartColor(aGradient.GetStartColor());
			aVCLGradient.SetEndColor(aGradient.GetEndColor());
			aVCLGradient.SetAngle((USHORT)aGradient.GetAngle());
			aVCLGradient.SetBorder(aGradient.GetBorder());
			aVCLGradient.SetOfsX(aGradient.GetXOffset());
			aVCLGradient.SetOfsY(aGradient.GetYOffset());
			aVCLGradient.SetStartIntensity(aGradient.GetStartIntens());
			aVCLGradient.SetEndIntensity(aGradient.GetEndIntens());
			aVCLGradient.SetSteps(aGradient.GetSteps());

			if( bRect )
				pOut->DrawGradient( rPolyPoly.GetBoundRect(), aVCLGradient );
			else
				pOut->DrawGradient( rPolyPoly, aVCLGradient );
		}
		else if( eFillStyle == XFILL_BITMAP )
		{
			if( nDrawMode & DRAWMODE_WHITEFILL )
			{
				const Color aOldFillColor( pOut->GetFillColor() );

				pOut->SetFillColor( COL_WHITE );
				pOut->DrawPolyPolygon( rPolyPoly );
				pOut->SetFillColor( aOldFillColor );
			}
			else
			{
				Rectangle       aPolyRect( rPolyPoly.GetBoundRect() );
				GDIMetaFile*    pMtf = pOut->GetConnectMetaFile();

				pOut->Push();
				pOut->SetRasterOp( ROP_OVERPAINT );

				if( pMtf && !bPrinter )
				{
					if( !pOut->GetPDFWriter() && XIMP_bDrawRasterOps )
					{
						pOut->SetRasterOp( ROP_XOR );
						ImpDrawBitmapFill( aPolyRect, bPrinter );

						pOut->Push( PUSH_FILLCOLOR );
						pOut->SetFillColor( COL_BLACK );
						pOut->SetRasterOp( ROP_0 );
						pOut->DrawPolyPolygon( rPolyPoly );
						pOut->Pop();

						pOut->SetRasterOp( ROP_XOR );
						ImpDrawBitmapFill( aPolyRect, bPrinter );
					}
					else
					{
						pOut->IntersectClipRegion( rPolyPoly );
						ImpDrawBitmapFill( aPolyRect, bPrinter );
					}
				}
				else if( bRect || bPrinter )
				{
					pOut->IntersectClipRegion( rPolyPoly );
					ImpDrawBitmapFill( aPolyRect, bPrinter );
				}
				else
				{
					VirtualDevice*  pMemDev;
					PolyPolygon		aPolyPoly( pOut->LogicToPixel( rPolyPoly ) );
                    Rectangle		aPolyRectPix( pOut->LogicToPixel( aPolyRect ) );
					Point			aPoint;
					Rectangle		aOutputRectPix( aPoint, pOut->GetOutputSizePixel() );
                    const BOOL      bOldMap = pOut->IsMapModeEnabled();

                    pOut->EnableMapMode( FALSE );

                    aOutputRectPix.Intersection( aPolyPoly.GetBoundRect() );
                    
					// add one pixel to avoid mapping differences
					aOutputRectPix.Right() += 2, aOutputRectPix.Bottom() += 2;
					const Size aVDevSizePix( aOutputRectPix.GetSize() );

					pOut->IntersectClipRegion( aPolyRectPix );

                    if( pOut->HasAlpha() )
                    {
                        // #110958# Pay attention to alpha VDevs here, otherwise, 
                        // background will be wrong: Temp VDev has to have alpha, too.
                        pMemDev = new VirtualDevice( *pOut, 0, pOut->GetAlphaBitCount() > 1 ? 0 : 1 );
                    }
                    else
                    {
                        // nothing special here. Plain VDev
                        pMemDev = new VirtualDevice();
                    }

					pMemDev->SetOutputSizePixel( aVDevSizePix );
					pMemDev->DrawOutDev( Point(), aVDevSizePix, aOutputRectPix.TopLeft(), aVDevSizePix, *pOut );
                    
                    pOut->EnableMapMode( bOldMap );
					ImpDrawBitmapFill( aPolyRect, bPrinter );
                    pOut->EnableMapMode( FALSE );
					
                    pMemDev->SetRasterOp( ROP_XOR );
					pMemDev->DrawOutDev( Point(), aVDevSizePix, aOutputRectPix.TopLeft(), aVDevSizePix, *pOut );

					pMemDev->Push( PUSH_FILLCOLOR );
					pMemDev->SetFillColor( COL_BLACK );
					pMemDev->SetRasterOp( ROP_0 );
					aPolyPoly.Move( -aOutputRectPix.Left(), -aOutputRectPix.Top() );
					pMemDev->DrawPolyPolygon( aPolyPoly );
					pMemDev->Pop();

					pOut->SetRasterOp( ROP_XOR );
					pOut->DrawOutDev( aOutputRectPix.TopLeft(), aVDevSizePix, Point(), aVDevSizePix, *pMemDev );

                    pOut->EnableMapMode( bOldMap );

                    delete pMemDev;
				}

				pOut->Pop();
			}
		}

		pOut->SetLineColor( aOldLineColor );
	}
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawBitmapFill( const Rectangle& rRect, BOOL bPrinter )
{
	// Ausgabe-Position und -Groesse bestimmen
	ImpCalcBmpFillStartValues( rRect, bPrinter );

	if( ( mbBmpTile || !mbBmpStretch ) && ( !maFillBitmapSize.Width() || !maFillBitmapSize.Height() ) )
		return;

	if( ( !pOut->GetConnectMetaFile() || bPrinter ) || pOut->GetPDFWriter() )
	{
		if ( mbBmpTile )
        {
            Point aOffset( rRect.TopLeft() - maStartPoint );

            // #105229# Delegating tile draw to graphic object
            mpFillGraphicObject->DrawTiled( pOut, rRect, maFillBitmapSize, 
                                            Size( aOffset.X(), aOffset.Y() ), NULL, GRFMGR_DRAW_CACHED, 128 );
        }
		else
		{
            // #104846# ImpCalcBmpFillStartValues now also calc non-tiled sizes correctly
            mpFillGraphicObject->Draw( pOut, maStartPoint, maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );
		}
	}
	// Mtf-Aufzeichnung
	else
	{
		pOut->Push();

		if( mbBmpTile )
		{
			VirtualDevice	aVDev;
			MapMode			aMap( pOut->GetMapMode().GetMapUnit() );

			aVDev.SetOutputSizePixel( pOut->LogicToPixel( rRect, aMap ).GetSize() );
			aMap.SetOrigin( Point( -rRect.Left(), -rRect.Top() ) );
			aVDev.SetMapMode( aMap );

            // #105229# Delegating tile draw to graphic object
            // #94014#
            Point aOffset( rRect.TopLeft() - maStartPoint );

            mpFillGraphicObject->DrawTiled( &aVDev, rRect, maFillBitmapSize, 
                                            Size( aOffset.X(), aOffset.Y() ), NULL, GRFMGR_DRAW_CACHED, 128 );
            GraphicObject aTmpGraphic( aVDev.GetBitmap( rRect.TopLeft(), aVDev.GetOutputSize() ) );
            aTmpGraphic.Draw( pOut, rRect.TopLeft(), rRect.GetSize(), NULL, GRFMGR_DRAW_CACHED );
		}
		else
		{
			if( !mbBmpStretch )
			{
				// in MetaFiles machen wir den Hintergrund weiss
				// das Poppen macht das Selektieren der Brush
				// wieder rueckgaengig
				PolyPolygon	aPolyPoly( 2 );
				aPolyPoly.Insert( Polygon( rRect ) );
				aPolyPoly.Insert( Polygon( Rectangle( maStartPoint, maFillBitmapSize ) ) );

				pOut->SetFillColor( Color( COL_WHITE ) );
				pOut->SetLineColor();
				pOut->DrawPolyPolygon( aPolyPoly );
            }

            // #104846# ImpCalcBmpFillStartValues now also calc non-tiled sizes correctly
            mpFillGraphicObject->Draw( pOut, maStartPoint, maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );
		}

		pOut->Pop();
	}
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpCalcBmpFillStartValues( const Rectangle& rRect, BOOL bPrinter )
{
    GDIMetaFile*    pMtf = pOut->GetConnectMetaFile();
	const MapMode	aDstMapMode( pOut->GetMapMode().GetMapUnit() );
    Size			aStartOffset;

    // #104609# Extracted to ImpCalcBmpFillSizes
    ImpCalcBmpFillSizes( aStartOffset, maBmpOutputSize, rRect, 
                         aDstMapMode, maFillBitmap, maBmpSize, 
                         Size( mnBmpPerCentX, mnBmpPerCentY ), 
                         Size( mnBmpOffPosX, mnBmpOffPosY ), 
                         mbBmpLogSize, mbBmpTile, mbBmpStretch, meBmpRectPoint );

    maStartPoint.X() = rRect.Left() + aStartOffset.Width();
    maStartPoint.Y() = rRect.Top() + aStartOffset.Height();

    if( mbRecalc )
    {
        mpFillGraphicObject->SetGraphic( maFillBitmap );

        const Size aBmpSizePix( maFillBitmap.GetSizePixel() );

        // create intermediate bitmap if neccessary
        // #105229# Condition changed: intermediate necessary only for
        // tiling plus phase offsets, mnBmpOff is only evaluated for tilings
        if( mbBmpTile && ( mnBmpOffX != 0 || 
                           mnBmpOffY != 0 ||
                           mnBmpOffPosX != 0 ||
                           mnBmpOffPosY != 0 ) && !maFillBitmap.IsEmpty() )
        {
            VirtualDevice   aVDev;
            const Point     aPt;
			const Size      aNewSize( 2 * aBmpSizePix.Width(), 2 * aBmpSizePix.Height() );
            const Rectangle aIntermediateRect( aPt, aNewSize );

            aVDev.SetOutputSizePixel( aNewSize );
            maBmpOutputSize.Width() *= 2;
            maBmpOutputSize.Height() *= 2;
            maFillBitmapSize = aBmpSizePix;
            ImpDrawTiledBitmap( &aVDev, aIntermediateRect, aPt, aIntermediateRect, FALSE );
            mpFillGraphicObject->SetGraphic( aVDev.GetBitmap( aPt, aNewSize ) );
        }

        maFillBitmapSize = maBmpOutputSize;
    }

	if( !pMtf )
    	mbRecalc = FALSE;
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawTiledBitmap( OutputDevice* pOutDev, const Rectangle& rRect,
										const Point& rStartPoint, const Rectangle& rClipRect,
                                        BOOL bPrinter )
{
    // #105229# Removed everything except plain painting; cached tile
    // draw is now done via GraphicObject. This method's solely
    // purpose is to render tiles with phase shifts (currently, 2x2 tiles)
    Point  		    aPixOrg;
    Point           aOrg;
    const Rectangle aPixRect( pOutDev->LogicToPixel( rRect ) ) ;
    const Rectangle aPixClipRect( pOutDev->LogicToPixel( rClipRect ) ) ;
    const Point     aPixPos( pOutDev->LogicToPixel( rStartPoint ) );
    const Size      aPixSize( pOutDev->LogicToPixel( maFillBitmapSize ) );
    const long		nOffX = aPixSize.Width() - aPixSize.Width() * mnBmpOffX / 100;
    const long		nOffY = aPixSize.Height() - aPixSize.Height() * mnBmpOffY / 100;
    // #106767# Prevent division by zero
    long			nCountX = ( aPixRect.Right() - aPixPos.X() ) / ::std::max( aPixSize.Width(), 1L ) + 1;
    long			nCountY = ( aPixRect.Bottom() - aPixPos.Y() ) / ::std::max( aPixSize.Height(), 1L ) + 1;
    BOOL			bDraw;

    // Falls Kacheln untereinander verschoben,
    // muessen wir noch eine zusaetzliche Zeile
    // oder Spalte ausgeben
    if( mnBmpOffX )
        nCountX++;
    else if( mnBmpOffY )
        nCountY++;

    long nCountX1 = nCountX - 1;
    long nCountY1 = nCountY - 1;

    aPixOrg = aPixPos;

    // Kachelung ausgeben
    for ( long nY = 0; nY < nCountY; nY++ )
    {
        for ( long nX = 0; nX < nCountX; nX++ )
        {
            bDraw = FALSE;

            if( mnBmpOffX && ( nY & 1 ) )
            {
                bDraw = TRUE;
                aOrg = Point( aPixOrg.X() - nOffX, aPixOrg.Y() );
            }
            else if( mnBmpOffY && ( nX & 1 ) )
            {
                bDraw = TRUE;
                aOrg = Point( aPixOrg.X(), aPixOrg.Y() - nOffY );
            }
            else
            {
                if( mnBmpOffX )
                {
                    // Nicht-Offset-Tiles ausser in der letzten Spalte immer zeichnen
                    if( nX < nCountX1 )
                        bDraw = TRUE;
                }
                else if( mnBmpOffY )
                {
                    // Nicht-Offset-Tiles ausser in der letzten Zeile immer zeichnen
                    if( nY < nCountY1 )
                        bDraw = TRUE;
                }
                else
                    bDraw = TRUE;

                aOrg = aPixOrg;
            }

            // ausgeben, wenn innerhalb des Objektes und innerhalb
            // des gueltigen Clipping-Bereiches
            if ( bDraw && !Rectangle( aOrg, aPixSize ).Intersection( aPixClipRect ).IsEmpty() )
                mpFillGraphicObject->Draw( pOutDev, pOutDev->PixelToLogic( aOrg ), maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );

            aPixOrg.X() += aPixSize.Width();
        }

        aPixOrg.X() = aPixPos.X();
        aPixOrg.Y() += aPixSize.Height();
    }
}
