/*************************************************************************
 *
 *  $RCSfile: excvfbff.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2004/08/12 12:46:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _EXCVFBFF_HXX
#define _EXCVFBFF_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class String;

class ValueFormBuffer;

#if defined(BLC) || defined(MAC)
// BLC will es auf jeden Fall hier
typedef void				( ValueFormBuffer::*Fkt_rString )( String & );
typedef ULONG				( ValueFormBuffer::*Fkt_USHORT )( USHORT );
#endif

class ValueFormBuffer
	{
	private:
#if !defined(BLC) && !defined(MAC)
// MSC will es auf jeden Fall hier
		typedef void		( ValueFormBuffer::*Fkt_rString )( String & );
		typedef ULONG		( ValueFormBuffer::*Fkt_USHORT )( USHORT );
#endif

		ULONG				*pHandles;		// Array mit Handles...
		USHORT				nMax;  			// Groesse des Arrays
		USHORT				nCount;			// Index des naechsten freien Eintrags
		ULONG				nDefaultHandle;

		// nur fuer Excel5
		static const USHORT nAnzBuiltin;	// bekannte Formate
		static const USHORT nNewFormats;	// selbstdefinierte
		static const sal_Char	*pBuiltinFormats[];	// vordefinierte Formate

		Fkt_rString			_NewValueFormat;
		Fkt_USHORT			_GetValueFormat;
		// ----------------------------------------------------------
		void				Init( void );
							// fuer 1. Nutzung
		void				__NewValueFormat( String &rFormString );
		ULONG				__GetValueFormat( USHORT nExcIndex );
							// fuer n-te Nutzung
		void				_NewValueFormatX( String &rFormString );
		void				_NewValueFormat5( String &rFormString );
		ULONG				_GetValueFormatX5( USHORT nExcIndex );
	public:
		ValueFormBuffer( const USHORT nSize = 2048 );
		~ValueFormBuffer();

		inline void			NewValueFormat( String &rFormString );
		inline ULONG		GetValueFormat( USHORT nExcIndex );
	};

inline void ValueFormBuffer::NewValueFormat( String &rFormString )
	{
	( this->*_NewValueFormat )( rFormString );
	}

inline ULONG ValueFormBuffer::GetValueFormat( USHORT nExcIndex )
	{
	return ( this->*_GetValueFormat )( nExcIndex );
	}

#endif
