/*************************************************************************
 *
 *  $RCSfile: mmaddressblockpage.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/01/07 09:45:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef SW_DLLIMPLEMENTATION
#undef SW_DLLIMPLEMENTATION
#endif

#pragma hdrstop
#ifndef _MAILMERGEADDRESSBLOCKPAGE_HXX
#include <mmaddressblockpage.hxx>
#endif
#ifndef _MAILMERGEWIZARD_HXX
#include <mailmergewizard.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _ADDRESSLISTDIALOG_HXX
#include <addresslistdialog.hxx>
#endif
#ifndef _XTEXTEDT_HXX
#include <svtools/xtextedt.hxx>
#endif
#ifndef _TXTATTR_HXX
#include <svtools/txtattr.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif
#ifndef _MMCONFIGITEM_HXX
#include <mmconfigitem.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XCOLUMNSSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XCOLUMN_HPP_
#include <com/sun/star/sdb/XColumn.hpp>
#endif

#include <vector>
#include <mmaddressblockpage.hrc>
#include <dbui.hrc>
#include <helpid.h>

using namespace svt;
using namespace ::com::sun::star;
using namespace ::com::sun::star::container;
using namespace com::sun::star::sdb;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::sdbcx;

//-------------------------------------------------------------------------
void lcl_Move(Control* pCtrl, long nYOffset)
{
    Point aPos(pCtrl->GetPosPixel());
    aPos.Y() += nYOffset;
    pCtrl->SetPosPixel(aPos);
}            
/*-- 02.04.2004 12:46:40---------------------------------------------------

  -----------------------------------------------------------------------*/
SwMailMergeAddressBlockPage::SwMailMergeAddressBlockPage( SwMailMergeWizard* _pParent) :
    svt::OWizardPage(_pParent, SW_RES(DLG_MM_ADDRESSBLOCK_PAGE)),
#pragma warning (disable : 4355)
    m_aHeaderFI(        this, ResId(  FI_HEADER           ) ),
    m_aAddressListFI(   this, ResId( FI_ADDRESSLIST ) ),
    m_aAddressListPB(   this, ResId( PB_ADDRESSLIST ) ),
    m_aCurrentAddressFI( this, ResId( FI_CURRENTADDRESS ) ),
    m_aSettingsFI(      this, ResId( FI_SETTINGS    ) ),
    m_aSettingsWIN(     this, ResId( WIN_SETTINGS   ) ),
    m_aSettingsPB(      this, ResId( PB_SETTINGS    ) ),
    m_aAddressCB(       this, ResId( CB_ADDRESS   ) ),
    m_aPreviewFI(       this, ResId( FI_PREVIEW     ) ),
    m_aPreviewWIN(      this, ResId( WIN_PREVIEW    ) ),
    m_aAssignPB(        this, ResId( PB_ASSIGN      ) ),
    m_aDocumentIndexFI( this, ResId( FI_DOCINDEX    ) ),
    m_aPrevSetIB(       this, ResId( IB_PREVSET     ) ),
    m_aNextSetIB(       this, ResId( IB_NEXTSET     ) ),
    m_sDocument(        ResId(       STR_DOCUMENT  ) ),
#pragma warning (default : 4355)
    m_sChangeAddress(   ResId(      STR_CHANGEADDRESS )),
    m_pWizard(_pParent)
{
    FreeResource();
    m_sCurrentAddress = m_aCurrentAddressFI.GetText();
    m_aAddressListPB.SetClickHdl(LINK(this, SwMailMergeAddressBlockPage, AddressListHdl_Impl));
    m_aSettingsPB.SetClickHdl(LINK(this, SwMailMergeAddressBlockPage, SettingsHdl_Impl));
    m_aAssignPB.SetClickHdl(LINK(this, SwMailMergeAddressBlockPage, AssignHdl_Impl ));
    m_aAddressCB.SetClickHdl(LINK(this, SwMailMergeAddressBlockPage, AddressBlockHdl_Impl));
    m_aSettingsWIN.SetSelectHdl(LINK(this, SwMailMergeAddressBlockPage, AddressBlockSelectHdl_Impl));
    Link aLink = LINK(this, SwMailMergeAddressBlockPage, InsertDataHdl_Impl);
    m_aPrevSetIB.SetClickHdl(aLink);
    m_aNextSetIB.SetClickHdl(aLink);
}
/*-- 02.04.2004 12:46:40---------------------------------------------------

  -----------------------------------------------------------------------*/
SwMailMergeAddressBlockPage::~SwMailMergeAddressBlockPage()
{
}
/*-- 05.07.2004 13:55:15---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Bool SwMailMergeAddressBlockPage::determineNextButtonState()
{
    return m_pWizard->GetConfigItem().GetResultSet().is();
}
/*-- 16.06.2004 12:34:09---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwMailMergeAddressBlockPage::ActivatePage()
{
    SwMailMergeConfigItem& rConfigItem = m_pWizard->GetConfigItem();
    bool bIsLetter = rConfigItem.IsOutputToLetter();
    
    //no address block is created for e-Mail
    m_aSettingsFI.Show( bIsLetter );
    m_aAddressCB.Show( bIsLetter );
    m_aSettingsWIN.Show( bIsLetter );
    m_aSettingsPB.Show( bIsLetter );
    m_aPreviewFI.Show( bIsLetter );
    m_aPreviewWIN.Show( bIsLetter );
    m_aAssignPB.Show( bIsLetter );
    m_aDocumentIndexFI.Show( bIsLetter );
    m_aPrevSetIB.Show( bIsLetter );
    m_aNextSetIB.Show( bIsLetter );
    
    if(bIsLetter)
    {
        String sTemp(m_sDocument);
        sTemp.SearchAndReplaceAscii("%1", String::CreateFromInt32(1));
        m_aDocumentIndexFI.SetText(sTemp);

        const uno::Sequence< ::rtl::OUString> aBlocks = 
                    m_pWizard->GetConfigItem().GetAddressBlocks();
        for(sal_Int32 nAddress = 0; nAddress < aBlocks.getLength(); ++nAddress)
            m_aSettingsWIN.AddAddress(aBlocks[nAddress]);
        m_aAddressCB.Check(rConfigItem.IsAddressBlock());
        AddressBlockHdl_Impl(&m_aAddressCB);
        m_aSettingsWIN.SetLayout(1, 2);
        InsertDataHdl_Impl(0);
    }
}
/*-- 27.05.2004 13:59:15---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Bool    SwMailMergeAddressBlockPage::commitPage(COMMIT_REASON _eReason)
{
    if(CR_TRAVEL_NEXT == _eReason && !m_pWizard->GetConfigItem().GetResultSet().is())
        return sal_False;            
    return sal_True;
}
/*-- 07.04.2004 16:19:30---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwMailMergeAddressBlockPage, AddressListHdl_Impl, PushButton*, pButton)
{
    SwAddressListDialog* pAddrDialog = new SwAddressListDialog(this);
    if(RET_OK == pAddrDialog->Execute())
    {
        SwMailMergeConfigItem& rConfigItem = m_pWizard->GetConfigItem();
        rConfigItem.SetCurrentConnection(
                        pAddrDialog->GetSource(), 
                        pAddrDialog->GetConnection(), 
                        pAddrDialog->GetColumnsSupplier(),
                        pAddrDialog->GetDBData());
        ::rtl::OUString sFilter = pAddrDialog->GetFilter();
        rConfigItem.SetFilter( sFilter );
        InsertDataHdl_Impl(0);
        GetWizard()->enableButtons(WZB_NEXT, rConfigItem.GetResultSet().is());
        GetWizard()->UpdateRoadmap();
    }            
    delete pAddrDialog;
    return 0;
}
/*-- 07.04.2004 16:19:30---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwMailMergeAddressBlockPage, SettingsHdl_Impl, PushButton*, pButton)
{
    SwSelectAddressBlockDialog* pDlg = 
                new SwSelectAddressBlockDialog(pButton, m_pWizard->GetConfigItem());
    SwMailMergeConfigItem& rConfig = m_pWizard->GetConfigItem();
    pDlg->SetAddressBlocks(rConfig.GetAddressBlocks(), m_aSettingsWIN.GetSelectedAddress());
    pDlg->SetSettings(rConfig.IsIncludeCountry(), rConfig.GetExcludeCountry());
    if(RET_OK == pDlg->Execute())
    {
        //the dialog provides the selected address at the first position!
        const uno::Sequence< ::rtl::OUString> aBlocks = 
                    pDlg->GetAddressBlocks();
        rConfig.SetAddressBlocks(aBlocks);
        m_aSettingsWIN.Clear();
        for(sal_Int32 nAddress = 0; nAddress < aBlocks.getLength(); ++nAddress)
            m_aSettingsWIN.AddAddress(aBlocks[nAddress]);
        m_aSettingsWIN.SelectAddress(0);
        rConfig.SetCountrySettings(pDlg->IsIncludeCountry(), pDlg->GetCountry());
        InsertDataHdl_Impl(0);
    }            
    delete pDlg;
    return 0;   
}
/*-- 07.04.2004 16:19:31---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwMailMergeAddressBlockPage, AssignHdl_Impl, PushButton*, pButton)
{
    SwMailMergeConfigItem& rConfigItem = m_pWizard->GetConfigItem();
    sal_uInt16 nSel = m_aSettingsWIN.GetSelectedAddress();
    const uno::Sequence< ::rtl::OUString> aBlocks = rConfigItem.GetAddressBlocks();
    SwAssignFieldsDialog* pDlg = 
            new SwAssignFieldsDialog(pButton, m_pWizard->GetConfigItem(), aBlocks[nSel], true);
    if(RET_OK == pDlg->Execute())
    {
        //preview update 
        InsertDataHdl_Impl(0);
    }            
    delete pDlg;
    return 0;
}
/*-- 11.06.2004 13:37:22---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwMailMergeAddressBlockPage::EnableAddressBlock(sal_Bool bAll, sal_Bool bSelective)
{        
    m_aSettingsFI.Enable(bAll);
    m_aAddressCB.Enable(bAll);
    bSelective &= bAll;
    m_aSettingsWIN.Enable(bSelective);
    m_aSettingsPB.Enable(bSelective);
    m_aPreviewFI.Enable(bSelective);
    m_aPreviewWIN.Enable(bSelective);
    m_aAssignPB.Enable(bSelective);
    m_aDocumentIndexFI.Enable(bSelective);
    m_aPrevSetIB.Enable(bSelective);
    m_aNextSetIB.Enable(bSelective);       
}
/*-- 28.04.2004 12:45:58---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwMailMergeAddressBlockPage, AddressBlockHdl_Impl, CheckBox*, pBox)
{        
    EnableAddressBlock(pBox->IsEnabled(), pBox->IsChecked());
    SwMailMergeConfigItem& rConfigItem = m_pWizard->GetConfigItem();
    rConfigItem.SetAddressBlock(m_aAddressCB.IsChecked());
    m_pWizard->UpdateRoadmap();
    return 0;
}
/*-- 08.06.2004 13:00:29---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwMailMergeAddressBlockPage, AddressBlockSelectHdl_Impl, SwAddressPreview*, EMPTYARG)
{
    sal_uInt16 nSel = m_aSettingsWIN.GetSelectedAddress();
    const uno::Sequence< ::rtl::OUString> aBlocks = 
                m_pWizard->GetConfigItem().GetAddressBlocks();
    String sPreview = SwAddressPreview::FillData(aBlocks[nSel], m_pWizard->GetConfigItem());
    m_aPreviewWIN.SetAddress(sPreview);
    return 0;
}
// ------------------------------------------------------------------------------
IMPL_LINK(SwMailMergeAddressBlockPage, InsertDataHdl_Impl, ImageButton*, pButton)
{
    //if no pButton is given, the first set has to be pre-set
    SwMailMergeConfigItem& rConfig = m_pWizard->GetConfigItem();
    m_pWizard->EnterWait();
    if(!pButton)
    {
        rConfig.GetResultSet();
    }
    else
    {
        BOOL bNext = pButton == &m_aNextSetIB;
        sal_Int32 nPos = rConfig.GetResultSetPosition();
        rConfig.MoveResultSet( bNext ? ++nPos : --nPos);
    }    
    m_pWizard->LeaveWait();
    sal_Int32 nPos = rConfig.GetResultSetPosition();
    BOOL bEnable = TRUE;
    if(nPos < 1)
    {
        bEnable = FALSE;
        nPos = 1;
    }
    else
    {
        //if output type is letter 
        if(m_aSettingsWIN.IsVisible())
        {
            //Fill data into preview
            sal_uInt16 nSel = m_aSettingsWIN.GetSelectedAddress();
            const uno::Sequence< ::rtl::OUString> aBlocks = 
                        m_pWizard->GetConfigItem().GetAddressBlocks();
            String sPreview = SwAddressPreview::FillData(aBlocks[nSel], rConfig);
            m_aPreviewWIN.SetAddress(sPreview);
        }
    }            
    m_aPrevSetIB.Enable(bEnable);
    //m_aNextSetIB.Enable(bEnable);
    //m_aDocumentIndexFI.Enable(bEnable);
    String sTemp(m_sDocument);
    sTemp.SearchAndReplaceAscii("%1", String::CreateFromInt32(nPos));
    m_aDocumentIndexFI.SetText(sTemp);
    
    sal_Bool bHasResultSet = rConfig.GetResultSet().is();
    GetWizard()->enableButtons(WZB_NEXT, bHasResultSet);
    m_aCurrentAddressFI.Show(bHasResultSet);
    if(bHasResultSet)
    {
        String sTmp = m_sCurrentAddress;
        sTmp.SearchAndReplaceAscii("%1", rConfig.GetCurrentDBData().sDataSource );
        m_aCurrentAddressFI.SetText(sTmp);
        m_aAddressListPB.SetText(m_sChangeAddress);
    }
    EnableAddressBlock(bHasResultSet, m_aAddressCB.IsChecked());
    return 0;
}
/*-- 13.04.2004 16:01:26---------------------------------------------------

  -----------------------------------------------------------------------*/
SwSelectAddressBlockDialog::SwSelectAddressBlockDialog(
                Window* pParent, SwMailMergeConfigItem& rConfig) :
    SfxModalDialog(pParent, SW_RES(DLG_MM_SELECTADDRESSBLOCK)),
#pragma warning (disable : 4355)
    m_aSelectFT( this, ResId(         FT_SELECT)),
    m_aPreview( this, ResId(          WIN_PREVIEW)),
    m_aNewPB( this, ResId(            PB_NEW)),
    m_aDeletePB( this, ResId(         PB_DELETE)),
    m_aCustomizePB( this, ResId(      PB_CUSTOMIZE)),
    m_aSettingsFI( this, ResId(       FI_SETTINGS)),
    m_aNeverRB( this, ResId(          RB_NEVER)),
    m_aAlwaysRB( this, ResId(         RB_ALWAYS)),
    m_aDependentRB( this, ResId(      RB_DEPENDENT)),
    m_aCountryED( this, ResId(        ED_COUNTRY)),
    m_aSeparatorFL( this, ResId(      FL_SEPARATOR)),
    m_aOK( this, ResId(               PB_OK)),
    m_aCancel( this, ResId(           PB_CANCEL)),
    m_aHelp( this, ResId(             PB_HELP)),
#pragma warning (default : 4355)
    m_rConfig(rConfig)
{
    FreeResource();
    
    Link aCustomizeHdl = LINK(this, SwSelectAddressBlockDialog, NewCustomizeHdl_Impl);
    m_aNewPB.SetClickHdl(aCustomizeHdl);
    m_aCustomizePB.SetClickHdl(aCustomizeHdl);
    
    m_aDeletePB.SetClickHdl(LINK(this, SwSelectAddressBlockDialog, DeleteHdl_Impl));
    
    Link aLk = LINK(this, SwSelectAddressBlockDialog, IncludeHdl_Impl);
    m_aNeverRB.SetClickHdl(aLk);
    m_aAlwaysRB.SetClickHdl(aLk);
    m_aDependentRB.SetClickHdl(aLk);
    m_aPreview.SetLayout(2, 2);
    m_aPreview.EnableScrollBar();
}
/*-- 13.04.2004 16:01:27---------------------------------------------------

  -----------------------------------------------------------------------*/
SwSelectAddressBlockDialog::~SwSelectAddressBlockDialog()
{
}
/*-- 28.04.2004 11:48:11---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwSelectAddressBlockDialog::SetAddressBlocks(const uno::Sequence< ::rtl::OUString>& rBlocks,
        sal_uInt16 nSelectedAddress)
{
    m_aAddressBlocks = rBlocks;
    for(sal_Int32 nAddress = 0; nAddress < m_aAddressBlocks.getLength(); ++nAddress)
        m_aPreview.AddAddress(m_aAddressBlocks[nAddress]);
    m_aPreview.SelectAddress(nSelectedAddress);
}
/*-- 25.06.2004 10:51:36---------------------------------------------------
    return the address blocks and put the selected one to the first position
  -----------------------------------------------------------------------*/
const uno::Sequence< ::rtl::OUString >&    SwSelectAddressBlockDialog::GetAddressBlocks() 
{
    //put the selected block to the first position
    sal_uInt16 nSelect = m_aPreview.GetSelectedAddress();
    if(nSelect)
    {
        uno::Sequence< ::rtl::OUString >aTemp = m_aAddressBlocks;
        ::rtl::OUString* pTemp = aTemp.getArray();
        pTemp[0] = m_aAddressBlocks[nSelect];
        sal_uInt32 nIndex = 1;
        for(sal_Int32 nAddress = 1; nAddress < m_aAddressBlocks.getLength(); ++nAddress)
        {
            if(nIndex == nSelect)
                ++nIndex;
            pTemp[nAddress] = m_aAddressBlocks[nIndex];
        }            
        m_aAddressBlocks = aTemp;
    }            
    return m_aAddressBlocks;
}
/*-- 28.04.2004 11:48:11---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwSelectAddressBlockDialog::SetSettings(
        sal_Bool bIsCountry, ::rtl::OUString rCountry)
{
    if(bIsCountry)
    {
        rCountry.getLength() ? m_aDependentRB.Check() : m_aAlwaysRB.Check();
        m_aCountryED.SetText(rCountry);
    }
    else
        m_aNeverRB.Check();
}
/*-- 10.05.2004 11:17:06---------------------------------------------------

  -----------------------------------------------------------------------*/
::rtl::OUString     SwSelectAddressBlockDialog::GetCountry() const 
{
    ::rtl::OUString sRet;    
    if(m_aDependentRB.IsChecked())
        sRet = m_aCountryED.GetText();
    return sRet;
}

/*-- 13.04.2004 16:02:32---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwSelectAddressBlockDialog, DeleteHdl_Impl, PushButton*, pButton)
{
    if(m_aAddressBlocks.getLength())
    {        
        sal_uInt16 nSelected = m_aPreview.GetSelectedAddress();
        ::rtl::OUString* pAddressBlocks = m_aAddressBlocks.getArray();
        sal_Int32 nSource = 0;
        for(sal_Int32 nTarget = 0; nTarget < m_aAddressBlocks.getLength() - 1; nTarget++)
        {        
            if(nSource == nSelected)
                ++nSource;
            pAddressBlocks[nTarget] = pAddressBlocks[nSource++];
        }
        m_aAddressBlocks.realloc(m_aAddressBlocks.getLength() - 1);
        if(m_aAddressBlocks.getLength() <= 1)
            pButton->Enable(sal_False);
        m_aPreview.RemoveSelectedAddress();
    }
    return 0;
}
/*-- 13.04.2004 16:02:32---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwSelectAddressBlockDialog, NewCustomizeHdl_Impl, PushButton*, pButton)
{
    SwCustomizeAddressBlockDialog* pDlg = 
            new SwCustomizeAddressBlockDialog(pButton, m_rConfig, 
                            SwCustomizeAddressBlockDialog::ADDRESSBLOCK);
    bool bCustomize = pButton == &m_aCustomizePB;
    if(bCustomize)
    {
        pDlg->SetAddress(m_aAddressBlocks[m_aPreview.GetSelectedAddress()]);
    }        
    if(RET_OK == pDlg->Execute())
    {
        if(bCustomize)
        {        
            ::rtl::OUString sNew = pDlg->GetAddress();
            m_aPreview.ReplaceSelectedAddress(sNew);
            m_aAddressBlocks[m_aPreview.GetSelectedAddress()] = sNew;
        }
        else
        {        
            ::rtl::OUString sNew = pDlg->GetAddress();
            m_aPreview.AddAddress(sNew);
            m_aAddressBlocks.realloc(m_aAddressBlocks.getLength() + 1);
            m_aAddressBlocks[m_aAddressBlocks.getLength() -1] = sNew;
        }
    }        
    delete pDlg;
    return 0;
}
/*-- 13.04.2004 16:02:33---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwSelectAddressBlockDialog, IncludeHdl_Impl, RadioButton*, pButton)
{
    m_aCountryED.Enable(&m_aDependentRB == pButton);
    return 0;
}

/*-- 13.04.2004 16:01:08---------------------------------------------------

  -----------------------------------------------------------------------*/
#define USER_DATA_SALUTATION        -1
#define USER_DATA_PUNCTUATION       -2
#define USER_DATA_TEXT              -3
#define USER_DATA_NONE              -4

SwCustomizeAddressBlockDialog::SwCustomizeAddressBlockDialog(
        Window* pParent, SwMailMergeConfigItem& rConfig, DialogType eType) :
    SfxModalDialog(pParent, SW_RES(DLG_MM_CUSTOMIZEADDRESSBLOCK)),
#pragma warning (disable : 4355)
    m_aAddressElementsFT( this, ResId(       FT_ADDRESSELEMENTS             )),
    m_aAddressElementsLB( this, ResId(       LB_ADDRESSELEMENTS             )),
    m_aInsertFieldIB( this, ResId(           IB_INSERTFIELD                 )),
    m_aRemoveFieldIB( this, ResId(           IB_REMOVEFIELD                 )),
    m_aDragFT( this, ResId(                  FT_DRAG                        )),
    m_aDragED( this, ResId(                  ED_DRAG                        )), 
    m_aUpIB( this, ResId(                    IB_UP                          )),
    m_aLeftIB( this, ResId(                  IB_LEFT                        )),
    m_aRightIB( this, ResId(                 IB_RIGHT                       )),
    m_aDownIB( this, ResId(                  IB_DOWN                        )),
    m_aFieldFT( this, ResId(                 FT_FIELD                       )),
    m_aFieldCB( this, ResId(                 CB_FIELD                       )), 
    m_aPreviewFI( this, ResId(               FI_PREVIEW                     )),
    m_aPreviewWIN( this, ResId(               WIN_PREVIEW                    )),
    m_aSeparatorFL( this, ResId(             FL_SEPARATOR                   )),
    m_aOK( this, ResId(                      PB_OK                          )),
    m_aCancel( this, ResId(                  PB_CANCEL                      )),
    m_aHelp( this, ResId(                    PB_HELP                        )),
#pragma warning (default : 4355)
    m_eType(eType),
    m_rConfigItem(rConfig)
{
    m_aDragED.SetStyle(m_aDragED.GetStyle() |WB_NOHIDESELECTION);
    if( eType != ADDRESSBLOCK  )
    {
        m_aFieldFT.Show();
        m_aFieldCB.Show();
        SvLBoxEntry* pEntry = m_aAddressElementsLB.InsertEntry(String(ResId(ST_SALUTATION )));
        pEntry->SetUserData((void*)(sal_Int32)USER_DATA_SALUTATION );
        pEntry = m_aAddressElementsLB.InsertEntry(String(ResId(ST_PUNCTUATION)));
        pEntry->SetUserData((void*)(sal_Int32)USER_DATA_PUNCTUATION );
        pEntry = m_aAddressElementsLB.InsertEntry(String(ResId(ST_TEXT       )));
        pEntry->SetUserData((void*)(sal_Int32)USER_DATA_TEXT       );
        ResStringArray aSalutArr(ResId(
                    eType == GREETING_MALE ? RA_SALUTATION_MALE : RA_SALUTATION_FEMALE));
        sal_uInt16 i;
        for(i = 0; i < aSalutArr.Count(); ++i)
            m_aSalutations.push_back(aSalutArr.GetString(i));
        ResStringArray aPunctArr(ResId(RA_PUNCTUATION));
        for(i = 0; i < aPunctArr.Count(); ++i)
            m_aPunctuations.push_back(aPunctArr.GetString(i));
        m_aDragED.SetText(String::CreateFromAscii("            "));
        SetText( String( ResId( eType == GREETING_MALE ? ST_TITLE_MALE : ST_TITLE_FEMALE)));
        m_aAddressElementsFT.SetText(String(ResId(ST_SALUTATIONELEMENTS)));
        m_aInsertFieldIB.SetQuickHelpText(String(ResId(ST_INSERTSALUTATIONFIELD)));
        m_aRemoveFieldIB.SetQuickHelpText(String(ResId(ST_REMOVESALUTATIONFIELD)));
        m_aDragFT.SetText(String(ResId(ST_DRAGSALUTATION)));
    }
    else
    {
        //resize the preview 
        Point aFieldPos(m_aFieldFT.GetPosPixel());
        long nDiff = m_aPreviewFI.GetPosPixel().Y() - aFieldPos.Y();
        m_aPreviewFI.SetPosPixel(aFieldPos);
        Size aPreviewSize = m_aPreviewWIN.GetSizePixel();
        aPreviewSize.Height() += nDiff;
        m_aPreviewWIN.SetSizePixel(aPreviewSize);
        m_aPreviewWIN.SetPosPixel(m_aFieldCB.GetPosPixel());
        m_aDragED.SetText(String::CreateFromAscii("\n\n\n\n\n"));
    }            
    FreeResource();
    const ResStringArray& rHeaders = m_rConfigItem.GetDefaultAddressHeaders();
    for(USHORT i = 0; i < rHeaders.Count(); ++i)
    {
        const XubString& rHeader = rHeaders.GetString( i );
        SvLBoxEntry* pEntry = m_aAddressElementsLB.InsertEntry(rHeader);
        pEntry->SetUserData((void*)(sal_Int32)i);
    }            
    m_aOK.SetClickHdl(LINK(this, SwCustomizeAddressBlockDialog, OKHdl_Impl));
    m_aAddressElementsLB.SetSelectHdl(LINK(this, SwCustomizeAddressBlockDialog, ListBoxSelectHdl_Impl ));
    m_aDragED.SetModifyHdl(LINK(this, SwCustomizeAddressBlockDialog, EditModifyHdl_Impl));
    m_aDragED.SetSelectionChangedHdl( LINK( this, SwCustomizeAddressBlockDialog, SelectionChangedHdl_Impl));
    Link aFieldsLink = LINK(this, SwCustomizeAddressBlockDialog, FieldChangeHdl_Impl);
    m_aFieldCB.SetModifyHdl(aFieldsLink);
    m_aFieldCB.SetSelectHdl(aFieldsLink);        
    Link aImgButtonHdl = LINK(this, SwCustomizeAddressBlockDialog, ImageButtonHdl_Impl);
    m_aInsertFieldIB.SetClickHdl(aImgButtonHdl);
    m_aRemoveFieldIB.SetClickHdl(aImgButtonHdl);
    m_aUpIB.SetClickHdl(aImgButtonHdl);
    m_aLeftIB.SetClickHdl(aImgButtonHdl);
    m_aRightIB.SetClickHdl(aImgButtonHdl);
    m_aDownIB.SetClickHdl(aImgButtonHdl);
    UpdateImageButtons_Impl();
}
/*-- 13.04.2004 16:01:08---------------------------------------------------

  -----------------------------------------------------------------------*/
SwCustomizeAddressBlockDialog::~SwCustomizeAddressBlockDialog()
{
}
/*-- 07.06.2004 13:51:11---------------------------------------------------
        
  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, OKHdl_Impl, OKButton*, EMPTYARG)
{
    EndDialog(RET_OK);
    return 0;
}
/*-- 24.06.2004 11:36:05---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, ListBoxSelectHdl_Impl, DDListBox*, pBox)
{
    sal_Int32 nUserData = (sal_Int32)pBox->FirstSelected()->GetUserData();
    // Check if the selected entry is already in the address and then forbid inserting
    m_aInsertFieldIB.Enable(nUserData >= 0 || !HasItem_Impl(nUserData));
    return 0;
}
/*-- 25.06.2004 11:21:24---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, EditModifyHdl_Impl, AddressMultiLineEdit*, EMPTYARG)
{
    m_aDragED.Modified();
    String sAddress = SwAddressPreview::FillData(
            m_aDragED.GetText(), 
            m_rConfigItem);
    m_aPreviewWIN.SetAddress(sAddress);
    UpdateImageButtons_Impl();
    return 0;
}
/*-- 25.06.2004 12:14:11---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, ImageButtonHdl_Impl, ImageButton*, pButton)
{
    if(&m_aInsertFieldIB == pButton)
    {
        SvLBoxEntry* pEntry = m_aAddressElementsLB.GetCurEntry();
        if(pEntry)
        {        
            String sEntry = m_aAddressElementsLB.GetEntryText(pEntry);
            sEntry.Insert('<', 0);
            sEntry += '>';
            m_aDragED.InsertNewEntry(sEntry);
        }            
    }            
    else if(&m_aRemoveFieldIB == pButton)
    {
        m_aDragED.RemoveCurrentEntry();
    }            
    else
    {        
        sal_uInt16 nMove = MOVE_ITEM_DOWN;
        if(&m_aUpIB == pButton)
            nMove = MOVE_ITEM_UP;
        else if(&m_aLeftIB == pButton)
            nMove = MOVE_ITEM_LEFT;
        else if(&m_aRightIB == pButton)
            nMove = MOVE_ITEM_RIGHT;
        m_aDragED.MoveCurrentItem(nMove);
    }
    UpdateImageButtons_Impl();
    return 0;
}
/*-- 01.07.2004 09:27:02---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Int32 SwCustomizeAddressBlockDialog::GetSelectedItem_Impl()
{
    sal_Int32 nRet = USER_DATA_NONE;
    String sSelected = m_aDragED.GetCurrentItem();
    if(sSelected.Len())
        for(ULONG i = 0; i < m_aAddressElementsLB.GetEntryCount();  ++i)
        {
            SvLBoxEntry* pEntry = m_aAddressElementsLB.GetEntry(i);
            String sEntry = m_aAddressElementsLB.GetEntryText(pEntry);
            if( sSelected.Equals( sEntry, 1, sSelected.Len() - 2 ) )
            {
                nRet = (sal_Int32)pEntry->GetUserData();
                break;
            }    
        }    
    return nRet;
}
/*-- 01.07.2004 10:01:19---------------------------------------------------

  -----------------------------------------------------------------------*/
bool   SwCustomizeAddressBlockDialog::HasItem_Impl(sal_Int32 nUserData)
{
    //get the entry from the ListBox
    String sEntry;
    for(ULONG i = 0; i < m_aAddressElementsLB.GetEntryCount();  ++i)
    {
        SvLBoxEntry* pEntry = m_aAddressElementsLB.GetEntry(i);
        if((sal_Int32)pEntry->GetUserData() == nUserData)
        {
            sEntry = m_aAddressElementsLB.GetEntryText(pEntry);
            break;
        }
    }    
    //put it into '<>'
    sEntry += '>';
    sEntry.Insert( '<', 0);
    //search for this entry in the content
    String sText = m_aDragED.GetText();
    bool bRet = bRet = sText.Search(sEntry) != STRING_NOTFOUND;
    return bRet;
}
/*-- 25.06.2004 13:10:16---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, SelectionChangedHdl_Impl, AddressMultiLineEdit*, pEdit)
{
    //determine selection - if it's one of the editable fields then 
    //enable the related ComboBox and fill it 
    sal_Int32 nSelected;
    if(m_aFieldCB.IsVisible() && 
            USER_DATA_NONE != (nSelected = GetSelectedItem_Impl()) && nSelected < 0)
    {        
        //search in ListBox if it's one of the first entries        
        sal_Bool bFound = sal_False;
        String sSelect;
        ::std::vector<String>* pVector = 0;
        switch(nSelected)
        {
            case USER_DATA_SALUTATION : 
                sSelect =  m_sCurrentSalutation;      
                pVector = &m_aSalutations; 
            break;
            case USER_DATA_PUNCTUATION : 
                sSelect =  m_sCurrentPunctuation;     
                pVector = &m_aPunctuations;
            break;
            case USER_DATA_TEXT : sSelect =  m_sCurrentText;  
            break;
        }
        m_aFieldCB.Clear();
        if(pVector)
        {
            ::std::vector<String>::iterator  aIterator;
            for( aIterator = pVector->begin(); aIterator != pVector->end(); ++aIterator)
                m_aFieldCB.InsertEntry(*aIterator);
            if(sSelect.Len())
                m_aFieldCB.SetText(sSelect);
        }            
        m_aFieldCB.Enable(sal_True);
        m_aFieldFT.Enable(sal_True);
    }    
    else
    {
        m_aFieldCB.Enable(sal_False);
        m_aFieldFT.Enable(sal_False);
    }            
    //make a selection 
    if(USER_DATA_NONE != nSelected)
    {
        pEdit->SelectCurrentItem();
    }            
    UpdateImageButtons_Impl();
    return 0;
}
/*-- 25.06.2004 13:36:29---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwCustomizeAddressBlockDialog, FieldChangeHdl_Impl, ComboBox*, EMPTYARG)
{
    //changing the field content changes the related members, too
    sal_Int32 nSelected = GetSelectedItem_Impl();
    String sContent = m_aFieldCB.GetText();
    switch(nSelected)
    {
        case USER_DATA_SALUTATION : 
            m_sCurrentSalutation = sContent; 
        break;
        case USER_DATA_PUNCTUATION : 
            m_sCurrentPunctuation = sContent;     
        break;
        case USER_DATA_TEXT : m_sCurrentText = sContent;  
        break;
    }
    UpdateImageButtons_Impl();
    return 0;
}

/*-- 25.06.2004 12:35:51---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwCustomizeAddressBlockDialog::UpdateImageButtons_Impl()
{
    sal_uInt16 nMove = m_aDragED.IsCurrentItemMoveable();
    m_aUpIB.Enable(nMove & MOVE_ITEM_UP );
    m_aLeftIB.Enable(nMove & MOVE_ITEM_LEFT );
    m_aRightIB.Enable(nMove & MOVE_ITEM_RIGHT );
    m_aDownIB.Enable(nMove & MOVE_ITEM_DOWN);
    m_aRemoveFieldIB.Enable(m_aDragED.HasCurrentItem() ? sal_True : sal_False);
    SvLBoxEntry* pEntry = m_aAddressElementsLB.GetCurEntry();
    m_aInsertFieldIB.Enable( pEntry && 
            (0 < (sal_Int32)pEntry->GetUserData() || m_aFieldCB.GetText().Len()));
}
/*-- 28.04.2004 12:04:14---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwCustomizeAddressBlockDialog::SetAddress(const ::rtl::OUString& rAddress)
{
    m_aDragED.SetText( rAddress );
    UpdateImageButtons_Impl();
}
/*-- 28.04.2004 12:04:14---------------------------------------------------

  -----------------------------------------------------------------------*/
::rtl::OUString SwCustomizeAddressBlockDialog::GetAddress()
{
    String sAddress(m_aDragED.GetAddress());
    //remove placeholders by the actual content
    if(m_aFieldFT.IsVisible())
    {
        for(ULONG i = 0; i < m_aAddressElementsLB.GetEntryCount();  ++i)
        {
            SvLBoxEntry* pEntry = m_aAddressElementsLB.GetEntry(i);
            String sEntry = m_aAddressElementsLB.GetEntryText(pEntry);
            sEntry += '>';
            sEntry.Insert('<', 0);
            sal_Int32 nUserData = (sal_Int32)pEntry->GetUserData();
            switch(nUserData)
            {        
                case USER_DATA_SALUTATION : sAddress.SearchAndReplace(sEntry, m_sCurrentSalutation); break;
                case USER_DATA_PUNCTUATION: sAddress.SearchAndReplace(sEntry, m_sCurrentPunctuation); break;
                case USER_DATA_TEXT       : sAddress.SearchAndReplace(sEntry, m_sCurrentText); break;
            }            
        }            
    }            
    return sAddress;
}
/*-- 13.04.2004 17:49:45---------------------------------------------------

  -----------------------------------------------------------------------*/
class SwAssignFieldsControl : public Control
{
    friend class SwAssignFieldsDialog;
    ScrollBar                   m_aVScroll;
    HeaderBar                   m_aHeaderHB;
    Window                      m_aWindow;

    ::std::vector<FixedInfo*>   m_aFieldNames;
    ::std::vector<ListBox*>     m_aMatches;
    ::std::vector<FixedInfo*>   m_aPreviews;
    
    SwMailMergeConfigItem&      m_rConfigItem;

    Link                        m_aModifyHdl;

    long                        m_nLBStartTopPos;
    long                        m_nYOffset;
    long                        m_nFirstYPos;
    
    DECL_LINK(ScrollHdl_Impl, ScrollBar*);
    DECL_LINK(MatchHdl_Impl, ListBox*);
    DECL_LINK(GotFocusHdl_Impl, ListBox*);

    virtual long        PreNotify( NotifyEvent& rNEvt );
    virtual void        Command( const CommandEvent& rCEvt );

    void                MakeVisible( sal_Int32 nIndex );
public:    
    SwAssignFieldsControl(Window* pParent, const ResId& rResId, 
                                SwMailMergeConfigItem& rConfigItem);
    ~SwAssignFieldsControl();

    void        SetModifyHdl(const Link& rModifyHdl) 
                {
                    m_aModifyHdl = rModifyHdl;
                    m_aModifyHdl.Call(this);
                }
};
/*-- 13.04.2004 17:51:27---------------------------------------------------

  -----------------------------------------------------------------------*/
//-------------------------------------------------------------------------
SwAssignFieldsControl::SwAssignFieldsControl(
        Window* pParent, const ResId& rResId, SwMailMergeConfigItem& rConfigItem) :
    Control(pParent, rResId),
#pragma warning (disable : 4355)
    m_aVScroll(this,  ResId(SCR_1     )),
    m_aHeaderHB(this, WB_BUTTONSTYLE | WB_BOTTOMBORDER), 
    m_aWindow(this, ResId(WIN_DATA)),
#pragma warning (default : 4355)
    m_rConfigItem(rConfigItem),
    m_nLBStartTopPos(0),
    m_nFirstYPos(0),
    m_nYOffset(0)
{
    long nHBHeight = m_aHeaderHB.CalcWindowSizePixel().Height();
    Size aOutputSize(GetOutputSize());
    m_aHeaderHB.SetSizePixel(
        Size(aOutputSize.Width(), nHBHeight));
    m_aHeaderHB.Show();
    m_aWindow.SetPosPixel(Point( 0, nHBHeight) );
    m_aWindow.SetSizePixel(Size(aOutputSize.Width() - m_aVScroll.GetSizePixel().Width(), aOutputSize.Height() - nHBHeight));
    m_aWindow.Show();
    
    //get the name of the default headers
    const ResStringArray& rHeaders = rConfigItem.GetDefaultAddressHeaders();
    //get the actual data
    uno::Reference< XColumnsSupplier > xColsSupp( rConfigItem.GetResultSet(), uno::UNO_QUERY);
    //get the name of the actual columns
    uno::Reference <XNameAccess> xColAccess = xColsSupp.is() ? xColsSupp->getColumns() : 0;
    uno::Sequence< ::rtl::OUString > aFields;
    if(xColAccess.is())
        aFields = xColAccess->getElementNames();
    const ::rtl::OUString* pFields = aFields.getConstArray();
    
    //get the current assignment list
    //each position in this sequence matches the position in the header array rHeaders
    //if no assignment is available an empty sequence will be returned
    uno::Sequence< ::rtl::OUString> aAssignments = rConfigItem.GetColumnAssignment( rConfigItem.GetCurrentDBData() );
    Link aMatchHdl = LINK(this, SwAssignFieldsControl, MatchHdl_Impl);
    Link aFocusHdl = LINK(this, SwAssignFieldsControl, GotFocusHdl_Impl);
    //fill the controls
    for(USHORT i = 0; i < rHeaders.Count(); ++i)
    {
        const XubString& rHeader = rHeaders.GetString( i );
        FixedInfo* pNewText = new FixedInfo(&m_aWindow, ResId( FT_FIELDS));
        String sLabel(String::CreateFromAscii("<>"));
        sLabel.Insert(rHeader, 1);
        pNewText->SetText(sLabel);
        ListBox* pNewLB = new ListBox(&m_aWindow, ResId(LB_FIELDS));
        pNewLB->SelectEntryPos(0);
        for(sal_Int32 nField = 0; nField < aFields.getLength(); ++nField)
            pNewLB->InsertEntry(pFields[nField]);
        
        FixedInfo* pNewPreview = new FixedInfo(&m_aWindow, ResId( FT_PREVIEW ));
        //select the ListBox
        //if there is an assignment
        if(aAssignments.getLength() > i && aAssignments[i].getLength())
            pNewLB->SelectEntry(aAssignments[i]);
        else //otherwise the current column name may match one of the db columns
            pNewLB->SelectEntry(rHeader);
        //then the preview can be filled accordingly
        if(xColAccess.is() && pNewLB->GetSelectEntryPos() > 0 &&
                xColAccess->hasByName(pNewLB->GetSelectEntry()))
        {        
            uno::Any aCol = xColAccess->getByName(pNewLB->GetSelectEntry());
            uno::Reference< XColumn > xColumn;
            aCol >>= xColumn;
            if(xColumn.is())
                pNewPreview->SetText(xColumn->getString());
        }
        if(!i)
        {
            //determine the vertical offset, use the bottom position of the ListBox    
            m_nFirstYPos = m_nYOffset = pNewLB->GetPosPixel().Y();
            m_nLBStartTopPos = m_nYOffset;
            m_nYOffset += pNewLB->GetSizePixel().Height();
        }            
        
        long nMove = m_nYOffset * i;
        lcl_Move(pNewText, nMove);
        lcl_Move(pNewLB, nMove);
        lcl_Move(pNewPreview, nMove);
        //set the select handler
        pNewLB->SetSelectHdl(aMatchHdl);
        pNewLB->SetGetFocusHdl(aFocusHdl);
        
        m_aFieldNames.push_back(pNewText);
        m_aMatches.push_back(pNewLB);
        m_aPreviews.push_back(pNewPreview);
    }
    ListBox* pBottomBox = m_aMatches[rHeaders.Count() -1];
    long nYBottom = pBottomBox->GetPosPixel().Y();
    nYBottom += pBottomBox->GetDropDownPosSizePixel().GetHeight();
    m_aVScroll.SetRange(Range(0, rHeaders.Count()));
    m_aVScroll.SetPageSize((aOutputSize.Height() - nHBHeight - m_nLBStartTopPos)/ m_nYOffset);
    m_aVScroll.EnableDrag();
    m_aVScroll.SetVisibleSize(m_aVScroll.GetPageSize());
    m_aVScroll.SetScrollHdl(LINK(this, SwAssignFieldsControl, ScrollHdl_Impl));
    
    FreeResource();
    m_aVScroll.SetPosPixel(Point(aOutputSize.Width() - m_aVScroll.GetSizePixel().Width(), nHBHeight));
    m_aVScroll.SetSizePixel(Size(m_aVScroll.GetSizePixel().Width(), aOutputSize.Height() - nHBHeight));

}
/*-- 13.04.2004 17:51:28---------------------------------------------------

  -----------------------------------------------------------------------*/
SwAssignFieldsControl::~SwAssignFieldsControl()
{
    ::std::vector<FixedInfo*>::iterator aFIIter;
    for(aFIIter = m_aFieldNames.begin(); aFIIter != m_aFieldNames.end(); ++aFIIter)
        delete *aFIIter;
    ::std::vector<ListBox*>::iterator aLBIter;
    for(aLBIter = m_aMatches.begin(); aLBIter != m_aMatches.end(); ++aLBIter)
        delete *aLBIter;
    for(aFIIter = m_aPreviews.begin(); aFIIter != m_aPreviews.end(); ++aFIIter)
        delete *aFIIter;
}

/*-- 07.05.2004 13:11:26---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwAssignFieldsControl::Command( const CommandEvent& rCEvt )
{
    switch ( rCEvt.GetCommand() )
    {
        case COMMAND_WHEEL:
        case COMMAND_STARTAUTOSCROLL:
        case COMMAND_AUTOSCROLL:
        {
            const CommandWheelData* pWheelData = rCEvt.GetWheelData();
            if(pWheelData && !pWheelData->IsHorz() && COMMAND_WHEEL_ZOOM != pWheelData->GetMode())
            {
                HandleScrollCommand( rCEvt, 0, &m_aVScroll );
            }
        }
        break;
        default:
            Control::Command(rCEvt);
    }
}
/*-- 07.05.2004 13:11:21---------------------------------------------------

  -----------------------------------------------------------------------*/
long SwAssignFieldsControl::PreNotify( NotifyEvent& rNEvt )
{
    if(rNEvt.GetType() == EVENT_COMMAND)
    {
        const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
        USHORT nCmd = pCEvt->GetCommand();
        if( COMMAND_WHEEL == nCmd )
        {
            Command(*pCEvt);
            return 1;
        }
    }
    return Control::PreNotify(rNEvt);
}
/*-- 03.09.2004 13:19:09---------------------------------------------------

  -----------------------------------------------------------------------*/
void SwAssignFieldsControl::MakeVisible( sal_Int32 nIndex )
{
    long nThumb = m_aVScroll.GetThumbPos();
    long nPage = m_aVScroll.GetPageSize();
    if(nThumb > nIndex) 
        m_aVScroll.SetThumbPos( nIndex );
    else if( (nThumb + nPage) < nIndex)
        m_aVScroll.SetThumbPos( nIndex - nPage );
    else 
        return;
    ScrollHdl_Impl( &m_aVScroll );
}
/*-- 30.04.2004 16:10:58---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwAssignFieldsControl, ScrollHdl_Impl, ScrollBar*, pScroll)
{
    long nThumb = pScroll->GetThumbPos();
    // the scrollbar moves on a per line basis 
    // the height of a line is stored in m_nYOffset
    // nThumb determines which line has to be set at the top (m_nYOffset)
    // The first line has to be -(nThumb * m_nYOffset) in the negative
    long nMove = m_nFirstYPos - (*m_aMatches.begin())->GetPosPixel().Y() - (nThumb * m_nYOffset);

    SetUpdateMode(FALSE);
    long nIndex;
    ::std::vector<FixedInfo*>::iterator aFIIter;
    for(nIndex = 0, aFIIter = m_aFieldNames.begin(); aFIIter != m_aFieldNames.end(); ++aFIIter, ++nIndex)
        lcl_Move(*aFIIter, nMove);
    ::std::vector<ListBox*>::iterator aLBIter;
    for(nIndex = 0, aLBIter = m_aMatches.begin(); aLBIter != m_aMatches.end(); ++aLBIter, ++nIndex)
        lcl_Move(*aLBIter, nMove);
    for(nIndex = 0, aFIIter = m_aPreviews.begin(); aFIIter != m_aPreviews.end(); ++aFIIter, ++nIndex)
        lcl_Move(*aFIIter, nMove);
    SetUpdateMode(TRUE);
    
    return 0;
}

/*-- 03.05.2004 15:37:52---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwAssignFieldsControl, MatchHdl_Impl, ListBox*, pBox)
{
    String sColumn = pBox->GetSelectEntry();
    uno::Reference< XColumnsSupplier > xColsSupp( m_rConfigItem.GetResultSet(), uno::UNO_QUERY);
    uno::Reference <XNameAccess> xColAccess = xColsSupp.is() ? xColsSupp->getColumns() : 0;
    ::rtl::OUString sPreview;
    if(xColAccess.is() && xColAccess->hasByName(sColumn))
    {
        uno::Any aCol = xColAccess->getByName(sColumn);
        uno::Reference< XColumn > xColumn;
        aCol >>= xColumn;
        if(xColumn.is())
        {        
            sPreview = xColumn->getString();
        }
    }
    ::std::vector<ListBox*>::iterator aLBIter;
    sal_Int32 nIndex = 0;
    for(aLBIter = m_aMatches.begin(); aLBIter != m_aMatches.end(); ++aLBIter, ++nIndex)
    {        
        if(*aLBIter == pBox)
        {        
            m_aPreviews[nIndex]->SetText(sPreview);
            break;
        }
    }
    m_aModifyHdl.Call(0);
    return 0;
}
/*-- 03.09.2004 13:16:04---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwAssignFieldsControl, GotFocusHdl_Impl, ListBox*, pBox)
{
    if(0 != (GETFOCUS_TAB & pBox->GetGetFocusFlags()))
    {        
        sal_Int32 nIndex = 0;
        ::std::vector<ListBox*>::iterator aLBIter;
        for(aLBIter = m_aMatches.begin(); aLBIter != m_aMatches.end(); ++aLBIter, ++nIndex)
        {        
            if(*aLBIter == pBox)
            {        
                MakeVisible(nIndex);
                break;
            }
        }
    }
    return 0;
}
/*-- 13.04.2004 17:44:01---------------------------------------------------

  -----------------------------------------------------------------------*/
SwAssignFieldsDialog::SwAssignFieldsDialog(
        Window* pParent, SwMailMergeConfigItem& rConfigItem,
        const ::rtl::OUString& rPreview, 
        bool bIsAddressBlock) :
    SfxModalDialog(pParent, SW_RES(DLG_MM_ASSIGNFIELDS)),
#pragma warning (disable : 4355)
    m_aMatchingFI( this, ResId(     FI_MATCHING)),
    m_pFieldsControl( new SwAssignFieldsControl(this, ResId(  CT_FIELDS  ), rConfigItem)),
    m_aPreviewFI( this, ResId(      FI_PREVIEW )),
    m_aPreviewWIN( this, ResId(     WIN_PREVIEW )),
    m_aSeparatorFL( this, ResId(    FL_SEPARATOR)),
    m_aOK( this, ResId(             PB_OK       )),
    m_aCancel( this, ResId(         PB_CANCEL   )),
    m_aHelp( this, ResId(           PB_HELP     )),
#pragma warning (default : 4355)
    m_sNone(ResId(ST_NONE)),
    m_rConfigItem(rConfigItem),
    m_rPreviewString(rPreview)
{
    //resize the HeaderBar
    String sAddressElement(  ResId(ST_ADDRESSELEMENT ));
    String sMatchesTo(       ResId(ST_MATCHESTO      ));
    String sPreview(         ResId(ST_PREVIEW        ));
    if(!bIsAddressBlock)
    {
        m_aPreviewFI.SetText(String(ResId(ST_SALUTATIONPREVIEW)));
        m_aMatchingFI.SetText(String(ResId(ST_SALUTATIONMATCHING)));
        sAddressElement = String(ResId(ST_SALUTATIONELEMENT));
    }        
    FreeResource();
    Size aOutputSize(m_pFieldsControl->m_aHeaderHB.GetSizePixel());
    sal_Int32 nFirstWidth;
    sal_Int32 nSecondWidth = nFirstWidth = aOutputSize.Width() / 3;
    const WinBits nHeadBits = HIB_VCENTER | HIB_FIXED| HIB_FIXEDPOS;
    m_pFieldsControl->m_aHeaderHB.InsertItem( 1, sAddressElement, nFirstWidth, nHeadBits|HIB_LEFT);
    m_pFieldsControl->m_aHeaderHB.InsertItem( 2, sMatchesTo,      nSecondWidth, nHeadBits|HIB_LEFT);
    m_pFieldsControl->m_aHeaderHB.InsertItem( 3, sPreview,
            aOutputSize.Width() - nFirstWidth - nSecondWidth, nHeadBits|HIB_LEFT);
    
    m_pFieldsControl->SetModifyHdl(LINK(this, SwAssignFieldsDialog, AssignmentModifyHdl_Impl ));
    
    String sMatching = m_aMatchingFI.GetText();
    sMatching.SearchAndReplaceAscii("%1", sMatchesTo);
    m_aMatchingFI.SetText(sMatching);

    m_aOK.SetClickHdl(LINK(this, SwAssignFieldsDialog, OkHdl_Impl));
}
/*-- 13.04.2004 17:44:02---------------------------------------------------

  -----------------------------------------------------------------------*/
SwAssignFieldsDialog::~SwAssignFieldsDialog()
{
    delete m_pFieldsControl;
}
/*-- 05.05.2004 14:39:13---------------------------------------------------

  -----------------------------------------------------------------------*/
uno::Sequence< ::rtl::OUString > SwAssignFieldsDialog::CreateAssignments()
{
    uno::Sequence< ::rtl::OUString > aAssignments(
            m_rConfigItem.GetDefaultAddressHeaders().Count());
    ::rtl::OUString* pAssignments = aAssignments.getArray();
    ::std::vector<ListBox*>::iterator aLBIter;
    sal_Int32 nIndex = 0;
    for(aLBIter = m_pFieldsControl->m_aMatches.begin(); 
                aLBIter != m_pFieldsControl->m_aMatches.end(); 
                    ++aLBIter, ++nIndex)
    {                    
        String sSelect = (*aLBIter)->GetSelectEntry();
        if(m_sNone != sSelect)
            pAssignments[nIndex] = sSelect;
    }
    return aAssignments;
}
/*-- 03.05.2004 18:04:00---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwAssignFieldsDialog, OkHdl_Impl, PushButton*, EMPTYARG)
{
    m_rConfigItem.SetColumnAssignment( 
                            m_rConfigItem.GetCurrentDBData(), 
                            CreateAssignments() );
    EndDialog(RET_OK);
    return 0;
}
/*-- 05.05.2004 14:37:19---------------------------------------------------

  -----------------------------------------------------------------------*/
IMPL_LINK(SwAssignFieldsDialog, AssignmentModifyHdl_Impl, void*, EMPTYARG)
{
    uno::Sequence< ::rtl::OUString > aAssignments = CreateAssignments();
    String sPreview = SwAddressPreview::FillData(
            m_rPreviewString, m_rConfigItem, &aAssignments);
    m_aPreviewWIN.SetAddress(sPreview);
    return 0;
}

/*-- 26.05.2004 11:20:11---------------------------------------------------

  -----------------------------------------------------------------------*/
DDListBox::DDListBox(SwCustomizeAddressBlockDialog* pParent, const ResId rResId) : 
        SvTreeListBox(pParent, rResId),
        m_pParentDialog(pParent)
{
    SetWindowBits( /*WB_HASBUTTONS|WB_HASBUTTONSATROOT|*/
                            WB_CLIPCHILDREN );
//    SetSpaceBetweenEntries(3);
    SetSelectionMode( SINGLE_SELECTION );
    SetDragDropMode(   SV_DRAGDROP_CTRL_COPY );
    EnableAsyncDrag(TRUE);
    SetHelpId(HID_MM_CUSTOMFIELDS);
    // expand selection to the complete width of the ListBox
    SetHighlightRange();
    Show();
    
}
/*-- 26.05.2004 11:20:15---------------------------------------------------

  -----------------------------------------------------------------------*/
DDListBox::~DDListBox()
{
}
/*-- 26.05.2004 11:20:16---------------------------------------------------

  -----------------------------------------------------------------------*/
void  DDListBox::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
{
    SvLBoxEntry* pEntry = GetCurEntry();
    if(pEntry)
    {     
        ReleaseMouse();
        
        TransferDataContainer* pContainer = new TransferDataContainer;
        uno::Reference<
             datatransfer::XTransferable > xRef( pContainer );
        
        sal_Int32 nUserData = (sal_Int32)pEntry->GetUserData();
        //special entries can only be once in the address / greeting
        if(nUserData >= 0 || !m_pParentDialog->HasItem_Impl(nUserData))
        {        
            String sEntry;
            sEntry = GetEntryText(pEntry);
            sEntry.Insert('<', 0);
            sEntry += '>';
            if(sEntry.Len())
            {        
                pContainer->CopyString( sEntry );
                pContainer->StartDrag( this, DND_ACTION_COPY, GetDragFinishedHdl() );
            }
        }    
    }
}
/*-- 26.05.2004 13:14:53---------------------------------------------------

  -----------------------------------------------------------------------*/
AddressMultiLineEdit::AddressMultiLineEdit(Window* pParent, const ResId& rResId) :
    MultiLineEdit(pParent, rResId)
{
    GetTextView()->SupportProtectAttribute(sal_True);
    StartListening(*GetTextEngine());
    DisableSelectionOnFocus();
}
/*-- 26.05.2004 13:14:53---------------------------------------------------

  -----------------------------------------------------------------------*/
AddressMultiLineEdit::~AddressMultiLineEdit()
{
    EndListening(*GetTextEngine());
}
/*-- 25.06.2004 13:02:49---------------------------------------------------

  -----------------------------------------------------------------------*/
void    AddressMultiLineEdit::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{        
    if(rHint.ISA(TextHint) && 
            static_cast<const TextHint&>(rHint).GetId() == TEXT_HINT_VIEWSELECTIONCHANGED &&
            m_aSelectionLink.IsSet())
    {
        m_aSelectionLink.Call(this);
    }            
}        
/*-- 26.05.2004 13:45:46---------------------------------------------------

  -----------------------------------------------------------------------*/
long  AddressMultiLineEdit::PreNotify( NotifyEvent& rNEvt )
{
    long nHandled = 0;
    if( EVENT_KEYINPUT == rNEvt.GetType() &&
         rNEvt.GetKeyEvent()->GetCharCode() )
    {
         nHandled = 1;
    }
    if(!nHandled)
        nHandled = MultiLineEdit::PreNotify( rNEvt );
    return nHandled;
    
}
/*-- 25.06.2004 08:20:54---------------------------------------------------

  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::SetText( const String& rStr )
{
    MultiLineEdit::SetText(rStr);
    //set attributes to all address tokens

    ExtTextEngine* pTextEngine = GetTextEngine();
    TextAttribProtect aProtectAttr;
    ULONG  nParaCount = pTextEngine->GetParagraphCount();
    for(ULONG nPara = 0; nPara < nParaCount; ++nPara)
    {        
        xub_StrLen nIndex = 0;
        String sPara = pTextEngine->GetText( nPara );
        if(sPara.Len() && sPara.GetChar(sPara.Len() - 1) != ' ')
        {
            TextPaM aPaM(nPara, sPara.Len());
            pTextEngine->ReplaceText(TextSelection( aPaM ), String(' '));
        }
        while(true)
        {
            USHORT nStart = sPara.Search( '<', nIndex );
            USHORT nEnd = sPara.Search( '>', nStart );
            nIndex = nEnd;
            if(nStart != STRING_NOTFOUND && nEnd != STRING_NOTFOUND)
                pTextEngine->SetAttrib( aProtectAttr, nPara, nStart, nEnd + 1, FALSE );
            else
                break;
        }
            
    }
}
/*-- 25.06.2004 09:10:43---------------------------------------------------

  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::Modified()
{
    //restore the attributes
    SetText( GetAddress() );
}

/*-- 25.06.2004 12:32:41---------------------------------------------------
    Insert the new entry in front of the entry at the beginning of the selection 
    
  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::InsertNewEntry( const String& rStr )
{
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    ULONG nPara = rSelection.GetStart().GetPara();
    USHORT nIndex = rSelection.GetStart().GetIndex();
    InsertNewEntryAtPosition( rStr, nPara, nIndex );
}

void AddressMultiLineEdit::InsertNewEntryAtPosition( const String& rStr, ULONG nPara, USHORT nIndex )
{
    ExtTextEngine* pTextEngine = GetTextEngine();
    TextPaM aInsertPos( nPara, nIndex );
    
    pTextEngine->ReplaceText( aInsertPos, rStr );

    //restore the attributes
    SetText( GetAddress() );
    //select the newly inserted/moved element
    TextSelection aEntrySel(aInsertPos);
    ExtTextView* pTextView = GetTextView();
    pTextView->SetSelection(aEntrySel);
    m_aSelectionLink.Call(this);
}
/*-- 25.06.2004 12:32:41---------------------------------------------------

  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::RemoveCurrentEntry()
{
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
    const TextCharAttrib* pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetEnd(), TEXTATTR_PROTECTED );
    if(pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()))
    {
        ULONG nPara = rSelection.GetStart().GetPara();
        TextSelection aEntrySel(TextPaM( nPara, pBeginAttrib->GetStart()), TextPaM(nPara, pBeginAttrib->GetEnd()));
        pTextEngine->ReplaceText(aEntrySel, String());
        //restore the attributes
        SetText( GetAddress() );
    }    
}
/*-- 25.06.2004 12:32:41---------------------------------------------------

  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::MoveCurrentItem(sal_uInt16 nMove)
{
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
    const TextCharAttrib* pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetEnd(), TEXTATTR_PROTECTED );
    if(pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()))
    {
        //current item has been found
        ULONG nPara = rSelection.GetStart().GetPara();
        USHORT nIndex = pBeginAttrib->GetStart();
        TextSelection aEntrySel(TextPaM( nPara, pBeginAttrib->GetStart()), TextPaM(nPara, pBeginAttrib->GetEnd()));
        String sCurrentItem = pTextEngine->GetText(aEntrySel);
        pTextEngine->RemoveAttrib( nPara, *pBeginAttrib );
        pTextEngine->ReplaceText(aEntrySel, String());
        switch(nMove)
        {
            case MOVE_ITEM_LEFT : 
                if(nIndex)
                {
                    //go left to find a predecessor or simple text
                    --nIndex;
                    String sPara = pTextEngine->GetText( nPara );
                    xub_StrLen nSearchIndex = sPara.SearchBackward( '>', nIndex+1 );
                    if( nSearchIndex != STRING_NOTFOUND && nSearchIndex == nIndex )
                    {
                        nSearchIndex = sPara.SearchBackward( '<', nIndex );
                        if( nSearchIndex != STRING_NOTFOUND )
                            nIndex = nSearchIndex;
                    }
                }            
            break;
            case MOVE_ITEM_RIGHT: 
            {    
                //go right to find a successor or simple text
                ++nIndex;
                pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
                if(pEndAttrib && pEndAttrib->GetEnd() >= nIndex)
                {
                    nIndex = pEndAttrib->GetEnd();
                }
            }
            break;
            case MOVE_ITEM_UP   : 
                --nPara;
                nIndex = 0;
            break;
            case MOVE_ITEM_DOWN : 
                ++nPara;
                nIndex = 0;
            break;
		}
        //add a new paragraph if there is none yet
        if(nPara >= pTextEngine->GetParagraphCount())
        {

            TextPaM aTemp(nPara - 1, pTextEngine->GetTextLen( nPara - 1 ));
            pTextEngine->ReplaceText( aTemp, String('\n'));
        }
        InsertNewEntryAtPosition( sCurrentItem, nPara, nIndex );
    }    
}
/*-- 25.06.2004 12:32:41---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_uInt16  AddressMultiLineEdit::IsCurrentItemMoveable()
{
    sal_uInt16 nRet = 0;
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
//    const TextCharAttrib* pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetEnd(), TEXTATTR_PROTECTED );
    if(pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()))
    {
        if(pBeginAttrib->GetStart())
            nRet |= MOVE_ITEM_LEFT;
        //if there is an entry it can always be move to the right and down
        nRet |= MOVE_ITEM_RIGHT|MOVE_ITEM_DOWN;
        if(rSelection.GetStart().GetPara() > 0)
            nRet |= MOVE_ITEM_UP;
    }
    return nRet;            
}
/*-- 25.06.2004 12:32:42---------------------------------------------------

  -----------------------------------------------------------------------*/
bool AddressMultiLineEdit::HasCurrentItem()
{
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
    return (pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()));
}
/*-- 01.07.2004 09:07:44---------------------------------------------------

  -----------------------------------------------------------------------*/
String AddressMultiLineEdit::GetCurrentItem()
{
    String sRet;
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
    const TextCharAttrib* pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetEnd(), TEXTATTR_PROTECTED );
    if(pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()))
    {
        ULONG nPara = rSelection.GetStart().GetPara();
        TextSelection aEntrySel(TextPaM( nPara, pBeginAttrib->GetStart()), TextPaM(nPara, pBeginAttrib->GetEnd()));
        sRet = pTextEngine->GetText( aEntrySel );
    }
    return sRet;            
}
/*-- 05.07.2004 14:29:02---------------------------------------------------

  -----------------------------------------------------------------------*/
void AddressMultiLineEdit::SelectCurrentItem()
{
    ExtTextEngine* pTextEngine = GetTextEngine();
    ExtTextView* pTextView = GetTextView();
    const TextSelection& rSelection = pTextView->GetSelection();
    const TextCharAttrib* pBeginAttrib = pTextEngine->FindCharAttrib( rSelection.GetStart(), TEXTATTR_PROTECTED );
    const TextCharAttrib* pEndAttrib = pTextEngine->FindCharAttrib( rSelection.GetEnd(), TEXTATTR_PROTECTED );
    if(pBeginAttrib && 
            (pBeginAttrib->GetStart() <= rSelection.GetStart().GetIndex() 
                            && pBeginAttrib->GetEnd() >= rSelection.GetEnd().GetIndex()))
    {
        ULONG nPara = rSelection.GetStart().GetPara();
        TextSelection aEntrySel(TextPaM( nPara, pBeginAttrib->GetStart()), TextPaM(nPara, pBeginAttrib->GetEnd()));
        pTextView->SetSelection(aEntrySel);
        Invalidate();
    }
}
/*-- 25.06.2004 09:10:43---------------------------------------------------
    returns the address
    remove trailing spaces
    and trailing empty paragraphs
  -----------------------------------------------------------------------*/
String AddressMultiLineEdit::GetAddress()
{
    String sRet;
    ExtTextEngine* pTextEngine = GetTextEngine();
    ULONG  nParaCount = pTextEngine->GetParagraphCount();
    for(ULONG nPara = nParaCount; nPara; --nPara)
    {        
        String sPara = pTextEngine->GetText( nPara - 1);
        sPara.EraseTrailingChars(' ');
        //don't add empty trailing paragraphs
        if(sRet.Len() || sPara.Len())
        {        
            sRet.Insert(sPara, 0);
            //insert the para break
            if(nPara > 1)
                sRet.Insert( '\n', 0);
        }
    }
    return sRet;
}

