/*************************************************************************
 *
 *  $RCSfile: swuilabimp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/05/10 16:25:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SWUILABIMP_HXX
#define _SWUILABIMP_HXX
#include "labimp.hxx"

class SwLabPage : public SfxTabPage
{
	SwNewDBMgr*   pNewDBMgr;
	String        sActDBName;
	SwLabItem	  aItem;

	FixedText	  aWritingText;
	CheckBox	  aAddrBox;
	MultiLineEdit aWritingEdit;
	FixedText	  aDatabaseFT;
	ListBox 	  aDatabaseLB;
	FixedText	  aTableFT;
	ListBox 	  aTableLB;
	ImageButton   aInsertBT;
	FixedText	  aDBFieldFT;
	ListBox 	  aDBFieldLB;
//	PushButton	  aDatabaseButton;
    FixedLine     aWritingFL;

	RadioButton   aContButton;
	RadioButton   aSheetButton;
	FixedText	  aMakeText;
	ListBox 	  aMakeBox;
	FixedText	  aTypeText;
	ListBox 	  aTypeBox;
    ListBox       aHiddenSortTypeBox;
    FixedInfo     aFormatInfo;
    FixedLine     aFormatFL;

	sal_Bool		m_bLabel;

	 SwLabPage(Window* pParent, const SfxItemSet& rSet);
	~SwLabPage();

	DECL_LINK( AddrHdl, Button * );
	DECL_LINK( DatabaseHdl, ListBox *pListBox );
//    DECL_LINK( DatabaseButtonHdl, Button * );
	DECL_LINK( FieldHdl, Button * );
	DECL_LINK( PageHdl, Button * );
	DECL_LINK( MakeHdl, ListBox * );
	DECL_LINK( TypeHdl, ListBox * );

	void DisplayFormat	();
	SwLabRec* GetSelectedEntryPos();

public:
	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rSet);

	virtual void ActivatePage(const SfxItemSet& rSet);
	virtual int  DeactivatePage(SfxItemSet* pSet = 0);
			void FillItem(SwLabItem& rItem);
	virtual sal_Bool FillItemSet(SfxItemSet& rSet);
	virtual void Reset(const SfxItemSet& rSet);

	SwLabDlg* GetParent() {return (SwLabDlg*) SfxTabPage::GetParent()->GetParent();}

	void 	SetToBusinessCard();

	void InitDatabaseBox();
	inline void SetNewDBMgr(SwNewDBMgr* pDBMgr) { pNewDBMgr = pDBMgr; }
	inline SwNewDBMgr* GetNewDBMgr() const { return pNewDBMgr; }
};

/* -----------------08.07.99 13:48-------------------

 --------------------------------------------------*/
class SwOneExampleFrame;
class SwVisitingCardPage : public SfxTabPage
{
	SvTreeListBox 	aAutoTextLB;
	FixedText 		aAutoTextGroupFT;
	ListBox			aAutoTextGroupLB;

    FixedLine       aContentFL;

	Window 			aExampleWIN;

	String			sVisCardGroup;
	String			sTempURL;

	SwLabItem	  	aLabItem;

	SwOneExampleFrame*	pExampleFrame;
	::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >  	_xAutoText;


	DECL_LINK( AutoTextSelectHdl, void* );
	DECL_LINK( FrameControlInitializedHdl, void* );

	void			InitFrameControl();
	void			UpdateFields();

	void			ClearUserData();
	void			SetUserData( sal_uInt32 nCnt,
									const rtl::OUString* pNames,
									const rtl::OUString* pValues );

	SwVisitingCardPage(Window* pParent, const SfxItemSet& rSet);
	~SwVisitingCardPage();

public:
	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rSet);

	virtual void ActivatePage(const SfxItemSet& rSet);
	virtual int  DeactivatePage(SfxItemSet* pSet = 0);
	virtual sal_Bool FillItemSet(SfxItemSet& rSet);
	virtual void Reset(const SfxItemSet& rSet);
};
/* -----------------29.09.99 08:51-------------------

 --------------------------------------------------*/
class SwPrivateDataPage : public SfxTabPage
{
    FixedLine       aDataFL;

	FixedText		aNameFT;
	Edit			aFirstNameED;
	Edit			aNameED;
	Edit			aShortCutED;

	FixedText		aName2FT;
	Edit			aFirstName2ED;
	Edit			aName2ED;
	Edit			aShortCut2ED;

	FixedText		aStreetFT;
	Edit			aStreetED;
	FixedText		aZipCityFT;
	Edit			aZipED;
	Edit			aCityED;
	FixedText		aCountryStateFT;
	Edit			aCountryED;
	Edit			aStateED;
	FixedText		aTitleProfessionFT;
	Edit			aTitleED;
	Edit			aProfessionED;
	FixedText		aPhoneFT;
	Edit			aPhoneED;
	Edit 			aMobilePhoneED;
	FixedText		aFaxFT;
	Edit			aFaxED;
	FixedText		aWWWMailFT;
	Edit			aHomePageED;
	Edit			aMailED;

	SwPrivateDataPage(Window* pParent, const SfxItemSet& rSet);
	~SwPrivateDataPage();

public:
	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rSet);

	virtual void ActivatePage(const SfxItemSet& rSet);
	virtual int  DeactivatePage(SfxItemSet* pSet = 0);
	virtual sal_Bool FillItemSet(SfxItemSet& rSet);
	virtual void Reset(const SfxItemSet& rSet);
};
/* -----------------29.09.99 08:51-------------------

 --------------------------------------------------*/
class SwBusinessDataPage : public SfxTabPage
{
    FixedLine       aDataFL;
	FixedText		aCompanyFT;
	Edit			aCompanyED;
	FixedText		aCompanyExtFT;
	Edit			aCompanyExtED;
	FixedText		aSloganFT;
	Edit			aSloganED;

	FixedText		aStreetFT;
	Edit			aStreetED;
	FixedText		aZipCityFT;
	Edit			aZipED;
	Edit			aCityED;
	FixedText		aCountryStateFT;
	Edit			aCountryED;
	Edit			aStateED;

	FixedText		aPositionFT;
	Edit			aPositionED;

	FixedText		aPhoneFT;
	Edit			aPhoneED;
	Edit 			aMobilePhoneED;
	FixedText		aFaxFT;
	Edit			aFaxED;

	FixedText		aWWWMailFT;
	Edit			aHomePageED;
	Edit			aMailED;

	SwBusinessDataPage(Window* pParent, const SfxItemSet& rSet);
	~SwBusinessDataPage();

public:
	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rSet);

	virtual void ActivatePage(const SfxItemSet& rSet);
	virtual int  DeactivatePage(SfxItemSet* pSet = 0);
	virtual sal_Bool FillItemSet(SfxItemSet& rSet);
	virtual void Reset(const SfxItemSet& rSet);
};

#endif