#!/bin/sh

# global variables to be replaced by the makefile
modulelist="%LAUNCHERLIST"
destfilename="%UNIXFILENAME"
pkgname="%PACKAGENAME"

source_root=`dirname $0`

appconfig="${PKG_INSTALL_ROOT}/etc/dt/appconfig"

# 
# parameter list:
# $1 : the preferred source directory for the fp/dt files
# $2 : the extension to handle
#
cat_entries () {
  file_list=
  for j in $modulelist ; do
    if [ -f $1/$j.$2 ]; then
      file_list="${file_list:+${file_list} }$1/$j.$2"
    elif [ -f $source_root/types/C/$j.$2 ]; then
      file_list="${file_list:+${file_list} }$source_root/types/C/$j.$2"
    fi
  done
  
  cat $file_list
}

get_locale_dir () {
  locale_dir=`echo $1 | sed 's/\..*//'`
  if [ ! -d $source_root/types/$locale_dir ]; then
    locale_dir=`echo $1 | sed 's/_.*//'`
    if [ ! -d $source_root/types/$locale_dir ]; then
      return
    fi
  fi
  echo $locale_dir
}

get_icon_names () {
  for i in $modulelist; do
    sed -n -e "/ICON/ { 
      s# *ICON *#$appconfig/icons/$2/#
      p
    }" $source_root/types/$1/$i.fp $source_root/types/$1/$i.dt
  done | sort -u
}

get_icon_list () {
  for i in `get_icon_names $1 $2`; do
    echo $i.t.pm
    echo $i.m.pm
    echo $i.l.pm
  done
}

create_entries_for_all_locales() {
  # create all necessary sub directories
  for i in `find ${PKG_INSTALL_ROOT}/usr/dt/appconfig/types/* -type d -o -type l`; do
    locale=`basename $i`
    locale_dir=`get_locale_dir $locale`
    if [ "X$locale_dir" != "X" ]; then

      # check if it's a symlink, create the directory but make the files hardlinks    
      if [ -h $i ]; then
        linktarget=`ls -l $i | sed 's/.*-> //'`
        linktargetbase=`basename $linktarget`
        
        # check whether the link target will get created
        if [ "X`get_locale_dir $linktargetbase`" != "X" ]; then
          echo "$appconfig/types/$locale d 0755 root root"
          echo "$appconfig/types/$locale/$destfilename.fp=$appconfig/types/$linktargetbase/$destfilename.fp l"
          echo "$appconfig/types/$locale/$destfilename.dt=$appconfig/types/$linktargetbase/$destfilename.dt l"
        fi
      else
        # We have launchers for that locale, so add
        # the target files and directory to the 
        # package list.
        echo "$appconfig/types/$locale d 0755 root root"
        echo "$appconfig/types/$locale/$destfilename.fp"
        echo "$appconfig/types/$locale/$destfilename.dt"

        # Collect icon files for the actual locale 
        # Note: the file names are extraced from
        # the fp/dt files.
        if [ -d $source_root/icons/$locale_dir ]; then
          echo "$appconfig/icons d 0755 root root"
          echo "$appconfig/icons/$locale d 0755 root root"
          get_icon_list $locale_dir $locale
        fi
      fi
    fi
  done | installf $pkgname - || exit 2

  for i in `find ${PKG_INSTALL_ROOT}/usr/dt/appconfig/types/* -type d`; do
    locale=`basename $i`
    locale_dir=`get_locale_dir $locale`
    if [ "X$locale_dir" != "X" ]; then

      # Create the fp/dt file by merging the different modules into
      # a single file.  
      cat_entries $source_root/types/$locale_dir "fp" | $source_root/dtconv -l $locale > "$appconfig/types/$locale/$destfilename.fp" 2>/dev/null
      cat_entries $source_root/types/$locale_dir "dt" | $source_root/dtconv -l $locale > "$appconfig/types/$locale/$destfilename.dt" 2>/dev/null

      if [ -d $source_root/icons/$locale_dir ]; then
        for j in `get_icon_list $locale_dir $locale`; do
          cp -f $source_root/icons/$locale_dir/`basename $j | sed -e "s/$destfilename-//"` $j
        done
      fi
    fi
  done

  installf -f $pkgname || exit 2
}

create_entries_in_user_home() {

  # get locale from environment
  if [ $LC_CTYPE ]; then 
    locale=$LC_CTYPE
  elif [ $LC_ALL ]; then 
    locale=$LC_ALL
  elif [ $LANG ]; then 
    locale=$LANG
  else
    locale="C"
  fi

  locale_dir=`get_locale_dir $locale`
  if [ "X$locale_dir" != "X" ]; then

    # Create the fp/dt file by merging the different modules into
    # a single file.  
    cat_entries $source_root/types/$locale_dir "fp" | $source_root/dtconv > "$HOME/.dt/types/$destfilename.fp" 2>/dev/null
    cat_entries $source_root/types/$locale_dir "dt" | $source_root/dtconv > "$HOME/.dt/types/$destfilename.dt" 2>/dev/null

    if [ -d $source_root/icons/$locale_dir ]; then
      icons_dir="$locale_dir"
    else
      icons_dir="C"
    fi
    
    for j in `get_icon_list $icons_dir $locale`; do
      cp -f $source_root/icons/$icons_dir/`basename $j | sed -e "s/$destfilename-//"` "$HOME/.dt/icons/`basename $j`"
    done
  fi
}

if [ -z "${BASEDIR}" ]; then
  create_entries_in_user_home
else
  create_entries_for_all_locales
fi

exit 0
