/*************************************************************************
 *
 *  $RCSfile: taghelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2004/01/05 18:12:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef TAGHELPER_HXX
#define TAGHELPER_HXX

#include <map>
#include <sal/types.h>
#include <cppunit/nocopy.hxx>

/* Tags are a general mechanism of extensible data arrays for parameter
 * specification and property inquiry. In practice, tags are used in arrays,
 * or chain of arrays.
 *
 */

//# typedef unsigned long sal_Int32;
typedef sal_Int32 Tag;
typedef sal_Int32 TagData;

//# struct TagItem
//# {
//#     Tag     ti_Tag;     /* identifies the type of data */
//#     TagData ti_Data;    /* type-specific data          */
//# };

/* constants for Tag.ti_Tag, control tag values */
#define TAG_DONE   (Tag(0L))     /* terminates array of TagItems. ti_Data unused */
#define TAG_END    (Tag(0L))     /* synonym for TAG_DONE             */
#define TAG_IGNORE (Tag(1L))     /* ignore this item, not end of array       */
#define TAG_MORE   (Tag(2L))     /* ti_Data is pointer to another array of TagItems
               * note that this tag terminates the current array
               */
#define TAG_SKIP   (Tag(3L))      /* skip this and the next ti_Data items     */

/* differentiates user tags from control tags */
#define TAG_USER   (Tag(1L<<31))

// -----------------------------------------------------------------------------
class TagHelper /* : NOCOPY */
{
    typedef std::map<Tag, TagData> TagItems;
    TagItems m_aTagItems;

public:
    TagHelper(){}
    void insert(Tag _nTag, TagData _nData)
    {
        m_aTagItems[_nTag] = _nData;
    }
    // const TagItems& get() const { return m_aTagItems; }

    TagData GetTagData(Tag _aTagValue, TagData _aDefaultValue = 0 /* NULL */) const
    {
        TagItems::const_iterator it = m_aTagItems.find(_aTagValue);
        if (it != m_aTagItems.end())
            return (*it).second;
        else
            return _aDefaultValue;
    }
};

#endif


