#include <EXTERN.h>               /* from the Perl distribution     */
#include <perl.h>                 /* from the Perl distribution     */
#include "XmlBuildList.hxx"

#ifdef __cplusplus
#  define EXTERN_C extern "C"
#else
#  define EXTERN_C extern
#endif

static PerlInterpreter *my_perl;  /***    The Perl interpreter    ***/
EXTERN_C void xs_init (pTHX);
EXTERN_C void boot_DynaLoader (pTHX_ CV* cv);
EXTERN_C void xs_init(pTHX) {
	char *file = __FILE__;
	dXSUB_SYS;
	/* DynaLoader is a special case */
	newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
}

bool XmlBuildList::PerlInitialized = false;

//
// Function initializes Perl
// ATTENTION: No check built in - YET TO DO
//
void XmlBuildList::initPerl(const char* ModulePath) {
    if (PerlInitialized)
        return;
    my_perl = perl_alloc();
    if (!my_perl)
        throw XmlBuildListException("Cannot initialize perl");
    perl_construct(my_perl);
    char* embedding[] = {"", "-e", "0"};
    perl_parse(my_perl, xs_init, 3, embedding, (char **)NULL);
    perl_run(my_perl);
    // Create a variable (s. perlguts)
    SV* sv = get_sv("main::module_path", TRUE);
    sv_setpv(sv, ModulePath);
    eval_pv("use lib $main::module_path; use XMLBuildListParser;", FALSE);
    checkOperationSuccess();
    eval_pv("$main::build_lst_obj = XMLBuildListParser->new();", FALSE);
    checkOperationSuccess();
    eval_pv("@array = ();", FALSE);
    checkOperationSuccess();
    PerlInitialized = true;
};

// Function proves if the $@ perl variable is set, if yes -
// last operation was unsuccessfull -> throws exception
void XmlBuildList::checkOperationSuccess() {
    char* op_result = SvPV_nolen(get_sv("main::@", FALSE));
    if (strcmp(op_result, ""))
        throw XmlBuildListException(op_result);
}

char** XmlBuildList::getJobDirectories(const char* jobType, const char* jobPlatform) {
    sv_setpv(string_obj1, jobType);
    sv_setpv(string_obj2, jobPlatform);
    eval_pv("@array = $main::build_lst_obj->getJobDirectories($main::string1, $main::string2);", FALSE);
    checkOperationSuccess();
    return extractArray(getJobDirectories_array); 
}

// A faint prototype of a garbage collector
void XmlBuildList::deleteArray(char** StoredArray) {
    if (!StoredArray)
        return;
    for(int i = 0; StoredArray[i] != NULL; i++) {
        delete [] StoredArray[i];
    };
    delete [] StoredArray;
};

//
// Function generates a regular array with NULL as last element
// from the Perl-object @array
//
char** XmlBuildList::extractArray(char** result_array) {
    deleteArray(result_array);
    AV* theArrayObj = get_av("main::array", FALSE);
    I32 arrayLength = av_len(theArrayObj); // $#array value
    if (arrayLength == -1)
        return NULL;
    result_array = new char*[arrayLength + 2];
    // Last element is NULL
    result_array[arrayLength + 1] = NULL;
    SV** string_ptr;
    char* PerlString, *StoredString;
    // populate vector with strings (char*)
    for (int i = 0; i <= arrayLength; i++) {
        string_ptr = av_fetch(theArrayObj, i, NULL);
        PerlString = SvPV_nolen(*string_ptr);
        StoredString = new char[strlen(PerlString) + 1];
        strcpy(StoredString, PerlString);
        result_array[i] = StoredString;
    };
    return result_array;
};

char** XmlBuildList::getJobBuildReqPlatforms(const char* jobDir, const char* buildReqName) {
    sv_setpv(string_obj1, jobDir);
    sv_setpv(string_obj2, buildReqName);
    eval_pv("@array = $main::build_lst_obj->getJobPlatforms($main::string1, $main::string2);", FALSE);
    checkOperationSuccess();
    return extractArray(getJobBuildReqPlatforms_array);
};

char** XmlBuildList::getJobPlatforms(const char* jobDir) {
    sv_setpv(string_obj1, jobDir);
    eval_pv("@array = $main::build_lst_obj->getJobPlatforms($main::string1);", FALSE);
    checkOperationSuccess();
    return extractArray(getJobPlatforms_array);
};

char** XmlBuildList::getJobTypes(const char* jobDir) {
    sv_setpv(string_obj1, jobDir);
    eval_pv("@array = $main::build_lst_obj->getJobTypes($main::string1);", FALSE);
    checkOperationSuccess();
    return extractArray(getJobTypes_array);
};

char** XmlBuildList::getDirDependencies(const char* jobDir, const char* jobType, const char* jobPlatform) {
    sv_setpv(string_obj1, jobDir);
    sv_setpv(string_obj2, jobType);
    sv_setpv(string_obj3, jobPlatform);
    eval_pv("@array = $main::build_lst_obj->getDirDependencies($main::string1, $main::string2, $main::string3);", FALSE);
    checkOperationSuccess();
    return extractArray(getDirDependencies_array);
};

char* XmlBuildList::getModuleName() {
    eval_pv("$main::string1 = $main::build_lst_obj->getModuleName();", FALSE);
    checkOperationSuccess();
    return SvPV_nolen(get_sv("main::string1", FALSE));
};

char* XmlBuildList::getError() {
    eval_pv("$main::string1 = $main::build_lst_obj->getError();", FALSE);
    checkOperationSuccess();
    return SvPV_nolen(get_sv("main::string1", FALSE));
};

char** XmlBuildList::getModuleDependencies(const char* dependencyType) {
    sv_setpv(string_obj1, dependencyType);
    eval_pv("@array = $main::build_lst_obj->getModuleDependencies(\\@products, $main::string1);", FALSE);
    checkOperationSuccess();
    return extractArray(getModuleDependencies_array);
};

char** XmlBuildList::getModuleDependencies(char* product, const char* dependencyType) {
    eval_pv("@products = ();", FALSE);
    checkOperationSuccess();
    AV* theArrayObj = get_av("main::products", FALSE);
    sv_setpv(string_obj2, product);
    av_push(theArrayObj, string_obj2);
    return getModuleDependencies(dependencyType);
};

char** XmlBuildList::getModuleDependencies(char** products, const char* dependencyType) {
    eval_pv("@products = ();", FALSE);
    checkOperationSuccess();
    AV* theArrayObj = get_av("main::products", FALSE);
//    av_clear(theArrayObj);
    for (int i = 0;; i++) {
        if (!products[i]) 
            break;
        sv_setpv(string_obj2, products[i]);
        av_push(theArrayObj, string_obj2);
//        printf("value = %s\n", products[i]);
    };
    return getModuleDependencies(dependencyType);
};

char** XmlBuildList::getJobBuildReqs(const char* dir, const char* buildReqPlatform) {
    sv_setpv(string_obj1, dir);
    sv_setpv(string_obj2, buildReqPlatform);
    eval_pv("@array = $main::build_lst_obj->getJobBuildReqs($main::string1, $main::string2);", FALSE);
    checkOperationSuccess();
    return extractArray(getJobBuildReqs_array);
}

//
// Function uninitializes Perl
//
XmlBuildList::~XmlBuildList() {
    if (!PerlInitialized)
        return;
    deleteArray(getJobBuildReqPlatforms_array);
    deleteArray(getJobPlatforms_array);
    deleteArray(getJobTypes_array);
    deleteArray(getDirDependencies_array);
    deleteArray(getJobDirectories_array);
    deleteArray(getModuleDependencies_array);
    deleteArray(getJobBuildReqs_array);
    perl_destruct(my_perl);
    perl_free(my_perl);
    PerlInitialized = false;
};

void XmlBuildList::loadXMLFile(const char* buildListPath) {
    sv_setpv(string_obj1, buildListPath);
    eval_pv("$main::string2 = $main::build_lst_obj->loadXMLFile($main::string1);", FALSE);
    checkOperationSuccess();
//    printf("load result = %s\n", SvPV_nolen(get_sv("main::string2", FALSE)));
    if(!SvTRUE(string_obj2)) {
        const char* Message = getError();
        throw XmlBuildListException(Message);
    };
};

XmlBuildList::XmlBuildList(const char* buildListPath) {
    initPerl();
    string_obj1 = get_sv("main::string1", TRUE);
    string_obj2 = get_sv("main::string2", TRUE);
    string_obj3 = get_sv("main::string3", TRUE);
    getJobBuildReqPlatforms_array = NULL;
    getJobPlatforms_array = NULL;
    getJobTypes_array = NULL;
    getDirDependencies_array = NULL;
    getJobDirectories_array = NULL;
    getModuleDependencies_array = NULL;
    getJobBuildReqs_array = NULL;
    if (!(string_obj1 && string_obj2 && string_obj3))
        throw XmlBuildListException("Cannot initialize Perl string objects");
    loadXMLFile(buildListPath);
};


char* XmlBuildList::getModuleProducts(const char* depModuleName) {
    sv_setpv(string_obj1, depModuleName);
    eval_pv("$main::string1 = $main::build_lst_obj->getModuleProducts($main::string1);", FALSE);
    checkOperationSuccess();
    return SvPV_nolen(get_sv("main::string1", FALSE));
};

char* XmlBuildList::getModuleDepType(const char* depModuleName) {
    sv_setpv(string_obj1, depModuleName);
    eval_pv("$main::string1 = $main::build_lst_obj->getModuleDepType($main::string1);", FALSE);
    checkOperationSuccess();
    return SvPV_nolen(get_sv("main::string1", FALSE));
}

