/*************************************************************************
 *
 *  $RCSfile: isolang.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/23 12:36:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ISOLANG_HXX
#define _ISOLANG_HXX

#ifndef _LANG_HXX
#include <lang.hxx>
#endif
#ifndef _STRING_HXX
#include <string.hxx>
#endif

// -----------------------------
// - ConvertLanguageToIsoNames -
// -----------------------------

void ConvertLanguageToIsoNames( LanguageType eLang, UniString& rLangStr, UniString& rCountry );
void ConvertLanguageToIsoNames( LanguageType eLang, ByteString& rLangStr, ByteString& rCountry );
UniString ConvertLanguageToIsoString( LanguageType eLang, sal_Unicode cSep = '-' );
ByteString ConvertLanguageToIsoByteString( LanguageType eLang, sal_Char cSep = '-' );

// -----------------------------
// - ConvertIsoNamesToLanguage -
// -----------------------------

LanguageType ConvertIsoNamesToLanguage( const UniString& rLang, const UniString& rCountry );
LanguageType ConvertIsoNamesToLanguage( const ByteString& rLang, const ByteString& rCountry );
LanguageType ConvertIsoStringToLanguage( const UniString& rString, sal_Unicode cSep = '-' );
LanguageType ConvertIsoByteStringToLanguage( const ByteString& rString, sal_Char cSep = '-' );
LanguageType ConvertUnxByteStringToLanguage( const ByteString& rString );


// ---------------------------------------------------------------------------

/// @internal - Access to fields of an element of the simple conversion table.
struct IsoLangEntry
{
    LanguageType  meLang;
    sal_Char      maLangStr[4];
    sal_Char      maCountry[3];
};

/** @internal - Return a pointer to the IsoLangEntry of the underlying table,
    matching the offset passed by nIndex. Only meaningful for the resource
    compiler to build a list of known languages.

    @returns address of IsoLangEntry, or NULL pointer if nIndex exceeds the
    table elements' count.
 */
const IsoLangEntry* GetIsoLangEntry( size_t nIndex );

#endif //_ISOLANG_HXX
