/*************************************************************************
 *
 *	$RCSfile: resmgr.hxx,v $
 *
 *	$Revision: 1.6 $
 *
 *	last change: $Author: kz $ $Date: 2005/01/18 13:30:25 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_RESMGR_HXX
#define _TOOLS_RESMGR_HXX

#ifndef _STRING_HXX
#include <string.hxx>
#endif
#ifndef _LANG_HXX
#include <lang.hxx>
#endif
#ifndef _REF_HXX
#include <ref.hxx>
#endif

#ifndef _TOOLS_RESID_HXX
#include <resid.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif


#define CREATEVERSIONRESMGR_NAME( Name )   #Name MAKE_NUMSTR( SUPD )
#define CREATEVERSIONRESMGR( Name ) 	   ResMgr::CreateResMgr( CREATEVERSIONRESMGR_NAME( Name ) )

#define LOCALE_MAX_FALLBACK 6

#include <vector>

class SvStream;
class InternalResMgr;

// -----------------
// - RSHEADER_TYPE -
// -----------------

// Definition der Struktur, aus denen die Resource aufgebaut ist
struct RSHEADER_TYPE
{
private:
	sal_uInt32				nId;		// Identifier der Resource
	RESOURCE_TYPE			nRT;		// Resource Typ
	sal_uInt32				nGlobOff;	// Globaler Offset
	sal_uInt32				nLocalOff;	// Lokaler Offset

public:
	inline sal_uInt32       GetId(); 	   // Identifier der Resource
	inline RESOURCE_TYPE    GetRT(); 	   // Resource Typ
	inline sal_uInt32       GetGlobOff();   // Globaler Offset
	inline sal_uInt32       GetLocalOff();  // Lokaler Offset
};

// ----------
// - ResMgr -
// ----------

typedef void (*ResHookProc)( UniString& rStr );

// ----------
// - ResMgr -
// ----------

// Initialisierung
#define RC_NOTYPE				0x00
// Globale Resource
#define RC_GLOBAL				0x01
#define RC_AUTORELEASE			0x02
#define RC_NOTFOUND             0x04
#define RC_FALLBACK_DOWN        0x08
#define RC_FALLBACK_UP          0x10

class Resource;
class ResMgr;
struct ImpRCStack
{
	// pResource and pClassRes equal NULL: resource was not loaded
	RSHEADER_TYPE * pResource;		    // pointer to resource
	void		  * pClassRes;		    // pointer to class specified init data
	short			Flags;			    // resource status
	void *			aResHandle; 	    // Resource-Identifier from InternalResMgr
	const Resource* pResObj;		    // pointer to Resource object
	sal_uInt32		nId;			    // ResId used for error message
	ResMgr*         pResMgr;		    // ResMgr for Resource pResObj

	void			Clear();
	void			Init( ResMgr * pMgr, const Resource * pObj, sal_uInt32 nId );    
};

class ResMgr
{
private:
	InternalResMgr*            pImpRes;
	std::vector< ImpRCStack >  aStack;	// resource context stack
    int                        nCurStack;
    ResMgr*         pFallbackResMgr;    // fallback ResMgr in case the Resource
                                        // was not contained in this ResMgr
    ResMgr*         pOriginalResMgr;    // the res mgr that fell back to this
                                        // stack level

    
    void         incStack();
    void         decStack();

	const ImpRCStack *	StackTop( sal_uInt32 nOff = 0 ) const
    {
        return (((int)nOff >= nCurStack) ? NULL : &aStack[nCurStack-nOff]);
    }
	void				Init( const rtl::OUString& rFileName );

    ResMgr( InternalResMgr * pImp );
    
    #ifdef DBG_UTIL
    static void RscError_Impl( const sal_Char* pMessage, ResMgr* pResMgr,
                               RESOURCE_TYPE nRT, sal_uInt32 nId,
                               std::vector< ImpRCStack >& rResStack, int nDepth );
    #endif

    // called from within GetResource() if a resource could not be found
    ResMgr* CreateFallbackResMgr( const ResId& rId, const Resource* pResource );
    // creates a 1k sized buffer set to zero for unfound resources
    // used in case RC_NOTFOUND
    static void* pEmptyBuffer;
    static void* getEmptyBuffer();
    
    // the next two methods are needed to prevent the string hook called
    // with the res mgr mutex locked
	// like GetString, but doesn't call the string hook
	static sal_uInt32	GetStringWithoutHook( UniString& rStr, const BYTE* pStr );
    // like ReadString but doesn't call the string hook
	UniString			ReadStringWithoutHook();
public:
	static void 		DestroyAllResMgr();  // Wird gerufen, wenn App beendet wird

    ~ResMgr();

						// Sprachabhaengige Ressource Library
	static const sal_Char*	GetLang( LanguageType& eLanguage, USHORT nPrio = 0 ); //depricated! see "tools/source/rc/resmgr.cxx"
    static ResMgr*      SearchCreateResMgr( const sal_Char* pPrefixName,
                                            com::sun::star::lang::Locale& rLocale );
 	static ResMgr*		CreateResMgr( const sal_Char* pPrefixName,
                                      com::sun::star::lang::Locale aLocale = com::sun::star::lang::Locale( rtl::OUString(),
                                                                                                           rtl::OUString(),
                                                                                                           rtl::OUString()));

	// Testet ob Resource noch da ist
	void				TestStack( const Resource * );

	// ist Resource verfuegbar
	BOOL				IsAvailable( const ResId& rId,
									 const Resource* = NULL) const;

	// Resource suchen und laden
	BOOL				GetResource( const ResId& rId, const Resource * = NULL );
	static void *		GetResourceSkipHeader( const ResId& rResId, ResMgr ** ppResMgr );
	// Kontext freigeben
	void				PopContext( const Resource* = NULL );

	// Resourcezeiger erhoehen
	void*				Increment( sal_uInt32 nSize );

	// Groesse ein Objektes in der Resource
	static sal_uInt32	GetObjSize( RSHEADER_TYPE* pHT )
							{ return( pHT->GetGlobOff() ); }

	// Liefert einen String aus der Resource
	static sal_uInt32	GetString( UniString& rStr, const BYTE* pStr );

	// Groesse eines Strings in der Resource
	static sal_uInt32	GetStringSize( sal_uInt32 nLen )
							{ nLen++; return (nLen + nLen%2); }
	static sal_uInt32	GetStringSize( const BYTE* pStr );

    // return a int64
    static sal_uInt64   GetUInt64( void* pDatum );
	// Gibt einen long zurueck
	static INT32		GetLong( void * pLong );
	// return a short
	static INT16		GetShort( void * pShort );

	// Gibt einen Zeiger auf die Resource zurueck
	void *				GetClass();

	RSHEADER_TYPE * 	CreateBlock( const ResId & rId );

	// Gibt die verbleibende Groesse zurueck
	sal_uInt32			GetRemainSize();

	const rtl::OUString&GetFileName() const;

	INT16				ReadShort();
	INT32				ReadLong();
	UniString			ReadString();
    
     // generate auto help id for current resource stack
    ULONG               GetAutoHelpId();

	static void 		SetReadStringHook( ResHookProc pProc );
	static ResHookProc	GetReadStringHook();
    static void         SetDefaultLocale( const com::sun::star::lang::Locale& rLocale );
    
    #if _SOLAR__PRIVATE
    rtl::OUString ImplGetPrefix();
    com::sun::star::lang::Locale ImplGetLocale();
    static ResMgr* ImplCreateResMgr( InternalResMgr* pImpl ) { return new ResMgr( pImpl ); }
    #endif
};

inline sal_uInt32 RSHEADER_TYPE::GetId()
{
	return (sal_uInt32)ResMgr::GetLong( &nId );
}
inline RESOURCE_TYPE RSHEADER_TYPE::GetRT()
{
	return (RESOURCE_TYPE)ResMgr::GetLong( &nRT );
}
inline sal_uInt32 RSHEADER_TYPE::GetGlobOff()
{
	return (sal_uInt32)ResMgr::GetLong( &nGlobOff );
}
inline sal_uInt32 RSHEADER_TYPE::GetLocalOff()
{
	return (sal_uInt32)ResMgr::GetLong( &nLocalOff );
}

#endif // _SV_RESMGR_HXX
