/*************************************************************************
 *
 *  $RCSfile: symbol.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/06/18 15:07:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <solar.h>
#include <stream.hxx>
#ifdef WNTx
#include <svwin.h>
#endif

ULONG nSize = 0;
ULONG nLines = 0;
ULONG nBrakes = 0;

int Error( int i, char* p, long l )
{
	fprintf( stderr, "Error=%i; Size=%lu; Lines=%lu; %s=%ld\n",
	 		 i, nSize, nLines, p, l );
	return i;
}

int main( int argc, char** argv )
{
	if( argc < 3 )
		return Error( 1, "argc", argc );
#ifdef WNTx
	HANDLE MapFileHandle = CreateFile( argv[1],
	                       			GENERIC_READ | GENERIC_WRITE,
									0,
		                       		0,
		                       		OPEN_EXISTING,
		                       		FILE_ATTRIBUTE_NORMAL /* | STANDARD_RIGHTS_REQUIRED |
		                       		FILE_MAP_WRITE | FILE_MAP_READ */,
		                       		0 );
	if( MapFileHandle == INVALID_HANDLE_VALUE )
		return Error( 2, argv[1], GetLastError() );

	nSize = GetFileSize( MapFileHandle, NULL );
	if( !nSize )
		return Error( 9, argv[1], nSize );

	HANDLE MapHandle = CreateFileMapping( MapFileHandle,
   		                      		   	0,
	                             	   	PAGE_READWRITE,
	                             	   	0,
	                             	   	nSize + 1,
										0 );
	if( MapHandle == NULL )
		return Error( 7, "CreateFileMapping", GetLastError() );

	char* pMap = (char*)MapViewOfFile( MapHandle, FILE_MAP_READ|FILE_MAP_WRITE, 0, 0, 0 );
	if( pMap == NULL )
		return Error( 8, "MapViewOfFile", GetLastError() );

	pMap[nSize] = '\0';
#else
	SvFileStream aMap( String( argv[1], gsl_getSystemTextEncoding()), STREAM_READ );

	nSize = aMap.Seek( STREAM_SEEK_TO_END );
	if( aMap.GetError() )
		return Error( 2, argv[1], aMap.GetError() );

	char* pMap  = new char[nSize+1];
	pMap[nSize] = '\0';

	aMap.Seek( STREAM_SEEK_TO_BEGIN );
	ULONG nRead = aMap.Read( pMap, nSize );
	aMap.Close();

	if( nRead != nSize )
		return Error( 6, "Read", nRead );
#endif
	char* p;
	for( p = pMap; *p; nLines++ )
	{
		while( *p != '\r' && *p != '\n' && *p )
			p++;
		while( *p == '\r' || *p == '\n' )
			p++;
	}
	if( p-pMap != nSize )
		return Error( 3, "p-pMap", p-pMap );

	if( nLines )
	{
		ULONG* pAddr = new ULONG[nLines];
		char** pName = new char*[nLines];
		ULONG  n     = 0;

		for( p = pMap; *p && n < nLines; n++ )
		{
			pAddr[n] = strtol( p, NULL, 16 );
			pName[n] = p + 9;

			while( *p != '\r' && *p != '\n' && *p )
				p++;
			while( *p == '\r' || *p == '\n' )
				*(p++) = 0;
		}
		if( p-pMap != nSize )
			return Error( 4, "p-pMap", p-pMap );
		if( n != nLines )
			return Error( 5, "n", n );

		SvFileStream aLeak( String( argv[2], gsl_getSystemTextEncoding()), STREAM_READ );
		ByteString aLine;

		aLeak.ReadLine( aLine );
		while( !aLeak.IsEof() )
		{
			if( !aLine.Len() )
				;
			else if( *aLine.GetBuffer() == '}' )
				nBrakes--;
			else if( aLine.GetChar( aLine.Len()-1 ) == '{' )
				nBrakes++;
			else if( nBrakes == 1 )
			{
				for( USHORT n = 0; aLine.GetChar(n) == ' '; n++ )
					;

				ULONG l = strtol( aLine.GetBuffer()+n, NULL, 16 );
				ULONG i = 0;
				ULONG j = nLines-1;

				while( i < j-1 )
				{
					ULONG k = (i + j) / 2;
					if( l < pAddr[k] )
						j = k;
					else
						i = k;
				}
				while( l < pAddr[i] && i < nLines )
					i++;

				if( i < nLines )
				{
					aLine.Erase( n, 8 );
					if( pAddr[i] != l )
					{
						aLine.Insert(
                            ByteString::CreateFromInt64( l - pAddr[i] ), n );
						aLine.Insert( "+", n );
					}
					aLine.Insert( pName[i], n );
					printf( "%s\n", aLine.GetBuffer() );
				}
			}
			aLeak.ReadLine( aLine );
		}

		delete pAddr;
		delete pName;
	}
#ifdef WNTx
	SetFilePointer( MapFileHandle, nSize, NULL, FILE_BEGIN );
	SetEndOfFile( MapFileHandle );
	UnmapViewOfFile( pMap );
	CloseHandle( MapHandle );
	CloseHandle( MapFileHandle );
#else
	delete pMap;
#endif
	return 0;
}
