/*************************************************************************
 *
 *  $RCSfile: imgcons.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:36:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _IMGCONS_HXX
#define _IMGCONS_HXX

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#include <bitmap.hxx>

// -----------------
// - ImageConsumer -
// -----------------

class ImageProducer;
class ImplColorMapper;
class BitmapEx;
class Image;

#define IMAGEERROR			1
#define SINGLEFRAMEDONE 	2
#define STATICIMAGEDONE 	3
#define IMAGEABORTED		4

class VCL_DLLPUBLIC ImageConsumer
{
private:

	Bitmap				maBitmap;
	Bitmap				maMask;
	Rectangle			maChangedRect;
	Size				maSize;
	ImplColorMapper*	mpMapper;
	Color*				mpPal;
	Link				maChgLink;
	Link				maDoneLink;
	ULONG				mnFormat;
	ULONG				mnStatus;
	BOOL				mbTrans;
						
protected:				
						
	virtual void		DataChanged();
						
public:					
						
						ImageConsumer();
	virtual				~ImageConsumer();
						
	BOOL				GetData( BitmapEx& rBmpEx ) const;
	BOOL				GetData( Image& rImage ) const;
	const Rectangle&	GetChangedRect() const { return maChangedRect; }
	ULONG				GetStatus() const;
						
	void				SetDataChangedLink( const Link& rLink ) { maChgLink = rLink; }
	const Link&			GetDataChangedLink() const { return maChgLink; }
						
	void				SetDoneLink( const Link& rLink ) { maDoneLink = rLink; }
	const Link&			GetDoneLink() const { return maDoneLink; }

public:

	virtual void		Init( ULONG nWidth, ULONG nHeight );

	virtual void		SetColorModel( USHORT nBitCount,
									   ULONG nPalEntries, const ULONG* pRGBAPal, 
									   ULONG nRMask, ULONG nGMask, ULONG nBMask, ULONG nAMask  );
						
	virtual	void		SetPixelsByBytes( ULONG nConsX, ULONG nConsY, 
										  ULONG nConsWidth, ULONG nConsHeight,
										  const BYTE* pProducerData, ULONG nOffset, ULONG nScanSize );
						
	virtual	void		SetPixelsByLongs( ULONG nConsX, ULONG nConsY, 
										  ULONG nConsWidth, ULONG nConsHeight,
										  const ULONG* pProducerData, ULONG nOffset, ULONG nScanSize );
						
	virtual void		Completed( ULONG nStatus );
//	virtual void		Completed( ULONG nStatus, ImageProducer& rProducer );
};

#endif // _IMGCONS_HXX
