 /*************************************************************************
 *
 *  $RCSfile: ReportDocument.java,v $
 *
 *  $Revision: 1.43 $
 *
 *  last change: $Author: kz $ $Date: 2004/11/27 09:07:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 */

package com.sun.star.wizards.report;

import java.util.Vector;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.VclWindowPeerAttribute;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.db.*;
import com.sun.star.wizards.common.*;
import com.sun.star.wizards.ui.*;
import com.sun.star.text.XTextDocument;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.text.TextTableHandler;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.document.FormHandler;


class ReportDocument extends com.sun.star.wizards.text.TextDocument{
	private Object ReportPageStyle;
    private Object FirstPageStyle;
	private int PageWidth;
	private Rectangle PosSize;
	private String ReportFolderName;
	public Vector DBColumnsVector;
	private RecordTable CurRecordTable;
	public RecordParser CurDBMetaData;
	private String sMsgTableNotExisting;
	private String sMsgCommonReportError;
	private String ContentTemplatePath;
	private String LayoutTemplatePath;
	private String sMsgInvalidTextField;
	private String sMsgEndAutopilot;
	public boolean bIsCurLandscape;
	public TextTableHandler oTextTableHandler;
	public TextSectionHandler oTextSectionHandler;
	public FormHandler oFormHandler;
	public TextStyleHandler oTextStyleHandler;
	public TextFieldHandler oTextFieldHandler;
	public ViewHandler oViewHandler;

	
	/** Creates new ReportDocument */
	public ReportDocument(XMultiServiceFactory xMSF,XTextDocument _textDocument, boolean bshowStatusIndicator, Resource oResource) {
	super(xMSF, _textDocument, bshowStatusIndicator);
	    lateInit(oResource);
	}

    public ReportDocument(XMultiServiceFactory xMSF, boolean bshowStatusIndicator, Resource oResource) {
	super(xMSF, bshowStatusIndicator,false, null);
	    lateInit(oResource);
	}

	void lateInit(Resource oResource){
		oTextTableHandler = new TextTableHandler(xMSFDoc, xTextDocument);
	    oTextSectionHandler = new TextSectionHandler(xMSFDoc, xTextDocument);
	    oFormHandler = new FormHandler(xMSFDoc, xTextDocument);
	    oTextStyleHandler = new TextStyleHandler(xMSFDoc, xTextDocument);
	    oViewHandler = new ViewHandler(xMSFDoc, xTextDocument);
	    oTextFieldHandler = new TextFieldHandler(xMSFDoc, xTextDocument);
	    DBColumnsVector = new java.util.Vector();
	    CurDBMetaData = new RecordParser(xMSF, CharLocale, oTextTableHandler.NumberFormats);
	    long lDateCorrection = Desktop.getNullDateCorrection(xNumberFormatsSupplier);
	    CurDBMetaData.setNullDateCorrection(lDateCorrection);
		sMsgInvalidTextField = oResource.getResText(UIConsts.RID_REPORT + 73);
		sMsgTableNotExisting = oResource.getResText(UIConsts.RID_REPORT + 61);
		sMsgCommonReportError = oResource.getResText(UIConsts.RID_REPORT + 72);	    
		sMsgCommonReportError = JavaTools.replaceSubString(sMsgCommonReportError, String.valueOf((char)13), "<BR>");		
		sMsgEndAutopilot = oResource.getResText(UIConsts.RID_DB_COMMON + 33);		
	    sMsgTableNotExisting = sMsgTableNotExisting + (char) 13 + sMsgEndAutopilot;
	    bIsCurLandscape = true;
	    getReportPageStyles();
	}

    public boolean checkReportLayoutMode( String[] GroupFieldNames){
    try{
		XNameAccess xTextSections = oTextSectionHandler.xTextSectionsSupplier.getTextSections();
		Object oTextSection;
		if (GroupFieldNames.length > 0)
		    oTextSection = xTextSections.getByName("GroupField1");
		else
		    oTextSection = xTextSections.getByName("RecordSection");
		boolean bLayoutMode = AnyConverter.toBoolean(Helper.getUnoPropertyValue(oTextSection, "IsVisible"));
		return bLayoutMode;
    }
    catch( Exception exception ){
        exception.printStackTrace(System.out);
	// In doubt we rather suggest this is LayoutMode...
	return true;
    }}


    public void swapContentTemplate(String ContentTemplatePath){
//	unlockallControllers();
		xProgressBar.start("", 10);
		this.ContentTemplatePath = ContentTemplatePath;
		loadSectionsfromTemplate(ContentTemplatePath);
		xProgressBar.setValue(40);
		oTextStyleHandler.loadStyleTemplates(ContentTemplatePath, "LoadTextStyles");
		xProgressBar.setValue(70);
		if (CurRecordTable != null)
		    CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
		xProgressBar.setValue(100);
		oViewHandler.selectFirstPage(oTextTableHandler);
		xProgressBar.end();	
    }
    

    public void swapLayoutTemplate(String LayoutTemplatePath, String BitmapPath){
    try{
		xProgressBar.start("", 10);
		this.LayoutTemplatePath = LayoutTemplatePath;
		boolean bOldIsCurLandscape = AnyConverter.toBoolean(Helper.getUnoPropertyValue(ReportPageStyle, "IsLandscape"));
		oTextStyleHandler.loadStyleTemplates(LayoutTemplatePath, "LoadPageStyles");
		xProgressBar.setValue(60);
		changePageOrientation(BitmapPath, bOldIsCurLandscape);
		xProgressBar.setValue(100);
		oViewHandler.selectFirstPage(oTextTableHandler);
		xProgressBar.end();	
    }
    catch( Exception exception ){
        exception.printStackTrace(System.out);
    }}
    

    public void createReportForm(String SOREPORTFORMNAME){
		com.sun.star.container.XNameContainer xNamedForm = oFormHandler.insertFormbyName(SOREPORTFORMNAME);
	        XNameAccess xNameAccess = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xNamedForm);
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "DataSourceName", CurDBMetaData.DataSourceName);
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Command", CurDBMetaData.Command);
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "CommandType", new String(Integer.toString(CurDBMetaData.getCommandType())));
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "GroupFieldNames", JavaTools.ArraytoString(CurDBMetaData.GroupFieldNames));
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "FieldNames", JavaTools.ArraytoString(CurDBMetaData.FieldNames));
		oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "RecordFieldNames", JavaTools.ArraytoString(CurDBMetaData.RecordFieldNames));
    }


    public void updateReportTitle(com.sun.star.awt.XTextComponent xTitleTextBox){
		String TitleName = xTitleTextBox.getText();
		Helper.setUnoPropertyValue(xDocInfo, "Title", TitleName);
    }
    

    public void getReportPageStyles(){
    try{
        Object oPageStyleFamily = oTextStyleHandler.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
        ReportPageStyle  = Helper.getUnoObjectbyName(oPageStyleFamily, "Standard");
        FirstPageStyle = Helper.getUnoObjectbyName(oPageStyleFamily, "First Page");
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}

    
    
    public void changePageOrientation(String BitmapPath, boolean bNewLandscape){
    try{
		com.sun.star.awt.Size oNewSize;
		getReportPageStyles();
	        com.sun.star.awt.Size oLocSize = (com.sun.star.awt.Size) Helper.getUnoStructValue(ReportPageStyle, "Size");
	        bIsCurLandscape = AnyConverter.toBoolean(Helper.getUnoPropertyValue(ReportPageStyle, "IsLandscape"));
	        if (bIsCurLandscape != bNewLandscape){
	            oNewSize = new com.sun.star.awt.Size(oLocSize.Height, oLocSize.Width);
	            Helper.setUnoPropertyValue(ReportPageStyle, "IsLandscape", new Boolean(bNewLandscape));
	            Helper.setUnoPropertyValue(ReportPageStyle, "Size", oNewSize);
	            Helper.setUnoPropertyValue(FirstPageStyle, "IsLandscape", new Boolean(bNewLandscape));
		    Helper.setUnoPropertyValue(FirstPageStyle, "Size", oNewSize);
		    int iLeftMargin = AnyConverter.toInt(Helper.getUnoPropertyValue(ReportPageStyle, "LeftMargin"));
		    int iRightMargin = AnyConverter.toInt(Helper.getUnoPropertyValue(ReportPageStyle, "RightMargin"));
		    PageWidth = oNewSize.Width - iLeftMargin - iRightMargin;
		    if (CurRecordTable != null)
			CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
		}
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}


    public boolean loadSectionsfromTemplate(String sTemplateUrl){
    try{
		int i;
		DBColumn CurDBColumn;
		int GroupCount = CurDBMetaData.GroupFieldNames.length;
		CurRecordTable = null;
		for (i = 0; i< GroupCount; i++){
		    String SectionName = "GroupField" + Integer.toString(i + 1);
		    oTextTableHandler.renameTextTable("Tbl_" + SectionName, "MyTextTable");
		    oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, SectionName);
		    oTextTableHandler.renameTextTable("MyTextTable", "Tbl_" + SectionName);
		}
		if (oTextSectionHandler.xTextSectionsSupplier.getTextSections().getElementNames().length > CurDBMetaData.GroupFieldNames.length){
		    oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, "RecordSection");
		    CurRecordTable = new RecordTable(oTextTableHandler);
		    insertColumnstoRecordTable();
		}		    
		for (i = 0; i < GroupCount; i++){
		    CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurDBMetaData.GroupFieldNames[i], i, "Tbl_GroupField" + (i + 1));
		    if (CurDBColumn == null)
				return false;
		    else{
		    	CurDBColumn.formatValueCell();
				DBColumnsVector.set(i, CurDBColumn);
				replaceFieldValueInGroupTable(CurDBColumn, i);
		    }
		}
		return true;
    }
    catch( Exception exception ){
		exception.printStackTrace(System.out);
	return false;
    }}

    
    public void setupRecordSection(String TemplateName){
	this.ContentTemplatePath = TemplateName;
	if (CurDBMetaData.RecordFieldNames.length > 0){
	    oTextSectionHandler.insertTextSection("RecordSection", TemplateName);
	    CurRecordTable = new RecordTable(oTextTableHandler);
	    insertColumnstoRecordTable();
	    if (CurRecordTable != null)
			CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
	}
	else
	    CurRecordTable = null;
    }
  
  
  	public void refreshGroupFields(String[] _sNewNames){
		for (int i = 0; i < DBColumnsVector.size(); i++){
			DBColumn CurDBColumn = (DBColumn) DBColumnsVector.elementAt(i);
			if (!CurDBColumn.CurDBField.FieldName.equals(_sNewNames[i])){			
				CurDBColumn.setDBField(_sNewNames[i]);
				CurDBColumn.insertColumnData(oTextFieldHandler, bIsCurLandscape);
			}
		}
  	}


	public boolean isGroupField(String _FieldName){
		return (JavaTools.FieldInList(CurDBMetaData.GroupFieldNames, _FieldName) != -1);
//		for (int i = 0; i < DBColumnsVector.size(); i++){
//			DBColumn CurDBColumn = (DBColumn) DBColumnsVector.elementAt(i);
//			if (!CurDBColumn.CurDBField.FieldName.equals(_FieldName)){	
//				return true;		
//			}
//		}
//		return false;
	}
    
    public void replaceFieldValueInRecordSection(int RecordCount){
		int GroupCount = CurDBMetaData.GroupFieldNames.length;
		int FieldCount = CurDBMetaData.FieldNames.length;
		for (int i = GroupCount; i < FieldCount; i++)
			((DBColumn) DBColumnsVector.elementAt(i)).insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
    }


    public void updateTextSections(String[] SelGroupNames) throws Exception{
	String TableName;
	DBColumn OldDBColumn;
	DBColumn CurDBColumn;
	XNameAccess xTableNames = oTextTableHandler.xTextTablesSupplier.getTextTables();
	int GroupFieldCount = SelGroupNames.length;
		for (int i = 0; i < GroupFieldCount; i++){
		    TableName = "Tbl_GroupField" + Integer.toString(i + 1);
		    OldDBColumn = (DBColumn) DBColumnsVector.get(i);
		    CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, SelGroupNames[i], i, TableName, OldDBColumn);
		    CurDBColumn.formatValueCell();
		    DBColumnsVector.setElementAt(CurDBColumn, i);
			CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
		}
    }
    

    public void replaceFieldValueInGroupTable(DBColumn CurDBColumn, int TableIndex){
		String TableName = "Tbl_GroupField" + (TableIndex + 1);
		// Note: for some reason the table might lose its name and has to be renamed therefor
		String OldTableName = CurDBColumn.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
			CurDBColumn.xTableName.setName(TableName);
		CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
		CurDBColumn.setCellFont();
    }
    

    public void replaceFieldValueInRecordTable(){
		String TableName = "Tbl_RecordSection";
		String OldTableName = CurRecordTable.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
		    CurRecordTable.xTableName.setName(TableName);
		int GroupCount = CurDBMetaData.GroupFieldNames.length;
		int RecordCount = CurDBMetaData.RecordFieldNames.length;
		for (int i = GroupCount; i < RecordCount; i++)
			((DBColumn) DBColumnsVector.elementAt(i)).insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
    }


    public void insertColumnstoRecordTable(){
    try{
		int GroupCount = CurDBMetaData.GroupFieldNames.length;
		DBColumn  CurDBColumn;
		// Note for some reason the table might lose its name and has to be renamed therefor
		String OldTableName = CurRecordTable.xTableName.getName();
	        if (OldTableName.compareTo("Tbl_RecordSection") != 0)
	       	    CurRecordTable = new RecordTable(oTextTableHandler);
		com.sun.star.table.XTableColumns xColumns = CurRecordTable.xTextTable.getColumns();
		int ColCount = xColumns.getCount();
		int RecordCount = CurDBMetaData.RecordFieldNames.length;
		if (ColCount > RecordCount){
		    int RemoveCount = ColCount - RecordCount;
		    xColumns.removeByIndex(0, RemoveCount);
		}
		else if (ColCount < RecordCount){
		    int AddCount = RecordCount - ColCount;
		    CurRecordTable.xTextTable.getColumns().insertByIndex(ColCount, AddCount);
		}
		for (int i = 0; i < RecordCount; i++){
		    CurDBColumn = new DBColumn(CurRecordTable, oTextTableHandler, CurDBMetaData, i);
		    CurDBColumn.initializeNumberFormat();
			CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);		    
		    if (DBColumnsVector.size() <= (i + GroupCount))
				DBColumnsVector.add(CurDBColumn);
		    else
				DBColumnsVector.set(i+GroupCount,CurDBColumn);
		}
    }
    catch(Exception exception){
		showCommonReportErrorBox(exception);
    }}


    public boolean addGroupNametoDocument(String[] GroupNames, String CurGroupTitle, Vector GroupFieldVector, String ReportPath, int iSelCount){
    DBColumn CurDBColumn = null;
    try{
		int GroupCount = GroupFieldVector.size();
		if (GroupCount < 4){
		    removeGroupNamesofRecordTable(iSelCount);
		    String CurGroupName = CurDBMetaData.getFieldName(CurGroupTitle);
		    GroupFieldVector.addElement(CurGroupName);
		    GroupCount += 1;
		    oTextSectionHandler.insertTextSection("GroupField" + GroupCount, ReportPath + "/cnt-default.stw");
		    CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurGroupName, GroupCount-1, "Tbl_GroupField" + (GroupCount));
		    CurDBColumn.formatValueCell();
		    if (CurDBColumn != null){
				DBColumnsVector.addElement(CurDBColumn);
				replaceFieldValueInGroupTable(CurDBColumn, GroupCount-1);
		    }
		    else{
				String sMessage = JavaTools.replaceSubString(sMsgTableNotExisting, "Tbl_GroupField" + (GroupCount), "<TABLENAME>");
				CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMessage);
		    }
		}
    }
    catch(Exception exception){
		showCommonReportErrorBox(exception);
    }
    return (CurDBColumn != null);
    }


    public void removeGroupName(String[] NewSelGroupNames, String CurGroupTitle, java.util.Vector GroupFieldVector){
    try{
		removeGroupNamesofRecordTable(NewSelGroupNames.length + 1);
		String CurGroupName = CurDBMetaData.getFieldName(CurGroupTitle); 
		GroupFieldVector.removeElement(CurGroupName);
		oTextSectionHandler.removeLastTextSection();
		oTextTableHandler.removeLastTextTable();
		// if the previously selected item is somewhere in the middle of the listbox (and not at the end) the
		// Textsections have to be updated
		if (JavaTools.FieldInList(NewSelGroupNames, CurGroupTitle) == -1)
		    updateTextSections(NewSelGroupNames);
		int iSelItemCount = (int) NewSelGroupNames.length;
		DBColumnsVector.remove(iSelItemCount);
    }
    catch(Exception exception){
		showCommonReportErrorBox(exception);
    }}
    
    
    
    public void removeGroupNamesofRecordTable(int GroupFieldCount){
	int CurFieldCount = DBColumnsVector.size();
		if (CurFieldCount > GroupFieldCount){
		    for (int i = CurFieldCount-1; i >= GroupFieldCount; i--){
				DBColumnsVector.removeElementAt(i);
		    }
		}
    }
    
    
    public void showCommonReportErrorBox(Exception exception){
		String SystemContentPath = JavaTools.convertfromURLNotation(ContentTemplatePath);
		String sMsgCurCommonReportError = JavaTools.replaceSubString(sMsgCommonReportError, SystemContentPath, "%PATH");
		CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMsgCurCommonReportError);
		exception.printStackTrace(System.out);
    }
    
    
   
    public void getallDBColumns(){
    try{
		int GroupCount = CurDBMetaData.GroupFieldNames.length;
		int FieldCount = CurDBMetaData.FieldNames.length;
		DBColumn CurDBColumn;
		for (int i = 0; i < FieldCount; i++){
		    if (i < GroupCount)
		        CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurDBMetaData.GroupFieldNames[i], i, "Tbl_GroupField" + (i + 1));
		    else{
		    	if (CurRecordTable == null)
					CurRecordTable = new RecordTable(oTextTableHandler);
				CurDBColumn = new DBColumn(CurRecordTable, oTextTableHandler, CurDBMetaData, i-GroupCount);
				CurDBColumn.initializeNumberFormat();
		    }				
		    if (CurDBColumn != null){
				DBColumnsVector.addElement(CurDBColumn);
		    }
		    else{
			String sMessage = JavaTools.replaceSubString(sMsgTableNotExisting, "Tbl_GroupField" + (GroupCount), "<TABLENAME>");
			CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMessage);
		    }
		}
    }
    catch(Exception exception){
		showCommonReportErrorBox(exception);
    }}
}