package com.sun.star.help;

import java.io.*;
import java.util.zip.*;
import java.util.jar.*;


public class HelpPackager
{
	private JarOutputStream _jarOutputStream;
	
	
	/*
	 *   in fileName: The file to pack in
	 */ 
	
	public HelpPackager( String fileName )
	{
		try
		{
			(new File( fileName )).createNewFile();		
			_jarOutputStream = new JarOutputStream( new FileOutputStream( fileName,false ) );
		}
        catch( FileNotFoundException e )
        {
            System.err.println("Error creating jar file!" );
        }
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}
	
	
	public void addEntry( String entryName,byte[] bytesToAdd )
	{
		if( bytesToAdd == null ) return;
			
		try
		{
			CRC32 crc= new CRC32();
			crc.update( bytesToAdd );
			
			JarEntry ze = new JarEntry( entryName );
			ze.setCrc( crc.getValue() );
			ze.setSize( bytesToAdd.length );
			ze.setMethod( JarEntry.DEFLATED );
			
			_jarOutputStream.putNextEntry( ze );
			if (bytesToAdd.length > 0)
				_jarOutputStream.write( bytesToAdd );
			_jarOutputStream.closeEntry();
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}	
	
	
	public void close()
	{
		try
		{
			_jarOutputStream.close();
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}

}
