#include <osl/file.hxx>
#include <rtl/ustring.hxx>

using namespace rtl;
using namespace osl;


void err_msg( const char* p,
              const OUString& aOUString )
{
    OString contentUrl( aOUString.getStr(),
                        aOUString.getLength(),
                        RTL_TEXTENCODING_UTF8 );
    
    fprintf( stderr,"%s%s\n",p,contentUrl.getStr() );
}


void wait_for( const char* p )
{
    const char* def = "/export/home/abi/dir";
    char* tmp = const_cast<char*>(def);
    if( p )
        tmp = const_cast<char*>(p);
    
    rtl::OUString aDirectoryName = rtl::OUString::createFromAscii( tmp );
    Directory aDirectory( aDirectoryName );
    while( aDirectory.open() != FileBase::E_None );
    aDirectory.close();
    Directory::remove( aDirectoryName );
}



