/*************************************************************************
 *
 *	$RCSfile: xmlstreamio.cxx,v $
 *
 *	$Revision: 1.1.1.1 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/12 13:15:21 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/*
 * Implementation of the I/O interfaces based on stream and URI binding
 */
#ifndef _XMLSTREAMIO_XMLSECIMPL_HXX_
#include "xmlstreamio.hxx"
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include <libxml/uri.h>
#include <xmlsec/io.h>

#define XMLSTREAMIO_INITIALIZED 0x01
#define XMLSTREAMIO_REGISTERED  0x02

/* Global variables */
/*-
 * Enable stream I/O or not.
 */
static char enableXmlStreamIO = 0x00 ;

::com::sun::star::uno::Reference< ::com::sun::star::xml::crypto::XUriBinding > m_xUriBinding ;

int xmlStreamMatch( const char* uri )
{
	::com::sun::star::uno::Reference< com::sun::star::io::XInputStream > xInputStream ;

	if( ( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) &&
		( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		if( uri == NULL || !m_xUriBinding.is() )
			return 0 ;

		xInputStream = m_xUriBinding->getUriBinding( ::rtl::OUString::createFromAscii( uri ) ) ;
		if( xInputStream.is() )
			return 1 ;
	}

	return 0 ;
}

void* xmlStreamOpen( const char* uri )
{
	::com::sun::star::uno::Reference< com::sun::star::io::XInputStream > xInputStream ;
	::com::sun::star::io::XInputStream* pInputStream ;

	if( ( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) &&
		( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		if( uri == NULL || !m_xUriBinding.is() )
			return NULL ;

		xInputStream = m_xUriBinding->getUriBinding( ::rtl::OUString::createFromAscii( uri ) ) ;
		if( xInputStream.is() ) {
			pInputStream = xInputStream.get() ;
			pInputStream->acquire() ;
			return ( void* )pInputStream ;
		}
	}

	return NULL ;
}

int xmlStreamRead( void* context, char* buffer, int len )
{
	int numbers ;
	::com::sun::star::uno::Reference< com::sun::star::io::XInputStream > xInputStream ;
	::com::sun::star::uno::Sequence< sal_Int8 > outSeqs( len ) ;

	numbers = 0 ;
	if( ( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) &&
		( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		if( context != NULL ) {
			xInputStream = ( com::sun::star::io::XInputStream* )context ;
			if( !xInputStream.is() )
				return 0 ;

			numbers = xInputStream->readBytes( outSeqs, len ) ;
			const sal_Int8* readBytes = ( const sal_Int8* )outSeqs.getArray() ;
			for( int i = 0 ; i < numbers ; i ++ )
				*( buffer + i ) = *( readBytes + i ) ;
		}
	}

	return numbers ;
}

int xmlStreamClose( void * context )
{
	::com::sun::star::io::XInputStream* pInputStream ;

	if( ( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) &&
		( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		if( context != NULL ) {
			pInputStream = ( ::com::sun::star::io::XInputStream* )context ;
			pInputStream->release() ;
		}
	}

	return 0 ;
}

int xmlEnableStreamInputCallbacks()
{
	int cbs = 0 ;

	if( !( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) ) {
		//Register the callbacks into libxml2
		//cbs = xmlRegisterInputCallbacks(
		//			xmlStreamMatch,
		//			xmlStreamOpen,
		//			xmlStreamRead,
		//			xmlStreamClose ) ;
		//if( cbs < 0 ) {
		//	return -1 ;
		//}

		//Register the callbacks into xmlSec
		//In order to make the xmlsec io finding the callbacks firstly,
		//I put the callbacks at the very begining.

		//Cleanup the older callbacks.
		//Notes: all none default callbacks will lose.
		xmlSecIOCleanupCallbacks() ;

		//Register my classbacks.
		cbs = xmlSecIORegisterCallbacks(
					xmlStreamMatch,
					xmlStreamOpen,
					xmlStreamRead,
					xmlStreamClose ) ;
		if( cbs < 0 ) {
			return -1 ;
		}

		//Register the default callbacks.
		//Notes: the error will cause xmlsec working problems.
		cbs = xmlSecIORegisterDefaultCallbacks() ;
		if( cbs < 0 ) {
			return -1 ;
		}

		enableXmlStreamIO |= XMLSTREAMIO_INITIALIZED ;
	}

	return 0 ;
}

int xmlRegisterStreamInputCallbacks(
	::com::sun::star::uno::Reference< ::com::sun::star::xml::crypto::XUriBinding >& aUriBinding
) {
	if( !( enableXmlStreamIO & XMLSTREAMIO_INITIALIZED ) ) {
		if( xmlEnableStreamInputCallbacks() < 0 )
			return -1 ;
	}

	if( !( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		enableXmlStreamIO |= XMLSTREAMIO_REGISTERED ;
	}

	m_xUriBinding = aUriBinding ;

	return 0 ;
}

int xmlUnregisterStreamInputCallbacks( void )
{
	if( ( enableXmlStreamIO & XMLSTREAMIO_REGISTERED ) ) {
		//Clear the uir-stream binding
		m_xUriBinding.clear() ;

		//disable the registered flag
		enableXmlStreamIO &= ~XMLSTREAMIO_REGISTERED ;
	}

	return 0 ;
}

void xmlDisableStreamInputCallbacks() {
	xmlUnregisterStreamInputCallbacks() ;
	enableXmlStreamIO &= ~XMLSTREAMIO_INITIALIZED ;
}

