/*************************************************************************
 *
 *	$RCSfile: testtool.cxx,v $
 *
 *	$Revision: 1.1.1.1 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/12 13:15:30 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <string.h>

#include <rtl/ustring.hxx>
#include <cppuhelper/bootstrap.hxx>
#include <cppuhelper/servicefactory.hxx>
#include <com/sun/star/bridge/XUnoUrlResolver.hpp>
#include <com/sun/star/registry/XImplementationRegistration.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/lang/XMultiComponentFactory.hpp>

#include <iostream>
#include <fstream>

#include <com/sun/star/xml/crypto/eval/XXMLSecTester.hpp>

#define RTL_ASCII_USTRINGPARAM( asciiStr ) \
asciiStr, strlen( asciiStr ), RTL_TEXTENCODING_ASCII_US

namespace cssu = com::sun::star::uno;
namespace cssl = com::sun::star::lang;
namespace cssb = com::sun::star::beans;
namespace cssxc = com::sun::star::xml::crypto;

const sal_Char* UNO_Connection_Url = 
	"uno:socket,host=localhost,port=2002;urp;StarOffice.ServiceManager";

cssu::Reference< cssl::XMultiComponentFactory > getServiceManager(
	cssu::Reference< cssu::XComponentContext >& xContext )
{
	cssu::Reference< com::sun::star::registry::XSimpleRegistry > xSimpleRegistry(
		::cppu::createSimpleRegistry() );
	
	/*
	 * Connects the registry to a persistent data source represented by an URL. 
	 */
	xSimpleRegistry->open( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
		"services.rdb") ), sal_True, sal_False );
	
	cssu::Reference< cssu::XComponentContext > rComponentContext(
		::cppu::bootstrap_InitialComponentContext( xSimpleRegistry ) );
	
	/*
	 * retrieve the service manager from the context
	 */
	cssu::Reference< cssl::XMultiComponentFactory > rServiceManager =
		rComponentContext->getServiceManager();
		
	/*
	 * instantiate a sample service with the service manager.
	 */
	cssu::Reference< cssu::XInterface > rInstance =
		rServiceManager->createInstanceWithContext(
			rtl::OUString::createFromAscii("com.sun.star.bridge.UnoUrlResolver" ),
			rComponentContext );
			
	/*
	 * Query for the com::sun::star::bridge::XUnoUrlResolver interface
	 */
	cssu::Reference< com::sun::star::bridge::XUnoUrlResolver > xUnoUrlResolver( rInstance, cssu::UNO_QUERY );
	
	/*
	 * Second step: use xUrlResolver interface to import the remote 
	 * StarOffice.ServiceManager,
	 * retrieve its property DefaultContext and get the remote servicemanager
	 */
	cssu::Reference< cssu::XInterface > initialObject = xUnoUrlResolver->resolve( 
		rtl::OUString::createFromAscii( UNO_Connection_Url ) );
	
	cssu::Reference< cssb::XPropertySet > xPropertySet( initialObject , cssu::UNO_QUERY );
	
	cssu::Reference< cssu::XComponentContext > xUsedComponentContext = NULL ;
	xPropertySet->getPropertyValue( 
		rtl::OUString::createFromAscii( "DefaultContext" ) ) >>= 
		xUsedComponentContext;

	xContext = xUsedComponentContext;	
	return xContext->getServiceManager();
}

/*
 * Get the length of a file in a platform independant fashion
 */
int getLength(const char *pInputFileName)
{
	int nSize = 0;
	std::ifstream data(pInputFileName);

	data.seekg(0, std::ios_base::end);
	nSize = data.tellg();

	return nSize;
}

void outputHeader()
{
	fprintf(stderr, "%16s%4s%8s%12s%12s%12s%12s\n", "File Name", "E/I", "Size", "-C++", "-Java", "Forw-O", "No S/E");
	fprintf(stderr, "===============================================================================\n");
}

/*
 * print the output on the screen as well as in the GNUPlot data file
 */
void output(const rtl::OUString& ouInputFileName, 
	const rtl::OUString& ouTime_C, 
	const rtl::OUString& ouTime_Java,
	const rtl::OUString& ouTime_NoSecurity,
	const rtl::OUString& ouTime_JavaForwardOnly,
	const rtl::OUString& ouRemark_C,
	const rtl::OUString& ouRemark_Java,
	bool bIsExporting)
{
	int nSize = getLength(rtl::OString(ouInputFileName, ouInputFileName.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	std::ofstream data;

	/* print screen */
	int nPosition = ouInputFileName.lastIndexOf('\\');
	rtl::OUString fileName = ouInputFileName.copy(nPosition + 1);

	fprintf(stderr, "%16s", rtl::OString(fileName, fileName.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());

	fprintf(stderr, "%4s", bIsExporting?"E":"I");
	fprintf(stderr, "%7dK", nSize/1024);
	fprintf(stderr, "%8s %3s", 
		rtl::OString(ouTime_C, ouTime_C.getLength(), RTL_TEXTENCODING_ASCII_US).getStr(),
		rtl::OString(ouRemark_C, ouRemark_C.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	fprintf(stderr, "%8s %3s", 
		rtl::OString(ouTime_Java, ouTime_Java.getLength(), RTL_TEXTENCODING_ASCII_US).getStr(),
		rtl::OString(ouRemark_Java, ouRemark_Java.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	fprintf(stderr, "%12s", rtl::OString(ouTime_JavaForwardOnly, ouTime_JavaForwardOnly.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	fprintf(stderr, "%12s", rtl::OString(ouTime_NoSecurity, ouTime_NoSecurity.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	fprintf(stderr, "\n");
	
	/* output the data as GNUPlot data file */
	/*
	char str[32];
	sprintf(str, "%d %s", nSize, rtl::OString(ouTime_C, ouTime_C.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	data.open("d:\\time_vs_size.txt", std::ios::app);
	data <<  str << std::endl;
	data.close();

	sprintf(str, "%d %s", nSize, rtl::OString(ouTime_Java, ouTime_Java.getLength(), RTL_TEXTENCODING_ASCII_US).getStr());
	data.open("d:\\time_vs_size_without_sec.txt", std::ios::app);
	data <<  str << std::endl;
	data.close();
	*/
}

int main( int argc, char **argv )
{
	if (argc != 5) 
	{
		fprintf(stderr, "Usage: testtool [javacryptodir] [ccryptodir] [exportbatchfile] [importbatchfile]\n");
	}

	try 
	{
		cssu::Reference< cssu::XComponentContext > xContext = NULL;
		
		/*
		 * create the service manager on the registry services.rdb
		 */
		cssu::Reference< cssl::XMultiComponentFactory > rServiceManager = 
			getServiceManager( xContext );
	
		cssu::Reference< cssu::XInterface > xTester =
			rServiceManager->createInstanceWithContext( 
				rtl::OUString::createFromAscii("com.sun.star.xml.crypto.eval.XSecTester"),
				xContext );

		cssu::Reference< cssxc::eval::XXMLSecTester > rTester(xTester, cssu::UNO_QUERY);
		
		rTester->setCryptoDir( rtl::OUString::createFromAscii(argv[1]), rtl::OUString::createFromAscii(argv[2]));
		
		rtl::OUString ouTime_C, ouTime_Java, ouTime_NoSecurity, ouTime_JavaForwardOnly;
		rtl::OUString ouInputFileName;
		rtl::OUString outputFileName1;
		rtl::OUString outputFileName2;
		rtl::OUString ouRemark_C, ouRemark_Java;

		outputHeader();

		std::ifstream batch_export, batch_import;

		batch_export.open(argv[3]);

		const int MAX_LINE = 80;
		char line[MAX_LINE + 1];
		
		while (batch_export.getline(line, MAX_LINE)) 
		{
			ouInputFileName = rtl::OUString::createFromAscii(line);
			int nPosition = ouInputFileName.lastIndexOf('.');
			int nPosition1;
			
			/*
			 * export the file with signautre/encryption (C++)
			 */
			outputFileName1 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-ex.xml");
			ouTime_C = rTester->export_xml(ouInputFileName, outputFileName1, sal_False);
			nPosition1 = ouTime_C.lastIndexOf('\t');
			ouRemark_C = ouTime_C.copy(nPosition1 + 1);
			ouTime_C = ouTime_C.copy(0, nPosition1);

			/*
			 * export the file with signautre/encryption (Java)
			 */
			outputFileName1 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-ex2.xml");
			ouTime_Java = rTester->export_xml(ouInputFileName, outputFileName1, sal_True);
			nPosition1 = ouTime_Java.lastIndexOf('\t');
			ouRemark_Java = ouTime_Java.copy(nPosition1 + 1);
			ouTime_Java = ouTime_Java.copy(0, nPosition1);
			
			/*
			 * export the file without signautre/encryption
			 */
			outputFileName2 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-ex-no.xml");
			ouTime_NoSecurity = rTester->transfer_without_sec(ouInputFileName, outputFileName2, sal_False);

			/*
			 * export the file with Java Flat Filter
			 */
			outputFileName2 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-ex-jf.xml");
			ouTime_JavaForwardOnly = rTester->transfer_without_sec(ouInputFileName, outputFileName2, sal_True);
			
			/*
			 * print output
			 */
			output(ouInputFileName, ouTime_C, ouTime_Java, ouTime_NoSecurity, ouTime_JavaForwardOnly, ouRemark_C, ouRemark_Java, true);
		}

		batch_export.close();

		batch_import.open(argv[4]);

		while (batch_import.getline(line, MAX_LINE)) 
		{
			ouInputFileName = rtl::OUString::createFromAscii(line);
			int nPosition = ouInputFileName.lastIndexOf('.');
			int nPosition1;
			
			/*
			 * import the file with signautre/encryption (C++)
			 */
			outputFileName1 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-im.xml");
			ouTime_C = rTester->import_xml(ouInputFileName, outputFileName1, sal_False);
			nPosition1 = ouTime_C.lastIndexOf('\t');
			ouRemark_C = ouTime_C.copy(nPosition1 + 1);
			ouTime_C = ouTime_C.copy(0, nPosition1);

			/*
			 * import the file with signautre/encryption (Java)
			 */
			outputFileName1 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-im2.xml");
			ouTime_Java = rTester->import_xml(ouInputFileName, outputFileName1, sal_True);
			nPosition1 = ouTime_Java.lastIndexOf('\t');
			ouRemark_Java = ouTime_Java.copy(nPosition1 + 1);
			ouTime_Java = ouTime_Java.copy(0, nPosition1);

			/*
			 * import the file without signautre/encryption
			 */
			outputFileName2 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-im-no.xml");
			ouTime_NoSecurity = rTester->transfer_without_sec(ouInputFileName, outputFileName2, sal_False);

			/*
			 * import the file without signautre/encryption
			 */
			outputFileName2 = ouInputFileName.copy(0, nPosition) + 
				rtl::OUString::createFromAscii("-im-jf.xml");
			ouTime_JavaForwardOnly = rTester->transfer_without_sec(ouInputFileName, outputFileName2, sal_True);
			
			/*
			 * print output
			 */
			output(ouInputFileName, ouTime_C, ouTime_Java, ouTime_NoSecurity, ouTime_JavaForwardOnly, ouRemark_C, ouRemark_Java, false);
		}

		batch_import.close();

		fprintf(stderr, "\n");
	}
	catch( cssu::Exception& e ) 
	{
		fprintf( stderr , "\nError Message: %s\n" , 
				 rtl::OUStringToOString( e.Message, RTL_TEXTENCODING_ASCII_US ).getStr() ) ;
	}

	return 0;
}
