import os
import orpg.pluginhandler
import orpg.dirpath

class Plugin(orpg.pluginhandler.PluginHandler):
    # Initialization subroutine.
    #
    # !self : instance of self
    # !chat : instance of the chat window to write to
    def __init__(self, openrpg, plugindb, parent):
        orpg.pluginhandler.PluginHandler.__init__(self, openrpg, plugindb, parent)

        # The Following code should be edited to contain the proper information
        self.name = 'Smilies!'
        self.author = 'mDuo13'
        self.help = "This plugin turns text smilies like >=) or :D into images. There are 15\n"
        self.help += "images. Also, you can type '/smiley' to get a list of what emoticons are\n"
        self.help += "converted to what images."

        self.smileylist = {}

    def plugin_enabled(self):
        #This is where you set any variables that need to be initalized when your plugin starts

        self.plugin_addcommand('/smiley', self.on_smiley, '- The Smiley command')

        self.smileylist={
                    ">:-("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
                    ">:("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
                    ">=("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
                    "=)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
                    "=D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
                    "8)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
                    ";)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley3.gif'> ",
                    "=/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
                    "=|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
                    "=("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
                    ":)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
                    ":D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
                    "B)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
                    ":p"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
                    ":/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
                    ":|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
                    ":("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
                    ":\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
                    "=\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
                    ":P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
                    "=P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
                    "^_^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "^-^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "^.^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "n_n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "n.n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "n,n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
                    "I-)"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley13.gif'> ",
                    "n.n;"  :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
                    "n.n;;" :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
                    "n_n;"  :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
                    ":-)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
                    ":-D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
                    ":-P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
                    ":-p"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
                    ":-/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
                    ":-|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
                    ":-("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
                    ":-\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> "}

    def plugin_disabled(self):
        #Here you need to remove any commands you added, and anything else you want to happen when you disable the plugin
        #such as closing windows created by the plugin

        self.plugin_removecmd('/smiley')

    def on_smiley(self, cmdargs):
        #this is just an example function for a command you create create your own
        self.chat.Post("Available Smilies:", 0)
        the_list = ""
        for key in self.smileylist.keys():
            the_list += key+"&nbsp&nbsp&nbsp : &nbsp&nbsp&nbsp" + self.smileylist[key] + "<br />"
        self.chat.Post(the_list)

    def post_msg(self, text, myself):
        text = text.replace("> ", ">&nbsp;")
        text = text.replace(" <", "&nbsp<")
        text = text.replace("<", " %%<")
        text = text.replace(">", ">%% ")
        text = text.replace(" >%% ", " >")
        text2 = text.split()
        for num in range(0, len(text2)):
            chunk = text2[num]
            for key in self.smileylist.keys():
                if chunk == key:
                    text2[num] = self.smileylist[key]
                if chunk == key + ",":
                    text2[num] = self.smileylist[key] + ","
                if chunk == key + ".":
                    text2[num] = self.smileylist[key] + "."
        text = ""
        for chunk in text2:
            text += chunk + " "
        text = text.replace("%% %%", "%%  %%")
        text = text.replace(" %%<", "<")
        text = text.replace(">%% ", ">")
        if text[:2] == "%%":
            text = text[2:]
        if text[-2:] == "%%":
            text = text[:-2]
        return text
