import os
import re
import string
import orpg.pluginhandler

class Plugin(orpg.pluginhandler.PluginHandler):
    # Initialization subroutine.
    #
    # !self : instance of self
    # !chat : instance of the chat window to write to
    def __init__(self, openrpg, plugindb, parent):
        orpg.pluginhandler.PluginHandler.__init__(self, openrpg, plugindb, parent)

        # The Following code should be edited to contain the proper information
        self.name = 'SRD Auto Linker'
        self.author = 'Digitalxero, Ulf'
        self.help = "This plugin automatically Links words to the proper section of the Online SRD"
        baseURL = 'http://d20srd.org/srd/'
        self.checklist = {

            # Skills
            'appraise':                         baseURL + "skills/appraise.htm",
            'autohypnosis':                     baseURL + "psionic/skills/autohypnosis.htm",
            'balance':                          baseURL + "skills/balance.htm",
            'bluff':                            baseURL + "skills/bluff.htm",
            'climb':                            baseURL + "skills/climb.htm",
            'concentration':                    baseURL + "skills/concentration.htm",
            'craft':                            baseURL + "skills/craft.htm",
            'decipher script':                  baseURL + "skills/decipherScript.htm",
            'diplomacy':                        baseURL + "skills/diplomacy.htm",
            'disable device':                   baseURL + "skills/disableDevice.htm",
            'disguise':                         baseURL + "skills/disguise.htm",
            'escape artist':                    baseURL + "skills/escapeArtist.htm",
            'forgery':                          baseURL + "skills/forgery.htm",
            'gather information':               baseURL + "skills/gatherInformation.htm",
            'handle animal':                    baseURL + "skills/handleAnimal.htm",
            'heal':                             baseURL + "skills/heal.htm",
            'hide':                             baseURL + "skills/hide.htm",
            'intimidate':                       baseURL + "skills/intimidate.htm",
            'jump':                             baseURL + "skills/jump.htm",
            'knowledge':                        baseURL + "skills/knowledge.htm",
            'listen':                           baseURL + "skills/listen.htm",
            'move silently':                    baseURL + "skills/moveSilently.htm",
            'open lock':                        baseURL + "skills/openLock.htm",
            'perform':                          baseURL + "skills/perform.htm",
            'profession':                       baseURL + "skills/profession.htm",
            'ride':                             baseURL + "skills/ride.htm",
            'search':                           baseURL + "skills/search.htm",
            'sense motive':                     baseURL + "skills/senseMotive.htm",
            'sleight of hand':                  baseURL + "skills/sleightOfHand.htm",
            'speak language':                   baseURL + "skills/speakLanguage.htm",
            'spellcraft':                       baseURL + "skills/spellcraft.htm",
            'spot':                             baseURL + "skills/spot.htm",
            'survival':                         baseURL + "skills/survival.htm",
            'swim':                             baseURL + "skills/swim.htm",
            'tumble':                           baseURL + "skills/tumble.htm",
            'use magic device':                 baseURL + "skills/useMagicDevice.htm",
            'use rope':                         baseURL + "skills/useRope.htm",

            # Feats
            'acrobatic':                        baseURL + 'feats.htm#acrobatic',
            'agile':                            baseURL + 'feats.htm#agile',
            'alertness':                        baseURL + 'feats.htm#alertness',
            'animal affinity':                  baseURL + 'feats.htm#animalAffinity',
            'armor proficiency (heavy)':        baseURL + 'feats.htm#armorProficiencyHeavy',
            'armor proficiency (light)':        baseURL + 'feats.htm#armorProficiencyLight',
            'armor proficiency (medium)':       baseURL + 'feats.htm#armorProficiencyMedium',
            'armor proficiency':                baseURL + 'feats.htm#armorProficiencyLight',
            'athletic':                         baseURL + 'feats.htm#athletic',
            'augment summoning':                baseURL + 'feats.htm#augmentSummoning',
            'blind-fight':                      baseURL + 'feats.htm#blindFight',
            'brew potion':                      baseURL + 'feats.htm#brewPotion',
            'cleave':                           baseURL + 'feats.htm#cleave',
            'combat casting':                   baseURL + 'feats.htm#combatCasting',
            'combat expertise':                 baseURL + 'feats.htm#combatExpertise',
            'combat reflexes':                  baseURL + 'feats.htm#combatReflexes',
            'craft magic arms and armor':       baseURL + 'feats.htm#craftMagicArmsAndArmor',
            'craft rod':                        baseURL + 'feats.htm#craftRod',
            'craft staff':                      baseURL + 'feats.htm#craftStaff',
            'craft wand':                       baseURL + 'feats.htm#craftWand',
            'craft wondrous item':              baseURL + 'feats.htm#craftWondrousItem',
            'deceitful':                        baseURL + 'feats.htm#deceitful',
            'deflect arrows':                   baseURL + 'feats.htm#deflectArrows',
            'deft hands':                       baseURL + 'feats.htm#deftHands',
            'diehard':                          baseURL + 'feats.htm#diehard',
            'diligent':                         baseURL + 'feats.htm#diligent',
            'dodge':                            baseURL + 'feats.htm#dodge',
            'empower spell':                    baseURL + 'feats.htm#empowerSpell',
            'endurance':                        baseURL + 'feats.htm#endurance',
            'enlarge spell':                    baseURL + 'feats.htm#enlargeSpell',
            'eschew materials':                 baseURL + 'feats.htm#eschewMaterials',
            'exotic weapon proficiency':        baseURL + 'feats.htm#exoticWeaponProficiency',
            'extend spell':                     baseURL + 'feats.htm#extendSpell',
            'extra turning':                    baseURL + 'feats.htm#extraTurning',
            'far shot':                         baseURL + 'feats.htm#farShot',
            'forge ring':                       baseURL + 'feats.htm#forgeRing',
            'great cleave':                     baseURL + 'feats.htm#greatCleave',
            'great fortitude':                  baseURL + 'feats.htm#greatFortitude',
            'greater spell focus':              baseURL + 'feats.htm#greaterSpellFocus',
            'greater spell penetration':        baseURL + 'feats.htm#greaterSpellPenetration',
            'greater two-weapon fighting':      baseURL + 'feats.htm#greaterTwoWeaponFighting',
            'greater weapon focus':             baseURL + 'feats.htm#greaterWeaponFocus',
            'greater weapon specialization':    baseURL + 'feats.htm#greaterWeaponSpecialization',
            'heighten spell':                   baseURL + 'feats.htm#heightenSpell',
            'improved bull rush':               baseURL + 'feats.htm#improvedBullRush',
            'improved counterspell':            baseURL + 'feats.htm#improvedCounterspell',
            'improved critical':                baseURL + 'feats.htm#improvedCritical',
            'improved disarm':                  baseURL + 'feats.htm#improvedDisarm',
            'improved familiar':                baseURL + 'feats.htm#improvedFamiliar',
            'improved feint':                   baseURL + 'feats.htm#improvedFeint',
            'improved grapple':                 baseURL + 'feats.htm#improvedGrapple',
            'improved initiative':              baseURL + 'feats.htm#improvedInitiative',
            'improved overrun':                 baseURL + 'feats.htm#improvedOverrun',
            'improved precise shot':            baseURL + 'feats.htm#improvedPreciseShot',
            'improved shield bash':             baseURL + 'feats.htm#improvedShieldBash',
            'improved sunder':                  baseURL + 'feats.htm#improvedSunder',
            'improved trip':                    baseURL + 'feats.htm#improvedTrip',
            'improved turning':                 baseURL + 'feats.htm#improvedTurning',
            'improved two-weapon fighting':     baseURL + 'feats.htm#improvedTwoWeaponFighting',
            'improved unarmed strike':          baseURL + 'feats.htm#improvedUnarmedStrike',
            'investigator':                     baseURL + 'feats.htm#investigator',
            'iron will':                        baseURL + 'feats.htm#ironWill',
            'leadership':                       baseURL + 'feats.htm#leadership',
            'lightning reflexes':               baseURL + 'feats.htm#lightningReflexes',
            'magical aptitude':                 baseURL + 'feats.htm#magicalAptitude',
            'manyshot':                         baseURL + 'feats.htm#manyshot',
            'martial weapon proficiency':       baseURL + 'feats.htm#martialWeaponProficiency',
            'maximize spell':                   baseURL + 'feats.htm#maximizeSpell',
            'mobility':                         baseURL + 'feats.htm#mobility',
            'mounted archery':                  baseURL + 'feats.htm#mountedArchery',
            'mounted combat':                   baseURL + 'feats.htm#mountedCombat',
            'natural spell':                    baseURL + 'feats.htm#naturalSpell',
            'negotiator':                       baseURL + 'feats.htm#negotiator',
            'nimble fingers':                   baseURL + 'feats.htm#nimbleFingers',
            'persuasive':                       baseURL + 'feats.htm#persuasive',
            'point blank shot':                 baseURL + 'feats.htm#pointBlankShot',
            'power attack':                     baseURL + 'feats.htm#powerAttack',
            'precise shot':                     baseURL + 'feats.htm#preciseShot',
            'quick draw':                       baseURL + 'feats.htm#quickDraw',
            'quicken spell':                    baseURL + 'feats.htm#quickenSpell',
            'rapid reload':                     baseURL + 'feats.htm#rapidReload',
            'rapid shot':                       baseURL + 'feats.htm#rapidShot',
            'ride-by attack':                   baseURL + 'feats.htm#rideByAttack',
            'run':                              baseURL + 'feats.htm#run',
            'scribe scroll':                    baseURL + 'feats.htm#scribeScroll',
            'self-sufficient':                  baseURL + 'feats.htm#selfSufficient',
            'shield proficiency':               baseURL + 'feats.htm#shieldProficiency',
            'shot on the run':                  baseURL + 'feats.htm#shotOnTheRun',
            'silent spell':                     baseURL + 'feats.htm#silentSpell',
            'simple weapon proficiency':        baseURL + 'feats.htm#simpleWeaponProficiency',
            'skill focus':                      baseURL + 'feats.htm#skillFocus',
            'snatch arrows':                    baseURL + 'feats.htm#snatchArrows',
            'spell focus':                      baseURL + 'feats.htm#spellFocus',
            'spell mastery':                    baseURL + 'feats.htm#spellMasterySpecial',
            'spell penetration':                baseURL + 'feats.htm#spellPenetration',
            'spirited charge':                  baseURL + 'feats.htm#spiritedCharge',
            'spring attack':                    baseURL + 'feats.htm#springAttack',
            'stealthy':                         baseURL + 'feats.htm#stealthy',
            'still spell':                      baseURL + 'feats.htm#stillSpell',
            'stunning fist':                    baseURL + 'feats.htm#stunningFist',
            'toughness':                        baseURL + 'feats.htm#toughness',
            'tower shield proficiency':         baseURL + 'feats.htm#towerShieldProficiency',
            'track':                            baseURL + 'feats.htm#track',
            'trample':                          baseURL + 'feats.htm#trample',
            'two-weapon defense':               baseURL + 'feats.htm#twoWeaponDefense',
            'two-weapon fighting':              baseURL + 'feats.htm#twoWeaponFighting',
            'weapon finesse':                   baseURL + 'feats.htm#weaponFinesse',
            'weapon focus':                     baseURL + 'feats.htm#weaponFocus',
            'weapon specialization':            baseURL + 'feats.htm#weaponSpecialization',
            'whirlwind attack':                 baseURL + 'feats.htm#whirlwindAttack',
            'widen spell':                      baseURL + 'feats.htm#widenSpell',

            # Druid special abilities.
            'animal companion' :                baseURL + "classes/druid.htm#animalCompanion",
            'wild empathy'     :                baseURL + "classes/druid.htm#wildEmpathy",
            'woodland stride'  :                baseURL + "classes/druid.htm#woodlandStride",
            'nature sense'     :                baseURL + "classes/druid.htm#natureSense",
            'trackless step'   :                baseURL + "classes/druid.htm#tracklessStep",
            "resist nature's lure":             baseURL + "classes/druid.htm#resistNaturesLure",
            'wild shape'       :                baseURL + "classes/druid.htm#wildShape",
            'venom immunity'   :                baseURL + "classes/druid.htm#venomImmunity",
            'a thousand faces' :                baseURL + "classes/druid.htm#aThousandFaces",
            'timeless body'    :                baseURL + "classes/druid.htm#druidTimelessBody",

            # Animal companion abilities.
            'link'             :                baseURL + "classes/druid.htm#link",
            'share spells'     :                baseURL + "classes/druid.htm#shareSpells",
            'devotion'         :                baseURL + "classes/druid.htm#devotion",
            'multiattack'      :                baseURL + "classes/druid.htm#multiattack",

            # Ranger special abilities.
            'wild empathy'     :                baseURL + "classes/ranger.htm#wildEmpathy",
            'favored enemy'    :                baseURL + "classes/ranger.htm#favoredEnemy",
            'combat style'     :                baseURL + "classes/ranger.htm#combatStyle",
            'animal companion' :                baseURL + "classes/druid.htm#animalCompanion",
            'improved combat style':            baseURL + "classes/ranger.htm#improvedCombatStyle",
            'woodland stride'  :                baseURL + "classes/ranger.htm#woodlandStride",
            'swift tracker'    :                baseURL + "classes/ranger.htm#swiftTracker",
            'combat style mastery':             baseURL + "classes/ranger.htm#combatStyleMastery",
            'camouflage'       :                baseURL + "classes/ranger.htm#camouflage",
            'hide in plain sight':              baseURL + "classes/ranger.htm#hideinPlainSight",

            # Rogue special abilities.
            'sneak attack'     :                baseURL + "classes/rogue.htm#sneakAttack",
            'trapfinding'      :                baseURL + "classes/rogue.htm#trapfinding",
            'trap sense'       :                baseURL + "classes/rogue.htm#trapSense",
            'uncanny dodge'    :                baseURL + "classes/rogue.htm#uncannyDodge",
            'improved uncanny dodge':           baseURL + "classes/rogue.htm#improvedUncannyDodge",

            # Wizard special abilities.
            'summon familiar'  :                baseURL + "classes/sorcererWizard.htm#wizardFamiliar",
            'scribe scroll'    :                baseURL + "classes/sorcererWizard.htm#scribeScroll",

            # Spells
            "acid arrow":                       baseURL + "spells/acidArrow.htm",
            "acid fog":                         baseURL + "spells/acidFog.htm",
            "acid splash":                      baseURL + "spells/acidSplash.htm",
            "aid":                              baseURL + "spells/aid.htm",
            "air walk":                         baseURL + "spells/airWalk.htm",
            "alarm":                            baseURL + "spells/alarm.htm",
            "align weapon":                     baseURL + "spells/alignWeapon.htm",
            "alter self":                       baseURL + "spells/alterSelf.htm",
            "analyze dweomer":                  baseURL + "spells/analyzeDweomer.htm",
            "animal growth":                    baseURL + "spells/animalGrowth.htm",
            "animal messenger":                 baseURL + "spells/animalMessenger.htm",
            "animal shapes":                    baseURL + "spells/animalShapes.htm",
            "animal trance":                    baseURL + "spells/animalTrance.htm",
            "animate dead":                     baseURL + "spells/animateDead.htm",
            "animate objects":                  baseURL + "spells/animateObjects.htm",
            "animate plants":                   baseURL + "spells/animatePlants.htm",
            "animate rope":                     baseURL + "spells/animateRope.htm",
            "antilife shell":                   baseURL + "spells/antilifeShell.htm",
            "antimagic field":                  baseURL + "spells/antimagicField.htm",
            "antipathy":                        baseURL + "spells/antipathy.htm",
            "antiplant shell":                  baseURL + "spells/antiplantShell.htm",
            "arcane eye":                       baseURL + "spells/arcaneEye.htm",
            "arcane lock":                      baseURL + "spells/arcaneLock.htm",
            "arcane mark":                      baseURL + "spells/arcaneMark.htm",
            "arcane sight":                     baseURL + "spells/arcaneSight.htm",
            "arcane sight, greater":            baseURL + "spells/arcaneSightGreater.htm",
            "astral projection":                baseURL + "spells/astralProjection.htm",
            "atonement":                        baseURL + "spells/atonement.htm",
            "augury":                           baseURL + "spells/augury.htm",
            "awaken":                           baseURL + "spells/awaken.htm",
            "baleful polymorph":                baseURL + "spells/balefulPolymorph.htm",
            "bane":                             baseURL + "spells/bane.htm",
            "banishment":                       baseURL + "spells/banishment.htm",
            "barkskin":                         baseURL + "spells/barkskin.htm",
            "bear's endurance":                 baseURL + "spells/bearsEndurance.htm",
            "bear's endurance, mass":           baseURL + "spells/bearsEnduranceMass.htm",
            "bestow curse":                     baseURL + "spells/bestowCurse.htm",
            "binding":                          baseURL + "spells/binding.htm",
            "black tentacles":                  baseURL + "spells/blackTentacles.htm",
            "blade barrier":                    baseURL + "spells/bladeBarrier.htm",
            "blasphemy":                        baseURL + "spells/blasphemy.htm",
            "bless":                            baseURL + "spells/bless.htm",
            "bless water":                      baseURL + "spells/blessWater.htm",
            "bless weapon":                     baseURL + "spells/blessWeapon.htm",
            "blight":                           baseURL + "spells/blight.htm",
            "blindness/deafness":               baseURL + "spells/blindnessDeafness.htm",
            "blink":                            baseURL + "spells/blink.htm",
            "blur":                             baseURL + "spells/blur.htm",
            "break enchantment":                baseURL + "spells/breakEnchantment.htm",
            "bull's strength":                  baseURL + "spells/bullsStrength.htm",
            "bull's strength, mass":            baseURL + "spells/bullsStrengthMass.htm",
            "burning hands":                    baseURL + "spells/burningHands.htm",
            "call lightning":                   baseURL + "spells/callLightning.htm",
            "call lightning storm":             baseURL + "spells/callLightningStorm.htm",
            "calm animals":                     baseURL + "spells/calmAnimals.htm",
            "calm emotions":                    baseURL + "spells/calmEmotions.htm",
            "cat's grace":                      baseURL + "spells/catsGrace.htm",
            "cat's grace, mass":                baseURL + "spells/catsGraceMass.htm",
            "cause fear":                       baseURL + "spells/causeFear.htm",
            "chain lightning":                  baseURL + "spells/chainLightning.htm",
            "changestaff":                      baseURL + "spells/changestaff.htm",
            "chaos hammer":                     baseURL + "spells/chaosHammer.htm",
            "charm animal":                     baseURL + "spells/charmAnimal.htm",
            "charm monster":                    baseURL + "spells/charmMonster.htm",
            "charm monster, mass":              baseURL + "spells/charmMonsterMass.htm",
            "charm person":                     baseURL + "spells/charmPerson.htm",
            "chill metal":                      baseURL + "spells/chillMetal.htm",
            "chill touch":                      baseURL + "spells/chillTouch.htm",
            "circle of death":                  baseURL + "spells/circleofDeath.htm",
            "clairaudience/clairvoyance":       baseURL + "spells/clairaudienceClairvoyance.htm",
            "clenched fist":                    baseURL + "spells/clenchedFist.htm",
            "cloak of chaos":                   baseURL + "spells/cloakofChaos.htm",
            "clone":                            baseURL + "spells/clone.htm",
            "cloudkill":                        baseURL + "spells/cloudkill.htm",
            "color spray":                      baseURL + "spells/colorSpray.htm",
            "command":                          baseURL + "spells/command.htm",
            "command, greater":                 baseURL + "spells/commandGreater.htm",
            "command plants":                   baseURL + "spells/commandPlants.htm",
            "command undead":                   baseURL + "spells/commandUndead.htm",
            "commune":                          baseURL + "spells/commune.htm",
            "commune with nature":              baseURL + "spells/communewithNature.htm",
            "comprehend languages":             baseURL + "spells/comprehendLanguages.htm",
            "cone of cold":                     baseURL + "spells/coneofCold.htm",
            "confusion":                        baseURL + "spells/confusion.htm",
            "confusion, lesser":                baseURL + "spells/confusionLesser.htm",
            "consecrate":                       baseURL + "spells/consecrate.htm",
            "contact other plane":              baseURL + "spells/contactOtherPlane.htm",
            "contagion":                        baseURL + "spells/contagion.htm",
            "contingency":                      baseURL + "spells/contingency.htm",
            "continual flame":                  baseURL + "spells/continualFlame.htm",
            "control plants":                   baseURL + "spells/controlPlants.htm",
            "control undead":                   baseURL + "spells/controlUndead.htm",
            "control water":                    baseURL + "spells/controlWater.htm",
            "control weather":                  baseURL + "spells/controlWeather.htm",
            "control winds":                    baseURL + "spells/controlWinds.htm",
            "create food and water":            baseURL + "spells/createFoodandWater.htm",
            "create greater undead":            baseURL + "spells/createGreaterUndead.htm",
            "create undead":                    baseURL + "spells/createUndead.htm",
            "create water":                     baseURL + "spells/createWater.htm",
            "creeping doom":                    baseURL + "spells/creepingDoom.htm",
            "crushing despair":                 baseURL + "spells/crushingDespair.htm",
            "crushing hand":                    baseURL + "spells/crushingHand.htm",
            "cure critical wounds":             baseURL + "spells/cureCriticalWounds.htm",
            "cure critical wounds, mass":       baseURL + "spells/cureCriticalWoundsMass.htm",
            "cure light wounds":                baseURL + "spells/cureLightWounds.htm",
            "cure light wounds, mass":          baseURL + "spells/cureLightWoundsMass.htm",
            "cure minor wounds":                baseURL + "spells/cureMinorWounds.htm",
            "cure moderate wounds":             baseURL + "spells/cureModerateWounds.htm",
            "cure moderate wounds, mass":       baseURL + "spells/cureModerateWoundsMass.htm",
            "cure serious wounds":              baseURL + "spells/cureSeriousWounds.htm",
            "cure serious wounds, mass":        baseURL + "spells/cureSeriousWoundsMass.htm",
            "curse water":                      baseURL + "spells/curseWater.htm",
            "dancing lights":                   baseURL + "spells/dancingLights.htm",
            "darkness":                         baseURL + "spells/darkness.htm",
            "darkvision":                       baseURL + "spells/darkvision.htm",
            "daylight":                         baseURL + "spells/daylight.htm",
            "daze":                             baseURL + "spells/daze.htm",
            "daze monster":                     baseURL + "spells/dazeMonster.htm",
            "death knell":                      baseURL + "spells/deathKnell.htm",
            "death ward":                       baseURL + "spells/deathWard.htm",
            "deathwatch":                       baseURL + "spells/deathwatch.htm",
            "deep slumber":                     baseURL + "spells/deepSlumber.htm",
            "deeper darkness":                  baseURL + "spells/deeperDarkness.htm",
            "delay poison":                     baseURL + "spells/delayPoison.htm",
            "delayed blast fireball":           baseURL + "spells/delayedBlastFireball.htm",
            "demand":                           baseURL + "spells/demand.htm",
            "desecrate":                        baseURL + "spells/desecrate.htm",
            "destruction":                      baseURL + "spells/destruction.htm",
            "detect animals or plants":         baseURL + "spells/detectAnimalsorPlants.htm",
            "detect chaos":                     baseURL + "spells/detectChaos.htm",
            "detect evil":                      baseURL + "spells/detectEvil.htm",
            "detect good":                      baseURL + "spells/detectGood.htm",
            "detect law":                       baseURL + "spells/detectLaw.htm",
            "detect magic":                     baseURL + "spells/detectMagic.htm",
            "detect poison":                    baseURL + "spells/detectPoison.htm",
            "detect scrying":                   baseURL + "spells/detectScrying.htm",
            "detect secret doors":              baseURL + "spells/detectSecretDoors.htm",
            "detect snares and pits":           baseURL + "spells/detectSnaresandPits.htm",
            "detect thoughts":                  baseURL + "spells/detectThoughts.htm",
            "detect undead":                    baseURL + "spells/detectUndead.htm",
            "dictum":                           baseURL + "spells/dictum.htm",
            "dimension door":                   baseURL + "spells/dimensionDoor.htm",
            "dimensional anchor":               baseURL + "spells/dimensionalAnchor.htm",
            "dimensional lock":                 baseURL + "spells/dimensionalLock.htm",
            "diminish plants":                  baseURL + "spells/diminishPlants.htm",
            "discern lies":                     baseURL + "spells/discernLies.htm",
            "discern location":                 baseURL + "spells/discernLocation.htm",
            "disguise self":                    baseURL + "spells/disguiseSelf.htm",
            "disintegrate":                     baseURL + "spells/disintegrate.htm",
            "dismissal":                        baseURL + "spells/dismissal.htm",
            "dispel chaos":                     baseURL + "spells/dispelChaos.htm",
            "dispel evil":                      baseURL + "spells/dispelEvil.htm",
            "dispel good":                      baseURL + "spells/dispelGood.htm",
            "dispel law":                       baseURL + "spells/dispelLaw.htm",
            "dispel magic":                     baseURL + "spells/dispelMagic.htm",
            "dispel magic, greater":            baseURL + "spells/dispelMagicGreater.htm",
            "displacement":                     baseURL + "spells/displacement.htm",
            "disrupt undead":                   baseURL + "spells/disruptUndead.htm",
            "disrupting weapon":                baseURL + "spells/disruptingWeapon.htm",
            "divination":                          baseURL + "spells/divination.htm",
            "divine favor":                        baseURL + "spells/divineFavor.htm",
            "divine power":                        baseURL + "spells/divinePower.htm",
            "dominate animal":                     baseURL + "spells/dominateAnimal.htm",
            "dominate monster":                    baseURL + "spells/dominateMonster.htm",
            "dominate person":                     baseURL + "spells/dominatePerson.htm",
            "doom":                                baseURL + "spells/doom.htm",
            "dream":                               baseURL + "spells/dream.htm",
            "eagle's splendor":                    baseURL + "spells/eaglesSplendor.htm",
            "eagle's splendor, mass":              baseURL + "spells/eaglesSplendorMass.htm",
            "earthquake":                          baseURL + "spells/earthquake.htm",
            "elemental swarm":                     baseURL + "spells/elementalSwarm.htm",
            "endure elements":                     baseURL + "spells/endureElements.htm",
            "energy drain":                        baseURL + "spells/energyDrain.htm",
            "enervation":                          baseURL + "spells/enervation.htm",
            "enlarge person":                      baseURL + "spells/enlargePerson.htm",
            "enlarge person, mass":                baseURL + "spells/enlargePersonMass.htm",
            "entangle":                            baseURL + "spells/entangle.htm",
            "enthrall":                            baseURL + "spells/enthrall.htm",
            "entropic shield":                     baseURL + "spells/entropicShield.htm",
            "erase":                               baseURL + "spells/erase.htm",
            "ethereal jaunt":                      baseURL + "spells/etherealJaunt.htm",
            "etherealness":                        baseURL + "spells/etherealness.htm",
            "expeditious retreat":                 baseURL + "spells/expeditiousRetreat.htm",
            "explosive runes":                     baseURL + "spells/explosiveRunes.htm",
            "eyebite":                             baseURL + "spells/eyebite.htm",
            "fabricate":                           baseURL + "spells/fabricate.htm",
            "faerie fire":                         baseURL + "spells/faerieFire.htm",
            "false life":                          baseURL + "spells/falseLife.htm",
            "false vision":                        baseURL + "spells/falseVision.htm",
            "fear":                                baseURL + "spells/fear.htm",
            "feather fall":                        baseURL + "spells/featherFall.htm",
            "feeblemind":                          baseURL + "spells/feeblemind.htm",
            "find the path":                       baseURL + "spells/findthePath.htm",
            "find traps":                          baseURL + "spells/findTraps.htm",
            "finger of death":                     baseURL + "spells/fingerofDeath.htm",
            "fire seeds":                          baseURL + "spells/fireSeeds.htm",
            "fire shield":                         baseURL + "spells/fireShield.htm",
            "fire storm":                          baseURL + "spells/fireStorm.htm",
            "fire trap":                           baseURL + "spells/fireTrap.htm",
            "fireball":                            baseURL + "spells/fireball.htm",
            "flame arrow":                         baseURL + "spells/flameArrow.htm",
            "flame blade":                         baseURL + "spells/flameBlade.htm",
            "flame strike":                        baseURL + "spells/flameStrike.htm",
            "flaming sphere":                      baseURL + "spells/flamingSphere.htm",
            "flare":                               baseURL + "spells/flare.htm",
            "flesh to stone":                      baseURL + "spells/fleshtoStone.htm",
            "fly":                                 baseURL + "spells/fly.htm",
            "floating disk":                       baseURL + "spells/floatingDisk.htm",
            "fog cloud":                           baseURL + "spells/fogCloud.htm",
            "forbiddance":                         baseURL + "spells/forbiddance.htm",
            "forcecage":                           baseURL + "spells/forcecage.htm",
            "forceful hand":                       baseURL + "spells/forcefulHand.htm",
            "foresight":                           baseURL + "spells/foresight.htm",
            "fox's cunning":                       baseURL + "spells/foxsCunning.htm",
            "fox's cunning, mass":                 baseURL + "spells/foxsCunningMass.htm",
            "freedom":                             baseURL + "spells/freedom.htm",
            "freedom of movement":                 baseURL + "spells/freedomofMovement.htm",
            "freezing sphere":                     baseURL + "spells/freezingSphere.htm",
            "gaseous form":                        baseURL + "spells/gaseousForm.htm",
            "gate":                                baseURL + "spells/gate.htm",
            "geas/quest":                          baseURL + "spells/geasQuest.htm",
            "geas, lesser":                        baseURL + "spells/geasLesser.htm",
            "gentle repose":                       baseURL + "spells/gentleRepose.htm",
            "ghost sound":                         baseURL + "spells/ghostSound.htm",
            "ghoul touch":                         baseURL + "spells/ghoulTouch.htm",
            "giant vermin":                        baseURL + "spells/giantVermin.htm",
            "glibness":                            baseURL + "spells/glibness.htm",
            "glitterdust":                         baseURL + "spells/glitterdust.htm",
            "globe of invulnerability":            baseURL + "spells/globeofInvulnerability.htm",
            "globe of invulnerability, lesser":    baseURL + "spells/globeofInvulnerabilityLesser.htm",
            "glyph of warding":                    baseURL + "spells/glyphofWarding.htm",
            "glyph of warding, greater":           baseURL + "spells/glyphofWardingGreater.htm",
            "goodberry":                           baseURL + "spells/goodberry.htm",
            "good hope":                           baseURL + "spells/goodHope.htm",
            "grasping hand":                       baseURL + "spells/graspingHand.htm",
            "grease":                              baseURL + "spells/grease.htm",
            "greater (spell name)":                baseURL + "spells/greaterSpellName.htm",
            "guards and wards":                    baseURL + "spells/guardsandWards.htm",
            "guidance":                            baseURL + "spells/guidance.htm",
            "gust of wind":                        baseURL + "spells/gustofWind.htm",
            "hallow":                              baseURL + "spells/hallow.htm",
            "hallucinatory terrain":               baseURL + "spells/hallucinatoryTerrain.htm",
            "halt undead":                         baseURL + "spells/haltUndead.htm",
            "harm":                                baseURL + "spells/harm.htm",
            "haste":                               baseURL + "spells/haste.htm",
            "heal":                                baseURL + "spells/heal.htm",
            "heal, mass":                          baseURL + "spells/healMass.htm",
            "heal mount":                          baseURL + "spells/healMount.htm",
            "heat metal":                          baseURL + "spells/heatMetal.htm",
            "helping hand":                        baseURL + "spells/helpingHand.htm",
            "heroes' feast":                       baseURL + "spells/heroesFeast.htm",
            "heroism":                             baseURL + "spells/heroism.htm",
            "heroism, greater":                    baseURL + "spells/heroismGreater.htm",
            "hide from animals":                   baseURL + "spells/hidefromAnimals.htm",
            "hide from undead":                    baseURL + "spells/hidefromUndead.htm",
            "hideous laughter":                    baseURL + "spells/hideousLaughter.htm",
            "hold animal":                         baseURL + "spells/holdAnimal.htm",
            "hold monster":                        baseURL + "spells/holdMonster.htm",
            "hold monster, mass":                  baseURL + "spells/holdMonsterMass.htm",
            "hold person":                         baseURL + "spells/holdPerson.htm",
            "hold person, mass":                   baseURL + "spells/holdPersonMass.htm",
            "hold portal":                         baseURL + "spells/holdPortal.htm",
            "holy aura":                           baseURL + "spells/holyAura.htm",
            "holy smite":                          baseURL + "spells/holySmite.htm",
            "holy sword":                          baseURL + "spells/holySword.htm",
            "holy word":                           baseURL + "spells/holyWord.htm",
            "horrid wilting":                          baseURL + "spells/horridWilting.htm",
            "hypnotic pattern":                    baseURL + "spells/hypnoticPattern.htm",
            "hypnotism":                           baseURL + "spells/hypnotism.htm",
            "ice storm":                           baseURL + "spells/iceStorm.htm",
            "identify":                                baseURL + "spells/identify.htm",
            "illusory script":                     baseURL + "spells/illusoryScript.htm",
            "illusory wall":                       baseURL + "spells/illusoryWall.htm",
            "imbue with spell ability":        baseURL + "spells/imbuewithSpellAbility.htm",
            "implosion":                           baseURL + "spells/implosion.htm",
            "imprisonment":                        baseURL + "spells/imprisonment.htm",
            "incendiary cloud":                    baseURL + "spells/incendiaryCloud.htm",
            "inflict critical wounds":             baseURL + "spells/inflictCriticalWounds.htm",
            "inflict critical wounds, mass":    baseURL + "spells/inflictCriticalWoundsMass.htm",
            "inflict light wounds":                baseURL + "spells/inflictLightWounds.htm",
            "inflict light wounds, mass":          baseURL + "spells/inflictLightWoundsMass.htm",
            "inflict minor wounds":                baseURL + "spells/inflictMinorWounds.htm",
            "inflict moderate wounds":             baseURL + "spells/inflictModerateWounds.htm",
            "inflict moderate wounds, mass":    baseURL + "spells/inflictModerateWoundsMass.htm",
            "inflict serious wounds":              baseURL + "spells/inflictSeriousWounds.htm",
            "inflict serious wounds, mass":     baseURL + "spells/inflictSeriousWoundsMass.htm",
            "insanity":                                baseURL + "spells/insanity.htm",
            "insect plague":                       baseURL + "spells/insectPlague.htm",
            "instant summons":                     baseURL + "spells/instantSummons.htm",
            "interposing hand":                    baseURL + "spells/interposingHand.htm",
            "invisibility":                        baseURL + "spells/invisibility.htm",
            "invisibility, greater":           baseURL + "spells/invisibilityGreater.htm",
            "invisibility, mass":                  baseURL + "spells/invisibilityMass.htm",
            "invisibility purge":                  baseURL + "spells/invisibilityPurge.htm",
            "invisibility sphere":                 baseURL + "spells/invisibilitySphere.htm",
            "iron body":                           baseURL + "spells/ironBody.htm",
            "ironwood":                                baseURL + "spells/ironwood.htm",
            "irresistible dance":                  baseURL + "spells/irresistibleDance.htm",
            "jump":                                    baseURL + "spells/jump.htm",
            "keen edge":                           baseURL + "spells/keenEdge.htm",
            "knock":                                   baseURL + "spells/knock.htm",
            "know direction":                          baseURL + "spells/knowDirection.htm",
            "legend lore":                             baseURL + "spells/legendLore.htm",
            "lesser (spell name)":                 baseURL + "spells/lesserSpellName.htm",
            "levitate":                                baseURL + "spells/levitate.htm",
            "light":                                   baseURL + "spells/light.htm",
            "lightning bolt":                          baseURL + "spells/lightningBolt.htm",
            "limited wish":                        baseURL + "spells/limitedWish.htm",
            "liveoak":                                 baseURL + "spells/liveoak.htm",
            "locate creature":                     baseURL + "spells/locateCreature.htm",
            "locate object":                       baseURL + "spells/locateObject.htm",
            "longstrider":                             baseURL + "spells/longstrider.htm",
            "lullaby":                                 baseURL + "spells/lullaby.htm",
            "mage armor":                              baseURL + "spells/mageArmor.htm",
            "mage hand":                           baseURL + "spells/mageHand.htm",
            "mage's disjunction":                  baseURL + "spells/magesDisjunction.htm",
            "mage's faithful hound":           baseURL + "spells/magesFaithfulHound.htm",
            "mage's lucubration":                  baseURL + "spells/magesLucubration.htm",
            "mage's magnificent mansion":          baseURL + "spells/magesMagnificentMansion.htm",
            "mage's private sanctum":              baseURL + "spells/magesPrivateSanctum.htm",
            "mage's sword":                        baseURL + "spells/magesSword.htm",
            "magic aura":                              baseURL + "spells/magicAura.htm",
            "magic circle against chaos":          baseURL + "spells/magicCircleagainstChaos.htm",
            "magic circle against evil":       baseURL + "spells/magicCircleagainstEvil.htm",
            "magic circle against good":       baseURL + "spells/magicCircleagainstGood.htm",
            "magic circle against law":        baseURL + "spells/magicCircleagainstLaw.htm",
            "magic fang":                              baseURL + "spells/magicFang.htm",
            "magic fang, greater":                 baseURL + "spells/magicFangGreater.htm",
            "magic jar":                           baseURL + "spells/magicJar.htm",
            "magic missile":                       baseURL + "spells/magicMissile.htm",
            "magic mouth":                             baseURL + "spells/magicMouth.htm",
            "magic stone":                             baseURL + "spells/magicStone.htm",
            "magic vestment":                          baseURL + "spells/magicVestment.htm",
            "magic weapon":                        baseURL + "spells/magicWeapon.htm",
            "magic weapon, greater":           baseURL + "spells/magicWeaponGreater.htm",
            "major creation":                          baseURL + "spells/majorCreation.htm",
            "major image":                             baseURL + "spells/majorImage.htm",
            "make whole":                              baseURL + "spells/makeWhole.htm",
            "mark of justice":                     baseURL + "spells/markofJustice.htm",
            "mass (spell name)":                   baseURL + "spells/massSpellName.htm",
            "maze":                                    baseURL + "spells/maze.htm",
            "meld into stone":                     baseURL + "spells/meldintoStone.htm",
            "mending":                                 baseURL + "spells/mending.htm",
            "message":                                 baseURL + "spells/message.htm",
            "meteor swarm":                        baseURL + "spells/meteorSwarm.htm",
            "mind blank":                              baseURL + "spells/mindBlank.htm",
            "mind fog":                                baseURL + "spells/mindFog.htm",
            "minor creation":                          baseURL + "spells/minorCreation.htm",
            "minor image":                             baseURL + "spells/minorImage.htm",
            "miracle":                                 baseURL + "spells/miracle.htm",
            "mirage arcana":                       baseURL + "spells/mirageArcana.htm",
            "mirror image":                        baseURL + "spells/mirrorImage.htm",
            "misdirection":                        baseURL + "spells/misdirection.htm",
            "mislead":                                 baseURL + "spells/mislead.htm",
            "mnemonic enhancer":                   baseURL + "spells/mnemonicEnhancer.htm",
            "modify memory":                       baseURL + "spells/modifyMemory.htm",
            "moment of prescience":                baseURL + "spells/momentofPrescience.htm",
            "mount":                                   baseURL + "spells/mount.htm",
            "move earth":                              baseURL + "spells/moveEarth.htm",
            "neutralize poison":                   baseURL + "spells/neutralizePoison.htm",
            "nightmare":                           baseURL + "spells/nightmare.htm",
            "nondetection":                        baseURL + "spells/nondetection.htm",
            "obscure object":                          baseURL + "spells/obscureObject.htm",
            "obscuring mist":                          baseURL + "spells/obscuringMist.htm",
            "open/close":                              baseURL + "spells/openClose.htm",
            "order's wrath":                       baseURL + "spells/ordersWrath.htm",
            "overland flight":                     baseURL + "spells/overlandFlight.htm",
            "owl's wisdom":                        baseURL + "spells/owlsWisdom.htm",
            "owl's wisdom, mass":                  baseURL + "spells/owlsWisdomMass.htm",
            "passwall":                                baseURL + "spells/passwall.htm",
            "pass without trace":                  baseURL + "spells/passwithoutTrace.htm",
            "permanency":                              baseURL + "spells/permanency.htm",
            "permanent image":                     baseURL + "spells/permanentImage.htm",
            "persistent image":                    baseURL + "spells/persistentImage.htm",
            "phantasmal killer":                   baseURL + "spells/phantasmalKiller.htm",
            "phantom steed":                       baseURL + "spells/phantomSteed.htm",
            "phantom trap":                        baseURL + "spells/phantomTrap.htm",
            "phase door":                              baseURL + "spells/phaseDoor.htm",
            "planar ally":                             baseURL + "spells/planarAlly.htm",
            "planar ally, greater":                baseURL + "spells/planarAllyGreater.htm",
            "planar ally, lesser":                 baseURL + "spells/planarAllyLesser.htm",
            "planar binding":                          baseURL + "spells/planarBinding.htm",
            "planar binding, greater":             baseURL + "spells/planarBindingGreater.htm",
            "planar binding, lesser":              baseURL + "spells/planarBindingLesser.htm",
            "plane shift":                             baseURL + "spells/planeShift.htm",
            "plant growth":                        baseURL + "spells/plantGrowth.htm",
            "poison":                                  baseURL + "spells/poison.htm",
            "polar ray":                           baseURL + "spells/polarRay.htm",
            "polymorph":                           baseURL + "spells/polymorph.htm",
            "polymorph any object":                baseURL + "spells/polymorphAnyObject.htm",
            "power word blind":                    baseURL + "spells/powerWordBlind.htm",
            "power word kill":                     baseURL + "spells/powerWordKill.htm",
            "power word stun":                     baseURL + "spells/powerWordStun.htm",
            "prayer":                                  baseURL + "spells/prayer.htm",
            "prestidigitation":                    baseURL + "spells/prestidigitation.htm",
            "prismatic sphere":                    baseURL + "spells/prismaticSphere.htm",
            "prismatic spray":                     baseURL + "spells/prismaticSpray.htm",
            "prismatic wall":                          baseURL + "spells/prismaticWall.htm",
            "produce flame":                       baseURL + "spells/produceFlame.htm",
            "programmed image":                    baseURL + "spells/programmedImage.htm",
            "project image":                       baseURL + "spells/projectImage.htm",
            "protection from arrows":              baseURL + "spells/protectionfromArrows.htm",
            "protection from chaos":           baseURL + "spells/protectionfromChaos.htm",
            "protection from energy":              baseURL + "spells/protectionfromEnergy.htm",
            "protection from evil":                baseURL + "spells/protectionfromEvil.htm",
            "protection from good":                baseURL + "spells/protectionfromGood.htm",
            "protection from law":                 baseURL + "spells/protectionfromLaw.htm",
            "protection from spells":              baseURL + "spells/protectionfromSpells.htm",
            "prying eyes":                             baseURL + "spells/pryingEyes.htm",
            "prying eyes, greater":                baseURL + "spells/pryingEyesGreater.htm",
            "purify food and drink":           baseURL + "spells/purifyFoodandDrink.htm",
            "pyrotechnics":                        baseURL + "spells/pyrotechnics.htm",
            "quench":                                  baseURL + "spells/quench.htm",
            "rage":                                    baseURL + "spells/rage.htm",
            "rainbow pattern":                     baseURL + "spells/rainbowPattern.htm",
            "raise dead":                              baseURL + "spells/raiseDead.htm",
            "ray of enfeeblement":                 baseURL + "spells/rayofEnfeeblement.htm",
            "ray of exhaustion":                   baseURL + "spells/rayofExhaustion.htm",
            "ray of frost":                        baseURL + "spells/rayofFrost.htm",
            "read magic":                              baseURL + "spells/readMagic.htm",
            "reduce animal":                       baseURL + "spells/reduceAnimal.htm",
            "reduce person":                       baseURL + "spells/reducePerson.htm",
            "reduce person, mass":                 baseURL + "spells/reducePersonMass.htm",
            "refuge":                                  baseURL + "spells/refuge.htm",
            "regenerate":                              baseURL + "spells/regenerate.htm",
            "reincarnate":                             baseURL + "spells/reincarnate.htm",
            "remove blindness/deafness":       baseURL + "spells/removeBlindnessDeafness.htm",
            "remove curse":                        baseURL + "spells/removeCurse.htm",
            "remove disease":                          baseURL + "spells/removeDisease.htm",
            "remove fear":                             baseURL + "spells/removeFear.htm",
            "remove paralysis":                    baseURL + "spells/removeParalysis.htm",
            "repel metal or stone":                baseURL + "spells/repelMetalorStone.htm",
            "repel vermin":                        baseURL + "spells/repelVermin.htm",
            "repel wood":                              baseURL + "spells/repelWood.htm",
            "repulsion":                           baseURL + "spells/repulsion.htm",
            "resilient sphere":                    baseURL + "spells/resilientSphere.htm",
            "resistance":                              baseURL + "spells/resistance.htm",
            "resist energy":                       baseURL + "spells/resistEnergy.htm",
            "restoration":                             baseURL + "spells/restoration.htm",
            "restoration, greater":                baseURL + "spells/restorationGreater.htm",
            "restoration, lesser":                 baseURL + "spells/restorationLesser.htm",
            "resurrection":                        baseURL + "spells/resurrection.htm",
            "reverse gravity":                     baseURL + "spells/reverseGravity.htm",
            "righteous might":                     baseURL + "spells/righteousMight.htm",
            "rope trick":                              baseURL + "spells/ropeTrick.htm",
            "rusting grasp":                       baseURL + "spells/rustingGrasp.htm",
            "sanctuary":                           baseURL + "spells/sanctuary.htm",
            "scare":                                   baseURL + "spells/scare.htm",
            "scintillating pattern":           baseURL + "spells/scintillatingPattern.htm",
            "scorching ray":                       baseURL + "spells/scorchingRay.htm",
            "screen":                                  baseURL + "spells/screen.htm",
            "scrying":                                 baseURL + "spells/scrying.htm",
            "scrying, greater":                    baseURL + "spells/scryingGreater.htm",
            "sculpt sound":                        baseURL + "spells/sculptSound.htm",
            "searing light":                       baseURL + "spells/searingLight.htm",
            "secret chest":                        baseURL + "spells/secretChest.htm",
            "secret page":                             baseURL + "spells/secretPage.htm",
            "secure shelter":                          baseURL + "spells/secureShelter.htm",
            "see invisibility":                    baseURL + "spells/seeInvisibility.htm",
            "seeming":                                 baseURL + "spells/seeming.htm",
            "sending":                                 baseURL + "spells/sending.htm",
            "sepia snake sigil":                   baseURL + "spells/sepiaSnakeSigil.htm",
            "sequester":                           baseURL + "spells/sequester.htm",
            "shades":                                  baseURL + "spells/shades.htm",
            "shadow conjuration":                  baseURL + "spells/shadowConjuration.htm",
            "shadow conjuration, greater":      baseURL + "spells/shadowConjurationGreater.htm",
            "shadow evocation":                    baseURL + "spells/shadowEvocation.htm",
            "shadow evocation, greater":       baseURL + "spells/shadowEvocationGreater.htm",
            "shadow walk":                             baseURL + "spells/shadowWalk.htm",
            "shambler":                                baseURL + "spells/shambler.htm",
            "shapechange":                             baseURL + "spells/shapechange.htm",
            "shatter":                                 baseURL + "spells/shatter.htm",
            "shield":                                  baseURL + "spells/shield.htm",
            "shield of faith":                     baseURL + "spells/shieldofFaith.htm",
            "shield of law":                       baseURL + "spells/shieldofLaw.htm",
            "shield other":                        baseURL + "spells/shieldOther.htm",
            "shillelagh":                              baseURL + "spells/shillelagh.htm",
            "shocking grasp":                          baseURL + "spells/shockingGrasp.htm",
            "shout":                                   baseURL + "spells/shout.htm",
            "shout, greater":                          baseURL + "spells/shoutGreater.htm",
            "shrink item":                             baseURL + "spells/shrinkItem.htm",
            "silence":                                 baseURL + "spells/silence.htm",
            "silent image":                        baseURL + "spells/silentImage.htm",
            "simulacrum":                              baseURL + "spells/simulacrum.htm",
            "slay living":                             baseURL + "spells/slayLiving.htm",
            "sleep":                                   baseURL + "spells/sleep.htm",
            "sleet storm":                             baseURL + "spells/sleetStorm.htm",
            "slow":                                    baseURL + "spells/slow.htm",
            "snare":                                   baseURL + "spells/snare.htm",
            "soften earth and stone":              baseURL + "spells/softenEarthandStone.htm",
            "solid fog":                           baseURL + "spells/solidFog.htm",
            "song of discord":                     baseURL + "spells/songofDiscord.htm",
            "soul bind":                           baseURL + "spells/soulBind.htm",
            "sound burst":                             baseURL + "spells/soundBurst.htm",
            "speak with animals":                  baseURL + "spells/speakwithAnimals.htm",
            "speak with dead":                     baseURL + "spells/speakwithDead.htm",
            "speak with plants":                   baseURL + "spells/speakwithPlants.htm",
            "spectral hand":                       baseURL + "spells/spectralHand.htm",
            "spell immunity":                          baseURL + "spells/spellImmunity.htm",
            "spell immunity, greater":             baseURL + "spells/spellImmunityGreater.htm",
            "spell resistance":                    baseURL + "spells/spellResistance.htm",
            "spellstaff":                              baseURL + "spells/spellstaff.htm",
            "spell turning":                       baseURL + "spells/spellTurning.htm",
            "spider climb":                        baseURL + "spells/spiderClimb.htm",
            "spike growth":                        baseURL + "spells/spikeGrowth.htm",
            "spike stones":                        baseURL + "spells/spikeStones.htm",
            "spiritual weapon":                    baseURL + "spells/spiritualWeapon.htm",
            "statue":                                  baseURL + "spells/statue.htm",
            "status":                                  baseURL + "spells/status.htm",
            "stinking cloud":                          baseURL + "spells/stinkingCloud.htm",
            "stone shape":                             baseURL + "spells/stoneShape.htm",
            "stoneskin":                           baseURL + "spells/stoneskin.htm",
            "stone tell":                              baseURL + "spells/stoneTell.htm",
            "stone to flesh":                          baseURL + "spells/stonetoFlesh.htm",
            "storm of vengeance":                  baseURL + "spells/stormofVengeance.htm",
            "suggestion":                              baseURL + "spells/suggestion.htm",
            "suggestion, mass":                    baseURL + "spells/suggestionMass.htm",
            "summon instrument":                   baseURL + "spells/summonInstrument.htm",
            "summon monster i":                    baseURL + "spells/summonMonsterI.htm",
            "summon monster ii":                   baseURL + "spells/summonMonsterII.htm",
            "summon monster iii":                  baseURL + "spells/summonMonsterIII.htm",
            "summon monster iv":                   baseURL + "spells/summonMonsterIV.htm",
            "summon monster v":                    baseURL + "spells/summonMonsterV.htm",
            "summon monster vi":                   baseURL + "spells/summonMonsterVI.htm",
            "summon monster vii":                  baseURL + "spells/summonMonsterVII.htm",
            "summon monster viii":                 baseURL + "spells/summonMonsterVIII.htm",
            "summon monster ix":                   baseURL + "spells/summonMonsterIX.htm",
            "summon nature's ally i":              baseURL + "spells/summonNaturesAllyI.htm",
            "summon nature's ally ii":             baseURL + "spells/summonNaturesAllyII.htm",
            "summon nature's ally iii":        baseURL + "spells/summonNaturesAllyIII.htm",
            "summon nature's ally iv":             baseURL + "spells/summonNaturesAllyIV.htm",
            "summon nature's ally v":              baseURL + "spells/summonNaturesAllyV.htm",
            "summon nature's ally vi":             baseURL + "spells/summonNaturesAllyVI.htm",
            "summon nature's ally vii":        baseURL + "spells/summonNaturesAllyVII.htm",
            "summon nature's ally viii":       baseURL + "spells/summonNaturesAllyVIII.htm",
            "summon nature's ally ix":             baseURL + "spells/summonNaturesAllyIX.htm",
            "summon swarm":                        baseURL + "spells/summonSwarm.htm",
            "sunbeam":                                 baseURL + "spells/sunbeam.htm",
            "sunburst":                                baseURL + "spells/sunburst.htm",
            "symbol of death":                     baseURL + "spells/symbolofDeath.htm",
            "symbol of fear":                          baseURL + "spells/symbolofFear.htm",
            "symbol of insanity":                  baseURL + "spells/symbolofInsanity.htm",
            "symbol of pain":                          baseURL + "spells/symbolofPain.htm",
            "symbol of persuasion":                baseURL + "spells/symbolofPersuasion.htm",
            "symbol of sleep":                     baseURL + "spells/symbolofSleep.htm",
            "symbol of stunning":                  baseURL + "spells/symbolofStunning.htm",
            "symbol of weakness":                  baseURL + "spells/symbolofWeakness.htm",
            "sympathetic vibration":           baseURL + "spells/sympatheticVibration.htm",
            "sympathy":                                baseURL + "spells/sympathy.htm",
            "telekinesis":                             baseURL + "spells/telekinesis.htm",
            "telekinetic sphere":                  baseURL + "spells/telekineticSphere.htm",
            "telepathic bond":                     baseURL + "spells/telepathicBond.htm",
            "teleport":                                baseURL + "spells/teleport.htm",
            "teleport object":                     baseURL + "spells/teleportObject.htm",
            "teleport, greater":                   baseURL + "spells/teleportGreater.htm",
            "teleportation circle":                baseURL + "spells/teleportationCircle.htm",
            "temporal stasis":                     baseURL + "spells/temporalStasis.htm",
            "time stop":                           baseURL + "spells/timeStop.htm",
            "tiny hut":                                baseURL + "spells/tinyHut.htm",
            "tongues":                                 baseURL + "spells/tongues.htm",
            "touch of fatigue":                    baseURL + "spells/touchofFatigue.htm",
            "touch of idiocy":                     baseURL + "spells/touchofIdiocy.htm",
            "transformation":                          baseURL + "spells/transformation.htm",
            "transmute metal to wood":             baseURL + "spells/transmuteMetaltoWood.htm",
            "transmute mud to rock":           baseURL + "spells/transmuteMudtoRock.htm",
            "transmute rock to mud":           baseURL + "spells/transmuteRocktoMud.htm",
            "transport via plants":                baseURL + "spells/transportviaPlants.htm",
            "trap the soul":                       baseURL + "spells/traptheSoul.htm",
            "tree shape":                              baseURL + "spells/treeShape.htm",
            "tree stride":                             baseURL + "spells/treeStride.htm",
            "true resurrection":                   baseURL + "spells/trueResurrection.htm",
            "true seeing":                             baseURL + "spells/trueSeeing.htm",
            "true strike":                             baseURL + "spells/trueStrike.htm",
            "undeath to death":                    baseURL + "spells/undeathtoDeath.htm",
            "undetectable alignment":              baseURL + "spells/undetectableAlignment.htm",
            "unhallow":                                baseURL + "spells/unhallow.htm",
            "unholy aura":                             baseURL + "spells/unholyAura.htm",
            "unholy blight":                       baseURL + "spells/unholyBlight.htm",
            "unseen servant":                          baseURL + "spells/unseenServant.htm",
            "vampiric touch":                          baseURL + "spells/vampiricTouch.htm",
            "veil":                                    baseURL + "spells/veil.htm",
            "ventriloquism":                       baseURL + "spells/ventriloquism.htm",
            "virtue":                                  baseURL + "spells/virtue.htm",
            "vision":                                  baseURL + "spells/vision.htm",
            "wail of the banshee":                 baseURL + "spells/wailoftheBanshee.htm",
            "wall of fire":                        baseURL + "spells/wallofFire.htm",
            "wall of force":                       baseURL + "spells/wallofForce.htm",
            "wall of ice":                             baseURL + "spells/wallofIce.htm",
            "wall of iron":                        baseURL + "spells/wallofIron.htm",
            "wall of stone":                       baseURL + "spells/wallofStone.htm",
            "wall of thorns":                          baseURL + "spells/wallofThorns.htm",
            "warp wood":                           baseURL + "spells/warpWood.htm",
            "water breathing":                     baseURL + "spells/waterBreathing.htm",
            "water walk":                              baseURL + "spells/waterWalk.htm",
            "waves of exhaustion":                 baseURL + "spells/wavesofExhaustion.htm",
            "waves of fatigue":                    baseURL + "spells/wavesofFatigue.htm",
            "web":                                     baseURL + "spells/web.htm",
            "weird":                                   baseURL + "spells/weird.htm",
            "whirlwind":                           baseURL + "spells/whirlwind.htm",
            "whispering wind":                     baseURL + "spells/whisperingWind.htm",
            "wind walk":                           baseURL + "spells/windWalk.htm",
            "wind wall":                           baseURL + "spells/windWall.htm",
            "wish":                                    baseURL + "spells/wish.htm",
            "wood shape":                              baseURL + "spells/woodShape.htm",
            "word of chaos":                       baseURL + "spells/wordofChaos.htm",
            "word of recall":                          baseURL + "spells/wordofRecall.htm",
            "zone of silence":                     baseURL + "spells/zoneofSilence.htm",
            "zone of truth":                       baseURL + "spells/zoneofTruth.htm",

            # Abilities
            'ability damage':                   baseURL + "naturalSpecialAbilities.htm#abilityDamage",
            'ability drain':                    baseURL + "naturalSpecialAbilities.htm#abilityDrain",
            'ability score loss':               baseURL + "naturalSpecialAbilities.htm#abilityScoreLoss",
            'alternate form':                   baseURL + "naturalSpecialAbilities.htm#alternateForm",
            'antimagic':                        baseURL + "naturalSpecialAbilities.htm#antimagic",
            'bite':                             baseURL + "naturalSpecialAbilities.htm#bite",
            'blindsense':                       baseURL + "naturalSpecialAbilities.htm#blindsightAndBlindsense",
            'blindsight':                       baseURL + "naturalSpecialAbilities.htm#blindsightAndBlindsense",
            'breath weapon':                    baseURL + "naturalSpecialAbilities.htm#breathWeapon",
            'burrow':                           baseURL + "naturalSpecialAbilities.htm#burrow",
            'change shape':                     baseURL + "naturalSpecialAbilities.htm#changeShape",
            'charm':                            baseURL + "naturalSpecialAbilities.htm#charmAndCompulsion",
            'claw':                             baseURL + "naturalSpecialAbilities.htm#claworTalon",
            'climb':                            baseURL + "naturalSpecialAbilities.htm#climb",
            'cold immunity':                    baseURL + "naturalSpecialAbilities.htm#coldImmunity",
            'compulsion':                       baseURL + "naturalSpecialAbilities.htm#charmAndCompulsion",
            'constrict':                        baseURL + "naturalSpecialAbilities.htm#constrict",
            'damage reduction':                 baseURL + "naturalSpecialAbilities.htm#damageReduction",
            'darkvision':                       baseURL + "naturalSpecialAbilities.htm#darkvision",
            'death attacks':                    baseURL + "naturalSpecialAbilities.htm#deathAttacks",
            'disease':                          baseURL + "naturalSpecialAbilities.htm#disease",
            'energy drain':                     baseURL + "naturalSpecialAbilities.htm#energyDrainAndNegativeLevels",
            'etherealness':                     baseURL + "naturalSpecialAbilities.htm#etherealness",
            'evasion':                          baseURL + "naturalSpecialAbilities.htm#evasionAndImprovedEvasion",
            'fast healing':                     baseURL + "naturalSpecialAbilities.htm#fastHealing",
            'fear aura':                        baseURL + "naturalSpecialAbilities.htm#fearAura",
            'fear cones':                       baseURL + "naturalSpecialAbilities.htm#fearConesSpandRays",
            'fear rays':                        baseURL + "naturalSpecialAbilities.htm#fearConesSpandRays",
            'fear':                             baseURL + "naturalSpecialAbilities.htm#fear",
            'fire immunity':                    baseURL + "naturalSpecialAbilities.htm#fireImmunity",
            'fly':                              baseURL + "naturalSpecialAbilities.htm#fly",
            'frightful presence':               baseURL + "naturalSpecialAbilities.htm#frightfulPresence",
            'gaseous form':                     baseURL + "naturalSpecialAbilities.htm#gaseousForm",
            'gaze attacks':                     baseURL + "naturalSpecialAbilities.htm#gazeAttacks",
            'gore':                             baseURL + "naturalSpecialAbilities.htm#gore",
            'improved evasion':                 baseURL + "naturalSpecialAbilities.htm#evasionAndImprovedEvasion",
            'improved grab':                    baseURL + "naturalSpecialAbilities.htm#improvedGrab",
            'incorporeality':                   baseURL + "naturalSpecialAbilities.htm#incorporeality",
            'invisibility':                     baseURL + "naturalSpecialAbilities.htm#invisibility",
            'level loss':                       baseURL + "naturalSpecialAbilities.htm#levelLoss",
            'low-light vision':                 baseURL + "naturalSpecialAbilities.htm#lowLightVision",
            'manufactured weapons':             baseURL + "naturalSpecialAbilities.htm#manufacturedWeapons",
            'movement modes':                   baseURL + "naturalSpecialAbilities.htm#movementModes",
            'natural weapons':                  baseURL + "naturalSpecialAbilities.htm#naturalWeapons",
            'negative levels':                  baseURL + "naturalSpecialAbilities.htm#energyDrainAndNegativeLevels",
            'nonabilities':                     baseURL + "naturalSpecialAbilities.htm#nonabilities",
            'paralysis':                        baseURL + "naturalSpecialAbilities.htm#paralysis",
            'poison':                           baseURL + "naturalSpecialAbilities.htm#poison",
            'polymorph':                        baseURL + "naturalSpecialAbilities.htm#polymorph",
            'pounce':                           baseURL + "naturalSpecialAbilities.htm#pounce",
            'powerful charge':                  baseURL + "naturalSpecialAbilities.htm#powerfulCharge",
            'psionics':                         baseURL + "naturalSpecialAbilities.htm#psionics",
            'rake':                             baseURL + "naturalSpecialAbilities.htm#rake",
            'rays':                             baseURL + "naturalSpecialAbilities.htm#rays",
            'regeneration':                     baseURL + "naturalSpecialAbilities.htm#regeneration",
            'resistance to energy':             baseURL + "naturalSpecialAbilities.htm#resistanceToEnergy",
            'scent':                            baseURL + "naturalSpecialAbilities.htm#scent",
            'slam':                             baseURL + "naturalSpecialAbilities.htm#slaporSlam",
            'slap':                             baseURL + "naturalSpecialAbilities.htm#slaporSlam",
            'sonic attacks':                    baseURL + "naturalSpecialAbilities.htm#sonicAttacks",
            'spell immunity':                   baseURL + "naturalSpecialAbilities.htm#spellImmunity",
            'spell resistance':                 baseURL + "naturalSpecialAbilities.htm#spellResistance",
            'spells':                           baseURL + "naturalSpecialAbilities.htm#spells",
            'sting':                            baseURL + "naturalSpecialAbilities.htm#sting",
            'summon':                           baseURL + "naturalSpecialAbilities.htm#summon",
            'swallow whole':                    baseURL + "naturalSpecialAbilities.htm#swallowWhole",
            'swim':                             baseURL + "naturalSpecialAbilities.htm#swim",
            'talon':                            baseURL + "naturalSpecialAbilities.htm#claworTalon",
            'telepathy':                        baseURL + "naturalSpecialAbilities.htm#telepathy",
            'tentacle':                         baseURL + "naturalSpecialAbilities.htm#tentacle",
            'trample':                          baseURL + "naturalSpecialAbilities.htm#trample",
            'tremorsense':                      baseURL + "naturalSpecialAbilities.htm#tremorsense",
            'turn resistance':                  baseURL + "naturalSpecialAbilities.htm#turnResistance",
            'vulnerability to energy':          baseURL + "naturalSpecialAbilities.htm#vulnerabilitytoEnergy",

        }

    def plugin_enabled(self):
        reg = []
        reg2 = []
        reg3 = []
        for search_phrase in self.checklist.keys():
            if len(reg) < 300:
                reg.append("(?<![a-zA-Z0-9>/\#\-])" + search_phrase + "[s]*(?!\w+|[<])")
            elif len(reg2) < 300:
                reg2.append("(?<![a-zA-Z0-9>/\#\-])" + search_phrase + "[s]*(?!\w+|[<])")
            elif len(reg3) < 400:
                reg3.append("(?<![a-zA-Z0-9>/\#\-])" + search_phrase + "[s]*(?!\w+|[<])")

        reg = string.join(reg, "|")
        reg2 = string.join(reg2, "|")
        reg3 = string.join(reg3, "|")
        self.regex = re.compile(reg, re.I)
        self.regex2 = re.compile(reg2, re.I)
        self.regex3 = re.compile(reg3, re.I)

    def plugin_disabled(self):
        pass

    def regsub(self, m):
        term = m.group(0).lower()
        while not self.checklist.has_key(term) and len(term) > 1:
            term = term[:-1]
        return '<a href="' + self.checklist[term] + '">' + m.group(0) + '</a>'

    def replace(self, text):
        text = self.regex.sub(self.regsub, text)
        text = self.regex2.sub(self.regsub, text)
        text = self.regex3.sub(self.regsub, text)
        return text

    def pre_parse(self, text):
        text = self.replace(text)
        return text

    def plugin_incoming_msg(self, text, type, name, player):
        text = self.replace(text)
        return text, type, name
