/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGFXMaterial!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &CGFXMaterialBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 CGFXMaterialBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
CGFXMaterialPtr CGFXMaterialBase::create(void) 
{
    CGFXMaterialPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = CGFXMaterialPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
CGFXMaterialPtr CGFXMaterialBase::createEmpty(void) 
{ 
    CGFXMaterialPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the CGFXMaterial::_sfEffectFile field.
inline
SFString *CGFXMaterialBase::getSFEffectFile(void)
{
    return &_sfEffectFile;
}

//! Get the CGFXMaterial::_sfEffectString field.
inline
SFString *CGFXMaterialBase::getSFEffectString(void)
{
    return &_sfEffectString;
}

//! Get the CGFXMaterial::_sfTechnique field.
inline
SFInt32 *CGFXMaterialBase::getSFTechnique(void)
{
    return &_sfTechnique;
}

//! Get the CGFXMaterial::_mfParameters field.
inline
MFShaderParameterPtr *CGFXMaterialBase::getMFParameters(void)
{
    return &_mfParameters;
}

//! Get the CGFXMaterial::_mfImages field.
inline
MFImagePtr *CGFXMaterialBase::getMFImages(void)
{
    return &_mfImages;
}


//! Get the value of the CGFXMaterial::_sfEffectFile field.
inline
std::string &CGFXMaterialBase::getEffectFile(void)
{
    return _sfEffectFile.getValue();
}

//! Get the value of the CGFXMaterial::_sfEffectFile field.
inline
const std::string &CGFXMaterialBase::getEffectFile(void) const
{
    return _sfEffectFile.getValue();
}

//! Set the value of the CGFXMaterial::_sfEffectFile field.
inline
void CGFXMaterialBase::setEffectFile(const std::string &value)
{
    _sfEffectFile.setValue(value);
}

//! Get the value of the CGFXMaterial::_sfEffectString field.
inline
std::string &CGFXMaterialBase::getEffectString(void)
{
    return _sfEffectString.getValue();
}

//! Get the value of the CGFXMaterial::_sfEffectString field.
inline
const std::string &CGFXMaterialBase::getEffectString(void) const
{
    return _sfEffectString.getValue();
}

//! Set the value of the CGFXMaterial::_sfEffectString field.
inline
void CGFXMaterialBase::setEffectString(const std::string &value)
{
    _sfEffectString.setValue(value);
}

//! Get the value of the CGFXMaterial::_sfTechnique field.
inline
Int32 &CGFXMaterialBase::getTechnique(void)
{
    return _sfTechnique.getValue();
}

//! Get the value of the CGFXMaterial::_sfTechnique field.
inline
const Int32 &CGFXMaterialBase::getTechnique(void) const
{
    return _sfTechnique.getValue();
}

//! Set the value of the CGFXMaterial::_sfTechnique field.
inline
void CGFXMaterialBase::setTechnique(const Int32 &value)
{
    _sfTechnique.setValue(value);
}


//! Get the value of the \a index element the CGFXMaterial::_mfParameters field.
inline
ShaderParameterPtr &CGFXMaterialBase::getParameters(const UInt32 index)
{
    return _mfParameters[index];
}

//! Get the CGFXMaterial::_mfParameters field.
inline
MFShaderParameterPtr &CGFXMaterialBase::getParameters(void)
{
    return _mfParameters;
}

//! Get the CGFXMaterial::_mfParameters field.
inline
const MFShaderParameterPtr &CGFXMaterialBase::getParameters(void) const
{
    return _mfParameters;
}

//! Get the value of the \a index element the CGFXMaterial::_mfImages field.
inline
ImagePtr &CGFXMaterialBase::getImages(const UInt32 index)
{
    return _mfImages[index];
}

//! Get the CGFXMaterial::_mfImages field.
inline
MFImagePtr &CGFXMaterialBase::getImages(void)
{
    return _mfImages;
}

//! Get the CGFXMaterial::_mfImages field.
inline
const MFImagePtr &CGFXMaterialBase::getImages(void) const
{
    return _mfImages;
}

OSG_END_NAMESPACE

#define OSGCGFXMATERIALBASE_INLINE_CVSID "@(#)$Id: OSGCGFXMaterialBase.inl,v 1.3 2006/02/20 17:04:10 dirk Exp $"

